/*
 * Decompiled with CFR 0.152.
 */
package cn.myrealm.flipcard.util;

import cn.myrealm.flipcard.FlipCard;
import cn.myrealm.flipcard.manager.LanguageManager;
import cn.myrealm.flipcard.util.Reward;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class Action {
    private List<String> actions = new ArrayList<String>();
    private Reward reward;

    public Action(List<String> list, Reward reward) {
        this.actions = list;
        this.reward = reward;
    }

    public Action(List<String> list) {
        this.actions = list;
        this.reward = null;
    }

    public void doAction(Player player) {
        int n = 1;
        if (this.reward != null) {
            n = this.reward.getTimes();
        }
        for (String string : this.actions) {
            if (string.startsWith("none")) {
                return;
            }
            if (string.startsWith("message: ") && player != null) {
                player.sendMessage(this.replacePlaceholder(FlipCard.parseColor(LanguageManager.getPlaceholder(player, string.substring(9))), player));
                continue;
            }
            if (string.startsWith("announcement: ")) {
                Collection collection = Bukkit.getOnlinePlayers();
                for (Object object : collection) {
                    object.sendMessage(this.replacePlaceholder(FlipCard.parseColor(LanguageManager.getPlaceholder(player, string.substring(14))), player));
                }
                continue;
            }
            if (string.startsWith("sound: ") && player != null) {
                String string2 = string.substring(7);
                String[] stringArray = string2.split(";;");
                if (stringArray.length >= 1) {
                    Object object;
                    object = stringArray[0];
                    float f = 1.0f;
                    float f2 = 1.0f;
                    if (stringArray.length >= 2) {
                        f = Float.parseFloat(stringArray[1]);
                    }
                    if (stringArray.length >= 3) {
                        f2 = Float.parseFloat(stringArray[2]);
                    }
                    Location location = player.getLocation();
                    player.playSound(location, (String)object, f, f2);
                    continue;
                }
                FlipCard.checkError("\u00a7x\u00a79\u00a78\u00a7F\u00a7B\u00a79\u00a78[FlipCard] \u00a7cError: Your sound action in UI configs can not being correctly load.");
                continue;
            }
            if (string.startsWith("effect: ") && player != null) {
                try {
                    if (PotionEffectType.getByName((String)string.substring(8).split(";;")[0].toUpperCase()) == null) {
                        FlipCard.checkError("\u00a7x\u00a79\u00a78\u00a7F\u00a7B\u00a79\u00a78[FlipCard] \u00a7cError: Can not found potion effect: " + string.split(";;")[0] + ".");
                    }
                    PotionEffect potionEffect = new PotionEffect(PotionEffectType.getByName((String)string.split(";;")[0].toUpperCase()), Integer.parseInt(string.substring(8).split(";;")[2]), Integer.parseInt(string.substring(8).split(";;")[1]) - 1, true, true, true);
                    player.addPotionEffect(potionEffect);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    FlipCard.checkError("\u00a7x\u00a79\u00a78\u00a7F\u00a7B\u00a79\u00a78[FlipCard] \u00a7cError: Your effect action in UI configs can not being correctly load.");
                }
                continue;
            }
            if (string.startsWith("teleport: ") && player != null) {
                try {
                    if (string.split(";;").length == 4) {
                        Location location = new Location(Bukkit.getWorld((String)string.substring(10).split(";;")[0]), Double.parseDouble(string.substring(10).split(";;")[1]), Double.parseDouble(string.substring(10).split(";;")[2]), Double.parseDouble(string.substring(10).split(";;")[3]), player.getLocation().getYaw(), player.getLocation().getPitch());
                        player.teleport(location);
                        continue;
                    }
                    if (string.split(";;").length == 6) {
                        Location location = new Location(Bukkit.getWorld((String)string.split(";;")[0]), Double.parseDouble(string.substring(10).split(";;")[1]), Double.parseDouble(string.substring(10).split(";;")[2]), Double.parseDouble(string.substring(10).split(";;")[3]), Float.parseFloat(string.substring(10).split(";;")[4]), Float.parseFloat(string.substring(10).split(";;")[5]));
                        player.teleport(location);
                        continue;
                    }
                    FlipCard.checkError("\u00a7x\u00a79\u00a78\u00a7F\u00a7B\u00a79\u00a78[FlipCard] \u00a7cError: Your teleport action in UI configs can not being correctly load.");
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    FlipCard.checkError("\u00a7x\u00a79\u00a78\u00a7F\u00a7B\u00a79\u00a78[FlipCard] \u00a7cError: Your teleport action in totem configs can not being correctly load.");
                }
                continue;
            }
            if (string.startsWith("console_command: ")) {
                for (int i = 0; i < n; ++i) {
                    Bukkit.getScheduler().runTask((Plugin)FlipCard.instance, () -> Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)this.replacePlaceholder(LanguageManager.getPlaceholder(player, string.substring(17)), player)));
                }
                continue;
            }
            if (string.startsWith("player_command: ") && player != null) {
                Bukkit.getScheduler().runTask((Plugin)FlipCard.instance, () -> Bukkit.dispatchCommand((CommandSender)player, (String)this.replacePlaceholder(LanguageManager.getPlaceholder(player, string.substring(16)), player)));
                continue;
            }
            if (!string.equals("close") || player == null) continue;
            Bukkit.getScheduler().runTask((Plugin)FlipCard.instance, () -> player.closeInventory());
        }
    }

    private String replacePlaceholder(String string, Player player) {
        if (this.reward != null) {
            string = string.replace("%display%", this.reward.getDisplayName()).replace("%amount%", String.valueOf(this.reward.getAmount())).replace("%player%", player.getName()).replace("%times", String.valueOf(this.reward.getTimes()));
        }
        string = string.replace("%player%", player.getName());
        if (FlipCard.instance.getServer().getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            string = PlaceholderAPI.setPlaceholders((Player)player, (String)string);
        }
        return string;
    }
}

