/*
 * Decompiled with CFR 0.152.
 */
package cn.myrealm.flipcard.util;

import cn.myrealm.flipcard.manager.ConfigManager;
import cn.myrealm.flipcard.manager.DatabaseManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class Cache {
    private Player player;
    private Map<String, Integer> cache;
    private boolean using = false;

    public Cache(Player player) {
        this.player = player;
        this.init();
    }

    public Cache(Player player, YamlConfiguration yamlConfiguration) {
        this.player = player;
        this.cache = new HashMap<String, Integer>();
        for (String string : yamlConfiguration.getKeys(false)) {
            if (!Objects.nonNull(yamlConfiguration.getInt(string))) continue;
            int n = yamlConfiguration.getInt(string);
            this.cache.put(string, n);
        }
    }

    private void init() {
        this.cache = new HashMap<String, Integer>();
        if (ConfigManager.getMySQL()) {
            for (String string : ConfigManager.getIds()) {
                DatabaseManager.query(this.player, string);
            }
        }
    }

    public List<Integer> getTask() {
        return new ArrayList<Integer>();
    }

    public Map<String, Integer> getCache() {
        return this.cache;
    }

    public int getTimes(String string) {
        if (this.cache.get(string) == null) {
            return 0;
        }
        int n = this.cache.get(string);
        return n;
    }

    public void addTimes(String string, int n) {
        int n2 = 0;
        if (this.cache.containsKey(string)) {
            n2 = this.cache.get(string);
        }
        if (n < 0 && -n > n2) {
            n = 0;
        }
        this.cache.put(string, n2 + n);
        if (ConfigManager.getMySQL()) {
            DatabaseManager.update(this.player, string, n2 + n);
        }
    }

    public void setTimes(String string, int n) {
        if (n < 0) {
            n = 0;
        }
        this.cache.replace(string, n);
        if (ConfigManager.getMySQL()) {
            DatabaseManager.update(this.player, string, n);
        }
    }

    public void closeInv() {
        if (this.using) {
            this.player.closeInventory();
        }
    }
}

