/*
 * Decompiled with CFR 0.152.
 */
package cn.myrealm.flipcard.util;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColorParser {
    public static final Pattern HEX_PATTERN = Pattern.compile("&#([\\da-fA-F]{6})");
    public static final Pattern GRADIENT_PATTERN = Pattern.compile("&<&?#([\\da-fA-F]{6})>");
    public static final Pattern COLOR_PATTERN = Pattern.compile("([&\u00a7][0-9a-fA-FrRxX])+");
    public static final Pattern FORMAT_PATTERN = Pattern.compile("([&\u00a7][0-9a-fA-Fk-oK-OrRxX])+");

    @NotNull
    public static String clear(@NotNull String string) {
        string = HEX_PATTERN.matcher(string).replaceAll("");
        string = GRADIENT_PATTERN.matcher(string).replaceAll("");
        string = COLOR_PATTERN.matcher(string).replaceAll("");
        return string;
    }

    @NotNull
    public static String parse(@NotNull String string) {
        return ColorParser.parseBaseColor(ColorParser.parseGradientColor(ColorParser.parseHexColor(string)));
    }

    public static String parseBaseColor(String string) {
        return string.replaceAll("&", "\u00a7").replace("\u00a7\u00a7", "&");
    }

    public static String parseHexColor(String string) {
        Matcher matcher = HEX_PATTERN.matcher(string);
        while (matcher.find()) {
            string = matcher.replaceFirst(ColorParser.buildHexColor(matcher.group(1)).toLowerCase());
            matcher.reset(string);
        }
        return string;
    }

    @NotNull
    public static String parseGradientColor(@NotNull String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Matcher matcher = GRADIENT_PATTERN.matcher(string);
        while (matcher.find()) {
            arrayList.add(matcher.group(1));
        }
        if (arrayList.isEmpty()) {
            return string;
        }
        String[] stringArray = GRADIENT_PATTERN.split(string);
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = i - 1 >= 0 && arrayList.size() > i - 1 ? (String)arrayList.get(i - 1) : null;
            String string3 = arrayList.size() > i ? (String)arrayList.get(i) : null;
            stringBuilder.append(ColorParser.gradientText(stringArray[i], string2, string3));
        }
        return stringBuilder.toString();
    }

    @NotNull
    public static String gradientText(@NotNull String string, @Nullable Color color, @Nullable Color color2) {
        Objects.requireNonNull(string, "Text to be gradient should not be null!");
        if (color == null || color2 == null || string.isEmpty()) {
            return (color != null ? "&r" : "") + string;
        }
        LinkedHashMap<Integer, String> linkedHashMap = new LinkedHashMap<Integer, String>();
        Matcher matcher = FORMAT_PATTERN.matcher(string);
        while (matcher.find()) {
            linkedHashMap.put(matcher.start(), matcher.group());
            string = matcher.replaceFirst("");
            matcher.reset(string);
        }
        if (string.length() == 1) {
            return ColorParser.colorText(string, (String)linkedHashMap.get(0), ColorParser.buildHexColor(ColorParser.mediumHex(color, color2)));
        }
        String[] stringArray = string.split("");
        int n2 = stringArray.length;
        int n3 = color.getRed() < color2.getRed() ? 1 : -1;
        int n4 = color.getGreen() < color2.getGreen() ? 1 : -1;
        int n5 = color.getBlue() < color2.getBlue() ? 1 : -1;
        int n6 = Math.abs(color.getRed() - color2.getRed()) / (n2 - 1);
        int n8 = Math.abs(color.getGreen() - color2.getGreen()) / (n2 - 1);
        int n9 = Math.abs(color.getBlue() - color2.getBlue()) / (n2 - 1);
        String[] stringArray2 = (String[])IntStream.range(0, n2).mapToObj(n7 -> ColorParser.colorToHex(color.getRed() + n6 * n7 * n3, color.getGreen() + n8 * n7 * n4, color.getBlue() + n9 * n7 * n5)).toArray(String[]::new);
        return IntStream.range(0, stringArray.length).mapToObj(n -> ColorParser.colorText(stringArray[n], (String)linkedHashMap.get(n), ColorParser.buildHexColor(stringArray2[n]))).collect(Collectors.joining());
    }

    protected static String gradientText(@NotNull String string, @Nullable String string2, @Nullable String string3) {
        return ColorParser.gradientText(string, string2 == null ? null : Color.decode("0x" + string2), string3 == null ? null : Color.decode("0x" + string3));
    }

    private static String mediumHex(@NotNull Color color, @NotNull Color color2) {
        return ColorParser.colorToHex(Math.abs(color.getRed() - color2.getRed()) / 2, Math.abs(color.getGreen() - color2.getGreen()) / 2, Math.abs(color.getBlue() - color2.getBlue()) / 2);
    }

    private static String colorText(String string, @Nullable String string2, @Nullable String string3) {
        if (string2 != null && COLOR_PATTERN.matcher(string2).find()) {
            return string2 + string;
        }
        return (string3 == null ? "" : string3) + (string2 == null ? "" : ColorParser.parseBaseColor(string2)) + string;
    }

    protected static String colorToHex(Color color) {
        return ColorParser.colorToHex(color.getRed(), color.getGreen(), color.getBlue());
    }

    protected static String colorToHex(int n, int n2, int n3) {
        return String.format("%02X%02X%02X", n, n2, n3);
    }

    protected static String buildHexColor(String string2) {
        return Arrays.stream(string2.split("")).map(string -> '\u00a7' + string).collect(Collectors.joining("", "\u00a7x", ""));
    }
}

