/*
 * Decompiled with CFR 0.152.
 */
package cn.myrealm.flipcard.util;

import cn.myrealm.flipcard.FlipCard;
import cn.myrealm.flipcard.hooks.ItemsHook;
import cn.myrealm.flipcard.hooks.PriceHook;
import cn.myrealm.flipcard.manager.LanguageManager;
import cn.myrealm.flipcard.manager.SavedItemManager;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class Price {
    private ConfigurationSection section;
    private String type;
    private boolean priceBoolean;
    private Player player;
    private ItemStack itemStack;

    public Price(ConfigurationSection configurationSection, Player player) {
        this.player = player;
        this.section = configurationSection;
        this.type = configurationSection == null ? "unknown" : (configurationSection.contains("hook-plugin") && configurationSection.contains("hook-item") ? "hook" : (configurationSection.contains("material") ? "vanilla" : (configurationSection.contains("economy-plugin") ? "economy" : (configurationSection.contains("economy-type") && !configurationSection.contains("economy-plugin") ? "exp" : "free"))));
    }

    public Price() {
        this.type = "unknown";
    }

    private Map<Integer, Double> getApplyCostMap() {
        List<Integer> list = this.getApply();
        List<Double> list2 = this.getCost();
        if (list.isEmpty() || list2.isEmpty()) {
            return null;
        }
        while (list.size() > list2.size()) {
            if (list2.size() > 0) {
                list2.add(list2.get(list2.size() - 1));
                continue;
            }
            list2.add(0.0);
        }
        HashMap<Integer, Double> hashMap = new HashMap<Integer, Double>();
        for (int i = 0; i < list.size(); ++i) {
            hashMap.put(list.get(i), list2.get(i));
        }
        return hashMap;
    }

    public List<Integer> getApply() {
        if (Objects.isNull(this.section) || this.section.getInt("start-apply", -1) != -1) {
            return new ArrayList<Integer>();
        }
        ArrayList<Integer> arrayList = this.section.getIntegerList("apply");
        if (arrayList.size() == 0) {
            arrayList = new ArrayList<Integer>();
            arrayList.add(Integer.valueOf(this.section.getName()));
        }
        return arrayList;
    }

    public int getStartApply() {
        if (Objects.isNull(this.section) || this.section.getInt("start-apply", -1) != -1) {
            return this.section.getInt("start-apply", 1);
        }
        return Integer.MAX_VALUE;
    }

    private List<Double> getCost() {
        if (Objects.isNull(this.section) || this.section.getInt("start-apply", -1) != -1) {
            return new ArrayList<Double>();
        }
        ArrayList<Double> arrayList = this.section.getDoubleList("cost");
        if (arrayList.size() == 0) {
            arrayList = new ArrayList<Double>();
            arrayList.add(this.section.getDouble("amount", 1.0));
        }
        return arrayList;
    }

    public String getType() {
        return this.type;
    }

    public String getExplain(int n) {
        double d = this.getCostAmount(n);
        if (this.section == null) {
            return "Error";
        }
        String string = this.section.getString("placeholder") != null ? FlipCard.parseColor(this.section.getString("placeholder")) : (this.section.getString("placeholders." + n) != null ? FlipCard.parseColor(this.section.getString("placeholders." + n)) : LanguageManager.getText("price-placeholder-default"));
        if (this.itemStack != null) {
            string = this.itemStack.getItemMeta().hasDisplayName() ? LanguageManager.varHandle(string, "display", this.itemStack.getItemMeta().getDisplayName()) : LanguageManager.varHandle(string, "display", this.itemStack.getType().name());
            string = LanguageManager.varHandle(string, "amount", String.valueOf((int)d));
        } else {
            string = LanguageManager.varHandle(string, "display", this.section.getString("economy-plugin", "Free"));
            string = LanguageManager.varHandle(string, "amount", String.valueOf(d));
        }
        return string;
    }

    public boolean checkCondition(int n) {
        boolean bl = true;
        List list = new ArrayList();
        if (!this.section.getStringList("conditions." + n).isEmpty()) {
            list = this.section.getStringList("conditions." + n);
        } else if (!this.section.getStringList("conditions").isEmpty()) {
            list = this.section.getStringList("conditions");
        } else {
            return true;
        }
        block0: for (String string : list) {
            if (string.startsWith("none")) {
                return true;
            }
            if (string.startsWith("world: ")) {
                int n2 = 0;
                for (String string2 : string.substring(7).split(";;")) {
                    if (string2.equals(this.player.getWorld().getName())) break;
                    ++n2;
                }
                if (n2 != string.substring(7).split(";;").length) continue;
                bl = false;
                break;
            }
            if (string.startsWith("permission: ")) {
                for (String string3 : string.substring(12).split(";;")) {
                    if (this.player.hasPermission(string3)) continue;
                    bl = false;
                    continue block0;
                }
                continue;
            }
            if (!Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI") || !string.startsWith("placeholder: ")) continue;
            String[] stringArray = string.substring(13).split(";;");
            Object object = stringArray[0];
            String string4 = stringArray[1];
            String string5 = stringArray[2];
            if (string4.equals("!=") && ((String)(object = PlaceholderAPI.setPlaceholders((Player)this.player, (String)object))).equals(string5)) {
                bl = false;
                break;
            }
            if (string4.equals("==") && !((String)(object = PlaceholderAPI.setPlaceholders((Player)this.player, (String)object))).equals(string5)) {
                bl = false;
                break;
            }
            if (string4.equals("!*=") && ((String)(object = PlaceholderAPI.setPlaceholders((Player)this.player, (String)object))).contains(string5)) {
                bl = false;
                break;
            }
            if (string4.equals("*=") && !((String)(object = PlaceholderAPI.setPlaceholders((Player)this.player, (String)object))).contains(string5)) {
                bl = false;
                break;
            }
            if (string4.equals(">=") && !(Double.parseDouble((String)(object = PlaceholderAPI.setPlaceholders((Player)this.player, (String)object))) >= Double.parseDouble(string5))) {
                bl = false;
                break;
            }
            if (string4.equals(">") && !(Double.parseDouble((String)(object = PlaceholderAPI.setPlaceholders((Player)this.player, (String)object))) > Double.parseDouble(string5))) {
                bl = false;
                break;
            }
            if (string4.equals("<=") && !(Double.parseDouble((String)(object = PlaceholderAPI.setPlaceholders((Player)this.player, (String)object))) <= Double.parseDouble(string5))) {
                bl = false;
                break;
            }
            if (string4.equals("<") && !(Double.parseDouble((String)(object = PlaceholderAPI.setPlaceholders((Player)this.player, (String)object))) < Double.parseDouble(string5))) {
                bl = false;
                break;
            }
            if (!string4.equals("=") || Double.parseDouble((String)(object = PlaceholderAPI.setPlaceholders((Player)this.player, (String)object))) == Double.parseDouble(string5)) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public boolean checkPrice(int n, boolean bl) {
        if (this.section == null) {
            return false;
        }
        double d = this.getCostAmount(n);
        if (d == -1.0) {
            return false;
        }
        switch (this.type) {
            case "free": {
                this.priceBoolean = true;
                break;
            }
            case "hook": {
                String string = this.section.getString("hook-plugin");
                String string2 = this.section.getString("hook-item");
                if (string.equals("MMOItems") && !string2.contains(";;")) {
                    string2 = this.section.getString("hook-item-type") + ";;" + string2;
                } else if (string.equals("EcoArmor") && !string2.contains(";;")) {
                    string2 = string2 + ";;" + this.section.getString("hook-item-type");
                }
                this.itemStack = ItemsHook.getHookItem(string, string2);
                this.priceBoolean = PriceHook.getPrice(string, string2, this.player, (int)d, bl);
                break;
            }
            case "vanilla": {
                String string = this.section.getString("material", "").toUpperCase();
                if (!string.equals("")) {
                    int n2;
                    Object object;
                    Object object2;
                    Material material;
                    if (string.equals("SKULL")) {
                        this.itemStack = new ItemStack(Material.getMaterial((String)"PLAYER_HEAD"));
                        material = (SkullMeta)this.itemStack.getItemMeta();
                        object2 = new GameProfile(UUID.randomUUID(), null);
                        object2.getProperties().put((Object)"textures", (Object)new Property("textures", this.section.getString("skull_meta")));
                        try {
                            object = material.getClass().getDeclaredMethod("setProfile", GameProfile.class);
                            ((Method)object).setAccessible(true);
                            ((Method)object).invoke((Object)material, object2);
                        }
                        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                            reflectiveOperationException.printStackTrace();
                        }
                        this.itemStack.setItemMeta((ItemMeta)material);
                    } else {
                        material = Material.getMaterial((String)string);
                        if (material == null) {
                            this.itemStack = SavedItemManager.getItemByKey(this.section.getString("material", ""));
                            if (this.itemStack == null) {
                                Bukkit.getConsoleSender().sendMessage("\u00a7x\u00a79\u00a78\u00a7F\u00a7B\u00a79\u00a78[FlipCard] \u00a7cCan not get material: " + string + "!");
                            }
                        } else {
                            this.itemStack = new ItemStack(material);
                        }
                    }
                    material = this.itemStack.getItemMeta();
                    if (material == null) {
                        Bukkit.getConsoleSender().sendMessage("\u00a7x\u00a79\u00a78\u00a7F\u00a7B\u00a79\u00a78[FlipCard] \u00a7cCan not get material: " + string + "!");
                    }
                    if (!((String)(object2 = this.section.getString("display", ""))).equals("")) {
                        object2 = FlipCard.parseColor((String)object2);
                        object2 = LanguageManager.varHandle((String)object2, "times", String.valueOf(n));
                        material.setDisplayName((String)object2);
                    }
                    if (Objects.nonNull(object = this.section.getStringList("lore"))) {
                        for (n2 = 0; n2 < object.size(); ++n2) {
                            String string3 = (String)object.get(n2);
                            string3 = LanguageManager.varHandle(string3, "times", String.valueOf(n));
                            string3 = FlipCard.parseColor("&f" + string3);
                            object.set(n2, string3);
                        }
                        material.setLore((List)object);
                    }
                    if ((n2 = this.section.getInt("cmd", 0)) != 0) {
                        material.setCustomModelData(Integer.valueOf(n2));
                    }
                    this.itemStack.setItemMeta((ItemMeta)material);
                }
                this.priceBoolean = PriceHook.getPrice(this.player, this.itemStack, (int)d, bl);
                break;
            }
            case "economy": {
                this.priceBoolean = PriceHook.getPrice(this.section.getString("economy-plugin"), this.section.getString("economy-type", "default"), this.player, d, bl);
                break;
            }
            case "exp": {
                this.priceBoolean = PriceHook.getPrice(this.section.getString("economy-type"), this.player, (int)d, bl);
                break;
            }
            case "unknwon": {
                Bukkit.getConsoleSender().sendMessage("\u00a7x\u00a79\u00a78\u00a7F\u00a7B\u00a79\u00a78[FlipCard] \u00a7cThere is something wrong in your UI configs!");
                this.priceBoolean = false;
            }
        }
        return this.priceBoolean;
    }

    public double getCostAmount(int n) {
        Map<Integer, Double> map = this.getApplyCostMap();
        double d = -1.0;
        if (n >= this.section.getInt("start-apply", -1) && this.section.getInt("start-apply", -1) != -1) {
            d = this.section.getDouble("amount", 1.0);
        } else if (map != null && map.containsKey(n)) {
            d = map.get(n);
        }
        return d;
    }
}

