/*
 * Decompiled with CFR 0.152.
 */
package cn.myrealm.flipcard.util;

import cn.myrealm.flipcard.FlipCard;
import cn.myrealm.flipcard.gui.DisplayGui;
import cn.myrealm.flipcard.gui.MainGui;
import cn.myrealm.flipcard.gui.TimerGui;
import cn.myrealm.flipcard.manager.AnimateManager;
import cn.myrealm.flipcard.manager.CacheManager;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Timer {
    private BukkitRunnable guiTitleRefreshTask;
    private BukkitRunnable guiCloseTask;
    private BukkitRunnable displayAnimate2Task;
    private BukkitRunnable cacheTask;
    private boolean doGuiTitleRefresh = false;
    private boolean doGuiClose = false;
    private boolean doDisplayAnimate2 = false;
    private boolean doCacheTask = false;
    private TimerGui gui;
    private int time;

    public Timer(TimerGui timerGui, int n) {
        this.gui = timerGui;
        this.time = n;
    }

    public void guiTitleRefreshTaskRegister() {
        this.guiTitleRefreshTask = new BukkitRunnable(){

            public void run() {
                if (!Timer.this.doGuiTitleRefresh) {
                    return;
                }
                Timer.this.gui.timeRefresh(Timer.this.time);
            }
        };
        this.guiTitleRefreshTask.runTaskLater((Plugin)FlipCard.instance, (long)(this.time * 20));
        this.doGuiTitleRefresh = true;
    }

    public void cacheTaskRegister() {
        this.cacheTask = new BukkitRunnable(){

            public void run() {
                if (!Timer.this.doCacheTask) {
                    return;
                }
                CacheManager.updateCache(Timer.this.gui.getPlayer(), (MainGui)Timer.this.gui, Timer.this.time);
            }
        };
        this.cacheTask.runTaskLater((Plugin)FlipCard.instance, (long)(this.time * 20));
        this.doCacheTask = true;
    }

    public void guiCloseTaskRegister() {
        this.guiCloseTask = new BukkitRunnable(){

            public void run() {
                if (!Timer.this.doGuiClose) {
                    return;
                }
                Timer.this.gui.closeGui();
            }
        };
        this.guiCloseTask.runTaskLater((Plugin)FlipCard.instance, (long)(this.time * 20));
        this.doGuiClose = true;
    }

    public void cancelAllTask() {
        if (this.guiTitleRefreshTask != null) {
            this.doGuiTitleRefresh = false;
        }
        if (this.guiCloseTask != null) {
            this.doGuiClose = false;
        }
        if (this.displayAnimate2Task != null) {
            this.doDisplayAnimate2 = false;
        }
    }

    public void setDoGuiTitleRefresh(boolean bl) {
        this.doGuiTitleRefresh = bl;
    }

    public void setDoGuiClose(boolean bl) {
        this.doGuiClose = bl;
    }

    public void setDoCacheTask(boolean bl) {
        this.doCacheTask = bl;
    }

    public void displayAnimate2TaskRegister() {
        this.displayAnimate2Task = new BukkitRunnable(){

            public void run() {
                if (!Timer.this.doDisplayAnimate2) {
                    return;
                }
                AnimateManager.displayAnimate2((DisplayGui)Timer.this.gui);
            }
        };
        this.displayAnimate2Task.runTaskLater((Plugin)FlipCard.instance, (long)(this.time * 20));
        this.doDisplayAnimate2 = true;
    }
}

