/*
 * Decompiled with CFR 0.152.
 */
package redempt.crunch;

import redempt.crunch.exceptions.ExpressionEvaluationException;
import redempt.crunch.token.Value;

public class CompiledExpression {
    protected double[] variableValues;
    private int variableCount;
    private Value value;

    protected CompiledExpression() {
    }

    public CompiledExpression(Value value, int n) {
        this.initialize(value, n);
    }

    protected void initialize(Value value, int n) {
        this.value = value;
        this.variableCount = n;
    }

    protected void setVariableValues(double[] dArray) {
        this.checkArgCount(dArray.length);
        this.variableValues = dArray;
    }

    public Value getValue() {
        return this.value;
    }

    public int getVariableCount() {
        return this.variableCount;
    }

    public double evaluate(double ... dArray) {
        this.setVariableValues(dArray);
        return this.value.getValue();
    }

    public double evaluate() {
        this.checkArgCount(0);
        return this.value.getValue();
    }

    public double evaluate(double d) {
        this.checkArgCount(1);
        if (this.variableValues == null) {
            this.variableValues = new double[1];
        }
        this.variableValues[0] = d;
        return this.value.getValue();
    }

    public double evaluate(double d, double d2) {
        this.checkArgCount(2);
        if (this.variableValues == null) {
            this.variableValues = new double[2];
        }
        this.variableValues[0] = d;
        this.variableValues[1] = d2;
        return this.value.getValue();
    }

    private void checkArgCount(int n) {
        if (this.variableCount > n) {
            throw new ExpressionEvaluationException("Too few variable values - expected " + this.variableCount + ", got " + n);
        }
    }

    public CompiledExpression clone() {
        return new CompiledExpression(this.value.getClone(), this.variableCount);
    }

    public String toString() {
        return this.value.toString();
    }
}

