/*
 * Decompiled with CFR 0.152.
 */
package redempt.crunch;

import java.util.ArrayDeque;
import java.util.Deque;
import redempt.crunch.token.BinaryOperation;
import redempt.crunch.token.BinaryOperator;
import redempt.crunch.token.LiteralValue;
import redempt.crunch.token.TokenType;
import redempt.crunch.token.Value;

public class ShuntingYard {
    private Deque<BinaryOperator> operators = new ArrayDeque<BinaryOperator>();
    private Deque<Value> stack = new ArrayDeque<Value>();

    public void addOperator(BinaryOperator binaryOperator) {
        while (!this.operators.isEmpty() && binaryOperator.priority <= this.operators.getLast().priority) {
            this.createOperation();
        }
        this.operators.add(binaryOperator);
    }

    public void addValue(Value value) {
        this.stack.add(value);
    }

    private void createOperation() {
        BinaryOperator binaryOperator = this.operators.removeLast();
        Value value = this.stack.removeLast();
        Value value2 = this.stack.removeLast();
        if (value.getType() == TokenType.LITERAL_VALUE && value2.getType() == TokenType.LITERAL_VALUE) {
            this.stack.add(new LiteralValue(binaryOperator.operate.applyAsDouble(value2.getValue(), value.getValue())));
        } else {
            this.stack.add(new BinaryOperation(binaryOperator, value2, value));
        }
    }

    public Value finish() {
        while (this.stack.size() > 1) {
            this.createOperation();
        }
        return this.stack.removeLast();
    }
}

