/*
 * Decompiled with CFR 0.152.
 */
package redempt.crunch.data;

import redempt.crunch.ExpressionParser;
import redempt.crunch.data.Pair;

public class CharTree<T> {
    private Node root = new Node();

    public void set(String string, T t) {
        Node node = this.root;
        for (char c : string.toCharArray()) {
            node = node.getOrCreateNode(c);
        }
        node.setValue(t);
    }

    public T get(String string) {
        Node node = this.root;
        for (char c : string.toCharArray()) {
            if ((node = node.getNode(c)) != null) continue;
            return null;
        }
        return (T)node.getValue();
    }

    public boolean containsFirstChar(char c) {
        return this.root.getNode(c) != null;
    }

    public Pair<T, Integer> getFrom(String string, int n) {
        Node node = this.root;
        Object object = null;
        for (int i = n; i < string.length(); ++i) {
            if ((node = node.getNode(string.charAt(i))) == null) {
                return new Pair<Object, Integer>(object, i - n);
            }
            if (node.getValue() == null) continue;
            object = node.getValue();
        }
        return new Pair<Object, Integer>(object, string.length() - n);
    }

    public T getWith(ExpressionParser expressionParser) {
        int n;
        Node node = this.root;
        Object object = null;
        for (int i = n = expressionParser.cur; i < expressionParser.str.length(); ++i) {
            if ((node = node.getNode(expressionParser.str.charAt(i))) == null) {
                expressionParser.cur = object == null ? expressionParser.cur : n + 1;
                return (T)object;
            }
            Object object2 = node.getValue();
            if (object2 == null) continue;
            n = i;
            object = object2;
        }
        if (object != null) {
            expressionParser.cur = n + 1;
        }
        return (T)object;
    }

    private static class Node {
        private Object value;
        private Node[] children = new Node[256];

        private Node() {
        }

        public Node getNode(char c) {
            return this.children[c];
        }

        public Node getOrCreateNode(char c) {
            if (this.children[c] == null) {
                this.children[c] = new Node();
            }
            return this.children[c];
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object object) {
            this.value = object;
        }
    }
}

