/*
 * Decompiled with CFR 0.152.
 */
package redempt.crunch.functional;

import java.util.Locale;
import java.util.function.DoubleSupplier;
import java.util.function.ToDoubleFunction;
import redempt.crunch.Variable;
import redempt.crunch.data.CharTree;
import redempt.crunch.functional.Function;
import redempt.crunch.token.BinaryOperator;
import redempt.crunch.token.Constant;
import redempt.crunch.token.LazyVariable;
import redempt.crunch.token.Token;
import redempt.crunch.token.UnaryOperator;
import redempt.crunch.token.Value;

public class ExpressionEnv {
    private CharTree<BinaryOperator> binaryOperators = new CharTree();
    private CharTree<Token> leadingOperators = new CharTree();
    private CharTree<Value> values = new CharTree();
    private int varCount = 0;

    public ExpressionEnv() {
        for (BinaryOperator enum_ : BinaryOperator.values()) {
            this.binaryOperators.set(enum_.symbol, enum_);
        }
        for (Enum enum_ : UnaryOperator.values()) {
            this.leadingOperators.set(((UnaryOperator)enum_).symbol, (Token)((Object)enum_));
        }
        for (Enum enum_ : Constant.values()) {
            this.values.set(((Constant)enum_).toString().toLowerCase(Locale.ROOT), (Value)((Object)enum_));
        }
    }

    private void checkName(String string) {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Identifier cannot be empty or null");
        }
        if (!Character.isAlphabetic(string.charAt(0))) {
            throw new IllegalArgumentException("Identifier must begin with an alphabetic character");
        }
    }

    public void addFunction(Function function) {
        this.checkName(function.getName());
        char[] cArray = function.getName().toCharArray();
        this.leadingOperators.set(function.getName(), function);
    }

    public void addFunctions(Function ... functionArray) {
        for (Function function : functionArray) {
            this.addFunction(function);
        }
    }

    public void addLazyVariable(String string, DoubleSupplier doubleSupplier) {
        this.checkName(string);
        this.values.set(string, new LazyVariable(string, doubleSupplier));
    }

    public void setVariableNames(String ... stringArray) {
        this.varCount = stringArray.length;
        for (int i = 0; i < stringArray.length; ++i) {
            this.checkName(stringArray[i]);
            this.values.set(stringArray[i], new Variable(null, i));
        }
    }

    public void addFunction(String string, int n, ToDoubleFunction<double[]> toDoubleFunction) {
        this.addFunction(new Function(string, n, toDoubleFunction));
    }

    public CharTree<Token> getLeadingOperators() {
        return this.leadingOperators;
    }

    public CharTree<BinaryOperator> getBinaryOperators() {
        return this.binaryOperators;
    }

    public CharTree<Value> getValues() {
        return this.values;
    }

    public int getVariableCount() {
        return this.varCount;
    }
}

