/*
 * Decompiled with CFR 0.152.
 */
package redempt.crunch.functional;

import redempt.crunch.functional.Function;
import redempt.crunch.token.TokenType;
import redempt.crunch.token.Value;

public class FunctionCall
implements Value {
    private Value[] values;
    private Function function;
    private double[] numbers;

    public FunctionCall(Function function, Value[] valueArray) {
        this.function = function;
        this.values = valueArray;
        this.numbers = new double[function.getArgCount()];
    }

    @Override
    public TokenType getType() {
        return TokenType.FUNCTION_CALL;
    }

    @Override
    public double getValue() {
        for (int i = 0; i < this.values.length; ++i) {
            this.numbers[i] = this.values[i].getValue();
        }
        return this.function.call(this.numbers);
    }

    @Override
    public Value getClone() {
        Value[] valueArray = new Value[this.values.length];
        System.arraycopy(this.values, 0, valueArray, 0, this.values.length);
        return new FunctionCall(this.function, this.values);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.function.getName()).append('(');
        for (int i = 0; i < this.values.length; ++i) {
            Value value = this.values[i];
            stringBuilder.append(value.toString());
            if (i == this.values.length - 1) continue;
            stringBuilder.append(", ");
        }
        return stringBuilder.append(')').toString();
    }
}

