/*
 * Decompiled with CFR 0.152.
 */
package redempt.crunch.token;

import java.util.function.DoubleBinaryOperator;
import redempt.crunch.token.Token;
import redempt.crunch.token.TokenType;

public enum BinaryOperator implements Token
{
    BOOLEAN_OR("|", 0, (d, d2) -> d == 1.0 || d2 == 1.0 ? 1.0 : 0.0),
    BOOLEAN_OR_ALT("||", 0, (d, d2) -> d == 1.0 || d2 == 1.0 ? 1.0 : 0.0),
    BOOLEAN_AND("&", 0, (d, d2) -> d == 1.0 && d2 == 1.0 ? 1.0 : 0.0),
    BOOLEAN_AND_ALT("&&", 0, (d, d2) -> d == 1.0 && d2 == 1.0 ? 1.0 : 0.0),
    GREATER_THAN(">", 1, (d, d2) -> d > d2 ? 1.0 : 0.0),
    LESS_THAN("<", 1, (d, d2) -> d < d2 ? 1.0 : 0.0),
    EQUAL_TO("=", 1, (d, d2) -> d == d2 ? 1.0 : 0.0),
    EQUAL_TO_ALT("==", 1, (d, d2) -> d == d2 ? 1.0 : 0.0),
    NOT_EQUAL_TO("!=", 1, (d, d2) -> d != d2 ? 1.0 : 0.0),
    GREATER_THAN_OR_EQUAL_TO(">=", 1, (d, d2) -> d >= d2 ? 1.0 : 0.0),
    LESS_THAN_OR_EQUAL_TO("<=", 1, (d, d2) -> d <= d2 ? 1.0 : 0.0),
    EXPONENT("^", 5, (d, d2) -> Math.pow(d, d2)),
    MULTIPLY("*", 4, (d, d2) -> d * d2),
    DIVIDE("/", 4, (d, d2) -> d / d2),
    MODULUS("%", 4, (d, d2) -> d % d2),
    ADD("+", 3, (d, d2) -> d + d2),
    SUBTRACT("-", 3, (d, d2) -> d - d2),
    SCIENTIFIC_NOTATION("E", 5, (d, d2) -> d * Math.pow(10.0, d2));

    public final String symbol;
    public final DoubleBinaryOperator operate;
    public final int priority;

    private BinaryOperator(String string2, int n2, DoubleBinaryOperator doubleBinaryOperator) {
        this.symbol = string2;
        this.operate = doubleBinaryOperator;
        this.priority = n2;
    }

    @Override
    public TokenType getType() {
        return TokenType.BINARY_OPERATOR;
    }

    public String toString() {
        return this.symbol;
    }
}

