/*
 * Decompiled with CFR 0.152.
 */
package deadlydisasters.entities;

import deadlydisasters.Main;
import deadlydisasters.entities.CustomEntity;
import deadlydisasters.utils.AnimationHandler;
import java.util.Iterator;
import org.bukkit.Location;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Mob;
import org.bukkit.util.EulerAngle;

public class AnimatedEntity
extends CustomEntity {
    protected ArmorStand stand;
    protected Location stepLocation;
    protected AnimationHandler walkAnimation;
    protected AnimationHandler attackAnimation;
    protected float bodyRotation;
    protected float rotationSpeed = 8.0f;
    protected boolean shouldWalk = true;

    public AnimatedEntity(Mob mob, Main main) {
        super(mob, main);
        this.stepLocation = mob.getLocation();
        this.attackAnimation = new AnimationHandler(true, false, false);
        AnimationHandler.Animation[] animationArray = new AnimationHandler.Animation[1];
        AnimationHandler animationHandler = this.attackAnimation;
        animationHandler.getClass();
        AnimationHandler.AnimationCheckpoint[] animationCheckpointArray = new AnimationHandler.AnimationCheckpoint[2];
        AnimationHandler animationHandler2 = this.attackAnimation;
        animationHandler2.getClass();
        animationCheckpointArray[0] = new AnimationHandler.AnimationCheckpoint(animationHandler2, AnimationHandler.BodyPart.RIGHT_ARM, 0.0, 0.0, 0.0, -112.0, 30.0, 0.0, 8, true, 0.5, 0.5);
        AnimationHandler animationHandler3 = this.attackAnimation;
        animationHandler3.getClass();
        animationCheckpointArray[1] = new AnimationHandler.AnimationCheckpoint(animationHandler3, AnimationHandler.BodyPart.LEFT_ARM, 0.0, 0.0, 0.0, -112.0, -30.0, 0.0, 8, true, 0.5, 0.5);
        animationArray[0] = new AnimationHandler.Animation(animationHandler, animationCheckpointArray);
        this.attackAnimation.setAnimations(animationArray);
    }

    @Override
    public void tick() {
        Location location = this.entity.getLocation();
        float f = location.getYaw() - this.bodyRotation;
        this.bodyRotation = Math.abs(f) > 300.0f ? location.getYaw() : (this.bodyRotation += f / this.rotationSpeed);
        this.stand.setHeadPose(new EulerAngle(Math.toRadians(this.entity.getLocation().getPitch()), Math.toRadians(location.getYaw() - this.bodyRotation), 0.0));
        location.setYaw(this.bodyRotation);
        this.stand.teleport(location);
        if (this.shouldWalk && this.stepLocation.distanceSquared(this.entity.getLocation()) > 0.01 && this.entity.isOnGround()) {
            this.stepLocation = this.entity.getLocation();
            this.walkAnimation.go();
        } else {
            this.walkAnimation.stop();
        }
        this.walkAnimation.tick(this.stand);
        this.attackAnimation.tick(this.stand);
    }

    @Override
    public void function(Iterator<CustomEntity> iterator) {
    }

    @Override
    public void clean() {
        if (this.stand != null) {
            this.stand.remove();
        }
    }

    @Override
    public void update(FileConfiguration fileConfiguration) {
    }

    public void attack() {
        if (this.stand == null) {
            return;
        }
        this.attackAnimation.startAnimation(this.stand);
    }
}

