/*
 * Decompiled with CFR 0.152.
 */
package deadlydisasters.entities;

import deadlydisasters.Main;
import deadlydisasters.entities.CustomDrop;
import deadlydisasters.entities.CustomEntityType;
import deadlydisasters.handlers.ItemsHandler;
import deadlydisasters.utils.Utils;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class CustomDropsFactory {
    private static boolean allowDrops;
    private static Map<String, Queue<CustomDrop>> dropMap;

    static {
        dropMap = new HashMap<String, Queue<CustomDrop>>();
    }

    public static void generateDrops(Location location, CustomEntityType customEntityType) {
        if (allowDrops) {
            for (CustomDrop customDrop : dropMap.get(customEntityType.species)) {
                customDrop.generateItems(location, false);
            }
        }
    }

    public static void generateDrops(Location location, CustomEntityType customEntityType, boolean bl) {
        if (allowDrops) {
            for (CustomDrop customDrop : dropMap.get(customEntityType.species)) {
                customDrop.generateItems(location, bl);
            }
        }
    }

    public static void reload(Main main) {
        dropMap.clear();
        allowDrops = CustomEntityType.yaml.getBoolean("settings.allow_custom_drops");
        Random random = new Random();
        CustomEntityType[] customEntityTypeArray = CustomEntityType.values();
        int n = customEntityTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            CustomEntityType customEntityType = customEntityTypeArray[n2];
            dropMap.put(customEntityType.species, new ArrayDeque());
            for (String string : customEntityType.getDropsList()) {
                int n3;
                int n4;
                string = string.replaceAll("\\s+", "");
                ItemStack itemStack = null;
                if (ItemsHandler.allItems.containsKey(string.substring(0, string.indexOf(124)))) {
                    itemStack = ItemsHandler.allItems.get(string.substring(0, string.indexOf(124)));
                } else if (Material.getMaterial((String)string.substring(0, string.indexOf(124)).toUpperCase()) != null) {
                    itemStack = new ItemStack(Material.getMaterial((String)string.substring(0, string.indexOf(124)).toUpperCase()));
                } else {
                    if (!main.debug) continue;
                    Main.consoleSender.sendMessage(Utils.chat("&e[DeadlyDisasters]: Item &d'" + string.substring(0, string.indexOf(124)) + "' &edoes not exist in config at &c" + customEntityType.configPath + ".drops"));
                    continue;
                }
                string = string.substring(string.indexOf(124) + 1);
                double d = 0.0;
                try {
                    d = Double.parseDouble(string.substring(0, string.indexOf(124))) / 100.0;
                }
                catch (NumberFormatException numberFormatException) {
                    if (!main.debug) continue;
                    Main.consoleSender.sendMessage(Utils.chat("&e[DeadlyDisasters]: &d'" + string.substring(0, string.indexOf(124)) + "' &eis not a valid double in config at &c" + customEntityType.configPath + ".drops"));
                    continue;
                }
                string = string.substring(string.indexOf(124) + 1);
                try {
                    n4 = Integer.parseInt(string.substring(0, string.indexOf(45)));
                    n3 = Integer.parseInt(string.substring(string.indexOf(45) + 1));
                }
                catch (NumberFormatException numberFormatException) {
                    if (!main.debug) continue;
                    Main.consoleSender.sendMessage(Utils.chat("&e[DeadlyDisasters]: &d'" + string + "' &einvalid integer min-max value in config at &c" + customEntityType.configPath + ".drops"));
                    continue;
                }
                dropMap.get(customEntityType.species).add(new CustomDrop(itemStack, d, n4, n3, random));
            }
            ++n2;
        }
    }
}

