/*
 * Decompiled with CFR 0.152.
 */
package deadlydisasters.entities.christmasentities;

import deadlydisasters.Main;
import deadlydisasters.entities.CustomDropsFactory;
import deadlydisasters.entities.CustomEntity;
import deadlydisasters.entities.CustomEntityType;
import deadlydisasters.entities.CustomHead;
import deadlydisasters.entities.EntityHandler;
import deadlydisasters.handlers.ItemsHandler;
import deadlydisasters.handlers.Languages;
import deadlydisasters.utils.RepeatingTask;
import deadlydisasters.utils.Utils;
import java.util.Iterator;
import java.util.Random;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.attribute.Attribute;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.entity.Slime;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;

public class Grinch
extends CustomEntity {
    private int cooldown = 4;
    private ArmorStand stand;
    private ItemStack weapon;
    private Slime projectile;
    private Random rand;
    private boolean cursed;

    public Grinch(Mob mob, Main main, Random random) {
        super(mob, main);
        this.rand = random;
        this.entityType = CustomEntityType.GRINCH;
        this.species = this.entityType.species;
        mob.getPersistentDataContainer().set(this.entityType.nameKey, PersistentDataType.BYTE, (Object)0);
        ItemStack[] itemStackArray = new ItemStack[]{new ItemStack(Material.LEATHER_BOOTS), new ItemStack(Material.LEATHER_LEGGINGS), new ItemStack(Material.LEATHER_CHESTPLATE), CustomHead.GRINCH.getHead()};
        int n = 0;
        while (n < 3) {
            LeatherArmorMeta leatherArmorMeta = (LeatherArmorMeta)itemStackArray[n].getItemMeta();
            leatherArmorMeta.setColor(Color.fromBGR((int)28, (int)94, (int)4));
            itemStackArray[n].setItemMeta((ItemMeta)leatherArmorMeta);
            ++n;
        }
        mob.getEquipment().setArmorContents(itemStackArray);
        mob.getEquipment().setHelmetDropChance(0.0f);
        mob.getEquipment().setChestplateDropChance(0.0f);
        mob.getEquipment().setLeggingsDropChance(0.0f);
        mob.getEquipment().setBootsDropChance(0.0f);
        if (random.nextInt(10) == 0) {
            this.weapon = ItemsHandler.cursedCandyCane;
            this.cursed = true;
        } else {
            this.weapon = ItemsHandler.candyCane;
        }
        mob.getEquipment().setItemInMainHand(this.weapon);
        mob.getEquipment().setItemInMainHandDropChance(0.0f);
        mob.setCanPickupItems(false);
        mob.setSilent(true);
        mob.getAttribute(Attribute.GENERIC_MAX_HEALTH).setBaseValue(this.entityType.getHealth());
        mob.setHealth(this.entityType.getHealth());
        mob.getAttribute(Attribute.GENERIC_ATTACK_DAMAGE).setBaseValue(this.entityType.getDamage());
        mob.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED).setBaseValue(0.35);
        mob.getAttribute(Attribute.GENERIC_FOLLOW_RANGE).setBaseValue(30.0);
        mob.setMetadata("dd-grinch", (MetadataValue)main.fixedData);
        mob.setMetadata("dd-christmasmob", (MetadataValue)main.fixedData);
        if (mob.getCustomName() == null) {
            mob.setCustomName(Languages.getString("entities.grinch"));
        }
    }

    @Override
    public void tick() {
        if (this.entity == null) {
            return;
        }
        if (this.entity.getNoDamageTicks() == 20) {
            this.entity.getWorld().playSound(this.entity.getLocation(), Sound.ENTITY_ZOMBIE_HURT, SoundCategory.HOSTILE, 1.0f, 0.5f);
        }
        this.entity.getWorld().spawnParticle(Particle.FALLING_DUST, this.entity.getLocation().add(0.0, this.entity.getHeight() / 2.0, 0.0), 2, 0.3, 0.5, 0.3, 1.0, (Object)Material.LIME_WOOL.createBlockData());
        this.entity.getWorld().spawnParticle(Particle.FALLING_DUST, this.entity.getLocation().add(0.0, this.entity.getHeight() / 2.0, 0.0), 2, 0.3, 0.5, 0.3, 1.0, (Object)Material.RED_WOOL.createBlockData());
    }

    @Override
    public void function(Iterator<CustomEntity> iterator) {
        this.entity = (Mob)this.plugin.getServer().getEntity(this.entityUUID);
        if (this.entity == null) {
            iterator.remove();
            this.clean();
            return;
        }
        if (this.entity.isDead()) {
            this.entity.getWorld().playSound(this.entity.getLocation(), Sound.ENTITY_ZOMBIE_DEATH, SoundCategory.HOSTILE, 1.0f, 0.5f);
            if (this.entity.getKiller() != null) {
                CustomDropsFactory.generateDrops(this.entity.getLocation(), this.entityType);
                if (this.rand.nextDouble() * 100.0 < (Double)this.entityType.grabCustomSetting("candy_cane_droprate")) {
                    this.entity.getWorld().dropItemNaturally(this.entity.getLocation(), this.weapon);
                }
            }
            iterator.remove();
            this.clean();
            return;
        }
        if (this.rand.nextInt(6) == 0) {
            this.entity.getWorld().playSound(this.entity.getLocation(), Sound.ENTITY_ZOMBIE_AMBIENT, SoundCategory.HOSTILE, 1.0f, 0.5f);
        }
        if (this.cooldown > 0) {
            --this.cooldown;
            return;
        }
        if (this.stand == null && this.entity.getTarget() != null && this.entity.getTarget().getWorld().equals(this.entity.getWorld()) && this.entity.getTarget().getLocation().distanceSquared(this.entity.getLocation()) >= 30.0 && this.entity.getTarget().getLocation().distanceSquared(this.entity.getLocation()) <= 350.0) {
            this.cooldown = 4;
            this.entity.addPotionEffect(new PotionEffect(PotionEffectType.SLOW, 15, 10, true, false));
            this.stand = Utils.lockArmorStand((ArmorStand)this.entity.getWorld().spawnEntity(this.entity.getLocation().add(100.0, 100.0, 0.0), EntityType.ARMOR_STAND), true, false, true);
            this.stand.getEquipment().setItemInMainHand(this.weapon);
            this.stand.setRightArmPose(new EulerAngle(0.0, 0.0, 0.0));
            this.stand.getPersistentDataContainer().set(EntityHandler.removalKey, PersistentDataType.BYTE, (Object)0);
            this.projectile = (Slime)this.entity.getWorld().spawnEntity(this.entity.getLocation().add(0.0, 100.0, 0.0), EntityType.SLIME);
            this.projectile.setSize(0);
            this.projectile.setSilent(true);
            this.projectile.getAttribute(Attribute.GENERIC_MAX_HEALTH).setBaseValue(100.0);
            this.projectile.setHealth(100.0);
            this.projectile.getAttribute(Attribute.GENERIC_ATTACK_DAMAGE).setBaseValue(0.0);
            this.projectile.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, 999999, 0, true, false));
            this.projectile.teleport((Entity)this.entity);
            this.projectile.teleport(this.projectile.getLocation().add(0.0, 1.0, 0.0));
            this.projectile.setVelocity(Utils.getVectorTowards(this.entity.getLocation(), this.entity.getTarget().getLocation()).multiply(1.5).add(new Vector(0.0, this.entity.getLocation().distance(this.entity.getTarget().getLocation()) / 20.0, 0.0)));
            this.entity.getEquipment().setItemInMainHand(new ItemStack(Material.AIR));
            this.entity.swingMainHand();
            new RepeatingTask(this.plugin, 0, 1){

                @Override
                public void run() {
                    if (Grinch.this.stand == null || Grinch.this.stand.isDead() || Grinch.this.projectile == null || Grinch.this.projectile.isDead() || Grinch.this.entity == null) {
                        Grinch.this.clean();
                        Grinch.this.stand = null;
                        Grinch.this.entity.getEquipment().setItemInMainHand(Grinch.this.weapon);
                        this.cancel();
                        return;
                    }
                    if (Grinch.this.cursed && Grinch.this.entity.getTarget() != null && Grinch.this.entity.getTarget().getWorld().equals(Grinch.this.entity.getWorld())) {
                        Grinch.this.projectile.setVelocity(Grinch.this.projectile.getVelocity().add(Utils.getVectorTowards(Grinch.this.projectile.getLocation(), Grinch.this.entity.getTarget().getLocation().add(0.0, Grinch.this.entity.getTarget().getHeight() / 2.0, 0.0)).multiply(0.2)));
                    }
                    Grinch.this.stand.teleport(Grinch.this.projectile.getLocation().add(0.0, -1.0, 0.0));
                    Vector vector = Grinch.this.projectile.getVelocity();
                    double d = Math.abs(vector.getX());
                    if (Math.abs(vector.getZ()) > d) {
                        d = Math.abs(vector.getZ());
                    }
                    double d2 = Math.toDegrees(Math.atan2(Math.abs(vector.getY()), d));
                    if (vector.getY() >= 0.0) {
                        Grinch.this.stand.setRightArmPose(new EulerAngle(Math.toRadians(360.0 - d2), 0.0, 0.0));
                    } else {
                        Grinch.this.stand.setRightArmPose(new EulerAngle(Math.toRadians(360.0 + d2), 0.0, 0.0));
                    }
                    if (Grinch.this.cursed) {
                        Grinch.this.stand.getWorld().spawnParticle(Particle.BLOCK_CRACK, Grinch.this.stand.getLocation().add(0.0, 1.0, 0.0), 2, 0.1, 0.1, 0.1, 1.0, (Object)Material.PURPLE_WOOL.createBlockData());
                    } else {
                        Grinch.this.stand.getWorld().spawnParticle(Particle.BLOCK_CRACK, Grinch.this.stand.getLocation().add(0.0, 1.0, 0.0), 2, 0.1, 0.1, 0.1, 1.0, (Object)Material.RED_WOOL.createBlockData());
                    }
                    Grinch.this.stand.getWorld().spawnParticle(Particle.BLOCK_CRACK, Grinch.this.stand.getLocation().add(0.0, 1.0, 0.0), 2, 0.1, 0.1, 0.1, 1.0, (Object)Material.SNOW.createBlockData());
                    if (Grinch.this.projectile.isOnGround()) {
                        Grinch.this.entity.getWorld().spawnParticle(Particle.BLOCK_CRACK, Grinch.this.entity.getLocation().add(0.0, 1.2, 0.0), 30, 0.4, 0.6, 0.4, 1.0, (Object)Material.SNOW.createBlockData());
                        Grinch.this.entity.getWorld().spawnParticle(Particle.BLOCK_DUST, Grinch.this.entity.getLocation().add(0.0, 1.2, 0.0), 30, 0.4, 0.6, 0.4, 1.0, (Object)Material.SNOW.createBlockData());
                        Grinch.this.entity.teleport((Entity)Grinch.this.projectile);
                        Grinch.this.stand.remove();
                        Grinch.this.projectile.remove();
                        Grinch.this.plugin.getServer().getScheduler().runTaskLater((Plugin)Grinch.this.plugin, () -> Grinch.this.entity.getEquipment().setItemInMainHand(Grinch.this.weapon), 3L);
                        Grinch.this.stand = null;
                        this.cancel();
                        return;
                    }
                    for (Entity entity : Grinch.this.projectile.getNearbyEntities(0.5, 0.5, 0.5)) {
                        if (!(entity instanceof LivingEntity) || entity.equals(Grinch.this.entity) || entity instanceof Player && Utils.isPlayerImmune((Player)entity)) continue;
                        Utils.pureDamageEntity((LivingEntity)entity, 7.0, "dd-candycane", false, (Entity)Grinch.this.entity);
                        ((LivingEntity)entity).addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, 40, 1, true, false));
                        if (Grinch.this.cursed) {
                            ((LivingEntity)entity).addPotionEffect(new PotionEffect(PotionEffectType.WEAKNESS, 80, 2, true, false));
                        }
                        Grinch.this.entity.setHealth(Math.min(Grinch.this.entity.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue(), Grinch.this.entity.getHealth() + 12.0));
                        Grinch.this.entity.getWorld().spawnParticle(Particle.BLOCK_CRACK, Grinch.this.entity.getLocation().add(0.0, 1.2, 0.0), 30, 0.4, 0.6, 0.4, 1.0, (Object)Material.SNOW.createBlockData());
                        Grinch.this.entity.getWorld().spawnParticle(Particle.BLOCK_DUST, Grinch.this.entity.getLocation().add(0.0, 1.2, 0.0), 30, 0.4, 0.6, 0.4, 1.0, (Object)Material.SNOW.createBlockData());
                        Grinch.this.entity.teleport((Entity)Grinch.this.projectile);
                        Grinch.this.entity.getWorld().spawnParticle(Particle.COMPOSTER, Grinch.this.entity.getLocation().add(0.0, 1.2, 0.0), 10, 0.3, 0.5, 0.3, 0.001);
                        Grinch.this.stand.remove();
                        Grinch.this.projectile.remove();
                        Grinch.this.plugin.getServer().getScheduler().runTaskLater((Plugin)Grinch.this.plugin, () -> Grinch.this.entity.getEquipment().setItemInMainHand(Grinch.this.weapon), 3L);
                        Grinch.this.stand = null;
                        this.cancel();
                        return;
                    }
                }
            };
        }
    }

    @Override
    public void clean() {
        if (this.stand != null) {
            this.stand.remove();
        }
        if (this.projectile != null) {
            this.projectile.remove();
        }
    }

    @Override
    public void update(FileConfiguration fileConfiguration) {
    }
}

