/*
 * Decompiled with CFR 0.152.
 */
package deadlydisasters.entities.easterentities;

import deadlydisasters.Main;
import deadlydisasters.entities.CustomDropsFactory;
import deadlydisasters.entities.CustomEntity;
import deadlydisasters.entities.CustomEntityType;
import deadlydisasters.entities.EntityHandler;
import deadlydisasters.entities.easterentities.KillerChicken;
import deadlydisasters.handlers.Languages;
import deadlydisasters.utils.DDSong;
import deadlydisasters.utils.RepeatingTask;
import deadlydisasters.utils.SongMaker;
import deadlydisasters.utils.Utils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Firework;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.entity.Rabbit;
import org.bukkit.entity.Slime;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.BlockVector;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;

public class EasterBunny
extends CustomEntity {
    private int cooldown = 10;
    private int leap = 7;
    private int eggLay = 15;
    private int jumpTicks = 15;
    private Random rand;
    private BossBar bar;
    public SongMaker songMaker;
    public LivingEntity target;
    private int biteTicks;
    private ArmorStand[] stands = new ArmorStand[5];
    private Slime[] slimes = new Slime[5];
    private List<KillerChicken> chickens = new ArrayList<KillerChicken>();
    public static Set<Block> easterBasketBlocks = new HashSet<Block>();

    public EasterBunny(Rabbit rabbit, Main main, Random random) {
        super((Mob)rabbit, main);
        this.rand = random;
        this.entityType = CustomEntityType.EASTERBUNNY;
        this.species = this.entityType.species;
        rabbit.getPersistentDataContainer().set(this.entityType.nameKey, PersistentDataType.BYTE, (Object)0);
        rabbit.setRabbitType(Rabbit.Type.THE_KILLER_BUNNY);
        rabbit.getAttribute(Attribute.GENERIC_MAX_HEALTH).setBaseValue(this.entityType.getHealth());
        rabbit.setHealth(this.entityType.getHealth());
        rabbit.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED).setBaseValue(0.5);
        rabbit.getAttribute(Attribute.GENERIC_FOLLOW_RANGE).setBaseValue(40.0);
        rabbit.setMetadata("dd-easterbunny", (MetadataValue)main.fixedData);
        rabbit.setMetadata("dd-eastermobs", (MetadataValue)main.fixedData);
        if (rabbit.getCustomName() == null) {
            rabbit.setCustomName(Languages.getString("easter.easterBunny"));
        }
        this.bar = Bukkit.createBossBar((String)Utils.chat("&c" + Languages.getString("easter.easterBunny")), (BarColor)BarColor.RED, (BarStyle)BarStyle.SOLID, (BarFlag[])new BarFlag[]{BarFlag.DARKEN_SKY, BarFlag.CREATE_FOG});
    }

    @Override
    public void tick() {
        if (this.entity == null) {
            return;
        }
        this.bar.setProgress(Utils.clamp(1.0 / this.entityType.getHealth() * this.entity.getHealth(), 0.0, 1.0));
        int n = 0;
        while (n < 8) {
            Particle.DustTransition dustTransition = new Particle.DustTransition(Color.fromRGB((int)(this.rand.nextInt(125) + 25), (int)255, (int)(this.rand.nextInt(55) + 25)), Color.fromRGB((int)25, (int)(this.rand.nextInt(155) + 100), (int)255), this.rand.nextFloat());
            if (this.rand.nextInt(2) == 0) {
                dustTransition = new Particle.DustTransition(Color.fromRGB((int)(this.rand.nextInt(105) + 150), (int)25, (int)255), Color.fromRGB((int)25, (int)(this.rand.nextInt(155) + 100), (int)255), this.rand.nextFloat() / 2.0f);
            }
            this.entity.getWorld().spawnParticle(Particle.DUST_COLOR_TRANSITION, this.entity.getLocation().add(this.rand.nextDouble() - 0.5, 0.3 + (this.rand.nextDouble() / 2.0 - 0.25), this.rand.nextDouble() - 0.5), 1, 0.0, 0.0, 0.0, 0.001, (Object)dustTransition);
            ++n;
        }
        if (this.biteTicks <= 0) {
            if (this.entity.getTarget() != null && this.entity.getTarget().getType() != EntityType.ARMOR_STAND && this.entity.getTarget().getWorld().equals(this.entity.getWorld()) && this.entity.getTarget().getLocation().distanceSquared(this.entity.getLocation()) <= 1.25) {
                this.biteTicks = 8;
                Utils.damageEntity(this.entity.getTarget(), this.entityType.getDamage(), "dd-easterbunnybite", false, (Entity)this.entity);
            }
        } else {
            --this.biteTicks;
        }
        if (this.jumpTicks-- <= 0 && this.entity.getVelocity().getY() > 0.0 && this.entity.getVelocity().getY() < 0.3) {
            this.jumpTicks = 15;
            this.entity.setVelocity(this.entity.getVelocity().multiply(1.5).setY(0.6));
        }
    }

    @Override
    public void function(Iterator<CustomEntity> iterator) {
        this.entity = (Mob)this.plugin.getServer().getEntity(this.entityUUID);
        if (this.entity == null) {
            iterator.remove();
            this.clean();
            if (this.songMaker != null) {
                this.songMaker.stopSong();
            }
            return;
        }
        if (this.entity.isDead()) {
            CustomDropsFactory.generateDrops(this.entity.getLocation(), this.entityType, true);
            this.bar.removeAll();
            iterator.remove();
            this.clean();
            if (this.songMaker != null) {
                this.songMaker.stopSong();
            }
            return;
        }
        if (this.rand.nextInt(4) == 0) {
            this.entity.getWorld().playSound(this.entity.getLocation(), Sound.ENTITY_RABBIT_ATTACK, SoundCategory.HOSTILE, 1.0f, 0.5f);
        }
        this.bar.removeAll();
        if (this.songMaker != null) {
            this.songMaker.removeAll();
        }
        for (Object object : this.entity.getNearbyEntities(40.0, 40.0, 40.0)) {
            if (!(object instanceof Player)) continue;
            this.bar.addPlayer((Player)object);
            if (this.songMaker == null) continue;
            this.songMaker.addPlayer((Player)object);
        }
        if (this.entity.getTarget() == null && this.target != null && !this.target.isDead()) {
            this.entity.setTarget(this.target);
        }
        if (this.eggLay > 0) {
            --this.eggLay;
        } else if (this.entity.getTarget() != null && this.entity.getTarget().getType() != EntityType.ARMOR_STAND) {
            this.eggLay = 20;
            new RepeatingTask(this.plugin, 0, 20){

                @Override
                public void run() {
                    if (EasterBunny.this.entity.getHealth() >= EasterBunny.this.entity.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue() / 2.0 && EasterBunny.this.eggLay <= 17 || EasterBunny.this.eggLay <= 15 || EasterBunny.this.entity == null || EasterBunny.this.entity.isDead() || EasterBunny.this.chickens.size() >= 10) {
                        this.cancel();
                        return;
                    }
                    KillerChicken.createEgg(EasterBunny.this.entity.getLocation(), EasterBunny.this.plugin, EasterBunny.this.target, EasterBunny.this.chickens);
                    EasterBunny.this.entity.getWorld().playSound(EasterBunny.this.entity.getLocation(), Sound.ENTITY_CHICKEN_EGG, SoundCategory.HOSTILE, 1.0f, 0.0f);
                }
            };
        }
        if (this.leap > 0) {
            --this.leap;
        }
        if (this.cooldown > 0) {
            if (this.cooldown >= 5 && this.leap <= 0 && this.entity.getTarget() != null && this.entity.getTarget().getWorld().equals(this.entity.getWorld())) {
                this.leap = 12;
                this.entity.getWorld().playSound(this.entity.getLocation(), Sound.ENTITY_RABBIT_JUMP, SoundCategory.HOSTILE, 20.0f, 0.0f);
                this.entity.setVelocity(Utils.getVectorTowards(this.entity.getLocation(), this.entity.getTarget().getLocation()).multiply(this.entity.getLocation().distance(this.entity.getTarget().getLocation()) / 10.0).setY(2));
                new RepeatingTask(this.plugin, 10, 1){

                    @Override
                    public void run() {
                        block10: {
                            if (EasterBunny.this.entity == null || EasterBunny.this.entity.isDead()) {
                                this.cancel();
                                return;
                            }
                            if (!EasterBunny.this.entity.isOnGround()) break block10;
                            BlockVector blockVector = new BlockVector(EasterBunny.this.entity.getLocation().getBlockX(), EasterBunny.this.entity.getLocation().getBlockY(), EasterBunny.this.entity.getLocation().getBlockZ());
                            HashSet<Material> hashSet = new HashSet<Material>();
                            hashSet.addAll(Tag.FLOWERS.getValues());
                            hashSet.addAll(Tag.SMALL_FLOWERS.getValues());
                            hashSet.addAll(Tag.TALL_FLOWERS.getValues());
                            hashSet.addAll(Set.of(Material.GRASS, Material.TALL_GRASS));
                            EasterBunny.this.entity.getWorld().playSound(EasterBunny.this.entity.getLocation(), Sound.BLOCK_GRASS_BREAK, SoundCategory.HOSTILE, 2.0f, 0.0f);
                            World world = EasterBunny.this.entity.getWorld();
                            int n = -4;
                            while (n < 4) {
                                int n2 = -4;
                                while (n2 < 4) {
                                    block11: {
                                        Block block;
                                        block13: {
                                            int n3;
                                            block12: {
                                                Vector vector = blockVector.clone().add(new Vector(n, 0, n2));
                                                block = world.getBlockAt(vector.toLocation(world));
                                                if (!(blockVector.distance(vector) <= 4.0)) break block11;
                                                if (!block.isPassable()) break block12;
                                                n3 = 0;
                                                while (n3 < 3) {
                                                    if (!(block = block.getRelative(BlockFace.DOWN)).isPassable()) break;
                                                    ++n3;
                                                }
                                                if (block.isPassable()) break block11;
                                                block = block.getRelative(BlockFace.UP);
                                                break block13;
                                            }
                                            n3 = 0;
                                            while (n3 < 3) {
                                                if ((block = block.getRelative(BlockFace.UP)).isPassable()) break;
                                                ++n3;
                                            }
                                            if (!block.isPassable()) break block11;
                                        }
                                        world.spawnParticle(Particle.BLOCK_CRACK, block.getLocation().clone().add(0.5, 0.5, 0.5), 6, 0.3, 0.5, 0.3, 0.001, (Object)Material.COARSE_DIRT.createBlockData());
                                        if (hashSet.contains(block.getType()) && !Utils.isZoneProtected(block.getLocation()) && !Utils.isBlockImmune(block.getType())) {
                                            block.breakNaturally(new ItemStack(Material.AIR));
                                        }
                                        for (Entity entity : world.getNearbyEntities(block.getLocation().clone().add(0.5, 0.5, 0.5), 0.5, 1.0, 0.5)) {
                                            if (entity.equals(EasterBunny.this.entity)) continue;
                                            entity.setVelocity(new Vector(entity.getLocation().getX() - EasterBunny.this.entity.getLocation().getX(), 0.0, entity.getLocation().getZ() - EasterBunny.this.entity.getLocation().getZ()).normalize().multiply(0.7).setY(1.5));
                                            if (!(entity instanceof LivingEntity) || entity instanceof Player && Utils.isPlayerImmune((Player)entity)) continue;
                                            Utils.damageEntity((LivingEntity)entity, 15.0, "dd-easterbunny", false, (Entity)EasterBunny.this.entity);
                                        }
                                    }
                                    ++n2;
                                }
                                ++n;
                            }
                            this.cancel();
                        }
                    }
                };
            }
            --this.cooldown;
            return;
        }
        if (this.entity.getTarget() != null && this.entity.getTarget().getType() != EntityType.ARMOR_STAND && this.entity.getTarget().getWorld().equals(this.entity.getWorld()) && this.entity.getTarget().getLocation().distanceSquared(this.entity.getLocation()) <= 325.0 && this.entity.getTarget().getLocation().distanceSquared(this.entity.getLocation()) >= 16.0) {
            Object object;
            this.cooldown = 10;
            this.entity.addPotionEffect(new PotionEffect(PotionEffectType.SLOW, 60, 10, true, false));
            int[] nArray = new int[2];
            nArray[1] = 2;
            object = nArray;
            if (this.entity.getHealth() <= this.entity.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue() / 2.0) {
                object[1] = (Entity)4;
            }
            new RepeatingTask(this.plugin, 0, 8, (int[])object){
                private final /* synthetic */ int[] val$index;
                {
                    this.val$index = nArray;
                    super(javaPlugin, n, n2);
                }

                @Override
                public void run() {
                    EasterBunny.this.stands[this.val$index[0]] = Utils.lockArmorStand((ArmorStand)EasterBunny.this.entity.getWorld().spawnEntity(EasterBunny.this.entity.getLocation().add(100.0, 100.0, 0.0), EntityType.ARMOR_STAND), true, false, true);
                    EasterBunny.this.stands[this.val$index[0]].getEquipment().setItemInMainHand(new ItemStack(Material.CARROT));
                    EasterBunny.this.stands[this.val$index[0]].setRightArmPose(new EulerAngle(Math.toRadians(270.0), 0.0, 0.0));
                    EasterBunny.this.stands[this.val$index[0]].getPersistentDataContainer().set(EntityHandler.removalKey, PersistentDataType.BYTE, (Object)0);
                    EasterBunny.this.slimes[this.val$index[0]] = (Slime)EasterBunny.this.entity.getWorld().spawnEntity(EasterBunny.this.entity.getLocation().add(0.0, 100.0, 0.0), EntityType.SLIME);
                    EasterBunny.this.slimes[this.val$index[0]].setSize(0);
                    EasterBunny.this.slimes[this.val$index[0]].setSilent(true);
                    EasterBunny.this.slimes[this.val$index[0]].getAttribute(Attribute.GENERIC_MAX_HEALTH).setBaseValue(100.0);
                    EasterBunny.this.slimes[this.val$index[0]].setHealth(100.0);
                    EasterBunny.this.slimes[this.val$index[0]].getAttribute(Attribute.GENERIC_ATTACK_DAMAGE).setBaseValue(0.0);
                    EasterBunny.this.slimes[this.val$index[0]].addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, 999999, 0, true, false));
                    EasterBunny.this.slimes[this.val$index[0]].teleport((Entity)EasterBunny.this.entity);
                    EasterBunny.this.slimes[this.val$index[0]].setVelocity(new Vector(0, 1, 0));
                    Firework firework = (Firework)EasterBunny.this.slimes[this.val$index[0]].getWorld().spawnEntity(EasterBunny.this.slimes[this.val$index[0]].getLocation(), EntityType.FIREWORK);
                    FireworkMeta fireworkMeta = firework.getFireworkMeta();
                    fireworkMeta.addEffect(FireworkEffect.builder().with(FireworkEffect.Type.BURST).withColor(new Color[]{Color.fromRGB((int)(EasterBunny.this.rand.nextInt(125) + 25), (int)255, (int)(EasterBunny.this.rand.nextInt(55) + 25)), Color.fromRGB((int)25, (int)(EasterBunny.this.rand.nextInt(155) + 100), (int)255), Color.fromRGB((int)(EasterBunny.this.rand.nextInt(105) + 150), (int)25, (int)255)}).build());
                    firework.setFireworkMeta(fireworkMeta);
                    firework.detonate();
                    this.val$index[0] = this.val$index[0] + 1;
                    if (this.val$index[0] > this.val$index[1]) {
                        this.cancel();
                        return;
                    }
                }
            };
            new RepeatingTask(this.plugin, 0, 1, (int[])object){
                private final /* synthetic */ int[] val$index;
                {
                    this.val$index = nArray;
                    super(javaPlugin, n, n2);
                }

                @Override
                public void run() {
                    int n;
                    if (this.val$index[0] >= this.val$index[1]) {
                        n = 0;
                        int n2 = 0;
                        while (n2 < this.val$index[0]) {
                            if (EasterBunny.this.stands[n2] == null) {
                                ++n;
                            }
                            ++n2;
                        }
                        if (n >= this.val$index[1] + 1) {
                            this.cancel();
                            return;
                        }
                    }
                    n = 0;
                    while (n < this.val$index[0]) {
                        if (EasterBunny.this.stands[n] == null || EasterBunny.this.stands[n].isDead() || EasterBunny.this.slimes[n] == null || EasterBunny.this.slimes[n].isDead() || EasterBunny.this.entity == null) {
                            if (EasterBunny.this.stands[n] != null) {
                                EasterBunny.this.stands[n].remove();
                            }
                            if (EasterBunny.this.slimes[n] != null) {
                                EasterBunny.this.slimes[n].remove();
                            }
                            EasterBunny.this.stands[n] = null;
                        } else {
                            if (EasterBunny.this.entity.getTarget() != null && EasterBunny.this.entity.getTarget().getWorld().equals(EasterBunny.this.entity.getWorld())) {
                                EasterBunny.this.slimes[n].setVelocity(EasterBunny.this.slimes[n].getVelocity().add(Utils.getVectorTowards(EasterBunny.this.slimes[n].getLocation(), EasterBunny.this.entity.getTarget().getLocation().add(0.0, EasterBunny.this.entity.getTarget().getHeight() / 2.0, 0.0)).multiply(0.1)));
                            }
                            EasterBunny.this.stands[n].teleport(EasterBunny.this.slimes[n].getLocation().add(0.0, -1.0, 0.0));
                            Vector vector = EasterBunny.this.slimes[n].getVelocity();
                            double d = Math.abs(vector.getX());
                            if (Math.abs(vector.getZ()) > d) {
                                d = Math.abs(vector.getZ());
                            }
                            double d2 = Math.toDegrees(Math.atan2(Math.abs(vector.getY()), d));
                            if (vector.getY() >= 0.0) {
                                EasterBunny.this.stands[n].setRightArmPose(new EulerAngle(Math.toRadians(360.0 - d2), 0.0, 0.0));
                            } else {
                                EasterBunny.this.stands[n].setRightArmPose(new EulerAngle(Math.toRadians(360.0 + d2), 0.0, 0.0));
                            }
                            int n3 = 0;
                            while (n3 < 3) {
                                Particle.DustTransition dustTransition = new Particle.DustTransition(Color.fromRGB((int)(((EasterBunny)EasterBunny.this).plugin.random.nextInt(125) + 25), (int)255, (int)(((EasterBunny)EasterBunny.this).plugin.random.nextInt(55) + 25)), Color.fromRGB((int)25, (int)(((EasterBunny)EasterBunny.this).plugin.random.nextInt(155) + 100), (int)255), ((EasterBunny)EasterBunny.this).plugin.random.nextFloat());
                                if (((EasterBunny)EasterBunny.this).plugin.random.nextInt(2) == 0) {
                                    dustTransition = new Particle.DustTransition(Color.fromRGB((int)(((EasterBunny)EasterBunny.this).plugin.random.nextInt(105) + 150), (int)25, (int)255), Color.fromRGB((int)25, (int)(((EasterBunny)EasterBunny.this).plugin.random.nextInt(155) + 100), (int)255), ((EasterBunny)EasterBunny.this).plugin.random.nextFloat() / 2.0f);
                                }
                                EasterBunny.this.slimes[n].getWorld().spawnParticle(Particle.DUST_COLOR_TRANSITION, EasterBunny.this.slimes[n].getLocation().add(((EasterBunny)EasterBunny.this).plugin.random.nextDouble() / 2.5 - 0.2, ((EasterBunny)EasterBunny.this).plugin.random.nextDouble() / 2.5 - 0.2, ((EasterBunny)EasterBunny.this).plugin.random.nextDouble() / 2.5 - 0.2), 1, 0.0, 0.0, 0.0, 0.001, (Object)dustTransition);
                                ++n3;
                            }
                            if (EasterBunny.this.slimes[n].isOnGround()) {
                                EasterBunny.this.slimes[n].getWorld().createExplosion(EasterBunny.this.slimes[n].getLocation(), EasterBunny.this.entity.getHealth() <= EasterBunny.this.entity.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue() / 2.0 ? 2.5f : 1.5f, true, true, (Entity)EasterBunny.this.entity);
                                EasterBunny.this.stands[n].remove();
                                EasterBunny.this.slimes[n].remove();
                                EasterBunny.this.stands[n] = null;
                            } else {
                                for (Entity entity : EasterBunny.this.slimes[n].getNearbyEntities(0.5, 0.5, 0.5)) {
                                    if (!(entity instanceof LivingEntity) || entity.equals(EasterBunny.this.entity) || entity instanceof Player && Utils.isPlayerImmune((Player)entity)) continue;
                                    EasterBunny.this.slimes[n].getWorld().createExplosion(EasterBunny.this.slimes[n].getLocation(), EasterBunny.this.entity.getHealth() <= EasterBunny.this.entity.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue() / 2.0 ? 2.5f : 1.5f, true, true, (Entity)EasterBunny.this.entity);
                                    EasterBunny.this.stands[n].remove();
                                    EasterBunny.this.slimes[n].remove();
                                    EasterBunny.this.stands[n] = null;
                                    break;
                                }
                            }
                        }
                        ++n;
                    }
                }
            };
        }
    }

    @Override
    public void clean() {
        int n = 0;
        while (n < 3) {
            if (this.stands[n] != null) {
                this.stands[n].remove();
            }
            if (this.slimes[n] != null) {
                this.slimes[n].remove();
            }
            ++n;
        }
        this.bar.removeAll();
    }

    @Override
    public void update(FileConfiguration fileConfiguration) {
    }

    public ArmorStand spawnTarget(Location location) {
        ArmorStand armorStand = (ArmorStand)location.getWorld().spawnEntity(location, EntityType.ARMOR_STAND);
        if (this.plugin.mcVersion >= 1.16) {
            armorStand.setInvisible(true);
        } else {
            armorStand.setVisible(false);
        }
        armorStand.setMarker(true);
        armorStand.setGravity(false);
        armorStand.setSmall(true);
        armorStand.setCollidable(false);
        if (this.plugin.mcVersion >= 1.16) {
            armorStand.addEquipmentLock(EquipmentSlot.CHEST, ArmorStand.LockType.ADDING_OR_CHANGING);
            armorStand.addEquipmentLock(EquipmentSlot.FEET, ArmorStand.LockType.ADDING_OR_CHANGING);
            armorStand.addEquipmentLock(EquipmentSlot.HAND, ArmorStand.LockType.ADDING_OR_CHANGING);
            armorStand.addEquipmentLock(EquipmentSlot.HEAD, ArmorStand.LockType.ADDING_OR_CHANGING);
            armorStand.addEquipmentLock(EquipmentSlot.LEGS, ArmorStand.LockType.ADDING_OR_CHANGING);
            armorStand.addEquipmentLock(EquipmentSlot.OFF_HAND, ArmorStand.LockType.ADDING_OR_CHANGING);
        }
        armorStand.getPersistentDataContainer().set(EntityHandler.removalKey, PersistentDataType.BYTE, (Object)0);
        return armorStand;
    }

    public static boolean summonEasterBunny(Main main, Block block) {
        Entity entity2;
        easterBasketBlocks.add(block);
        World world = block.getWorld();
        Location location = Utils.findSmartYSpawn(block.getLocation(), Utils.getSpotInSquareRadius(block.getLocation(), 30), 2, 15);
        int n = 0;
        while (n < 30) {
            if (location != null && location.getBlock().isPassable()) break;
            location = Utils.findSmartYSpawn(block.getLocation(), Utils.getSpotInSquareRadius(block.getLocation(), 30), 2, 15);
            ++n;
        }
        if (location == null) {
            return false;
        }
        Rabbit rabbit = (Rabbit)world.spawnEntity(location.clone().add(150.0, 300.0, 0.0), EntityType.RABBIT, false);
        rabbit.setRemoveWhenFarAway(false);
        rabbit.teleport(location);
        EasterBunny easterBunny = new EasterBunny(rabbit, main, main.random);
        main.handler.addEntity(easterBunny);
        SongMaker songMaker = new SongMaker(DDSong.EASTER_THEME);
        for (Entity entity2 : world.getNearbyEntities(block.getLocation(), 30.0, 30.0, 30.0)) {
            if (!(entity2 instanceof Player)) continue;
            songMaker.addPlayer((Player)entity2);
        }
        songMaker.setLoop(true);
        songMaker.setVolume((float)((Double)CustomEntityType.EASTERBUNNY.grabCustomSetting("boss_music_volume")).doubleValue());
        if (((Boolean)CustomEntityType.EASTERBUNNY.grabCustomSetting("play_boss_music")).booleanValue()) {
            songMaker.playSong();
        }
        easterBunny.songMaker = songMaker;
        entity2 = easterBunny.spawnTarget(block.getLocation().add(0.5, 0.5, 0.5));
        easterBunny.target = entity2;
        Object object = new boolean[1];
        object[0] = false;
        new RepeatingTask(main, 0, 1, (boolean[])object, main, world, block){
            private final /* synthetic */ boolean[] val$end;
            private final /* synthetic */ Main val$plugin;
            private final /* synthetic */ World val$world;
            private final /* synthetic */ Block val$block;
            {
                this.val$end = blArray;
                this.val$plugin = main;
                this.val$world = world;
                this.val$block = block;
                super(javaPlugin, n, n2);
            }

            @Override
            public void run() {
                if (this.val$end[0]) {
                    this.cancel();
                    return;
                }
                int n = 0;
                while (n < 8) {
                    Particle.DustTransition dustTransition = new Particle.DustTransition(Color.fromRGB((int)(this.val$plugin.random.nextInt(125) + 25), (int)255, (int)(this.val$plugin.random.nextInt(55) + 25)), Color.fromRGB((int)25, (int)(this.val$plugin.random.nextInt(155) + 100), (int)255), this.val$plugin.random.nextFloat());
                    if (this.val$plugin.random.nextInt(2) == 0) {
                        dustTransition = new Particle.DustTransition(Color.fromRGB((int)(this.val$plugin.random.nextInt(105) + 150), (int)25, (int)255), Color.fromRGB((int)25, (int)(this.val$plugin.random.nextInt(155) + 100), (int)255), this.val$plugin.random.nextFloat() / 2.0f);
                    }
                    this.val$world.spawnParticle(Particle.DUST_COLOR_TRANSITION, this.val$block.getLocation().add(0.5, 0.3, 0.5).add(this.val$plugin.random.nextDouble() / 1.5 - 0.3, this.val$plugin.random.nextDouble() / 1.5 - 0.3, this.val$plugin.random.nextDouble() / 1.5 - 0.3), 1, 0.0, 0.0, 0.0, 0.001, (Object)dustTransition);
                    ++n;
                }
            }
        };
        main.getServer().getScheduler().runTaskLater((Plugin)main, () -> EasterBunny.lambda$0(block, world, rabbit, (ArmorStand)entity2, (boolean[])object), 300L);
        return true;
    }

    private static /* synthetic */ void lambda$0(Block block, World world, Rabbit rabbit, ArmorStand armorStand, boolean[] blArray) {
        easterBasketBlocks.remove(block);
        block.setType(Material.AIR);
        world.spawnParticle(Particle.BLOCK_CRACK, block.getLocation().add(0.5, 0.3, 0.5), 30, 0.2, 0.2, 0.2, 1.0E-4, (Object)Material.BLUE_WOOL.createBlockData());
        world.playSound(block.getLocation().add(0.5, 0.3, 0.5), Sound.BLOCK_WOOL_BREAK, SoundCategory.BLOCKS, 1.0f, 0.5f);
        rabbit.setRemoveWhenFarAway(true);
        armorStand.remove();
        blArray[0] = true;
    }
}

