/*
 * Decompiled with CFR 0.152.
 */
package deadlydisasters.entities.endstormentities;

import deadlydisasters.Main;
import deadlydisasters.entities.CustomDropsFactory;
import deadlydisasters.entities.CustomEntity;
import deadlydisasters.entities.CustomEntityType;
import deadlydisasters.entities.EntityHandler;
import deadlydisasters.events.DestructionDisaster;
import deadlydisasters.events.WeatherDisaster;
import deadlydisasters.handlers.Languages;
import java.util.Iterator;
import java.util.Random;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.entity.Wolf;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.EulerAngle;

public class BabyEndTotem
extends CustomEntity {
    private ArmorStand[] stands = new ArmorStand[4];
    private int locked = 1;
    private int timer = 3;
    private int animTicks;
    private Random rand;
    private boolean animation;
    private String name;

    public BabyEndTotem(Mob mob, FileConfiguration fileConfiguration, Main main, Random random) {
        super(mob, main);
        this.entityType = CustomEntityType.BABYENDTOTEM;
        this.rand = random;
        this.species = this.entityType.species;
        mob.getPersistentDataContainer().set(this.entityType.nameKey, PersistentDataType.BYTE, (Object)0);
        int n = 0;
        while (n < 4) {
            this.spawnStands(n);
            ++n;
        }
        if (main.mcVersion >= 1.16) {
            mob.getAttribute(Attribute.GENERIC_ATTACK_KNOCKBACK).setBaseValue(2.0);
        }
        mob.getAttribute(Attribute.GENERIC_ATTACK_DAMAGE).setBaseValue(this.entityType.getDamage());
        mob.getAttribute(Attribute.GENERIC_MAX_HEALTH).setBaseValue(this.entityType.getHealth());
        mob.setHealth(this.entityType.getHealth());
        mob.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, 999999, 0, true, false));
        mob.setSilent(true);
        mob.setMetadata("dd-endtotem", (MetadataValue)new FixedMetadataValue((Plugin)main, (Object)"protected"));
        if (fileConfiguration.contains("customentities." + mob.getUniqueId() + ".name")) {
            mob.setCustomName(fileConfiguration.getString("customentities." + mob.getUniqueId() + ".name"));
            this.stands[3].setCustomName(fileConfiguration.getString("customentities." + mob.getUniqueId() + ".name"));
        } else {
            mob.setCustomName(Languages.getString("entities.endTotem"));
            this.stands[3].setCustomName(Languages.getString("entities.endTotem"));
        }
        mob.setCustomNameVisible(false);
        this.stands[3].setCustomNameVisible(true);
    }

    @Override
    public void tick() {
        if (this.entity == null) {
            return;
        }
        if (this.entity.getNoDamageTicks() == 20) {
            this.entity.getWorld().playSound(this.entity.getLocation(), Sound.ENTITY_ENDERMAN_HURT, SoundCategory.HOSTILE, 0.3f, 0.5f);
        }
        if (!this.animation && this.entity.hasMetadata("dd-animation")) {
            this.entity.removeMetadata("dd-animation", (Plugin)this.plugin);
            this.animation = true;
            this.animTicks = 15;
        }
        Location location = this.entity.getLocation();
        this.stands[0].setHeadPose(new EulerAngle(Math.toRadians(location.getPitch()), 0.0, 0.0));
        if (this.plugin.mcVersion >= 1.16) {
            this.entity.getWorld().spawnParticle(Particle.REVERSE_PORTAL, location.clone().add(0.0, 0.5, 0.0), 3, 0.2, 0.3, 0.2, 0.01);
        }
        if (this.animation) {
            float f = this.stands[0].getLocation().getYaw();
            this.stands[0].teleport(location.clone().add(0.0, 0.3, 0.0));
            this.stands[0].setRotation(f + 30.0f, 0.0f);
            f = this.stands[1].getLocation().getYaw();
            this.stands[1].teleport(location.clone().subtract(0.0, 0.19, 0.0));
            this.stands[1].setRotation(f - 30.0f, 0.0f);
            f = this.stands[2].getLocation().getYaw();
            this.stands[2].teleport(location.clone().subtract(0.0, 0.68, 0.0));
            this.stands[2].setRotation(f + 30.0f, 0.0f);
            this.stands[3].teleport(location.clone().add(0.0, 1.15, 0.0));
            this.entity.getWorld().spawnParticle(Particle.DRAGON_BREATH, location.clone().add(0.0, 0.3, 0.0), 2, 0.15, 0.15, 0.15, 0.1);
            --this.animTicks;
            if (this.animTicks <= 0) {
                this.animation = false;
            }
            return;
        }
        Location location2 = null;
        if (this.locked >= 0) {
            location2 = this.stands[this.locked].getLocation().clone();
        }
        if (((Wolf)this.entity).isSitting()) {
            this.stands[0].teleport(location.clone().add(0.0, 0.13, 0.0));
            location.setYaw(location.getYaw() + 180.0f);
            this.stands[1].teleport(location.clone().subtract(0.0, 0.31, 0.0));
            this.stands[1].setRotation(location.getYaw() + 90.0f, 0.0f);
            this.stands[2].teleport(location.clone().subtract(0.0, 0.75, 0.0));
            this.stands[3].teleport(location.clone().add(0.0, 0.95, 0.0));
        } else {
            this.stands[0].teleport(location.clone().add(0.0, 0.3, 0.0));
            this.stands[1].teleport(location.clone().subtract(0.0, 0.19, 0.0));
            this.stands[1].setRotation(location.getYaw() + 90.0f, 0.0f);
            this.stands[2].teleport(location.clone().subtract(0.0, 0.68, 0.0));
            this.stands[3].teleport(location.clone().add(0.0, 1.15, 0.0));
        }
        if (location2 != null) {
            this.stands[this.locked].setRotation(location2.getYaw() + 6.0f, 0.0f);
        }
    }

    @Override
    public void function(Iterator<CustomEntity> iterator) {
        this.entity = (Mob)this.plugin.getServer().getEntity(this.entityUUID);
        if (this.entity == null) {
            ArmorStand[] armorStandArray = this.stands;
            int n = this.stands.length;
            int n2 = 0;
            while (n2 < n) {
                ArmorStand armorStand = armorStandArray[n2];
                if (armorStand != null) {
                    armorStand.remove();
                }
                ++n2;
            }
            iterator.remove();
            return;
        }
        this.refreshReferences((Entity[])this.stands);
        int n = 0;
        while (n < 4) {
            if (this.stands[n] == null || this.stands[n].isDead()) {
                this.spawnStands(n);
            }
            ++n;
        }
        if (this.entity.isDead()) {
            this.entity.getWorld().playSound(this.entity.getLocation(), Sound.ENTITY_EVOKER_PREPARE_ATTACK, SoundCategory.HOSTILE, 0.3f, 0.7f);
            if (this.entity.getKiller() != null) {
                CustomDropsFactory.generateDrops(this.entity.getLocation(), this.entityType);
            }
            this.entity.getWorld().spawnParticle(Particle.ENCHANTMENT_TABLE, this.entity.getLocation().add(0.0, 1.5, 0.0), 200, 0.25, 0.25, 0.25, 20.0);
            this.clean();
            iterator.remove();
            return;
        }
        this.entity.getWorld().playSound(this.entity.getLocation(), Sound.ENTITY_ENDERMITE_STEP, SoundCategory.HOSTILE, 0.01f, 0.5f);
        if (this.timer <= 0) {
            this.timer = 5;
            this.locked = -1;
        } else if (this.timer == 3) {
            this.locked = this.rand.nextInt(3);
            if (this.rand.nextInt(3) == 0) {
                n = this.rand.nextInt(4);
                if (n == 0) {
                    this.entity.getWorld().playSound(this.entity.getLocation(), Sound.BLOCK_CONDUIT_AMBIENT_SHORT, SoundCategory.HOSTILE, 0.5f, 0.5f);
                } else if (n == 1) {
                    this.entity.getWorld().playSound(this.entity.getLocation(), Sound.BLOCK_CONDUIT_AMBIENT_SHORT, SoundCategory.HOSTILE, 0.5f, 2.0f);
                } else if (n == 2) {
                    this.entity.getWorld().playSound(this.entity.getLocation(), Sound.BLOCK_CONDUIT_ATTACK_TARGET, SoundCategory.HOSTILE, 0.15f, 0.5f);
                } else {
                    this.entity.getWorld().playSound(this.entity.getLocation(), Sound.BLOCK_CONDUIT_ATTACK_TARGET, SoundCategory.HOSTILE, 0.15f, 2.0f);
                }
            }
        }
        --this.timer;
        if (WeatherDisaster.currentWorlds.contains(this.entity.getWorld())) {
            this.animation = true;
            this.animTicks = 100;
            this.entity.getWorld().playSound(this.entity.getLocation(), Sound.ENTITY_ENDERMITE_STEP, SoundCategory.HOSTILE, 0.4f, 0.5f);
        } else if (DestructionDisaster.currentLocations.containsKey(this.entity.getWorld())) {
            for (Player player : DestructionDisaster.currentLocations.get(this.entity.getWorld())) {
                if (!(this.entity.getLocation().distanceSquared(player.getLocation()) < 10000.0)) continue;
                this.animation = true;
                this.animTicks = 100;
                this.entity.getWorld().playSound(this.entity.getLocation(), Sound.ENTITY_ENDERMITE_STEP, SoundCategory.HOSTILE, 0.4f, 0.5f);
                break;
            }
        } else if (this.animTicks <= 0) {
            this.animation = false;
        }
    }

    @Override
    public void clean() {
        ArmorStand[] armorStandArray = this.stands;
        int n = this.stands.length;
        int n2 = 0;
        while (n2 < n) {
            ArmorStand armorStand = armorStandArray[n2];
            if (armorStand != null) {
                armorStand.remove();
            }
            ++n2;
        }
        this.update(this.plugin.dataFile);
    }

    @Override
    public void update(FileConfiguration fileConfiguration) {
        if (this.name != null) {
            fileConfiguration.set("customentities." + this.entity.getUniqueId() + ".name", (Object)this.name);
        }
    }

    private void spawnStands(int n) {
        World world = this.entity.getWorld();
        Location location = this.entity.getLocation().clone().add(150.0, 100.0, 0.0);
        switch (n) {
            case 0: {
                this.stands[0] = (ArmorStand)world.spawnEntity(location, EntityType.ARMOR_STAND);
                this.equipHands(this.stands[0], Material.END_PORTAL_FRAME, Material.CHORUS_PLANT, Material.CHORUS_FLOWER);
                this.stands[0].getPersistentDataContainer().set(EntityHandler.removalKey, PersistentDataType.BYTE, (Object)0);
                break;
            }
            case 1: {
                this.stands[1] = (ArmorStand)world.spawnEntity(location, EntityType.ARMOR_STAND);
                this.equipHands(this.stands[1], Material.PURPUR_PILLAR, Material.CHORUS_PLANT, Material.CHORUS_FLOWER);
                this.stands[1].setLeftArmPose(new EulerAngle(0.5, 0.5, -1.8));
                this.stands[1].setRotation(90.0f, 0.0f);
                this.stands[1].getPersistentDataContainer().set(EntityHandler.removalKey, PersistentDataType.BYTE, (Object)0);
                break;
            }
            case 2: {
                this.stands[2] = (ArmorStand)world.spawnEntity(location, EntityType.ARMOR_STAND);
                this.lockStand(this.stands[2]);
                this.stands[2].getEquipment().setHelmet(new ItemStack(Material.OBSIDIAN));
                this.stands[2].getPersistentDataContainer().set(EntityHandler.removalKey, PersistentDataType.BYTE, (Object)0);
                break;
            }
            case 3: {
                this.stands[3] = (ArmorStand)world.spawnEntity(location, EntityType.ARMOR_STAND);
                this.lockStand(this.stands[3]);
                this.stands[3].getPersistentDataContainer().set(EntityHandler.removalKey, PersistentDataType.BYTE, (Object)0);
            }
        }
    }

    private void equipHands(ArmorStand armorStand, Material material, Material material2, Material material3) {
        this.lockStand(armorStand);
        armorStand.getEquipment().setHelmet(new ItemStack(material));
        armorStand.getEquipment().setItemInMainHand(new ItemStack(material2));
        armorStand.getEquipment().setItemInOffHand(new ItemStack(material3));
        armorStand.setRightArmPose(new EulerAngle(0.0, 0.3, 1.1));
        armorStand.setLeftArmPose(new EulerAngle(0.0, 0.5, -1.8));
    }

    private void lockStand(ArmorStand armorStand) {
        if (this.plugin.mcVersion >= 1.16) {
            armorStand.setInvisible(true);
        } else {
            armorStand.setVisible(false);
        }
        armorStand.setGravity(false);
        armorStand.setArms(true);
        armorStand.setMarker(true);
        armorStand.setSmall(true);
        if (this.plugin.mcVersion >= 1.16) {
            armorStand.addEquipmentLock(EquipmentSlot.CHEST, ArmorStand.LockType.ADDING_OR_CHANGING);
            armorStand.addEquipmentLock(EquipmentSlot.FEET, ArmorStand.LockType.ADDING_OR_CHANGING);
            armorStand.addEquipmentLock(EquipmentSlot.HAND, ArmorStand.LockType.ADDING_OR_CHANGING);
            armorStand.addEquipmentLock(EquipmentSlot.HEAD, ArmorStand.LockType.ADDING_OR_CHANGING);
            armorStand.addEquipmentLock(EquipmentSlot.LEGS, ArmorStand.LockType.ADDING_OR_CHANGING);
            armorStand.addEquipmentLock(EquipmentSlot.OFF_HAND, ArmorStand.LockType.ADDING_OR_CHANGING);
        }
    }

    public void changeName(String string) {
        this.name = string;
        this.stands[3].setCustomName(string);
    }
}

