/*
 * Decompiled with CFR 0.152.
 */
package deadlydisasters.entities.endstormentities;

import deadlydisasters.Main;
import deadlydisasters.entities.CustomDropsFactory;
import deadlydisasters.entities.CustomEntity;
import deadlydisasters.entities.CustomEntityType;
import deadlydisasters.handlers.Languages;
import java.util.Iterator;
import java.util.Random;
import org.bukkit.Particle;
import org.bukkit.attribute.Attribute;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Mob;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class VoidStalker
extends CustomEntity {
    public VoidStalker(Mob mob, Main main, Random random) {
        super(mob, main);
        this.entityType = CustomEntityType.VOIDSTALKER;
        this.species = this.entityType.species;
        mob.getPersistentDataContainer().set(this.entityType.nameKey, PersistentDataType.BYTE, (Object)0);
        mob.getAttribute(Attribute.GENERIC_MAX_HEALTH).setBaseValue(this.entityType.getHealth());
        mob.setHealth(this.entityType.getHealth());
        mob.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, 999999, 0, true));
        mob.setMetadata("dd-voidstalker", (MetadataValue)new FixedMetadataValue((Plugin)main, (Object)"protected"));
        mob.getAttribute(Attribute.GENERIC_ATTACK_DAMAGE).setBaseValue(this.entityType.getDamage());
        if (mob.getCustomName() == null) {
            mob.setCustomName(Languages.getString("entities.voidStalker"));
        }
        mob.setMetadata("dd-unburnable", (MetadataValue)new FixedMetadataValue((Plugin)main, (Object)"protected"));
    }

    @Override
    public void tick() {
        if (this.entity == null) {
            return;
        }
        this.entity.getWorld().spawnParticle(Particle.SQUID_INK, this.entity.getLocation(), 5, 0.4, 0.4, 0.4, 0.01);
    }

    @Override
    public void function(Iterator<CustomEntity> iterator) {
        this.entity = (Mob)this.plugin.getServer().getEntity(this.entityUUID);
        if (this.entity == null) {
            iterator.remove();
            return;
        }
        if (this.entity.isDead()) {
            if (this.plugin.mcVersion >= 1.16) {
                this.entity.getWorld().spawnParticle(Particle.SOUL, this.entity.getLocation(), 10, 0.3, 0.3, 0.3, 0.03);
            }
            if (this.entity.getKiller() != null) {
                CustomDropsFactory.generateDrops(this.entity.getLocation(), this.entityType);
            }
            iterator.remove();
            return;
        }
    }

    @Override
    public void clean() {
    }

    @Override
    public void update(FileConfiguration fileConfiguration) {
    }
}

