/*
 * Decompiled with CFR 0.152.
 */
package deadlydisasters.entities.monsoonentities;

import deadlydisasters.Main;
import deadlydisasters.entities.CustomDropsFactory;
import deadlydisasters.entities.CustomEntity;
import deadlydisasters.entities.CustomEntityType;
import deadlydisasters.entities.CustomHead;
import deadlydisasters.events.disasters.Monsoon;
import deadlydisasters.handlers.ItemsHandler;
import deadlydisasters.handlers.Languages;
import deadlydisasters.utils.RepeatingTask;
import deadlydisasters.utils.Utils;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.Random;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Levelled;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;

public class CursedDiver
extends CustomEntity {
    private int cooldown;
    private Random rand;
    private BlockData bd = Material.OBSIDIAN.createBlockData();

    public CursedDiver(Mob mob, Main main, Random random) {
        super(mob, main);
        this.entityType = CustomEntityType.CURSEDDIVER;
        this.rand = random;
        this.species = this.entityType.species;
        this.entity.getPersistentDataContainer().set(this.entityType.nameKey, PersistentDataType.BYTE, (Object)0);
        this.entity.setMetadata("dd-curseddiver", (MetadataValue)new FixedMetadataValue((Plugin)main, (Object)"protected"));
        this.entity.getEquipment().setHelmet(CustomHead.DIVER.getHead());
        this.entity.getEquipment().setHelmetDropChance(0.0f);
        this.entity.setCanPickupItems(false);
        this.entity.getAttribute(Attribute.GENERIC_MAX_HEALTH).setBaseValue(this.entityType.getHealth());
        this.entity.setHealth(this.entityType.getHealth());
        this.entity.getAttribute(Attribute.GENERIC_ATTACK_DAMAGE).setBaseValue(this.entityType.getDamage());
        this.entity.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED).setBaseValue(0.3);
        this.entity.getAttribute(Attribute.GENERIC_FOLLOW_RANGE).setBaseValue(40.0);
        this.entity.getEquipment().setItemInMainHand(ItemsHandler.poseidonsTrident);
        if (this.entity.getCustomName() == null) {
            this.entity.setCustomName(Languages.getString("entities.cursedDiver"));
        }
    }

    @Override
    public void tick() {
        if (this.entity == null) {
            return;
        }
        this.entity.getWorld().spawnParticle(Particle.FALLING_WATER, this.entity.getLocation().add(0.0, 1.0, 0.0), 4, 0.4, 0.7, 0.4, 1.0E-4);
        this.entity.getWorld().spawnParticle(Particle.FALLING_DUST, this.entity.getLocation().clone().add(0.0, 1.4, 0.0), 3, 0.2, 0.4, 0.2, 1.0, (Object)this.bd);
    }

    @Override
    public void function(Iterator<CustomEntity> iterator) {
        this.entity = (Mob)this.plugin.getServer().getEntity(this.entityUUID);
        if (this.entity == null) {
            iterator.remove();
            return;
        }
        if (this.entity.isDead()) {
            if (this.plugin.mcVersion >= 1.16) {
                this.entity.getWorld().spawnParticle(Particle.SOUL, this.entity.getLocation().add(0.0, 1.5, 0.0), 5, 0.3, 0.3, 0.3, 1.0E-4);
            }
            if (this.entity.getKiller() != null) {
                CustomDropsFactory.generateDrops(this.entity.getLocation(), this.entityType);
            }
            iterator.remove();
            return;
        }
        if (this.cooldown > 0) {
            --this.cooldown;
            return;
        }
        if (this.entity.getTarget() == null || this.entity.getLocation().distanceSquared(this.entity.getTarget().getLocation()) > 144.0 || !this.entity.hasLineOfSight((Entity)this.entity.getTarget())) {
            return;
        }
        this.cooldown = 5;
        this.entity.addPotionEffect(new PotionEffect(PotionEffectType.SLOW, 40, 5, true, false, false));
        this.castWaveSpell(this.entity.getLocation(), Utils.getVectorTowards(this.entity.getLocation(), this.entity.getTarget().getLocation()), 15, this.rand);
        if (this.plugin.mcVersion >= 1.16) {
            this.entity.swingMainHand();
        }
        this.entity.getWorld().spawnParticle(Particle.DRIP_WATER, this.entity.getLocation().add(0.0, 1.0, 0.0), 100, 0.9, 1.0, 0.9, 1.0);
        this.entity.getWorld().playSound(this.entity.getLocation(), Sound.ENTITY_DROWNED_DEATH_WATER, SoundCategory.HOSTILE, 1.0f, 0.5f);
    }

    @Override
    public void clean() {
    }

    @Override
    public void update(FileConfiguration fileConfiguration) {
    }

    private void castWaveSpell(Location location, final Vector vector, int n, final Random random) {
        final World world = location.getWorld();
        final int[] nArray = new int[]{n};
        final Vector vector2 = new Vector(vector.getZ(), 0.0, -vector.getX());
        final Location location2 = location.clone().add(vector.clone().multiply(2)).add(vector2.clone().multiply(-2));
        final Block[] blockArray = new Block[15];
        final ArrayDeque arrayDeque = new ArrayDeque();
        final ArrayDeque arrayDeque2 = new ArrayDeque();
        new RepeatingTask(this.plugin, 0, 2){

            @Override
            public void run() {
                Block block = blockArray;
                int n = ((Block[])block).length;
                int n2 = 0;
                while (n2 < n) {
                    Block block2 = block[n2];
                    if (block2 != null && block2.getType() == Material.WATER) {
                        world.spawnParticle(Particle.FALLING_WATER, block2.getLocation().add(0.5, 0.5, 0.5), 30, 0.5, 0.5, 0.5, 1.0E-4);
                        if (random.nextInt(4) == 0 && block2.getRelative(BlockFace.DOWN).getType().isSolid()) {
                            arrayDeque2.add(block2);
                            arrayDeque.remove(block2);
                            Levelled levelled = (Levelled)block2.getBlockData();
                            levelled.setLevel(7);
                            block2.setBlockData((BlockData)levelled);
                            Monsoon.globalPuddles.add(block2);
                        } else {
                            block2.setType(Material.AIR);
                        }
                    }
                    ++n2;
                }
                if (nArray[0] <= 0) {
                    for (Block block2 : arrayDeque) {
                        if (block2 == null) continue;
                        block2.setType(Material.AIR);
                    }
                    if (nArray[0] <= -10) {
                        this.cancel();
                        new RepeatingTask(CursedDiver.this.plugin, 60, 1){

                            @Override
                            public void run() {
                                Block block;
                                if (arrayDeque2.isEmpty()) {
                                    this.cancel();
                                }
                                if ((block = (Block)arrayDeque2.poll()) != null && block.getType() == Material.WATER) {
                                    block.setType(Material.AIR);
                                }
                                Monsoon.globalPuddles.remove(block);
                            }
                        };
                    }
                    nArray[0] = nArray[0] - 1;
                    return;
                }
                nArray[0] = nArray[0] - 1;
                int n3 = 0;
                while (n3 < 3) {
                    Location location = location2.clone().add(vector.clone().multiply(n3)).add(0.0, (double)n3, 0.0);
                    n = 0;
                    while (n < 5) {
                        block = location.clone().add(vector2.clone().multiply(n)).getBlock();
                        if (block.getType() == Material.AIR && !Utils.isZoneProtected(block.getLocation())) {
                            arrayDeque.add(block);
                            world.spawnParticle(Particle.BUBBLE_POP, block.getLocation().add(0.5, 0.5, 0.5), 10, 0.5, 0.5, 0.5, 1.0E-4);
                            block.setType(Material.WATER);
                            blockArray[n + n3 * 5] = block;
                            for (Levelled levelled : world.getNearbyEntities(block.getLocation(), 0.5, 0.5, 0.5)) {
                                if (levelled.equals(CursedDiver.this.entity)) continue;
                                levelled.setVelocity(vector);
                                if (!(levelled instanceof LivingEntity) || levelled instanceof Player && Utils.isPlayerImmune((Player)levelled)) continue;
                                ((LivingEntity)levelled).damage(4.0);
                            }
                        }
                        ++n;
                    }
                    ++n3;
                }
                location2.add(vector);
                world.playSound(location2, Sound.WEATHER_RAIN, SoundCategory.HOSTILE, 1.0f, 0.75f);
            }
        };
    }
}

