/*
 * Decompiled with CFR 0.152.
 */
package deadlydisasters.entities.purgeentities;

import deadlydisasters.Main;
import deadlydisasters.entities.CustomDropsFactory;
import deadlydisasters.entities.CustomEntity;
import deadlydisasters.entities.CustomEntityType;
import deadlydisasters.entities.CustomHead;
import deadlydisasters.entities.EntityHandler;
import deadlydisasters.handlers.Languages;
import java.util.Iterator;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Mob;
import org.bukkit.entity.ZombieHorse;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class ZombieKnight
extends CustomEntity {
    private ZombieHorse horse;
    private UUID horseUUID;

    public ZombieKnight(Mob mob, Main main) {
        super(mob, main);
        this.entityType = CustomEntityType.ZOMBIEKNIGHT;
        this.species = this.entityType.species;
        mob.getPersistentDataContainer().set(this.entityType.nameKey, PersistentDataType.BYTE, (Object)0);
        mob.getEquipment().setHelmet(CustomHead.ZOMBIEKNIGHT.getHead());
        mob.getEquipment().setHelmetDropChance(0.0f);
        mob.getEquipment().setItemInMainHand(new ItemStack(Material.STONE_SWORD));
        mob.getEquipment().setItemInOffHand(new ItemStack(Material.SHIELD));
        mob.getAttribute(Attribute.GENERIC_MAX_HEALTH).setBaseValue(this.entityType.getHealth());
        mob.setHealth(this.entityType.getHealth());
        mob.setCanPickupItems(false);
        if (!mob.isInsideVehicle()) {
            this.horse = (ZombieHorse)mob.getWorld().spawnEntity(mob.getLocation(), EntityType.ZOMBIE_HORSE);
            this.horse.setTamed(true);
            this.horse.addPassenger((Entity)mob);
            this.horse.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED).setBaseValue(0.425);
            this.horseUUID = this.horse.getUniqueId();
            this.horse.getPersistentDataContainer().set(EntityHandler.removalKey, PersistentDataType.BYTE, (Object)0);
        } else if (mob.getVehicle() instanceof ZombieHorse) {
            this.horseUUID = mob.getVehicle().getUniqueId();
        }
        if (mob.getCustomName() == null) {
            mob.setCustomName(Languages.getString("entities.zombieKnight"));
        }
    }

    @Override
    public void tick() {
    }

    @Override
    public void function(Iterator<CustomEntity> iterator) {
        this.entity = (Mob)this.plugin.getServer().getEntity(this.entityUUID);
        if (this.horseUUID != null) {
            this.horse = (ZombieHorse)this.plugin.getServer().getEntity(this.horseUUID);
        }
        if (this.entity == null || this.entity.isDead()) {
            if (this.entity != null && this.entity.getKiller() != null) {
                CustomDropsFactory.generateDrops(this.entity.getLocation(), this.entityType);
            }
            iterator.remove();
            if (this.horse != null && !this.horse.isDead()) {
                this.horse.setTamed(false);
                this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, new Runnable(){

                    @Override
                    public void run() {
                        if (ZombieKnight.this.horse != null && !ZombieKnight.this.horse.isDead()) {
                            ZombieKnight.this.horse.remove();
                        }
                    }
                }, 600L);
            }
            return;
        }
    }

    @Override
    public void clean() {
        if (this.horse != null && !this.horse.isDead()) {
            this.horse.remove();
        }
    }

    @Override
    public void update(FileConfiguration fileConfiguration) {
    }
}

