/*
 * Decompiled with CFR 0.152.
 */
package deadlydisasters.events.disasters;

import deadlydisasters.Main;
import deadlydisasters.events.Disaster;
import deadlydisasters.events.WeatherDisaster;
import deadlydisasters.events.WeatherDisasterEvent;
import deadlydisasters.handlers.ItemsHandler;
import deadlydisasters.handlers.WorldObject;
import deadlydisasters.listeners.DeathMessages;
import deadlydisasters.utils.Metrics;
import deadlydisasters.utils.RepeatingTask;
import deadlydisasters.utils.Utils;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.entity.Slime;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitTask;

public class AcidStorm
extends WeatherDisaster {
    private int particleRange;
    private int particleYRange;
    private int blockDamageRange;
    private boolean meltItems;
    private boolean meltArmor;
    private boolean poisonCrops;
    private double damage;
    private double slimeRate;
    private double blockChangeRate;
    private double particleMultiplier;
    private int blocksDestroyed;
    private Queue<UUID> slimes = new ArrayDeque<UUID>();
    private Map<PotionEffectType, Integer> potionEffects = new HashMap<PotionEffectType, Integer>();
    private Map<Material, Material> blockChanges = new HashMap<Material, Material>();
    private Map<UUID, UUID> targets = new HashMap<UUID, UUID>();
    public static Set<Material> CROPS = new HashSet<Material>(Arrays.asList(Material.WHEAT, Material.CARROTS, Material.POTATOES, Material.BEETROOTS, Material.PUMPKIN_STEM, Material.ATTACHED_PUMPKIN_STEM, Material.MELON_STEM, Material.ATTACHED_MELON_STEM, Material.NETHER_WART));
    public static Set<Block> poisonedCrops = ConcurrentHashMap.newKeySet();
    public static BukkitTask cropsMonitor;
    private static volatile boolean isRunning;

    public AcidStorm(int n) {
        super(n);
        this.meltItems = this.configFile.getBoolean("acidstorm.melt_dropped_items");
        this.meltArmor = this.configFile.getBoolean("acidstorm.melt_armor");
        this.time = this.configFile.getInt("acidstorm.time.level " + this.level) * 20;
        this.delay = this.configFile.getInt("acidstorm.start_delay") * 20;
        this.damage = this.configFile.getDouble("acidstorm.damage");
        this.particleRange = this.configFile.getInt("acidstorm.particle_max_distance");
        this.particleYRange = this.configFile.getInt("acidstorm.particle_Y_range");
        this.particleMultiplier = 0.25 * this.configFile.getDouble("acidstorm.particle_multiplier");
        this.blockDamageRange = this.configFile.getInt("acidstorm.block_damage_range");
        this.blockChangeRate = 0.03 * this.configFile.getDouble("acidstorm.block_change_rate");
        this.slimeRate = 0.075 * this.configFile.getDouble("acidstorm.slime_spawn_rate");
        this.poisonCrops = this.configFile.getBoolean("acidstorm.poison_crops");
        this.volume = this.configFile.getDouble("acidstorm.volume");
        for (String string : this.configFile.getConfigurationSection("acidstorm.effects").getKeys(false)) {
            if (PotionEffectType.getByName((String)string) == null) continue;
            this.potionEffects.putIfAbsent(PotionEffectType.getByName((String)string), this.configFile.getInt("acidstorm.effects." + string));
        }
        for (String string : this.configFile.getConfigurationSection("acidstorm.block_changes").getKeys(false)) {
            if (Material.getMaterial((String)string.toUpperCase()) != null) {
                if (Material.getMaterial((String)this.configFile.getString("acidstorm.block_changes." + string).toUpperCase()) != null) {
                    this.blockChanges.putIfAbsent(Material.getMaterial((String)string.toUpperCase()), Material.getMaterial((String)this.configFile.getString("acidstorm.block_changes." + string).toUpperCase()));
                    continue;
                }
                if (this.configFile.getString("acidstorm.block_changes." + string).toLowerCase().equals("air")) {
                    this.blockChanges.putIfAbsent(Material.getMaterial((String)string.toUpperCase()), Material.AIR);
                    continue;
                }
                Main.consoleSender.sendMessage(Utils.chat("&e[DeadlyDisasters]: Could not find material &c'" + this.configFile.getString("acidstorm.block_changes." + string) + "' &eon line &d'" + string + " : " + this.configFile.getString("acidstorm.block_changes." + string) + "' &ein acidstorm block changes section in the config!"));
                continue;
            }
            Main.consoleSender.sendMessage(Utils.chat("&e[DeadlyDisasters]: Could not find material &c'" + string + "' &eon line &d'" + string + " : " + this.configFile.getString("acidstorm.block_changes." + string) + "' &ein acidstorm block changes section in the config!"));
        }
        this.type = Disaster.ACIDSTORM;
    }

    @Override
    public void start(final World world, Player player, boolean bl) {
        WeatherDisasterEvent weatherDisasterEvent = new WeatherDisasterEvent(this, world, this.level, player);
        Bukkit.getPluginManager().callEvent((Event)weatherDisasterEvent);
        if (weatherDisasterEvent.isCancelled()) {
            return;
        }
        this.world = world;
        this.updateWeatherSettings();
        ongoingDisasters.add(this);
        if (bl && ((Boolean)WorldObject.findWorldObject((World)world).settings.get("event_broadcast")).booleanValue()) {
            Utils.broadcastEvent(this.level, "weather", this.type, world);
        }
        DeathMessages.acidstorms.add(this);
        final AcidStorm acidStorm = this;
        final Random random = new Random();
        final int[] nArray = new int[1];
        new RepeatingTask(this.plugin, this.delay, 5){

            @Override
            public void run() {
                if (world.hasStorm()) {
                    Slime slime;
                    Location location;
                    nArray[0] = nArray[0] + 1;
                    if (nArray[0] >= 4) {
                        nArray[0] = 0;
                        for (Entity entity : world.getPlayers()) {
                            if (Utils.isPlayerImmune((Player)entity) || !(random.nextDouble() < AcidStorm.this.slimeRate) || (location = world.getHighestBlockAt(Utils.getSpotInSquareRadius(entity.getLocation(), 18)).getRelative(BlockFace.UP).getLocation()).getBlockY() - entity.getLocation().getBlockY() > 25) continue;
                            slime = (Slime)world.spawnEntity(location, EntityType.SLIME);
                            slime.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED).setBaseValue(0.3);
                            slime.setTarget((LivingEntity)entity);
                            AcidStorm.this.slimes.add(slime.getUniqueId());
                            AcidStorm.this.targets.put(slime.getUniqueId(), entity.getUniqueId());
                        }
                    }
                    for (Entity entity : world.getEntities()) {
                        if (AcidStorm.this.slimes.contains(entity.getUniqueId()) && ((Mob)entity).getTarget() == null && Bukkit.getEntity((UUID)AcidStorm.this.targets.get(entity.getUniqueId())) != null) {
                            ((Mob)entity).setTarget((LivingEntity)Bukkit.getEntity((UUID)AcidStorm.this.targets.get(entity.getUniqueId())));
                        }
                        location = entity.getLocation();
                        if (entity.getWorld().getHighestBlockYAt(location) > location.getBlockY() + 1 || location.getBlock().getTemperature() <= 0.15 || location.getBlock().getTemperature() > 0.95 || Utils.isWeatherDisabled(location, acidStorm)) continue;
                        if (entity instanceof LivingEntity) {
                            ItemMeta itemMeta;
                            if (entity instanceof Slime || entity.isDead() || (slime = (LivingEntity)entity).getEquipment().getHelmet() != null && slime.getEquipment().getHelmet().hasItemMeta() && slime.getEquipment().getHelmet().getItemMeta().getPersistentDataContainer().has(ItemsHandler.basicCoatingKey, PersistentDataType.BYTE)) continue;
                            if (entity instanceof Player) {
                                if (Utils.isPlayerImmune((Player)entity)) continue;
                                ((Player)entity).playSound(entity.getLocation(), Sound.BLOCK_FIRE_EXTINGUISH, (float)(0.75 * AcidStorm.this.volume), 2.0f);
                            }
                            for (Map.Entry<PotionEffectType, Integer> entry : AcidStorm.this.potionEffects.entrySet()) {
                                slime.addPotionEffect(new PotionEffect(entry.getKey(), entry.getValue().intValue(), 1, true, false, false));
                            }
                            Utils.pureDamageEntity((LivingEntity)slime, AcidStorm.this.damage, "dd-acidstormdeath", false, null);
                            if (!AcidStorm.this.meltArmor) continue;
                            ItemStack itemStack = slime.getEquipment().getHelmet();
                            ItemStack itemStack2 = slime.getEquipment().getChestplate();
                            ItemStack itemStack3 = slime.getEquipment().getBoots();
                            ItemStack itemStack4 = slime.getEquipment().getLeggings();
                            if (itemStack != null && (itemStack.getType() == Material.IRON_HELMET || itemStack.getType() == Material.GOLDEN_HELMET || itemStack.getType() == Material.CHAINMAIL_HELMET)) {
                                itemMeta = itemStack.getItemMeta();
                                ((Damageable)itemMeta).setDamage(((Damageable)itemMeta).getDamage() + 1);
                                if (((Damageable)itemMeta).getDamage() >= itemStack.getType().getMaxDurability()) {
                                    itemStack.setAmount(0);
                                } else {
                                    itemStack.setItemMeta(itemMeta);
                                }
                                slime.getEquipment().setHelmet(itemStack);
                            }
                            if (itemStack2 != null && (itemStack2.getType() == Material.IRON_CHESTPLATE || itemStack2.getType() == Material.GOLDEN_CHESTPLATE || itemStack2.getType() == Material.CHAINMAIL_CHESTPLATE)) {
                                itemMeta = itemStack2.getItemMeta();
                                ((Damageable)itemMeta).setDamage(((Damageable)itemMeta).getDamage() + 1);
                                if (((Damageable)itemMeta).getDamage() >= itemStack2.getType().getMaxDurability()) {
                                    itemStack2.setAmount(0);
                                } else {
                                    itemStack2.setItemMeta(itemMeta);
                                }
                                slime.getEquipment().setChestplate(itemStack2);
                            }
                            if (itemStack4 != null && (itemStack4.getType() == Material.IRON_LEGGINGS || itemStack4.getType() == Material.GOLDEN_LEGGINGS || itemStack4.getType() == Material.CHAINMAIL_LEGGINGS)) {
                                itemMeta = itemStack4.getItemMeta();
                                ((Damageable)itemMeta).setDamage(((Damageable)itemMeta).getDamage() + 1);
                                if (((Damageable)itemMeta).getDamage() >= itemStack4.getType().getMaxDurability()) {
                                    itemStack4.setAmount(0);
                                } else {
                                    itemStack4.setItemMeta(itemMeta);
                                }
                                slime.getEquipment().setLeggings(itemStack4);
                            }
                            if (itemStack3 == null || itemStack3.getType() != Material.IRON_BOOTS && itemStack3.getType() != Material.GOLDEN_BOOTS && itemStack3.getType() != Material.CHAINMAIL_BOOTS) continue;
                            itemMeta = itemStack3.getItemMeta();
                            ((Damageable)itemMeta).setDamage(((Damageable)itemMeta).getDamage() + 1);
                            if (((Damageable)itemMeta).getDamage() >= itemStack3.getType().getMaxDurability()) {
                                itemStack3.setAmount(0);
                            } else {
                                itemStack3.setItemMeta(itemMeta);
                            }
                            slime.getEquipment().setBoots(itemStack3);
                            continue;
                        }
                        if (!AcidStorm.this.meltItems || !entity.getType().equals((Object)EntityType.DROPPED_ITEM)) continue;
                        slime = ((Item)entity).getItemStack();
                        if (slime.getType() == Material.IRON_INGOT || slime.getType() == Material.IRON_BLOCK || slime.getType() == Material.IRON_HORSE_ARMOR || slime.getType() == Material.IRON_NUGGET || slime.getType() == Material.IRON_DOOR || slime.getType() == Material.IRON_TRAPDOOR || slime.getType() == Material.GOLD_INGOT || slime.getType() == Material.GOLD_BLOCK || slime.getType() == Material.GOLDEN_HORSE_ARMOR || slime.getType() == Material.GOLD_NUGGET || slime.getType() == Material.GOLDEN_CARROT || slime.getType() == Material.GOLDEN_APPLE) {
                            slime.setAmount(0);
                            continue;
                        }
                        if (slime.getType() == Material.IRON_SWORD || slime.getType() == Material.IRON_AXE || slime.getType() == Material.IRON_PICKAXE || slime.getType() == Material.IRON_SHOVEL || slime.getType() == Material.IRON_HOE || slime.getType() == Material.GOLDEN_SWORD || slime.getType() == Material.GOLDEN_AXE || slime.getType() == Material.GOLDEN_PICKAXE || slime.getType() == Material.GOLDEN_SHOVEL || slime.getType() == Material.GOLDEN_HOE) {
                            ItemMeta itemMeta = slime.getItemMeta();
                            ((Damageable)itemMeta).setDamage(((Damageable)itemMeta).getDamage() + 2);
                            if (((Damageable)itemMeta).getDamage() >= slime.getType().getMaxDurability()) {
                                world.dropItem(entity.getLocation(), new ItemStack(Material.STICK));
                                slime.setAmount(0);
                                continue;
                            }
                            slime.setItemMeta(itemMeta);
                            continue;
                        }
                        if (slime.getType() != Material.IRON_HELMET && slime.getType() != Material.IRON_CHESTPLATE && slime.getType() != Material.IRON_LEGGINGS && slime.getType() != Material.IRON_BOOTS && slime.getType() != Material.GOLDEN_HELMET && slime.getType() != Material.GOLDEN_CHESTPLATE && slime.getType() != Material.GOLDEN_LEGGINGS && slime.getType() != Material.GOLDEN_BOOTS) continue;
                        ItemMeta itemMeta = slime.getItemMeta();
                        ((Damageable)itemMeta).setDamage(((Damageable)itemMeta).getDamage() + 1);
                        if (((Damageable)itemMeta).getDamage() >= slime.getType().getMaxDurability()) {
                            slime.setAmount(0);
                            continue;
                        }
                        slime.setItemMeta(itemMeta);
                    }
                    AcidStorm acidStorm2 = AcidStorm.this;
                    acidStorm2.time = acidStorm2.time - 5;
                    if (AcidStorm.this.time <= 0) {
                        world.setStorm(false);
                    }
                } else if (AcidStorm.this.time > 0) {
                    world.setStorm(true);
                } else {
                    AcidStorm.this.triggerRegen(true);
                    DeathMessages.acidstorms.remove(acidStorm);
                    ongoingDisasters.remove(acidStorm);
                    AcidStorm.this.clearEntities();
                    this.cancel();
                    Metrics.incrementValue(Metrics.disasterDestroyedMap, AcidStorm.this.type.getMetricsLabel(), AcidStorm.this.blocksDestroyed);
                }
            }
        };
        final BukkitTask[] bukkitTaskArray = new BukkitTask[2];
        final BlockData blockData = Material.LIME_WOOL.createBlockData();
        bukkitTaskArray[0] = this.plugin.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                if (AcidStorm.this.time <= 0) {
                    bukkitTaskArray[0].cancel();
                    return;
                }
                for (Player player : world.getPlayers()) {
                    if (!player.getWorld().equals(world)) continue;
                    int n = -AcidStorm.this.particleRange;
                    while (n <= AcidStorm.this.particleRange) {
                        int n2 = -AcidStorm.this.particleRange;
                        while (n2 <= AcidStorm.this.particleRange) {
                            int n3;
                            Location location;
                            Location location2;
                            if (!(random.nextDouble() >= AcidStorm.this.particleMultiplier || (location2 = world.getHighestBlockAt(location = player.getLocation().add((double)n, 0.0, (double)n2)).getLocation()).getBlock().getTemperature() <= 0.15 || location2.getBlock().getTemperature() > 0.95 || Utils.isWeatherDisabled(location2, acidStorm) || (n3 = location2.getBlockY() - location.getBlockY()) > AcidStorm.this.particleYRange)) {
                                if (n3 < 0) {
                                    location2.setY(location2.getY() + (double)(n3 * -1));
                                }
                                if (AcidStorm.this.plugin.mcVersion >= 1.17) {
                                    player.spawnParticle(Particle.FALLING_SPORE_BLOSSOM, location2.add(0.5, 5.0, 0.5), 1, 0.5, 1.5, 0.5, 1.0);
                                } else {
                                    player.spawnParticle(Particle.FALLING_DUST, location2.add(0.5, 5.0, 0.5), 1, 0.5, 1.5, 0.5, 1.0, (Object)blockData);
                                }
                            }
                            ++n2;
                        }
                        ++n;
                    }
                }
            }
        }, (long)this.delay, 1L);
        bukkitTaskArray[1] = this.plugin.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                if (AcidStorm.this.time <= 0) {
                    bukkitTaskArray[1].cancel();
                    return;
                }
                final HashMap<Block, Material> hashMap = new HashMap<Block, Material>();
                for (Player player : world.getPlayers()) {
                    int n = -AcidStorm.this.blockDamageRange;
                    while (n < AcidStorm.this.blockDamageRange) {
                        int n2 = -AcidStorm.this.blockDamageRange;
                        while (n2 < AcidStorm.this.blockDamageRange) {
                            if (!(random.nextDouble() >= AcidStorm.this.blockChangeRate)) {
                                Block block = world.getHighestBlockAt(player.getLocation().add((double)n, 0.0, (double)n2));
                                if (AcidStorm.this.poisonCrops && CROPS.contains(block.getRelative(BlockFace.UP).getType()) && !poisonedCrops.contains(block.getRelative(BlockFace.UP))) {
                                    poisonedCrops.add(block.getRelative(BlockFace.UP));
                                    if (cropsMonitor == null) {
                                        AcidStorm.startCropsMonitor(AcidStorm.this.plugin);
                                    }
                                }
                                if (AcidStorm.this.blockChanges.containsKey(block.getType()) && !Utils.isZoneProtected(block.getLocation()) && !Utils.passStrengthTest(block.getType()) && !Utils.isWeatherDisabled(block.getLocation(), acidStorm)) {
                                    Material material = AcidStorm.this.blockChanges.get(block.getType());
                                    if (AcidStorm.this.plugin.CProtect) {
                                        Utils.getCoreProtect().logRemoval("Deadly-Disasters", block.getLocation(), block.getType(), block.getBlockData());
                                        Utils.getCoreProtect().logPlacement("Deadly-Disasters", block.getLocation(), material, material.createBlockData());
                                    }
                                    AcidStorm.this.addBlockWithTopToListAsync(block, block.getState());
                                    hashMap.put(block, material);
                                    world.playSound(block.getLocation(), Sound.BLOCK_FIRE_EXTINGUISH, SoundCategory.BLOCKS, (float)(0.1 * AcidStorm.this.volume), 2.0f);
                                }
                            }
                            ++n2;
                        }
                        ++n;
                    }
                }
                AcidStorm.this.plugin.getServer().getScheduler().runTask((Plugin)AcidStorm.this.plugin, new Runnable(){

                    @Override
                    public void run() {
                        for (Map.Entry entry : hashMap.entrySet()) {
                            ((Block)entry.getKey()).setType((Material)entry.getValue());
                        }
                        (this).AcidStorm.this.blocksDestroyed += hashMap.size();
                    }
                });
            }
        }, (long)this.delay, 40L);
    }

    public static void startCropsMonitor(final Main main) {
        final BlockData blockData = Material.LIME_WOOL.createBlockData();
        final Random random = main.random;
        cropsMonitor = main.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)main, new Runnable(){

            @Override
            public void run() {
                if (isRunning) {
                    return;
                }
                isRunning = true;
                Iterator<Block> iterator = poisonedCrops.iterator();
                block9: while (iterator.hasNext()) {
                    final Block block = iterator.next();
                    for (Player player : block.getWorld().getPlayers()) {
                        if (!(player.getLocation().distanceSquared(block.getLocation()) <= 2500.0)) continue;
                        if (!CROPS.contains(block.getType()) || !(block.getBlockData() instanceof Ageable)) {
                            iterator.remove();
                        }
                        try {
                            int n = ((Ageable)block.getBlockData()).getAge();
                            if (n >= ((Ageable)block.getBlockData()).getMaximumAge() && random.nextInt(50) == 0) {
                                main.getServer().getScheduler().runTask((Plugin)main, new Runnable(){

                                    @Override
                                    public void run() {
                                        block.getWorld().spawnParticle(Particle.CLOUD, block.getLocation().add(0.5, 0.2, 0.5), 10, 0.2, 0.2, 0.2, 1.0E-4);
                                        block.getWorld().playSound(block.getLocation(), Sound.BLOCK_FIRE_EXTINGUISH, SoundCategory.BLOCKS, 0.1f, 2.0f);
                                        block.setType(Material.AIR);
                                        Metrics.incrementValue(Metrics.disasterDestroyedMap, Disaster.ACIDSTORM.getMetricsLabel());
                                    }
                                });
                                iterator.remove();
                                continue block9;
                            }
                            if (!(player.getLocation().distanceSquared(block.getLocation()) <= 100.0)) continue block9;
                            switch (n) {
                                default: {
                                    if (main.mcVersion >= 1.17) {
                                        block.getWorld().spawnParticle(Particle.FALLING_SPORE_BLOSSOM, block.getLocation().add(0.5, -0.05, 0.5), 4, 0.225, 0.05, 0.225, 1.0);
                                        break;
                                    }
                                    block.getWorld().spawnParticle(Particle.FALLING_DUST, block.getLocation().add(0.5, -0.05, 0.5), 3, 0.225, 0.05, 0.225, 1.0E-4, (Object)blockData);
                                    break;
                                }
                                case 1: {
                                    if (main.mcVersion >= 1.17) {
                                        block.getWorld().spawnParticle(Particle.FALLING_SPORE_BLOSSOM, block.getLocation().add(0.5, 0.05, 0.5), 4, 0.225, 0.05, 0.225, 1.0);
                                        break;
                                    }
                                    block.getWorld().spawnParticle(Particle.FALLING_DUST, block.getLocation().add(0.5, 0.05, 0.5), 3, 0.225, 0.05, 0.225, 1.0E-4, (Object)blockData);
                                    break;
                                }
                                case 2: {
                                    if (main.mcVersion >= 1.17) {
                                        block.getWorld().spawnParticle(Particle.FALLING_SPORE_BLOSSOM, block.getLocation().add(0.5, 0.3, 0.5), 4, 0.24, 0.05, 0.24, 1.0);
                                        break;
                                    }
                                    block.getWorld().spawnParticle(Particle.FALLING_DUST, block.getLocation().add(0.5, 0.4, 0.5), 3, 0.225, 0.05, 0.225, 1.0E-4, (Object)blockData);
                                    break;
                                }
                                case 3: {
                                    if (main.mcVersion >= 1.17) {
                                        block.getWorld().spawnParticle(Particle.FALLING_SPORE_BLOSSOM, block.getLocation().add(0.5, 0.5, 0.5), 4, 0.24, 0.05, 0.24, 1.0);
                                        break;
                                    }
                                    block.getWorld().spawnParticle(Particle.FALLING_DUST, block.getLocation().add(0.5, 0.5, 0.5), 3, 0.225, 0.05, 0.225, 1.0E-4, (Object)blockData);
                                    break;
                                }
                                case 4: 
                                case 5: {
                                    if (main.mcVersion >= 1.17) {
                                        block.getWorld().spawnParticle(Particle.FALLING_SPORE_BLOSSOM, block.getLocation().add(0.5, 0.7, 0.5), 4, 0.24, 0.05, 0.24, 1.0);
                                        break;
                                    }
                                    block.getWorld().spawnParticle(Particle.FALLING_DUST, block.getLocation().add(0.5, 0.7, 0.5), 3, 0.225, 0.05, 0.225, 1.0E-4, (Object)blockData);
                                    break;
                                }
                            }
                            continue block9;
                        }
                        catch (ClassCastException classCastException) {
                            iterator.remove();
                            Main.consoleSender.sendMessage(Utils.chat("&c[DeadlyDisasters]: Error block type " + block.getType() + " could not be cast to Ageable!"));
                            Utils.sendDebugMessage();
                        }
                        catch (Exception exception) {
                            iterator.remove();
                            exception.printStackTrace();
                            Utils.sendDebugMessage();
                        }
                    }
                }
                isRunning = false;
                if (poisonedCrops.isEmpty()) {
                    cropsMonitor.cancel();
                    cropsMonitor = null;
                }
            }
        }, 0L, 10L);
    }

    @Override
    public void clear() {
        this.time = 0;
    }

    public void clearEntities() {
        for (UUID uUID : this.slimes) {
            if (Bukkit.getEntity((UUID)uUID) == null) continue;
            Bukkit.getEntity((UUID)uUID).remove();
        }
    }

    public boolean isMeltItems() {
        return this.meltItems;
    }

    public void setMeltItems(boolean bl) {
        this.meltItems = bl;
    }

    public boolean isMeltArmor() {
        return this.meltArmor;
    }

    public void setMeltArmor(boolean bl) {
        this.meltArmor = bl;
    }

    public double getDamage() {
        return this.damage;
    }

    public void setDamage(double d) {
        this.damage = d;
    }
}

