/*
 * Decompiled with CFR 0.152.
 */
package deadlydisasters.events.disasters;

import deadlydisasters.events.disasters.CaveIn;
import deadlydisasters.listeners.CoreListener;
import deadlydisasters.utils.Utils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

class CaveInBlock {
    private Location loc;
    private int depth;
    private CaveIn classInstance;
    private boolean CP;

    CaveInBlock(Location location, int n, CaveIn caveIn) {
        this.depth = n;
        this.loc = location;
        this.classInstance = caveIn;
        this.CP = caveIn.plugin.CProtect;
    }

    public void fall(BlockData blockData, double d) {
        if (this.depth > 0) {
            FallingBlock fallingBlock;
            Block block = this.loc.getBlock();
            if (!Utils.passStrengthTest(block.getType()) && !Utils.isZoneProtected(this.loc)) {
                BlockState blockState;
                if (blockData == null) {
                    blockData = block.getBlockData();
                }
                fallingBlock = block.getWorld().spawnFallingBlock(this.loc.clone().add(0.5, 0.5, 0.5), blockData);
                if (this.CP) {
                    Utils.getCoreProtect().logRemoval("Deadly-Disasters", block.getLocation(), block.getType(), block.getBlockData());
                }
                if ((blockState = block.getState()) instanceof InventoryHolder) {
                    CoreListener.addBlockInventory((Entity)fallingBlock, ((InventoryHolder)blockState).getInventory().getContents());
                }
                this.classInstance.addBlockToList(block, blockState);
                block.setType(Material.AIR);
                ++this.classInstance.blocksDestroyed;
            } else {
                this.classInstance.iterator.remove();
                return;
            }
            fallingBlock.setHurtEntities(false);
            fallingBlock.setDropItem(false);
            fallingBlock.setVelocity(new Vector(0.0, d, 0.0));
            fallingBlock.setMetadata("dd-fb", (MetadataValue)new FixedMetadataValue((Plugin)this.classInstance.plugin, (Object)"protected"));
            EntityChangeBlockEvent entityChangeBlockEvent = new EntityChangeBlockEvent((Entity)fallingBlock, block, Material.AIR.createBlockData());
            Bukkit.getPluginManager().callEvent((Event)entityChangeBlockEvent);
            this.classInstance.fallingRoof.add(fallingBlock.getUniqueId());
            --this.depth;
            this.loc.setY(this.loc.getY() + 1.0);
        } else {
            this.classInstance.iterator.remove();
        }
    }

    public Location getLocation() {
        return this.loc;
    }
}

