/*
 * Decompiled with CFR 0.152.
 */
package deadlydisasters.events.disasters;

import deadlydisasters.Main;
import deadlydisasters.utils.Utils;
import org.bukkit.Location;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Flying;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;

class CustomDisasterMob {
    private EntityType type;
    private double health;
    private double range;
    private double speed;
    private double damage;
    private double knockback;
    private double resistance;
    private ItemStack[] armor;
    private ItemStack mainHand;
    private ItemStack offHand;
    private float[] dropChances;
    private boolean silent;
    private String name;
    private boolean pickUp;
    private boolean despawn;

    public CustomDisasterMob(EntityType entityType, double d, double d2, double d3, double d4, double d5, double d6, ItemStack[] itemStackArray, ItemStack itemStack, ItemStack itemStack2, float[] fArray, boolean bl, String string, boolean bl2, boolean bl3) {
        this.type = entityType;
        this.health = d;
        this.range = d2;
        this.speed = d3;
        this.damage = d4;
        this.knockback = d5;
        this.resistance = d6;
        this.armor = itemStackArray;
        this.mainHand = itemStack;
        this.offHand = itemStack2;
        this.dropChances = fArray;
        this.silent = bl;
        this.name = string;
        this.pickUp = bl2;
        this.despawn = bl3;
    }

    public void spawnMob(Location location, boolean bl, LivingEntity livingEntity) {
        Entity entity = location.getWorld().spawnEntity(location, this.type);
        if (this.name != null) {
            entity.setCustomName(this.name);
        }
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity2 = (LivingEntity)entity;
            if (this.health > 0.0) {
                livingEntity2.getAttribute(Attribute.GENERIC_MAX_HEALTH).setBaseValue(this.health);
                livingEntity2.setHealth(this.health);
            }
            if (this.range > 0.0) {
                livingEntity2.getAttribute(Attribute.GENERIC_FOLLOW_RANGE).setBaseValue(this.range);
            }
            if (this.damage > 0.0) {
                livingEntity2.getAttribute(Attribute.GENERIC_ATTACK_DAMAGE).setBaseValue(this.damage);
            }
            if (this.speed > 0.0) {
                if (livingEntity2 instanceof Flying) {
                    livingEntity2.getAttribute(Attribute.GENERIC_FLYING_SPEED).setBaseValue(this.speed);
                } else {
                    livingEntity2.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED).setBaseValue(this.speed);
                }
            }
            if (this.knockback > 0.0 && Main.getInstance().mcVersion >= 1.16) {
                livingEntity2.getAttribute(Attribute.GENERIC_ATTACK_KNOCKBACK).setBaseValue(this.knockback);
            }
            if (this.resistance > 0.0) {
                livingEntity2.getAttribute(Attribute.GENERIC_KNOCKBACK_RESISTANCE).setBaseValue(this.resistance);
            }
            livingEntity2.setSilent(this.silent);
            livingEntity2.setCanPickupItems(this.pickUp);
            livingEntity2.setRemoveWhenFarAway(this.despawn);
            EntityEquipment entityEquipment = livingEntity2.getEquipment();
            entityEquipment.setItemInMainHand(this.mainHand);
            entityEquipment.setItemInMainHandDropChance(this.dropChances[4]);
            entityEquipment.setItemInOffHand(this.offHand);
            entityEquipment.setItemInOffHandDropChance(this.dropChances[5]);
            entityEquipment.setArmorContents(this.armor);
            entityEquipment.setHelmetDropChance(this.dropChances[0]);
            entityEquipment.setChestplateDropChance(this.dropChances[1]);
            entityEquipment.setLeggingsDropChance(this.dropChances[2]);
            entityEquipment.setBootsDropChance(this.dropChances[3]);
            if (bl && livingEntity2 instanceof Mob && (!(livingEntity instanceof Player) || !Utils.isPlayerImmune((Player)livingEntity))) {
                ((Mob)livingEntity2).setTarget(livingEntity);
            }
        }
    }
}

