/*
 * Decompiled with CFR 0.152.
 */
package deadlydisasters.events.disasters;

import deadlydisasters.Main;
import deadlydisasters.entities.CustomEntityType;
import deadlydisasters.entities.halloweenentities.Ghoul;
import deadlydisasters.entities.halloweenentities.Psyco;
import deadlydisasters.entities.halloweenentities.Scarecrow;
import deadlydisasters.entities.halloweenentities.Vampire;
import deadlydisasters.entities.purgeentities.DarkMage;
import deadlydisasters.entities.purgeentities.ShadowLeech;
import deadlydisasters.entities.purgeentities.SkeletonKnight;
import deadlydisasters.entities.purgeentities.SwampBeast;
import deadlydisasters.entities.purgeentities.TunnellerZombie;
import deadlydisasters.entities.purgeentities.ZombieKnight;
import deadlydisasters.events.DestructionDisaster;
import deadlydisasters.events.Disaster;
import deadlydisasters.handlers.Languages;
import deadlydisasters.handlers.WorldObject;
import deadlydisasters.listeners.DeathMessages;
import deadlydisasters.utils.RepeatingTask;
import deadlydisasters.utils.Utils;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.entity.Skeleton;
import org.bukkit.entity.Zombie;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.MetadataValue;

public class DeathParade
extends DestructionDisaster {
    private boolean custom;
    private boolean running = true;
    private int spawnDistance;
    private int despawnSpeed;
    private int spawnSpeed;
    private Random rand;
    private String endMessage;
    private int[] mobProbabilities;
    private int sum;
    public UUID kingUUID;
    private Queue<UUID> entities = new ArrayDeque<UUID>();
    private Map<UUID, UUID> targetMap = new HashMap<UUID, UUID>();

    public DeathParade(int n) {
        super(n);
        this.rand = this.plugin.random;
        this.spawnDistance = 25;
        this.despawnSpeed = 40;
        this.volume = this.configFile.getDouble("purge.volume");
        this.spawnSpeed = 120 - 8 * (n - 1);
        this.mobProbabilities = new int[]{2, 2, 5, 3, 2, 3, 3, 3, 5, 4, 4, 4};
        int n2 = 0;
        while (n2 < this.mobProbabilities.length) {
            this.sum += this.mobProbabilities[n2];
            ++n2;
        }
        this.type = Disaster.PURGE;
    }

    @Override
    public void start(Location location, Player player) {
        this.custom = (Boolean)WorldObject.findWorldObject((World)location.getWorld()).settings.get("custom_mob_spawning");
        this.world = location.getWorld();
        DeathMessages.deathparades.add(this);
        final DeathParade deathParade = this;
        new RepeatingTask(this.plugin, 0, this.spawnSpeed){

            @Override
            public void run() {
                Entity entity = Bukkit.getEntity((UUID)DeathParade.this.kingUUID);
                Iterator iterator = DeathParade.this.entities.iterator();
                while (iterator.hasNext()) {
                    LivingEntity livingEntity = (LivingEntity)Bukkit.getEntity((UUID)((UUID)iterator.next()));
                    if (livingEntity == null) {
                        iterator.remove();
                        continue;
                    }
                    if (!livingEntity.isDead()) continue;
                    iterator.remove();
                }
                if (entity == null || entity.isDead()) {
                    DeathMessages.deathparades.remove(deathParade);
                    new RepeatingTask(DeathParade.this.plugin, 0, DeathParade.this.despawnSpeed){

                        @Override
                        public void run() {
                            UUID uUID = (this).DeathParade.this.entities.poll();
                            if (uUID == null) {
                                return;
                            }
                            LivingEntity livingEntity = (LivingEntity)Bukkit.getEntity((UUID)uUID);
                            if (livingEntity != null) {
                                livingEntity.remove();
                            }
                            if ((this).DeathParade.this.entities.isEmpty()) {
                                this.cancel();
                            }
                        }
                    };
                    this.cancel();
                    DeathParade.this.running = false;
                    return;
                }
                for (LivingEntity livingEntity : entity.getWorld().getPlayers()) {
                    if (Utils.isPlayerImmune((Player)livingEntity) || livingEntity.getLocation().distanceSquared(entity.getLocation()) > 1600.0) continue;
                    Location location = Utils.findSmartYSpawn(livingEntity.getLocation(), Utils.getSpotInSquareRadius(livingEntity.getLocation(), DeathParade.this.spawnDistance), 2, 25);
                    if (location == null || location.getBlock().getRelative(BlockFace.DOWN).isPassable()) {
                        return;
                    }
                    int n = DeathParade.this.rand.nextInt(DeathParade.this.sum);
                    int n2 = 0;
                    int n3 = 0;
                    while (n3 < DeathParade.this.mobProbabilities.length) {
                        if (n <= (n2 += DeathParade.this.mobProbabilities[n3])) {
                            n = n3;
                            break;
                        }
                        ++n3;
                    }
                    Mob mob = null;
                    switch (n) {
                        default: {
                            mob = (Mob)location.getWorld().spawnEntity(location, EntityType.ZOMBIE);
                            mob.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED).setBaseValue(0.35);
                            mob.getEquipment().setHelmet(new ItemStack(Material.JACK_O_LANTERN));
                            break;
                        }
                        case 1: {
                            mob = (Mob)location.getWorld().spawnEntity(location, EntityType.SKELETON);
                            mob.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED).setBaseValue(0.35);
                            mob.getEquipment().setHelmet(new ItemStack(Material.JACK_O_LANTERN));
                            break;
                        }
                        case 2: {
                            if (!DeathParade.this.custom || !CustomEntityType.TUNNELLER.canSpawn()) break;
                            mob = (Mob)livingEntity.getWorld().spawnEntity(location, EntityType.ZOMBIE);
                            DeathParade.this.plugin.handler.addEntity(new TunnellerZombie((Zombie)mob, livingEntity, DeathParade.this.plugin));
                            break;
                        }
                        case 3: {
                            if (!DeathParade.this.custom || !CustomEntityType.SKELETONKNIGHT.canSpawn()) break;
                            mob = (Mob)livingEntity.getWorld().spawnEntity(location, EntityType.SKELETON);
                            DeathParade.this.plugin.handler.addEntity(new SkeletonKnight((Skeleton)mob, DeathParade.this.plugin));
                            break;
                        }
                        case 4: {
                            if (!DeathParade.this.custom || !CustomEntityType.DARKMAGE.canSpawn()) break;
                            mob = (Mob)livingEntity.getWorld().spawnEntity(location, EntityType.ZOMBIE);
                            DeathParade.this.plugin.handler.addEntity(new DarkMage(mob, DeathParade.this.plugin));
                            break;
                        }
                        case 5: {
                            if (!DeathParade.this.custom || !CustomEntityType.SHADOWLEECH.canSpawn()) break;
                            mob = (Mob)livingEntity.getWorld().spawnEntity(location, EntityType.ZOMBIE);
                            DeathParade.this.plugin.handler.addEntity(new ShadowLeech((Zombie)mob, DeathParade.this.plugin, DeathParade.this.rand));
                            break;
                        }
                        case 6: {
                            if (!DeathParade.this.custom || !CustomEntityType.SWAMPBEAST.canSpawn()) break;
                            mob = (Mob)livingEntity.getWorld().spawnEntity(location, EntityType.ZOMBIE);
                            DeathParade.this.plugin.handler.addEntity(new SwampBeast(mob, DeathParade.this.plugin));
                            break;
                        }
                        case 7: {
                            if (!DeathParade.this.custom || !CustomEntityType.ZOMBIEKNIGHT.canSpawn()) break;
                            mob = (Mob)livingEntity.getWorld().spawnEntity(location, EntityType.ZOMBIE);
                            DeathParade.this.plugin.handler.addEntity(new ZombieKnight(mob, DeathParade.this.plugin));
                            break;
                        }
                        case 8: {
                            if (!DeathParade.this.custom || !CustomEntityType.GHOUL.canSpawn()) break;
                            mob = (Mob)livingEntity.getWorld().spawnEntity(location, EntityType.ZOMBIE);
                            DeathParade.this.plugin.handler.addEntity(new Ghoul((Zombie)mob, location.getBlock().getRelative(BlockFace.DOWN), DeathParade.this.plugin, true));
                            break;
                        }
                        case 9: {
                            if (!DeathParade.this.custom || !CustomEntityType.PSYCO.canSpawn()) break;
                            mob = (Mob)livingEntity.getWorld().spawnEntity(location, EntityType.SKELETON);
                            DeathParade.this.plugin.handler.addEntity(new Psyco(mob, DeathParade.this.plugin, DeathParade.this.rand));
                            break;
                        }
                        case 10: {
                            if (!DeathParade.this.custom || !CustomEntityType.SCARECROW.canSpawn()) break;
                            mob = (Mob)livingEntity.getWorld().spawnEntity(location, EntityType.ZOMBIE);
                            DeathParade.this.plugin.handler.addEntity(new Scarecrow((Zombie)mob, DeathParade.this.plugin, DeathParade.this.rand));
                            break;
                        }
                        case 11: {
                            if (!DeathParade.this.custom || !CustomEntityType.VAMPIRE.canSpawn()) break;
                            mob = (Mob)livingEntity.getWorld().spawnEntity(location, EntityType.EVOKER);
                            DeathParade.this.plugin.handler.addEntity(new Vampire(mob, DeathParade.this.plugin));
                        }
                    }
                    if (mob == null) continue;
                    mob.getAttribute(Attribute.GENERIC_FOLLOW_RANGE).setBaseValue(40.0);
                    mob.setMetadata("dd-halloweenmobs", (MetadataValue)DeathParade.this.plugin.fixedData);
                    mob.setTarget(livingEntity);
                    DeathParade.this.entities.add(mob.getUniqueId());
                    DeathParade.this.targetMap.put(mob.getUniqueId(), livingEntity.getUniqueId());
                }
            }
        };
        new RepeatingTask(this.plugin, 0, 5){

            @Override
            public void run() {
                if (!DeathParade.this.running) {
                    this.cancel();
                    return;
                }
                for (Map.Entry<UUID, UUID> entry : DeathParade.this.targetMap.entrySet()) {
                    Mob mob = (Mob)Bukkit.getEntity((UUID)entry.getKey());
                    if (mob == null || mob.isDead() || mob.getTarget() != null) continue;
                    mob.setTarget((LivingEntity)Bukkit.getPlayer((UUID)entry.getValue()));
                }
            }
        };
    }

    public void clearEntities() {
        for (UUID uUID : this.entities) {
            if (Bukkit.getEntity((UUID)uUID) == null) continue;
            Bukkit.getEntity((UUID)uUID).remove();
        }
    }

    @Override
    public Location findApplicableLocation(Location location, Player player) {
        if (location.getBlockY() < this.type.getMinHeight()) {
            return null;
        }
        if (((Boolean)WorldObject.findWorldObject((World)location.getWorld()).settings.get("event_broadcast")).booleanValue()) {
            this.broadcastMessage(player.getLocation(), player);
        }
        return location;
    }

    @Override
    public void startAdjustment(Location location, Player player) {
        this.start(location, player);
    }

    @Override
    public void broadcastMessage(Location location, Player player) {
        if (((Boolean)WorldObject.findWorldObject((World)location.getWorld()).settings.get("event_broadcast")).booleanValue()) {
            String string = this.configFile.getString("messages.misc.purge.started");
            if (this.level == 1) {
                string = "&a" + string;
            } else if (this.level == 2) {
                string = "&2" + string;
            } else if (this.level == 3) {
                string = "&b" + string;
            } else if (this.level == 4) {
                string = "&e" + string;
            } else if (this.level == 5) {
                string = "&c" + string;
            } else if (this.level == 6) {
                string = "&4" + string;
            }
            string = Utils.chat(string.replace("%level%", String.valueOf(this.level)).replace("%player%", player.getName()));
            if (this.configFile.getBoolean("messages.disaster_tips")) {
                string = String.valueOf(string) + "\n" + this.type.getTip();
            }
            for (Player player2 : location.getWorld().getPlayers()) {
                player2.sendMessage(string);
            }
            Main.consoleSender.sendMessage(String.valueOf(Languages.prefix) + string + ChatColor.GREEN + " (" + location.getWorld().getName() + ")");
        }
    }

    public int getSpawnDistance() {
        return this.spawnDistance;
    }

    public void setSpawnDistance(int n) {
        this.spawnDistance = n;
    }

    public int getDespawnSpeed() {
        return this.despawnSpeed;
    }

    public void setDespawnSpeed(int n) {
        this.despawnSpeed = n;
    }

    public String getEndMessage() {
        return this.endMessage;
    }

    public void setEndMessage(String string) {
        this.endMessage = string;
    }

    public int getSpawnSpeed() {
        return this.spawnSpeed;
    }

    public void setSpawnSpeed(int n) {
        this.spawnSpeed = n;
    }
}

