/*
 * Decompiled with CFR 0.152.
 */
package deadlydisasters.events.disasters;

import deadlydisasters.events.DestructionDisaster;
import deadlydisasters.events.DestructionDisasterEvent;
import deadlydisasters.events.Disaster;
import deadlydisasters.listeners.DeathMessages;
import deadlydisasters.utils.AsyncRepeatingTask;
import deadlydisasters.utils.Metrics;
import deadlydisasters.utils.RepeatingTask;
import deadlydisasters.utils.Utils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.TileState;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.BlockVector;
import org.bukkit.util.Vector;

public class Earthquake
extends DestructionDisaster {
    private Set<Place> list = ConcurrentHashMap.newKeySet();
    private Map<BlockVector, Vector> vectors = new HashMap<BlockVector, Vector>();
    public Random rand = new Random();
    private Map<Chunk, Set<Place>> masteryBlocks = new ConcurrentHashMap<Chunk, Set<Place>>();
    private Location mem;
    private int len;
    private int wid;
    private int radius;
    private World world;
    private double size = this.configFile.getDouble("earthquake.size");
    private double tilt = this.configFile.getDouble("earthquake.tilt");
    private double force = this.configFile.getDouble("earthquake.force");
    public int blocksDestroyed;

    public Earthquake(int n) {
        super(n);
        this.volume = this.configFile.getDouble("earthquake.volume");
        switch (n) {
            default: {
                this.len = this.rand.nextInt(11) + 10;
                this.wid = this.rand.nextInt(3) + 3;
                break;
            }
            case 2: {
                this.len = this.rand.nextInt(11) + 20;
                this.wid = this.rand.nextInt(4) + 5;
                break;
            }
            case 3: {
                this.len = this.rand.nextInt(11) + 40;
                this.wid = this.rand.nextInt(4) + 8;
                break;
            }
            case 4: {
                this.len = this.rand.nextInt(21) + 60;
                this.wid = this.rand.nextInt(5) + 10;
                break;
            }
            case 5: {
                this.len = this.rand.nextInt(21) + 80;
                this.wid = this.rand.nextInt(6) + 15;
                break;
            }
            case 6: {
                this.len = this.rand.nextInt(11) + 140;
                this.wid = this.rand.nextInt(6) + 20;
            }
        }
        this.radius = this.len;
        this.type = Disaster.EARTHQUAKE;
    }

    @Override
    public void start(final Location location, Player player) {
        DestructionDisasterEvent destructionDisasterEvent = new DestructionDisasterEvent(this, location, this.level, player);
        Bukkit.getPluginManager().callEvent((Event)destructionDisasterEvent);
        if (destructionDisasterEvent.isCancelled()) {
            return;
        }
        ongoingDisasters.add(this);
        final double d = this.level;
        this.len = (int)((double)this.len * this.size);
        this.wid = (int)((double)this.wid * this.size);
        this.radius = this.len;
        this.p = player;
        this.loc = location;
        this.mem = location.clone();
        this.world = location.getWorld();
        Vector vector = new Vector(this.rand.nextInt(360) - 180, 0, this.rand.nextInt(360) - 180).normalize();
        this.vectors.put(new BlockVector(location.getX(), location.getY(), location.getZ()), vector.clone().multiply(-1));
        location.subtract(vector);
        this.vectors.put(new BlockVector(location.getX(), location.getY(), location.getZ()).add(new Vector(vector.getZ(), 0.0, -vector.getX()).normalize().multiply(this.wid)).toBlockVector(), vector.clone());
        final Earthquake earthquake = this;
        this.addPlayersToSurvivalChannel(location.clone().subtract(0.0, (double)this.len, 0.0), this.len + 5, this.survivingPlayers);
        DeathMessages.earthquakes.add(this);
        final int[] nArray = new int[2];
        final HashMap hashMap = new HashMap();
        final int n = this.len;
        final boolean[] blArray = new boolean[1];
        new RepeatingTask(this.plugin, 0, 1){

            @Override
            public void run() {
                int n5 = 0;
                while (n5 < Earthquake.this.level) {
                    if (Earthquake.this.len <= 0) {
                        for (Entity entity : Earthquake.this.world.getNearbyEntities(location, (double)(n / 2), (double)(n / 3), (double)(n / 2))) {
                            if (!(entity instanceof Player)) continue;
                            ((Player)entity).playSound(entity.getLocation(), Sound.ENTITY_ENDER_DRAGON_DEATH, (float)(0.33 * d * Earthquake.this.volume), 0.5f);
                        }
                        new RepeatingTask(Earthquake.this.plugin, 0, Earthquake.this.configFile.getInt("earthquake.tick_speed")){

                            @Override
                            public void run() {
                                Iterator<Place> iterator = (this).Earthquake.this.list.iterator();
                                while (iterator.hasNext()) {
                                    iterator.next().dig(iterator);
                                }
                                for (Map.Entry entry : ((Map)hashMap.get(nArray[1])).entrySet()) {
                                    for (Entity entity : (this).Earthquake.this.world.getNearbyEntities(((BlockVector)entry.getKey()).subtract((Vector)entry.getValue()).toLocation((this).Earthquake.this.world), (double)((this).Earthquake.this.level * 10), (double)((this).Earthquake.this.level * 10), (double)((this).Earthquake.this.level * 10))) {
                                        if (!(entity instanceof LivingEntity) || entity instanceof Player && ((Player)entity).isFlying()) continue;
                                        double d2 = entity.getVelocity().getY();
                                        d2 = !entity.isOnGround() || entity.getVelocity().getY() > 3.0 ? 0.0 : (this).Earthquake.this.rand.nextDouble() / 14.0 * d * (this).Earthquake.this.force;
                                        Vector vector = new Vector(((this).Earthquake.this.rand.nextDouble() - 0.5) / 5.0 * d * (this).Earthquake.this.force, d2, ((this).Earthquake.this.rand.nextDouble() - 0.5) / 5.0 * d * (this).Earthquake.this.force);
                                        if (entity instanceof Player && (this).Earthquake.this.plugin.achievementsHandler.isMasteryActive(entity.getUniqueId(), "disasters.survival.earthquake")) {
                                            vector.multiply((this).Earthquake.this.plugin.achievementsHandler.getMasteryPower(entity.getUniqueId(), "disasters.survival.earthquake"));
                                        }
                                        entity.setVelocity(entity.getVelocity().add(vector));
                                    }
                                }
                                nArray[1] = nArray[1] + 1;
                                if (nArray[1] >= nArray[0]) {
                                    blArray[0] = true;
                                    this.cancel();
                                    Earthquake.this.triggerRegen(true);
                                    ongoingDisasters.remove(earthquake);
                                    Metrics.incrementValue(Metrics.disasterDestroyedMap, (this).Earthquake.this.type.getMetricsLabel(), (this).Earthquake.this.blocksDestroyed);
                                    (this).Earthquake.this.plugin.getServer().getScheduler().runTaskLater((Plugin)(this).Earthquake.this.plugin, () -> {
                                        Earthquake.this.awardPlayersInSet(Earthquake.this.survivingPlayers, 1, "disasters.survival.earthquake");
                                        if ((this).Earthquake.this.level >= 6) {
                                            Earthquake.this.awardPlayersInSet(Earthquake.this.survivingPlayers, 1, "disasters.survival.level_six", 1);
                                        }
                                        Earthquake.this.removePlayersFromSurvivalChannel(Earthquake.this.survivingPlayers);
                                    }, 80L);
                                    (this).Earthquake.this.plugin.getServer().getScheduler().runTaskLater((Plugin)(this).Earthquake.this.plugin, new Runnable(){

                                        @Override
                                        public void run() {
                                            DeathMessages.earthquakes.remove(earthquake);
                                        }
                                    }, 200L);
                                    return;
                                }
                            }
                        };
                        this.cancel();
                        return;
                    }
                    --Earthquake.this.len;
                    int n2 = Earthquake.this.wid * 2;
                    HashMap hashMap3 = new HashMap();
                    for (Map.Entry<BlockVector, Vector> entry : Earthquake.this.vectors.entrySet()) {
                        entry.getKey().add(entry.getValue());
                        BlockVector blockVector = entry.getKey().clone();
                        Vector vector = new Vector(-entry.getValue().getZ(), 0.0, entry.getValue().getX()).normalize().multiply(0.5);
                        int n3 = 1;
                        while (n3 < n2) {
                            int n4;
                            Location location2 = blockVector.toLocation(Earthquake.this.world);
                            if (location2.getBlock().getType().isSolid()) {
                                n4 = 0;
                                while (n4 < 15) {
                                    location2.setY(location2.getY() + 1.0);
                                    if (!location2.getBlock().getType().isSolid()) {
                                        location2.setY(location2.getY() - 1.0);
                                        break;
                                    }
                                    ++n4;
                                }
                            } else {
                                n4 = 0;
                                while (n4 < 15) {
                                    location2.setY(location2.getY() - 1.0);
                                    if (!location2.getBlock().getType().isSolid()) {
                                        ++n4;
                                        continue;
                                    }
                                    break;
                                }
                            }
                            n4 = location.getBlockY() - 5;
                            if (n3 < Earthquake.this.level * 2 && n3 < n2 / 3) {
                                location2.subtract(0.0, (double)(5 - n3), 0.0);
                                n4 = n4 / n2 * n3;
                            } else if (n3 > n2 - Earthquake.this.level && n3 > n2 / 3 * 2) {
                                location2.subtract(0.0, (double)(5 - (n2 - n3)), 0.0);
                                n4 = n4 / n2 * (n2 - n3);
                            }
                            Place place = new Place(location2, n4, earthquake, nArray[0]);
                            Earthquake.this.list.add(place);
                            if (Earthquake.this.masteryBlocks.containsKey(location2.getChunk())) {
                                Earthquake.this.masteryBlocks.get(location2.getChunk()).add(place);
                            } else {
                                ConcurrentHashMap.KeySetView keySetView = ConcurrentHashMap.newKeySet();
                                keySetView.add(place);
                                Earthquake.this.masteryBlocks.put(location2.getChunk(), keySetView);
                            }
                            blockVector.add(vector);
                            ++n3;
                        }
                        if (Earthquake.this.level > 3 && Earthquake.this.rand.nextInt(Earthquake.this.level * 10) == 0) {
                            Vector vector2 = new Vector(vector.getX() + (Earthquake.this.rand.nextDouble() / 2.0 - 0.25), 0.0, vector.getZ() + (Earthquake.this.rand.nextDouble() / 2.0 - 0.25)).normalize();
                            if (Earthquake.this.rand.nextInt(2) == 0) {
                                vector2.multiply(-1);
                            }
                            hashMap3.put(entry.getKey().clone().add(vector.clone().multiply(n2 / 2)).toBlockVector(), vector2);
                        }
                        vector.multiply(n2 / 2);
                        if (hashMap.containsKey(nArray[0])) {
                            ((Map)hashMap.get(nArray[0])).put(blockVector.clone(), vector.clone());
                        } else {
                            HashMap<BlockVector, Vector> hashMap2 = new HashMap<BlockVector, Vector>();
                            hashMap2.put(blockVector.clone(), vector.clone().multiply(n2 / 2));
                            hashMap.put(nArray[0], hashMap2);
                        }
                        vector.multiply(Earthquake.this.tilt);
                        entry.getKey().add(vector.multiply(Earthquake.this.rand.nextInt(3) - 1));
                    }
                    Earthquake.this.vectors.putAll(hashMap3);
                    nArray[0] = nArray[0] + 1;
                    ++n5;
                }
            }
        };
        final World world = location.getWorld();
        final Particle.DustOptions dustOptions = new Particle.DustOptions(Color.fromRGB((int)217, (int)15, (int)15), 0.8f);
        new AsyncRepeatingTask(this.plugin, 0, 8){

            @Override
            public void run() {
                if (blArray[0]) {
                    this.cancel();
                    return;
                }
                for (Player player : world.getPlayers()) {
                    if (!player.getWorld().equals(world) || !Earthquake.this.plugin.achievementsHandler.isMasteryActive(player.getUniqueId(), "disasters.survival.earthquake") || Earthquake.this.plugin.achievementsHandler.getMasteryTier(player.getUniqueId(), "disasters.survival.earthquake") < 3) continue;
                    Location location = player.getLocation();
                    Chunk chunk = location.getChunk();
                    int n = -1;
                    while (n < 2) {
                        int n2 = -1;
                        while (n2 < 2) {
                            if (Earthquake.this.masteryBlocks.containsKey(world.getChunkAt(chunk.getX() + n, chunk.getZ() + n2))) {
                                for (Place place : Earthquake.this.masteryBlocks.get(world.getChunkAt(chunk.getX() + n, chunk.getZ() + n2))) {
                                    if (place.loc.getBlockY() + 15 <= location.getBlockY() || place.loc.getBlockY() - place.depth - 10 >= location.getBlockY()) continue;
                                    Location location2 = place.loc.clone();
                                    location2.setY(Math.max(location.getY() - 15.0, (double)(place.loc.getBlockY() - place.depth)));
                                    Block block = location2.getBlock();
                                    int n3 = block.getLocation().getBlockY();
                                    while (n3 < Math.min(location.getBlockY() + 10, place.loc.getBlockY() + 2)) {
                                        if (block.getType() != Material.AIR) {
                                            block = block.getRelative(BlockFace.UP);
                                        } else {
                                            if (block.getRelative(BlockFace.UP).getType().isSolid()) {
                                                player.spawnParticle(Particle.REDSTONE, block.getLocation().add(0.5, 0.99, 0.5), 1, 0.3, 0.01, 0.3, 0.001, (Object)dustOptions);
                                            } else if (block.getRelative(BlockFace.DOWN).getType().isSolid()) {
                                                player.spawnParticle(Particle.REDSTONE, block.getLocation().add(0.5, 0.01, 0.5), 1, 0.3, 0.01, 0.3, 0.001, (Object)dustOptions);
                                            } else if (block.getRelative(BlockFace.NORTH).getType().isSolid()) {
                                                player.spawnParticle(Particle.REDSTONE, block.getLocation().add(0.5, 0.5, 0.01), 1, 0.3, 0.3, 0.01, 0.001, (Object)dustOptions);
                                            } else if (block.getRelative(BlockFace.EAST).getType().isSolid()) {
                                                player.spawnParticle(Particle.REDSTONE, block.getLocation().add(0.99, 0.5, 0.5), 1, 0.01, 0.3, 0.3, 0.001, (Object)dustOptions);
                                            } else if (block.getRelative(BlockFace.SOUTH).getType().isSolid()) {
                                                player.spawnParticle(Particle.REDSTONE, block.getLocation().add(0.5, 0.5, 0.99), 1, 0.3, 0.3, 0.01, 0.001, (Object)dustOptions);
                                            } else if (block.getRelative(BlockFace.WEST).getType().isSolid()) {
                                                player.spawnParticle(Particle.REDSTONE, block.getLocation().add(0.01, 0.5, 0.5), 1, 0.01, 0.3, 0.3, 0.001, (Object)dustOptions);
                                            }
                                            block = block.getRelative(BlockFace.UP);
                                        }
                                        ++n3;
                                    }
                                }
                            }
                            ++n2;
                        }
                        ++n;
                    }
                }
            }
        };
    }

    @Override
    public Location findApplicableLocation(Location location, Player player) {
        if ((location = Utils.getBlockBelow(location).getLocation()).getBlockY() < this.type.getMinHeight()) {
            return null;
        }
        return location;
    }

    @Override
    public void startAdjustment(Location location, Player player) {
        this.start(Utils.getBlockBelow(location).getLocation(), player);
    }

    public int getX() {
        return this.mem.getBlockX();
    }

    public int getY() {
        return this.mem.getBlockY();
    }

    public int getZ() {
        return this.mem.getBlockZ();
    }

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int n) {
        this.len = n;
        this.radius = n;
    }

    public int getWidth() {
        return this.wid;
    }

    public void setWidth(int n) {
        this.wid = n;
    }

    public double getTilt() {
        return this.tilt;
    }

    public void setTilt(double d) {
        this.tilt = d;
    }

    public double getSize() {
        return this.size;
    }

    public void setSize(double d) {
        this.size = d;
    }

    public double getForce() {
        return this.force;
    }

    public void setForce(double d) {
        this.force = d;
    }

    class Place {
        private int depth;
        private int delay;
        private Location loc;
        private boolean CP;
        private Random rand;
        private Earthquake classInstance;

        Place(Location location, int n, Earthquake earthquake2, int n2) {
            this.loc = location;
            this.delay = n2;
            this.depth = n;
            this.classInstance = earthquake2;
            this.rand = earthquake2.rand;
            this.CP = earthquake2.plugin.CProtect;
            this.addTopBlock();
        }

        void dig(Iterator<Place> iterator) {
            if (this.delay > 0) {
                --this.delay;
                return;
            }
            Block block = this.loc.getBlock();
            int n = Math.min(this.rand.nextInt(4) + 1, this.depth);
            while (n > 0) {
                this.loc.setY(this.loc.getY() - 1.0);
                block = this.loc.getBlock();
                if (!Utils.passStrengthTest(block.getType()) && !Utils.isZoneProtected(block.getLocation())) {
                    Block block2;
                    if (this.CP) {
                        Utils.getCoreProtect().logRemoval("Deadly-Disasters", block.getLocation(), block.getType(), block.getBlockData());
                        Utils.getCoreProtect().logPlacement("Deadly-Disasters", block.getLocation(), new Location(block.getWorld(), (double)block.getX(), (double)(block.getY() + 1), (double)block.getZ()).getBlock().getType(), new Location(block.getWorld(), (double)block.getX(), (double)(block.getY() + 1), (double)block.getZ()).getBlock().getBlockData());
                        Utils.getCoreProtect().logRemoval("Deadly-Disasters", new Location(block.getWorld(), (double)block.getX(), (double)(block.getY() + 1), (double)block.getZ()), new Location(block.getWorld(), (double)block.getX(), (double)(block.getY() + 1), (double)block.getZ()).getBlock().getType(), new Location(block.getWorld(), (double)block.getX(), (double)(block.getY() + 1), (double)block.getZ()).getBlock().getBlockData());
                    }
                    if (!Utils.passStrengthTest((block2 = this.loc.getBlock().getRelative(BlockFace.UP)).getType()) && !Utils.isZoneProtected(block2.getLocation())) {
                        BlockState blockState = block.getState();
                        this.classInstance.addBlockToList(block, blockState);
                        block.setBlockData(block2.getBlockData());
                        if (blockState instanceof TileState) {
                            if (block2.getState() instanceof InventoryHolder) {
                                ((InventoryHolder)blockState).getInventory().setContents(((InventoryHolder)block2.getState()).getInventory().getContents());
                            }
                            if (this.classInstance.blockToBlock.containsKey(block2)) {
                                this.classInstance.blockToBlock.put(block, (Block)this.classInstance.blockToBlock.get(block2));
                                this.classInstance.blockToBlock.remove(block2);
                            } else {
                                this.classInstance.blockToBlock.put(block, block2);
                            }
                        }
                        block2.setType(Material.AIR);
                        ++this.classInstance.blocksDestroyed;
                    }
                } else {
                    iterator.remove();
                    this.classInstance.masteryBlocks.get(this.loc.getChunk()).remove(this);
                    return;
                }
                --this.depth;
                --n;
            }
            if (this.depth <= 0) {
                if (this.loc.getBlockY() < 15) {
                    this.classInstance.addBlockToList(block, block.getState());
                    block.setType(Material.LAVA);
                    ++this.classInstance.blocksDestroyed;
                }
                this.classInstance.masteryBlocks.get(this.loc.getChunk()).remove(this);
                iterator.remove();
            }
        }

        public void addTopBlock() {
            this.classInstance.addBlockWithTopToList(this.loc.getBlock(), this.loc.getBlock().getState());
        }

        public Location getLocation() {
            return this.loc;
        }
    }
}

