/*
 * Decompiled with CFR 0.152.
 */
package deadlydisasters.events.disasters;

import com.mojang.datafixers.util.Pair;
import deadlydisasters.Main;
import deadlydisasters.events.DestructionDisaster;
import deadlydisasters.events.DestructionDisasterEvent;
import deadlydisasters.events.Disaster;
import deadlydisasters.handlers.Languages;
import deadlydisasters.handlers.WorldObject;
import deadlydisasters.listeners.CoreListener;
import deadlydisasters.listeners.DeathMessages;
import deadlydisasters.utils.ChannelDataHolder;
import deadlydisasters.utils.Metrics;
import deadlydisasters.utils.RepeatingTask;
import deadlydisasters.utils.Utils;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.BlockVector;
import org.bukkit.util.Vector;

public class LandSlide
extends DestructionDisaster
implements Listener {
    private int radius;
    private int depth;
    private int maxOffset;
    private int maxBlocks;
    private BlockData[] materials;
    private double size;
    private double damage;
    public int blocksDestroyed;
    private Random rand;
    private Iterator<Block> it;
    private boolean shouldBeAvalanche;
    private Vector direction;
    private Map<UUID, Integer> fallingBlocks = new ConcurrentHashMap<UUID, Integer>();
    private Map<UUID, Pair<Location, BlockData>> fallingBlocksLocations = new HashMap<UUID, Pair<Location, BlockData>>();
    private Map<UUID, Block> initialSpot = new HashMap<UUID, Block>();
    private Map<UUID, ItemStack[]> invBlocks = new HashMap<UUID, ItemStack[]>();
    private Set<Material> allowedBlocks = new HashSet<Material>(Arrays.asList(Material.GRASS_BLOCK, Material.DIRT, Material.DIRT_PATH, Material.COARSE_DIRT, Material.ROOTED_DIRT, Material.SNOW_BLOCK, Material.STONE, Material.GRAVEL, Material.PACKED_ICE, Material.ICE, Material.BLUE_ICE));
    private Set<ChannelDataHolder> survivingPlayers = new HashSet<ChannelDataHolder>();

    public LandSlide(int n) {
        super(n);
        this.rand = this.plugin.random;
        switch (n) {
            default: {
                this.radius = 9;
                this.depth = 1;
                this.maxOffset = 6;
                break;
            }
            case 2: {
                this.radius = 13;
                this.depth = 2;
                this.maxOffset = 8;
                break;
            }
            case 3: {
                this.radius = 18;
                this.depth = 3;
                this.maxOffset = 10;
                break;
            }
            case 4: {
                this.radius = 23;
                this.depth = 4;
                this.maxOffset = 12;
                break;
            }
            case 5: {
                this.radius = 30;
                this.depth = 5;
                this.maxOffset = 15;
                break;
            }
            case 6: {
                this.radius = 50;
                this.depth = 6;
                this.maxOffset = 25;
            }
        }
        this.size = this.configFile.getDouble("landslide.size");
        this.radius = (int)((double)this.radius * this.size);
        this.damage = this.configFile.getDouble("landslide.damage");
        this.maxBlocks = this.configFile.getInt("landslide.max_falling_blocks");
        this.volume = this.configFile.getDouble("landslide.volume");
        if (this.plugin.mcVersion >= 1.17) {
            this.allowedBlocks.add(Material.POWDER_SNOW);
        }
        this.type = Disaster.LANDSLIDE;
    }

    @Override
    public void start(Location location, Player player) {
        this.start(location, location.clone().add(Utils.randomVector().multiply(15.0)), player);
    }

    public void start(Location location, Location location2, Player player) {
        Object object;
        DestructionDisasterEvent destructionDisasterEvent = new DestructionDisasterEvent(this, this.loc, this.level, player);
        Bukkit.getPluginManager().callEvent((Event)destructionDisasterEvent);
        if (destructionDisasterEvent.isCancelled()) {
            return;
        }
        ongoingDisasters.add(this);
        this.loc = location;
        this.radius = (int)((double)this.radius * this.size);
        this.world = this.loc.getWorld();
        DeathMessages.landslides.add(this);
        this.addPlayersToSurvivalChannel(this.loc.clone().subtract(0.0, (double)(this.radius / 2), 0.0), this.radius + 5, this.survivingPlayers);
        HashMap<int[], Double> hashMap = new HashMap<int[], Double>();
        BlockVector blockVector = new BlockVector(this.loc.getX(), this.loc.getY(), this.loc.getZ());
        int n = -this.radius;
        while (n < this.radius) {
            int n2 = -this.radius;
            while (n2 < this.radius) {
                Vector vector = blockVector.clone().add(new Vector(n, 0, n2));
                if (!(blockVector.distance(vector) > (double)this.radius)) {
                    int n3;
                    object = this.world.getBlockAt(vector.toLocation(this.world));
                    if (this.isPassableOrSnow((Block)object)) {
                        n3 = 0;
                        while (n3 < this.maxOffset) {
                            if (this.isPassableOrSnow((Block)(object = (Object)object.getRelative(BlockFace.DOWN)))) {
                                ++n3;
                                continue;
                            }
                            break;
                        }
                    } else {
                        n3 = 0;
                        while (n3 < this.maxOffset) {
                            if (this.isPassableOrSnow((Block)(object = (Object)object.getRelative(BlockFace.UP)))) {
                                object = object.getRelative(BlockFace.DOWN);
                                break;
                            }
                            ++n3;
                        }
                    }
                    if (!this.isPassableOrSnow((Block)object)) {
                        hashMap.put((int[])object, object.getLocation().distanceSquared(location2));
                    }
                }
                ++n2;
            }
            ++n;
        }
        LinkedHashSet linkedHashSet = new LinkedHashSet(Utils.sortByValue(hashMap).keySet());
        LinkedHashSet linkedHashSet2 = new LinkedHashSet();
        int n4 = Math.min(this.maxBlocks, linkedHashSet.size() / 20);
        object = new int[4];
        this.it = linkedHashSet.iterator();
        this.direction = Utils.getVectorTowards(this.loc, location2);
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
        LandSlide landSlide = this;
        double d = this.level * 20 * (this.level * 20);
        double d2 = 1.0 / d;
        new RepeatingTask(this.plugin, 0, 1, (int[])object, d, d2, landSlide, n4, linkedHashSet, linkedHashSet2){
            private final /* synthetic */ int[] val$current;
            private final /* synthetic */ double val$soundDistance;
            private final /* synthetic */ double val$vol;
            private final /* synthetic */ LandSlide val$instance;
            private final /* synthetic */ int val$ticks;
            private final /* synthetic */ Set val$spots;
            private final /* synthetic */ Set val$next;
            {
                this.val$current = nArray;
                this.val$soundDistance = d;
                this.val$vol = d2;
                this.val$instance = landSlide2;
                this.val$ticks = n3;
                this.val$spots = set;
                this.val$next = set2;
                super(javaPlugin, n, n2);
            }

            @Override
            public void run() {
                BlockState blockState;
                FallingBlock fallingBlock;
                Object object;
                Player player2;
                int n2 = this.val$current[3];
                this.val$current[3] = n2 + 1;
                if (n2 % 5 == 0) {
                    for (Player player2 : LandSlide.this.world.getPlayers()) {
                        object = player2.getEyeLocation();
                        double d = object.distanceSquared(LandSlide.this.loc);
                        if (!(d <= this.val$soundDistance)) continue;
                        if (!LandSlide.this.shouldBeAvalanche) {
                            if (LandSlide.this.rand.nextInt(2) == 0) {
                                LandSlide.this.world.playSound(object.add(Utils.getVectorTowards(object, LandSlide.this.loc).multiply(4.0)), Sound.BLOCK_GRAVEL_BREAK, (float)(this.val$vol * (this.val$soundDistance - d) * LandSlide.this.volume), 0.5f);
                                continue;
                            }
                            LandSlide.this.world.playSound(object.add(Utils.getVectorTowards(object, LandSlide.this.loc).multiply(4.0)), Sound.BLOCK_GRASS_BREAK, (float)(this.val$vol * (this.val$soundDistance - d) * LandSlide.this.volume), 0.5f);
                            continue;
                        }
                        if (LandSlide.this.rand.nextInt(2) == 0) {
                            LandSlide.this.world.playSound(object.add(Utils.getVectorTowards(object, LandSlide.this.loc).multiply(4.0)), Sound.BLOCK_SNOW_BREAK, (float)(this.val$vol * (this.val$soundDistance - d) * LandSlide.this.volume), 0.5f);
                            continue;
                        }
                        LandSlide.this.world.playSound(object.add(Utils.getVectorTowards(object, LandSlide.this.loc).multiply(4.0)), Sound.BLOCK_SAND_BREAK, (float)(this.val$vol * (this.val$soundDistance - d) * LandSlide.this.volume), 0.5f);
                    }
                }
                player2 = LandSlide.this.fallingBlocks.entrySet().iterator();
                while (player2.hasNext()) {
                    Map.Entry<UUID, Integer> entry = player2.next();
                    object = (UUID)entry.getKey();
                    Entity entity = Bukkit.getEntity((UUID)object);
                    if (entity == null || entity.isDead()) {
                        fallingBlock = LandSlide.this.loc.getWorld().spawnFallingBlock((Location)LandSlide.this.fallingBlocksLocations.get(object).getFirst(), (BlockData)LandSlide.this.fallingBlocksLocations.get(object).getSecond());
                        fallingBlock.setHurtEntities(false);
                        fallingBlock.setDropItem(false);
                        fallingBlock.setMetadata("dd-fb", (MetadataValue)new FixedMetadataValue((Plugin)LandSlide.this.plugin, (Object)"protected"));
                        fallingBlock.setVelocity(LandSlide.this.direction.clone().add(new Vector(LandSlide.this.rand.nextDouble() / 4.0 - 0.125, 0.0, LandSlide.this.rand.nextDouble() / 4.0 - 0.125)).multiply(LandSlide.this.rand.nextDouble() / 4.0 + 0.4).setY(0.3));
                        if (!LandSlide.this.shouldBeAvalanche) {
                            if (LandSlide.this.rand.nextInt(2) == 0) {
                                fallingBlock.getWorld().playSound(fallingBlock.getLocation(), Sound.BLOCK_GRAVEL_BREAK, (float)(1.0 * LandSlide.this.volume), 0.5f);
                            } else {
                                fallingBlock.getWorld().playSound(fallingBlock.getLocation(), Sound.BLOCK_GRASS_BREAK, (float)(1.0 * LandSlide.this.volume), 0.5f);
                            }
                        } else if (LandSlide.this.rand.nextInt(2) == 0) {
                            fallingBlock.getWorld().playSound(fallingBlock.getLocation(), Sound.BLOCK_SNOW_BREAK, (float)(1.0 * LandSlide.this.volume), 0.5f);
                        } else {
                            fallingBlock.getWorld().playSound(fallingBlock.getLocation(), Sound.BLOCK_SAND_BREAK, (float)(1.0 * LandSlide.this.volume), 0.5f);
                        }
                        int n3 = (Integer)entry.getValue();
                        if (n3 > 0) {
                            LandSlide.this.fallingBlocks.put(fallingBlock.getUniqueId(), n3 - 1);
                            LandSlide.this.fallingBlocksLocations.put(fallingBlock.getUniqueId(), (Pair<Location, BlockData>)Pair.of((Object)fallingBlock.getLocation(), (Object)fallingBlock.getBlockData()));
                            LandSlide.this.initialSpot.put(fallingBlock.getUniqueId(), LandSlide.this.initialSpot.remove(object));
                            if (LandSlide.this.invBlocks.containsKey(object)) {
                                LandSlide.this.invBlocks.put(fallingBlock.getUniqueId(), LandSlide.this.invBlocks.remove(object));
                            }
                        } else {
                            LandSlide.this.UUIDToFalling.put(fallingBlock.getUniqueId(), LandSlide.this.initialSpot.remove(object));
                            if (LandSlide.this.invBlocks.containsKey(object)) {
                                CoreListener.addBlockInventory((Entity)fallingBlock, LandSlide.this.invBlocks.remove(object));
                            }
                        }
                        LandSlide.this.fallingBlocksLocations.remove(object);
                        player2.remove();
                        continue;
                    }
                    LandSlide.this.fallingBlocksLocations.replace(entity.getUniqueId(), (Pair<Location, BlockData>)Pair.of((Object)entity.getLocation(), (Object)((FallingBlock)entity).getBlockData()));
                    fallingBlock = entity.getVelocity().multiply(0.05).setY(0);
                    blockState = entity.getNearbyEntities(1.8, 1.8, 1.8).iterator();
                    while (blockState.hasNext()) {
                        Entity entity2 = (Entity)blockState.next();
                        if (entity2 instanceof FallingBlock) continue;
                        if (entity2.getVelocity().distanceSquared((Vector)fallingBlock) < 0.28) {
                            entity2.setVelocity(entity2.getVelocity().add((Vector)fallingBlock));
                        }
                        if (!(entity2 instanceof LivingEntity) || ((LivingEntity)entity2).getNoDamageTicks() != 0 || entity2 instanceof Player && Utils.isPlayerImmune((Player)entity2)) continue;
                        Utils.damageEntity((LivingEntity)entity2, LandSlide.this.damage, "dd-" + (LandSlide.this.shouldBeAvalanche ? "avalanche" : "landslide"), false);
                    }
                }
                if (this.val$current[2] > 0) {
                    int n4 = this.val$current[2];
                    this.val$current[2] = n4 + 1;
                    if (n4 > 200 || LandSlide.this.fallingBlocks.isEmpty()) {
                        this.cancel();
                        LandSlide.this.fallingBlocks.forEach((uUID, n) -> {
                            if (Bukkit.getEntity((UUID)uUID) != null) {
                                Bukkit.getEntity((UUID)uUID).remove();
                            }
                        });
                        HandlerList.unregisterAll((Listener)this.val$instance);
                        ongoingDisasters.remove(this.val$instance);
                        DeathMessages.landslides.remove(this.val$instance);
                        LandSlide.this.triggerRegen(true);
                        Metrics.incrementValue(Metrics.disasterDestroyedMap, LandSlide.this.type.getMetricsLabel(), LandSlide.this.blocksDestroyed);
                    }
                    return;
                }
                int n5 = this.val$current[0];
                while (n5 < this.val$current[0] + this.val$ticks) {
                    if (LandSlide.this.fallingBlocks.size() >= LandSlide.this.maxBlocks) {
                        this.val$current[0] = this.val$current[0] + (n5 - this.val$current[0]);
                        return;
                    }
                    if (!LandSlide.this.it.hasNext()) {
                        this.val$current[0] = 0;
                        this.val$current[1] = this.val$current[1] + 1;
                        this.val$spots.clear();
                        this.val$spots.addAll(this.val$next);
                        this.val$next.clear();
                        LandSlide.this.it = this.val$spots.iterator();
                        if (this.val$current[1] < LandSlide.this.depth) break;
                        this.val$current[2] = 1;
                        break;
                    }
                    object = LandSlide.this.it.next();
                    int n6 = 0;
                    while (n6 < (LandSlide.this.rand.nextInt(4) == 0 ? 2 : 1)) {
                        if (LandSlide.this.isPassableOrSnow((Block)object) || Utils.passStrengthTest(object.getType()) || Utils.isZoneProtected(object.getLocation())) break;
                        fallingBlock = object.getBlockData();
                        if (LandSlide.this.materials != null) {
                            fallingBlock = LandSlide.this.materials[LandSlide.this.rand.nextInt(LandSlide.this.materials.length)];
                        }
                        FallingBlock fallingBlock2 = object.getWorld().spawnFallingBlock(object.getLocation().add(0.5, 0.5, 0.5), (BlockData)fallingBlock);
                        if (LandSlide.this.plugin.CProtect) {
                            Utils.getCoreProtect().logRemoval("Deadly-Disasters", object.getLocation(), object.getType(), object.getBlockData());
                        }
                        if ((blockState = object.getState()) instanceof InventoryHolder) {
                            LandSlide.this.invBlocks.put(fallingBlock2.getUniqueId(), ((InventoryHolder)object.getState()).getInventory().getContents());
                        }
                        LandSlide.this.addBlockWithTopToList((Block)object, blockState);
                        object.setType(Material.AIR);
                        ++LandSlide.this.blocksDestroyed;
                        fallingBlock2.setHurtEntities(false);
                        fallingBlock2.setDropItem(false);
                        fallingBlock2.setVelocity(LandSlide.this.direction.clone().add(new Vector(LandSlide.this.rand.nextDouble() / 4.0 - 0.125, 0.0, LandSlide.this.rand.nextDouble() / 4.0 - 0.125)).multiply(LandSlide.this.rand.nextDouble() / 4.0 + 0.25).setY(0.1));
                        fallingBlock2.setMetadata("dd-fb", (MetadataValue)new FixedMetadataValue((Plugin)LandSlide.this.plugin, (Object)"protected"));
                        LandSlide.this.fallingBlocks.put(fallingBlock2.getUniqueId(), LandSlide.this.rand.nextInt(5));
                        LandSlide.this.fallingBlocksLocations.put(fallingBlock2.getUniqueId(), (Pair<Location, BlockData>)Pair.of((Object)fallingBlock2.getLocation(), (Object)fallingBlock2.getBlockData()));
                        LandSlide.this.initialSpot.put(fallingBlock2.getUniqueId(), (Block)object);
                        object = object.getRelative(BlockFace.DOWN);
                        ++n6;
                    }
                    this.val$next.add(object);
                    ++n5;
                }
                this.val$current[0] = this.val$current[0] + this.val$ticks;
            }
        };
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onBlockLand(EntityChangeBlockEvent entityChangeBlockEvent) {
        if (!this.fallingBlocks.containsKey(entityChangeBlockEvent.getEntity().getUniqueId())) {
            return;
        }
        UUID uUID = entityChangeBlockEvent.getEntity().getUniqueId();
        entityChangeBlockEvent.setCancelled(true);
        BlockData blockData = ((FallingBlock)entityChangeBlockEvent.getEntity()).getBlockData();
        if (this.materials != null) {
            blockData = this.materials[this.rand.nextInt(this.materials.length)];
        }
        FallingBlock fallingBlock = entityChangeBlockEvent.getEntity().getWorld().spawnFallingBlock(entityChangeBlockEvent.getEntity().getLocation(), blockData);
        fallingBlock.setHurtEntities(false);
        fallingBlock.setDropItem(false);
        fallingBlock.setMetadata("dd-fb", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)"protected"));
        fallingBlock.setVelocity(this.direction.clone().add(new Vector(this.rand.nextDouble() / 4.0 - 0.125, 0.0, this.rand.nextDouble() / 4.0 - 0.125)).multiply(this.rand.nextDouble() / 4.0 + 0.4).setY(0.3));
        int n = this.fallingBlocks.remove(uUID);
        if (n > 0) {
            this.fallingBlocks.put(fallingBlock.getUniqueId(), n - 1);
            this.fallingBlocksLocations.put(fallingBlock.getUniqueId(), (Pair<Location, BlockData>)Pair.of((Object)fallingBlock.getLocation(), (Object)fallingBlock.getBlockData()));
            this.initialSpot.put(fallingBlock.getUniqueId(), this.initialSpot.remove(uUID));
            if (this.invBlocks.containsKey(uUID)) {
                this.invBlocks.put(fallingBlock.getUniqueId(), this.invBlocks.remove(uUID));
            }
        } else {
            this.UUIDToFalling.put(fallingBlock.getUniqueId(), this.initialSpot.remove(uUID));
            if (this.invBlocks.containsKey(uUID)) {
                CoreListener.addBlockInventory((Entity)fallingBlock, this.invBlocks.remove(uUID));
            }
        }
        this.fallingBlocksLocations.remove(entityChangeBlockEvent.getEntity().getUniqueId());
        entityChangeBlockEvent.getEntity().remove();
        if (!this.shouldBeAvalanche) {
            if (this.rand.nextInt(2) == 0) {
                fallingBlock.getWorld().playSound(fallingBlock.getLocation(), Sound.BLOCK_GRAVEL_BREAK, (float)(1.0 * this.volume), 0.5f);
            } else {
                fallingBlock.getWorld().playSound(fallingBlock.getLocation(), Sound.BLOCK_GRASS_BREAK, (float)(1.0 * this.volume), 0.5f);
            }
        } else if (this.rand.nextInt(2) == 0) {
            fallingBlock.getWorld().playSound(fallingBlock.getLocation(), Sound.BLOCK_SNOW_BREAK, (float)(1.0 * this.volume), 0.5f);
        } else {
            fallingBlock.getWorld().playSound(fallingBlock.getLocation(), Sound.BLOCK_SAND_BREAK, (float)(1.0 * this.volume), 0.5f);
        }
    }

    @Override
    public Location findApplicableLocation(Location location, Player player) {
        int n = 0;
        while (n < 5) {
            Location location2 = location.clone().add(0.0, (double)(this.rand.nextInt(this.level * 4) + 10), 0.0);
            if (location2.getBlock().getType() == Material.AIR && !(location2.getY() < (double)this.type.getMinHeight())) {
                int n2 = 0;
                while (n2 < 10) {
                    Vector vector = new Vector(this.rand.nextDouble() - 0.5, (this.rand.nextDouble() - 0.8) / 2.0, this.rand.nextDouble() - 0.5).normalize().multiply(0.8);
                    Location location3 = location2.clone().add(vector);
                    int n3 = 0;
                    while (n3 < 30) {
                        if (!this.isPassableOrSnow(location3.getBlock()) && !Tag.LEAVES.isTagged((Keyed)location3.getBlock().getType())) {
                            if (location3.getBlockY() <= location.getBlockY() + 5 || !this.allowedBlocks.contains(location3.getBlock().getType())) break;
                            int n4 = 0;
                            int n5 = 0;
                            int n6 = 0;
                            block3: while (n6 < 30) {
                                Vector vector2 = new Vector(vector.getX() + (this.rand.nextDouble() - 0.5), vector.getY() + (this.rand.nextDouble() - 0.5) / 2.0, vector.getZ() + (this.rand.nextDouble() - 0.5)).normalize().multiply(0.8);
                                Location location4 = location2.clone().add(vector2);
                                int n7 = 0;
                                while (n7 < n3 + 6) {
                                    if (!this.isPassableOrSnow(location4.getBlock()) && !Tag.LEAVES.isTagged((Keyed)location4.getBlock().getType())) {
                                        if (!this.allowedBlocks.contains(location4.getBlock().getType()) || n7 < n3 - 6) break;
                                        ++n4;
                                        if (location4.getBlock().getType() == Material.SNOW_BLOCK || this.plugin.mcVersion >= 1.17 && location4.getBlock().getType() == Material.POWDER_SNOW) {
                                            ++n5;
                                        }
                                        if (n4 < 20) break;
                                        if (n5 >= 10 && location4.getBlock().getTemperature() < 0.15) {
                                            this.shouldBeAvalanche = true;
                                            break block3;
                                        }
                                        this.shouldBeAvalanche = false;
                                        break block3;
                                    }
                                    location4.add(vector2);
                                    ++n7;
                                }
                                ++n6;
                            }
                            if (n4 < 20) break;
                            return location3;
                        }
                        location3.add(vector);
                        ++n3;
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return null;
    }

    public Location findApplicableLocationDebug(Location location, Player player) {
        final ArrayDeque arrayDeque = new ArrayDeque();
        final ArrayDeque<Location> arrayDeque2 = new ArrayDeque<Location>();
        final ArrayDeque<Location> arrayDeque3 = new ArrayDeque<Location>();
        final Location[] locationArray = new Location[1];
        new RepeatingTask(this.plugin, 0, 1){

            @Override
            public void run() {
                arrayDeque.forEach(location -> location.getWorld().spawnParticle(Particle.SOUL_FIRE_FLAME, location, 1, 0.0, 0.0, 0.0, 1.0E-5, null));
                arrayDeque3.forEach(location -> location.getWorld().spawnParticle(Particle.FLAME, location, 1, 0.0, 0.0, 0.0, 1.0E-5, null));
                arrayDeque2.forEach(location -> location.getWorld().spawnParticle(Particle.CRIT, location, 1, 0.0, 0.0, 0.0, 1.0E-5, null));
                if (locationArray[0] != null && locationArray[0].getBlock().isPassable()) {
                    this.cancel();
                }
            }
        };
        int n = 0;
        while (n < 5) {
            Location location2 = location.clone().add(0.0, (double)(this.rand.nextInt(this.level * 4) + 10), 0.0);
            if (location2.getBlock().getType() == Material.AIR && !(location2.getY() < (double)this.type.getMinHeight())) {
                location2.getBlock().setType(Material.GOLD_BLOCK);
                locationArray[0] = location2;
                int n2 = 0;
                while (n2 < 10) {
                    Vector vector = new Vector(this.rand.nextDouble() - 0.5, (this.rand.nextDouble() - 0.8) / 2.0, this.rand.nextDouble() - 0.5).normalize().multiply(0.8);
                    Location location3 = location2.clone().add(vector);
                    int n3 = 0;
                    while (n3 < 30) {
                        arrayDeque2.add(location3.clone());
                        if (!this.isPassableOrSnow(location3.getBlock()) && !Tag.LEAVES.isTagged((Keyed)location3.getBlock().getType())) {
                            if (location3.getBlockY() <= location.getBlockY() + 5 || !this.allowedBlocks.contains(location3.getBlock().getType())) {
                                arrayDeque.addAll(arrayDeque2);
                                arrayDeque2.clear();
                                break;
                            }
                            int n4 = 0;
                            int n5 = 0;
                            int n6 = 0;
                            block3: while (n6 < 30) {
                                Vector vector2 = new Vector(vector.getX() + (this.rand.nextDouble() - 0.5), vector.getY() + (this.rand.nextDouble() - 0.5) / 2.0, vector.getZ() + (this.rand.nextDouble() - 0.5)).normalize().multiply(0.8);
                                Location location4 = location2.clone().add(vector2);
                                int n7 = 0;
                                while (n7 < n3 + 6) {
                                    arrayDeque3.add(location4.clone());
                                    if (location4.getBlock().getType() == Material.GOLD_BLOCK) {
                                        location4.add(vector2);
                                    } else {
                                        if (!this.isPassableOrSnow(location4.getBlock()) && !Tag.LEAVES.isTagged((Keyed)location4.getBlock().getType())) {
                                            if (!this.allowedBlocks.contains(location4.getBlock().getType()) || n7 < n3 - 6) break;
                                            ++n4;
                                            if (location4.getBlock().getType() == Material.SNOW_BLOCK || this.plugin.mcVersion >= 1.17 && location4.getBlock().getType() == Material.POWDER_SNOW) {
                                                ++n5;
                                            }
                                            if (n4 < 20) break;
                                            if (n5 >= 10 && location4.getBlock().getTemperature() < 0.15) {
                                                this.shouldBeAvalanche = true;
                                                break block3;
                                            }
                                            this.shouldBeAvalanche = false;
                                            break block3;
                                        }
                                        location4.add(vector2);
                                    }
                                    ++n7;
                                }
                                ++n6;
                            }
                            Bukkit.broadcastMessage((String)(String.valueOf(location2.getBlockY()) + " " + n4));
                            if (n4 >= 20) {
                                location3.getBlock().setType(Material.DIAMOND_BLOCK);
                                return location3;
                            }
                            arrayDeque.addAll(arrayDeque2);
                            arrayDeque2.clear();
                            break;
                        }
                        location3.add(vector);
                        ++n3;
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return null;
    }

    @Override
    public void broadcastMessage(Location location, Player player) {
        if (((Boolean)WorldObject.findWorldObject((World)location.getWorld()).settings.get("event_broadcast")).booleanValue()) {
            String string = this.configFile.getString("messages.destructive.level " + this.level);
            string = string.replace("%location%", String.valueOf(location.getBlockX()) + " " + location.getBlockY() + " " + location.getBlockZ());
            string = player != null ? string.replace("%player%", player.getName()) : string.replace("%player%", "");
            string = !this.shouldBeAvalanche ? string.replace("%disaster%", this.type.getLabel().substring(0, this.type.getLabel().indexOf(47))) : string.replace("%disaster%", this.type.getLabel().substring(this.type.getLabel().indexOf(47) + 1));
            string = ChatColor.translateAlternateColorCodes((char)'&', (String)string);
            if (this.configFile.getBoolean("messages.disaster_tips")) {
                string = String.valueOf(string) + "\n" + this.type.getTip();
            }
            for (Player player2 : location.getWorld().getPlayers()) {
                player2.sendMessage(string);
            }
            Main.consoleSender.sendMessage(String.valueOf(Languages.prefix) + string + ChatColor.GREEN + " (" + location.getWorld().getName() + ")");
        }
    }

    @Override
    public void startAdjustment(Location location, Player player) {
        this.start(location, player);
    }

    private boolean isPassableOrSnow(Block block) {
        return !(!block.isPassable() || this.plugin.mcVersion >= 1.17 && block.getType() == Material.POWDER_SNOW);
    }

    public BlockData[] getMaterials() {
        return this.materials;
    }

    public void setMaterials(Material[] materialArray) {
        this.materials = new BlockData[materialArray.length];
        int n = 0;
        while (n < materialArray.length) {
            this.materials[n] = materialArray[n].createBlockData();
            ++n;
        }
    }
}

