/*
 * Decompiled with CFR 0.152.
 */
package deadlydisasters.events.disasters;

import deadlydisasters.entities.CustomEntityType;
import deadlydisasters.entities.solarstormentities.FirePhantom;
import deadlydisasters.events.Disaster;
import deadlydisasters.events.WeatherDisaster;
import deadlydisasters.events.WeatherDisasterEvent;
import deadlydisasters.handlers.WorldObject;
import deadlydisasters.listeners.CoreListener;
import deadlydisasters.listeners.DeathMessages;
import deadlydisasters.utils.Metrics;
import deadlydisasters.utils.RepeatingTask;
import deadlydisasters.utils.Utils;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class SolarStorm
extends WeatherDisaster {
    private boolean changeTime;
    private boolean spawnMobs = true;
    private long timeMemory;
    private double fireCatch;
    private double fireSpawn;
    private float fireballSize;
    private Material fireMaterial = Material.FIRE;
    public int blocksDestroyed;
    private Queue<UUID> fallingBlocks = new ArrayDeque<UUID>();
    private Set<UUID> entities = new HashSet<UUID>();
    private Map<UUID, UUID> targets = new HashMap<UUID, UUID>();

    public SolarStorm(int n) {
        super(n);
        this.time = this.configFile.getInt("solarstorm.time.level " + this.level) * 20;
        this.delay = this.configFile.getInt("solarstorm.start_delay") * 20;
        this.volume = this.configFile.getDouble("solarstorm.volume");
        this.changeTime = this.configFile.getBoolean("solarstorm.set_sunset");
        this.fireCatch = this.configFile.getDouble("solarstorm.fire_catch_chance");
        this.fireSpawn = this.configFile.getDouble("solarstorm.fire_spawn_rate");
        this.fireballSize = (float)this.configFile.getDouble("solarstorm.fireball_explosion_size");
        this.type = Disaster.SOLARSTORM;
    }

    @Override
    public void start(final World world, Player player, boolean bl) {
        WeatherDisasterEvent weatherDisasterEvent = new WeatherDisasterEvent(this, world, this.level, player);
        Bukkit.getPluginManager().callEvent((Event)weatherDisasterEvent);
        if (weatherDisasterEvent.isCancelled()) {
            return;
        }
        this.world = world;
        this.updateWeatherSettings();
        ongoingDisasters.add(this);
        if (bl && ((Boolean)WorldObject.findWorldObject((World)world).settings.get("event_broadcast")).booleanValue()) {
            Utils.broadcastEvent(this.level, "weather", this.type, world);
        }
        DeathMessages.solarstorms.add(this);
        final Random random = this.plugin.random;
        final int n = (int)(15.0 * this.fireSpawn);
        final BlockData blockData = this.fireMaterial.createBlockData();
        final FixedMetadataValue fixedMetadataValue = new FixedMetadataValue((Plugin)this.plugin, (Object)"protected");
        final SolarStorm solarStorm = this;
        final int[] nArray = new int[1];
        new RepeatingTask(this.plugin, this.delay, 20){

            @Override
            public void run() {
                Vector vector = new Vector(0.6, -2.0, 0.6);
                for (UUID object : SolarStorm.this.fallingBlocks) {
                    if (Bukkit.getEntity((UUID)object) == null) continue;
                    Bukkit.getEntity((UUID)object).setVelocity(vector);
                }
                if (SolarStorm.this.time > 0) {
                    SolarStorm solarStorm2 = SolarStorm.this;
                    solarStorm2.time = solarStorm2.time - 20;
                    nArray[0] = nArray[0] + 1;
                    if (world.hasStorm()) {
                        world.setStorm(false);
                    }
                    for (LivingEntity livingEntity : world.getLivingEntities()) {
                        FallingBlock fallingBlock;
                        if (SolarStorm.this.entities.contains(livingEntity.getUniqueId()) && ((Mob)livingEntity).getTarget() == null && Bukkit.getEntity((UUID)SolarStorm.this.targets.get(livingEntity.getUniqueId())) != null) {
                            ((Mob)livingEntity).setTarget((LivingEntity)Bukkit.getEntity((UUID)SolarStorm.this.targets.get(livingEntity.getUniqueId())));
                        }
                        if (Utils.isWeatherDisabled(livingEntity.getLocation(), solarStorm)) continue;
                        if (livingEntity.getFireTicks() > 0) {
                            livingEntity.setFireTicks(livingEntity.getFireTicks() + 10);
                        }
                        if (livingEntity.getLocation().getBlockY() > 55 && livingEntity.getLocation().getBlock().getLightFromBlocks() >= 11 && random.nextDouble() * 100.0 < SolarStorm.this.fireCatch) {
                            livingEntity.setFireTicks(100);
                        }
                        if (!(livingEntity instanceof Player) || Utils.isPlayerImmune((Player)livingEntity)) continue;
                        int n2 = 0;
                        while (n2 < n) {
                            fallingBlock = world.spawnFallingBlock(new Location(world, (double)(livingEntity.getLocation().getBlockX() + (random.nextInt(100) - 90)), (double)Math.max(livingEntity.getLocation().getBlockY() + 70, 210), (double)(livingEntity.getLocation().getBlockZ() + (random.nextInt(100) - 90))), blockData);
                            fallingBlock.setGravity(false);
                            fallingBlock.setMetadata("dd-fb", (MetadataValue)fixedMetadataValue);
                            CoreListener.fallingBlocks.put(fallingBlock.getUniqueId(), solarStorm);
                            SolarStorm.this.fallingBlocks.add(fallingBlock.getUniqueId());
                            ++n2;
                        }
                        Fireball fireball = (Fireball)world.spawnEntity(new Location(world, (double)(livingEntity.getLocation().getBlockX() + (random.nextInt(100) - 90)), (double)Math.max(livingEntity.getLocation().getBlockY() + 50, 210), (double)(livingEntity.getLocation().getBlockZ() + (random.nextInt(100) - 90))), EntityType.FIREBALL);
                        fireball.setDirection(new Vector(0.8, -3.0, 0.8));
                        fireball.setYield(SolarStorm.this.fireballSize);
                        CoreListener.fireBalls.put(fireball, solarStorm);
                        if (!SolarStorm.this.spawnMobs || nArray[0] < 7 || livingEntity.getLocation().getBlockY() < 60 || !CustomEntityType.FIREPHANTOM.canSpawn() || random.nextInt(3) != 0) continue;
                        fallingBlock = livingEntity.getLocation().clone().add((double)(random.nextInt(40) - 20), 20.0, (double)(random.nextInt(40) - 20));
                        if (!fallingBlock.getBlock().isPassable()) {
                            fallingBlock = Utils.getBlockAbove((Location)fallingBlock).getLocation();
                        }
                        Mob mob = (Mob)world.spawnEntity((Location)fallingBlock, EntityType.PHANTOM);
                        SolarStorm.this.plugin.handler.addEntity(new FirePhantom(mob, SolarStorm.this.plugin, random));
                        mob.setTarget(livingEntity);
                        SolarStorm.this.entities.add(mob.getUniqueId());
                        SolarStorm.this.targets.put(mob.getUniqueId(), livingEntity.getUniqueId());
                        mob.setMetadata("dd-solarstormmob", (MetadataValue)fixedMetadataValue);
                    }
                    if (nArray[0] >= 7) {
                        nArray[0] = 0;
                    }
                } else {
                    if (!SolarStorm.this.fallingBlocks.isEmpty()) {
                        Iterator iterator = SolarStorm.this.fallingBlocks.iterator();
                        while (iterator.hasNext()) {
                            Entity entity = Bukkit.getEntity((UUID)((UUID)iterator.next()));
                            if (entity != null && !entity.isDead()) continue;
                            iterator.remove();
                        }
                        return;
                    }
                    SolarStorm.this.clear();
                    this.cancel();
                    ongoingDisasters.remove(solarStorm);
                    SolarStorm.this.triggerRegen(true);
                    Metrics.incrementValue(Metrics.disasterDestroyedMap, SolarStorm.this.type.getMetricsLabel(), SolarStorm.this.blocksDestroyed);
                }
            }
        };
        if (this.changeTime) {
            this.timeMemory = world.getTime();
            new RepeatingTask(this.plugin, this.delay, 1){

                @Override
                public void run() {
                    long l = world.getTime();
                    if (SolarStorm.this.time <= 0) {
                        if (l < SolarStorm.this.timeMemory - 300L || l > SolarStorm.this.timeMemory + 300L) {
                            if (l > SolarStorm.this.timeMemory - 8000L && l < SolarStorm.this.timeMemory + 300L) {
                                world.setTime(l + 200L);
                            } else {
                                world.setTime(l - 200L);
                            }
                            if (DeathMessages.solarstorms.stream().anyMatch(solarStorm -> solarStorm.getWorld().equals(world))) {
                                this.cancel();
                            }
                            return;
                        }
                        this.cancel();
                        return;
                    }
                    if (l < 12700L || l > 13300L) {
                        if (l > 8000L && l < 13300L) {
                            world.setTime(l + 200L);
                        } else {
                            world.setTime(l - 200L);
                        }
                    }
                }
            };
        }
    }

    @Override
    public void clear() {
        this.time = 0;
        this.clearEntities();
        DeathMessages.solarstorms.remove(this);
        Iterator iterator = this.fallingBlocks.iterator();
        while (iterator.hasNext()) {
            Entity entity = Bukkit.getEntity((UUID)((UUID)iterator.next()));
            if (entity == null) continue;
            entity.remove();
        }
    }

    public void clearEntities() {
        for (UUID uUID : this.entities) {
            if (Bukkit.getEntity((UUID)uUID) == null) continue;
            Bukkit.getEntity((UUID)uUID).remove();
        }
    }

    public boolean isChangeTime() {
        return this.changeTime;
    }

    public void setChangeTime(boolean bl) {
        this.changeTime = bl;
    }

    public boolean isSpawnMobs() {
        return this.spawnMobs;
    }

    public void setSpawnMobs(boolean bl) {
        this.spawnMobs = bl;
    }

    public double getFireCatch() {
        return this.fireCatch;
    }

    public void setFireCatch(double d) {
        this.fireCatch = d;
    }

    public float getFireballSize() {
        return this.fireballSize;
    }

    public void setFireballSize(float f) {
        this.fireballSize = f;
    }

    public Material getFireMaterial() {
        return this.fireMaterial;
    }

    public void setFireMaterial(Material material) {
        this.fireMaterial = material;
    }

    public double getFireSpawn() {
        return this.fireSpawn;
    }

    public void setFireSpawn(double d) {
        this.fireSpawn = d;
    }
}

