/*
 * Decompiled with CFR 0.152.
 */
package deadlydisasters.handlers;

import deadlydisasters.Main;
import deadlydisasters.events.Disaster;
import deadlydisasters.handlers.Languages;
import deadlydisasters.utils.ConfigUpdater;
import deadlydisasters.utils.Utils;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.casperge.realisticseasons.api.SeasonsAPI;
import me.casperge.realisticseasons.season.Season;
import org.apache.commons.io.FileUtils;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class SeasonsHandler {
    public boolean isActive;
    public int blizzTemp;
    private static SeasonsAPI SeasonsAPI;
    private Main plugin;
    private FileConfiguration seasonFile;
    public Map<Disaster, Set<Season>> seasonMap = new HashMap<Disaster, Set<Season>>();

    public SeasonsHandler(Main main) {
        if (main.getServer().getPluginManager().getPlugin("RealisticSeasons") == null) {
            return;
        }
        this.plugin = main;
        main.getLogger().info("Successfully hooked into RealisticSeasons");
        if (!new File(main.getDataFolder().getAbsolutePath(), "seasons.yml").exists()) {
            this.createFile();
        }
        this.seasonFile = YamlConfiguration.loadConfiguration((File)new File(main.getDataFolder().getAbsolutePath(), "seasons.yml"));
        if (!this.seasonFile.getBoolean("general.enabled")) {
            main.getLogger().info("RealisticSeasons is detected but this feature is disabled in the seasons.yml file!");
            return;
        }
        this.isActive = true;
        main.getServer().getScheduler().runTaskLater((Plugin)main, new Runnable(){

            @Override
            public void run() {
                SeasonsAPI = me.casperge.realisticseasons.api.SeasonsAPI.getInstance();
                SeasonsHandler.this.readMapValues();
                SeasonsHandler.this.blizzTemp = SeasonsHandler.this.seasonFile.getInt("general.min_blizzard_temperature");
            }
        }, 10L);
    }

    private void createFile() {
        this.plugin.getLogger().info("Could not find seasons file in plugin directory! Creating new seasons file...");
        try {
            FileUtils.copyInputStreamToFile(this.plugin.getResource("files/seasons.yml"), new File(this.plugin.getDataFolder().getAbsolutePath(), "seasons.yml"));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void updateSeasonsFile() {
        try {
            ConfigUpdater.update((Plugin)this.plugin, this.plugin.getResource("files/seasons.yml"), new File(this.plugin.getDataFolder().getAbsolutePath(), "seasons.yml"), Arrays.asList(""));
            this.saveSeasonsFile(this.plugin);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void readMapValues() {
        Disaster[] disasterArray = Disaster.values();
        int n = disasterArray.length;
        int n2 = 0;
        while (n2 < n) {
            block6: {
                Disaster disaster = disasterArray[n2];
                if (disaster != Disaster.SOULSTORM && disaster != Disaster.ENDSTORM && disaster != Disaster.CUSTOM) {
                    List list = this.seasonFile.getStringList("disasters." + disaster.name());
                    HashSet<Season> hashSet = new HashSet<Season>();
                    if (list.contains("ALL")) {
                        hashSet.addAll(Arrays.asList(Season.SPRING, Season.SUMMER, Season.FALL, Season.WINTER));
                    } else {
                        for (String string : list) {
                            if (!(string.equals("SPRING") || string.equals("SUMMER") || string.equals("FALL") || string.equals("WINTER"))) {
                                Main.consoleSender.sendMessage(Utils.chat(String.valueOf(Languages.prefix) + "&cSeason &6'" + string + "' &cdoes not exist! Something won't work right until you fix this line in seasons.yml:\n" + "disasters\n  -> " + disaster.name() + ": " + Arrays.toString(list.toArray())));
                                hashSet.clear();
                                hashSet.addAll(Arrays.asList(Season.SPRING, Season.SUMMER, Season.FALL, Season.WINTER));
                                this.seasonMap.put(disaster, hashSet);
                                break block6;
                            }
                            hashSet.add(Season.valueOf((String)string));
                        }
                    }
                    this.seasonMap.put(disaster, hashSet);
                }
            }
            ++n2;
        }
    }

    public void saveSeasonsFile(Main main) {
        try {
            this.seasonFile.save(new File(main.getDataFolder().getAbsolutePath(), "seasons.yml"));
        }
        catch (IOException iOException) {
            Main.consoleSender.sendMessage(Utils.chat("&c[DeadlyDisasters]: Error unable to save seasons file!"));
        }
    }

    public void reload(Main main) {
        this.seasonFile = YamlConfiguration.loadConfiguration((File)new File(main.getDataFolder().getAbsolutePath(), "seasons.yml"));
        this.seasonMap.clear();
        this.readMapValues();
    }

    public static SeasonsAPI getSeasonsAPI() {
        return SeasonsAPI;
    }
}

