/*
 * Decompiled with CFR 0.152.
 */
package deadlydisasters.listeners;

import deadlydisasters.Main;
import deadlydisasters.entities.AnimatedEntity;
import deadlydisasters.entities.CustomEntity;
import deadlydisasters.entities.CustomEntityType;
import deadlydisasters.entities.christmasentities.ElfPet;
import deadlydisasters.entities.endstormentities.BabyEndTotem;
import deadlydisasters.entities.endstormentities.EndWorm;
import deadlydisasters.entities.halloweenentities.PumpkinKing;
import deadlydisasters.entities.halloweenentities.Vampire;
import deadlydisasters.entities.purgeentities.DarkMage;
import deadlydisasters.entities.soulstormentities.SoulReaper;
import deadlydisasters.events.Disaster;
import deadlydisasters.events.disasters.BlackPlague;
import deadlydisasters.events.disasters.EndStorm;
import deadlydisasters.handlers.ItemsHandler;
import deadlydisasters.handlers.Languages;
import deadlydisasters.listeners.CustomEnchantHandler;
import deadlydisasters.utils.Metrics;
import deadlydisasters.utils.Utils;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.ShulkerBullet;
import org.bukkit.entity.Snowman;
import org.bukkit.entity.Wolf;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;

public class CustomEntitiesListener
implements Listener {
    private Main plugin;

    public CustomEntitiesListener(Main main) {
        this.plugin = main;
        main.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)main);
    }

    @EventHandler
    public void onAttack(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        CustomEntity customEntity;
        LivingEntity livingEntity;
        Entity entity;
        block45: {
            block47: {
                block46: {
                    if (entityDamageByEntityEvent.isCancelled()) {
                        return;
                    }
                    Entity entity2 = entityDamageByEntityEvent.getDamager();
                    entity = entityDamageByEntityEvent.getEntity();
                    if (entity2 instanceof Arrow && entity2.hasMetadata("dd-voidarrow")) {
                        if (!Utils.isZoneProtected(entity2.getLocation()) || this.plugin.getConfig().getBoolean("customitems.items.void_wrath.allow_in_regions")) {
                            EndStorm.createUnstableRift(entity2.getLocation(), ItemsHandler.voidBowPortalTicks, ((Arrow)entity2).getShooter());
                        }
                        entity2.remove();
                        return;
                    }
                    if (entity2 instanceof Projectile && entity.hasMetadata("dd-frosty")) {
                        entityDamageByEntityEvent.setCancelled(true);
                        return;
                    }
                    if (entity instanceof Player && entity2.hasMetadata("dd-endworm") && ((Player)entity).getHealth() <= entityDamageByEntityEvent.getFinalDamage()) {
                        entity.setMetadata("dd-endwormfangs", (MetadataValue)this.plugin.fixedData);
                        return;
                    }
                    if (entity2 instanceof ShulkerBullet && entity2.hasMetadata("dd-magebullet") && entity instanceof LivingEntity) {
                        livingEntity = (LivingEntity)entity;
                        livingEntity.setVelocity(entity2.getVelocity().multiply(3).setY(1));
                        livingEntity.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, 60, 0, true));
                        livingEntity.removePotionEffect(PotionEffectType.LEVITATION);
                        this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, new Runnable(){

                            @Override
                            public void run() {
                                livingEntity.removePotionEffect(PotionEffectType.LEVITATION);
                            }
                        }, 1L);
                    }
                    if (entity2.hasMetadata("dd-pumpkinkingbloodfang")) {
                        entityDamageByEntityEvent.setCancelled(true);
                        Utils.damageEntity((LivingEntity)entity, 20.0, "dd-pumpkinkingblooddeath", false);
                    }
                    if (!(entity2 instanceof LivingEntity)) {
                        return;
                    }
                    livingEntity = (LivingEntity)entity2;
                    if (entity.hasMetadata("dd-plague") && !entity2.hasMetadata("dd-plague") && BlackPlague.time.size() < BlackPlague.maxInfectedMobs) {
                        if (livingEntity instanceof Player) {
                            if (!Utils.isPlayerImmune((Player)livingEntity)) {
                                livingEntity.sendMessage(Utils.chat("&c" + Languages.getString("misc.plagueCatch")));
                                BlackPlague.time.put(livingEntity.getUniqueId(), 300);
                                livingEntity.setMetadata("dd-plague", (MetadataValue)this.plugin.fixedData);
                            }
                        } else {
                            BlackPlague.time.put(livingEntity.getUniqueId(), 300);
                            livingEntity.setMetadata("dd-plague", (MetadataValue)this.plugin.fixedData);
                        }
                    }
                    if (!livingEntity.hasMetadata("dd-customentity")) break block45;
                    customEntity = this.plugin.handler.findEntity(livingEntity);
                    if (customEntity instanceof AnimatedEntity) {
                        ((AnimatedEntity)customEntity).attack();
                    }
                    if (!livingEntity.hasMetadata("dd-endtotem")) break block46;
                    Location location = entity.getLocation();
                    entity.teleport(location.add(0.0, 0.15, 0.0));
                    if (this.plugin.mcVersion >= 1.16) {
                        entity.setVelocity(new Vector(location.getX() - livingEntity.getLocation().getX(), 0.1, location.getZ() - livingEntity.getLocation().getZ()).normalize().multiply(livingEntity.getAttribute(Attribute.GENERIC_ATTACK_KNOCKBACK).getBaseValue()));
                    }
                    if (livingEntity instanceof Enderman) {
                        livingEntity.getWorld().playSound(livingEntity.getLocation(), Sound.ENTITY_EVOKER_PREPARE_ATTACK, SoundCategory.HOSTILE, 1.0f, 2.0f);
                    } else {
                        livingEntity.getWorld().playSound(livingEntity.getLocation(), Sound.ENTITY_EVOKER_PREPARE_ATTACK, SoundCategory.HOSTILE, 0.3f, 2.0f);
                    }
                    if (livingEntity.hasMetadata("dd-animation")) break block47;
                    livingEntity.setMetadata("dd-animation", (MetadataValue)this.plugin.fixedData);
                    break block47;
                }
                if (livingEntity.hasMetadata("dd-voidguardian")) {
                    entityDamageByEntityEvent.setDamage(Math.max(18.0 - livingEntity.getHealth() / 4.0, 4.0));
                } else if (livingEntity.hasMetadata("dd-voidstalker") && entity instanceof LivingEntity) {
                    ((LivingEntity)entity).addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, 60, 0, true));
                } else if (livingEntity.hasMetadata("dd-ancientmummy") && entity instanceof LivingEntity) {
                    ((LivingEntity)entity).addPotionEffect(new PotionEffect(PotionEffectType.WEAKNESS, 60, 4, true));
                } else if (livingEntity.hasMetadata("dd-endworm")) {
                    ((EndWorm)this.plugin.handler.findEntity(livingEntity)).triggerAnimation();
                } else if (livingEntity.hasMetadata("dd-petelf") && ((ElfPet)this.plugin.handler.findEntity((LivingEntity)livingEntity)).owner.equals(entity.getUniqueId())) {
                    entityDamageByEntityEvent.setCancelled(true);
                } else if (livingEntity.hasMetadata("dd-vampire")) {
                    for (CustomEntity customEntity2 : this.plugin.handler.getList()) {
                        if (customEntity2.getType() != CustomEntityType.VAMPIRE || !((Vampire)customEntity2).zombieUUID.equals(livingEntity.getUniqueId())) continue;
                        ((Vampire)customEntity2).bite(entity);
                        break;
                    }
                }
            }
            if (entity instanceof Player && entityDamageByEntityEvent.getFinalDamage() >= ((LivingEntity)entity).getHealth()) {
                if (livingEntity.hasMetadata("dd-sandstormmob")) {
                    entity.setMetadata("dd-sandstormdeath", (MetadataValue)this.plugin.fixedData);
                } else if (livingEntity.hasMetadata("dd-solarstormmob")) {
                    Metrics.incrementValue(Metrics.disasterKillMap, Disaster.SOLARSTORM.getMetricsLabel());
                } else if (livingEntity.hasMetadata("dd-monsoonmob")) {
                    Metrics.incrementValue(Metrics.disasterKillMap, Disaster.MONSOON.getMetricsLabel());
                } else if (livingEntity.hasMetadata("dd-purgemob")) {
                    entity.setMetadata("dd-purgedeath", (MetadataValue)this.plugin.fixedData);
                } else if (livingEntity.hasMetadata("dd-lostsoul")) {
                    livingEntity.getWorld().playSound(livingEntity.getLocation(), Sound.ENTITY_VEX_CHARGE, SoundCategory.HOSTILE, 2.0f, 0.5f);
                    livingEntity.remove();
                    entity.setMetadata("dd-lostsouldeath", (MetadataValue)this.plugin.fixedData);
                }
            }
        }
        if (entity.hasMetadata("dd-customentity")) {
            if (entity.hasMetadata("dd-darkmage") && !entity.isDead()) {
                customEntity = (LivingEntity)entity;
                if (customEntity.getHealth() < 12.0 && entityDamageByEntityEvent.getFinalDamage() < customEntity.getHealth()) {
                    ((DarkMage)this.plugin.handler.findEntity((LivingEntity)customEntity)).reboundTarget = livingEntity;
                }
            } else if (entity.hasMetadata("dd-soulreaper") && !entity.isDead()) {
                ((SoulReaper)this.plugin.handler.findEntity((LivingEntity)((LivingEntity)entity))).target = livingEntity;
            } else if (entity.hasMetadata("dd-pumpkinking") && !entity.isDead()) {
                ((PumpkinKing)this.plugin.handler.findEntity((LivingEntity)((LivingEntity)entity))).damageTicks += 3;
            }
        }
    }

    @EventHandler
    public void onDamage(EntityDamageEvent entityDamageEvent) {
        if (entityDamageEvent.isCancelled()) {
            return;
        }
        if (entityDamageEvent.getEntity().hasMetadata("dd-invulnerable")) {
            entityDamageEvent.setCancelled(true);
            return;
        }
        if (!entityDamageEvent.getEntity().hasMetadata("dd-customentity")) {
            return;
        }
        Entity entity = entityDamageEvent.getEntity();
        if (entity.hasMetadata("dd-soulreaper") && entityDamageEvent.getCause() != EntityDamageEvent.DamageCause.ENTITY_ATTACK) {
            entityDamageEvent.setCancelled(true);
        } else if (entity.hasMetadata("dd-firephantom") && (entityDamageEvent.getCause() == EntityDamageEvent.DamageCause.FIRE_TICK || entityDamageEvent.getCause() == EntityDamageEvent.DamageCause.FIRE)) {
            entityDamageEvent.setCancelled(true);
        } else if (entityDamageEvent.getCause() == EntityDamageEvent.DamageCause.FALL && (entity.hasMetadata("dd-infesteddevourer") || entity.hasMetadata("dd-eastermobs"))) {
            entityDamageEvent.setCancelled(true);
        } else if (entityDamageEvent.getCause() == EntityDamageEvent.DamageCause.ENTITY_EXPLOSION && entity.hasMetadata("dd-easterbunny")) {
            entityDamageEvent.setCancelled(true);
        } else if (entityDamageEvent.getCause() == EntityDamageEvent.DamageCause.SUFFOCATION && entity.hasMetadata("dd-killerchickenghost")) {
            entityDamageEvent.setCancelled(true);
        } else if (entityDamageEvent.getCause() == EntityDamageEvent.DamageCause.FALL && entity.hasMetadata("dd-vampire")) {
            entityDamageEvent.setCancelled(true);
        }
    }

    @EventHandler
    public void onDeath(EntityDeathEvent entityDeathEvent) {
        if (entityDeathEvent.getEntity().hasMetadata("dd-customentity")) {
            for (ItemStack itemStack : entityDeathEvent.getDrops()) {
                itemStack.setType(Material.AIR);
            }
        }
    }

    @EventHandler
    public void onEntityInteract(PlayerInteractEntityEvent playerInteractEntityEvent) {
        if (!playerInteractEntityEvent.getRightClicked().hasMetadata("dd-customentity")) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)playerInteractEntityEvent.getRightClicked();
        if (livingEntity.hasMetadata("dd-endtotem") && livingEntity instanceof Wolf) {
            ItemStack itemStack = null;
            itemStack = this.plugin.mcVersion >= 1.16 ? playerInteractEntityEvent.getPlayer().getInventory().getItem(playerInteractEntityEvent.getHand()) : playerInteractEntityEvent.getPlayer().getInventory().getItemInMainHand();
            if (itemStack.getType() == Material.AIR) {
                return;
            }
            if (itemStack.getType() == Material.CHORUS_FRUIT && livingEntity.getHealth() < livingEntity.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue()) {
                if (playerInteractEntityEvent.getPlayer().getGameMode() != GameMode.CREATIVE) {
                    itemStack.setAmount(itemStack.getAmount() - 1);
                }
                livingEntity.setHealth(Math.min(livingEntity.getHealth() + 4.0, livingEntity.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue()));
                livingEntity.getWorld().spawnParticle(Particle.COMPOSTER, livingEntity.getLocation().clone().add(0.0, 0.5, 0.0), 12, 0.25, 0.25, 0.25, 0.01);
            } else if (itemStack.getType() == Material.GHAST_TEAR && ((Wolf)livingEntity).getOwner() == null) {
                if (playerInteractEntityEvent.getPlayer().getGameMode() != GameMode.CREATIVE) {
                    itemStack.setAmount(itemStack.getAmount() - 1);
                }
                if (this.plugin.random.nextInt(4) == 0) {
                    livingEntity.getWorld().spawnParticle(Particle.HEART, livingEntity.getLocation().clone().add(0.0, 0.5, 0.0), 7, 0.25, 0.3, 0.25, 0.03);
                    ((Wolf)livingEntity).setOwner((AnimalTamer)playerInteractEntityEvent.getPlayer());
                    livingEntity.getWorld().playSound(livingEntity.getLocation(), Sound.BLOCK_CONDUIT_ATTACK_TARGET, SoundCategory.HOSTILE, 0.5f, 0.5f);
                    this.plugin.achievementsHandler.awardProgress(playerInteractEntityEvent.getPlayer().getUniqueId(), "master.series.void_master", 1, 5);
                }
            } else if (itemStack.getType() == Material.NAME_TAG && ((Wolf)livingEntity).getOwner() != null && ((Wolf)livingEntity).getOwner().equals(playerInteractEntityEvent.getPlayer()) && itemStack.hasItemMeta() && itemStack.getItemMeta().hasDisplayName()) {
                ((BabyEndTotem)this.plugin.handler.findEntity(livingEntity)).changeName(itemStack.getItemMeta().getDisplayName());
                if (playerInteractEntityEvent.getPlayer().getGameMode() != GameMode.CREATIVE) {
                    itemStack.setAmount(itemStack.getAmount() - 1);
                }
            }
            playerInteractEntityEvent.setCancelled(true);
        }
    }

    @EventHandler
    public void onProjectileHit(ProjectileHitEvent projectileHitEvent) {
        if (projectileHitEvent.isCancelled()) {
            return;
        }
        if (projectileHitEvent.getHitEntity() instanceof LivingEntity && projectileHitEvent.getEntity().getShooter() instanceof Snowman && ((Snowman)projectileHitEvent.getEntity().getShooter()).hasMetadata("dd-frosty")) {
            if (this.plugin.mcVersion >= 1.17) {
                projectileHitEvent.getHitEntity().getWorld().playSound(projectileHitEvent.getEntity().getLocation(), Sound.ENTITY_PLAYER_HURT_FREEZE, SoundCategory.HOSTILE, 2.0f, 0.5f);
            }
            if (projectileHitEvent.getHitEntity() instanceof Player && ((Player)projectileHitEvent.getHitEntity()).isBlocking()) {
                projectileHitEvent.setCancelled(true);
                ((Player)projectileHitEvent.getHitEntity()).playSound(projectileHitEvent.getHitEntity(), Sound.ITEM_SHIELD_BLOCK, SoundCategory.PLAYERS, 1.0f, 1.0f);
                return;
            }
            ((LivingEntity)projectileHitEvent.getHitEntity()).addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, 40, 1, true, false));
            Utils.damageEntity((LivingEntity)projectileHitEvent.getHitEntity(), CustomEntityType.FROSTY.getDamage(), "dd-frostydeath", false);
        }
        if (projectileHitEvent.getEntity().hasMetadata("dd-elfarrow")) {
            projectileHitEvent.getEntity().getWorld().createExplosion(projectileHitEvent.getEntity().getLocation(), 1.5f, false, false, (Entity)projectileHitEvent.getEntity());
            projectileHitEvent.getEntity().remove();
            if (projectileHitEvent.getHitEntity() instanceof LivingEntity) {
                ((LivingEntity)projectileHitEvent.getHitEntity()).addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, 40, 1, true, false));
            }
        }
        if (projectileHitEvent.getEntity().hasMetadata("dd-petelfarrow")) {
            projectileHitEvent.getEntity().getWorld().createExplosion(projectileHitEvent.getEntity().getLocation(), 1.5f, false, false, (Entity)projectileHitEvent.getEntity());
            projectileHitEvent.getEntity().remove();
            if (projectileHitEvent.getHitEntity() instanceof LivingEntity) {
                ((LivingEntity)projectileHitEvent.getHitEntity()).addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, 40, 1, true, false));
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onTarget(EntityTargetLivingEntityEvent entityTargetLivingEntityEvent) {
        if (entityTargetLivingEntityEvent.getTarget() == null || entityTargetLivingEntityEvent.isCancelled()) {
            return;
        }
        Entity entity = entityTargetLivingEntityEvent.getEntity();
        if (entity.hasMetadata("dd-infestedtribesman") && entityTargetLivingEntityEvent.getTarget().hasMetadata("dd-infestedtribesman") || entity.hasMetadata("dd-elf") && entityTargetLivingEntityEvent.getTarget().hasMetadata("dd-elf")) {
            entityTargetLivingEntityEvent.setCancelled(true);
            return;
        }
        if (entity.hasMetadata("dd-christmasmob") && entityTargetLivingEntityEvent.getTarget().hasMetadata("dd-christmasmob")) {
            entityTargetLivingEntityEvent.setCancelled(true);
            return;
        }
        if (entity.hasMetadata("dd-killerchicken") && entityTargetLivingEntityEvent.getTarget().hasMetadata("dd-easterbunny")) {
            entityTargetLivingEntityEvent.setCancelled(true);
            return;
        }
        if (entity.hasMetadata("dd-halloweenmobs") && entityTargetLivingEntityEvent.getTarget().hasMetadata("dd-halloweenmobs")) {
            entityTargetLivingEntityEvent.setCancelled(true);
            return;
        }
        if (entity.hasMetadata("dd-petelf")) {
            CustomEntity customEntity = this.plugin.handler.findEntity((LivingEntity)entity);
            if (customEntity != null) {
                if (((ElfPet)customEntity).owner.equals(entityTargetLivingEntityEvent.getTarget().getUniqueId()) || entityTargetLivingEntityEvent.getTarget().hasMetadata("dd-petelf") && this.plugin.handler.findEntity(entityTargetLivingEntityEvent.getTarget()) != null && ((ElfPet)this.plugin.handler.findEntity((LivingEntity)entityTargetLivingEntityEvent.getTarget())).owner.equals(((ElfPet)customEntity).owner)) {
                    entityTargetLivingEntityEvent.setCancelled(true);
                    return;
                }
                if (entityTargetLivingEntityEvent.getReason() == EntityTargetEvent.TargetReason.TARGET_ATTACKED_ENTITY) {
                    ((ElfPet)customEntity).target = entityTargetLivingEntityEvent.getTarget();
                    if (CustomEnchantHandler.santaHatPlayers.containsKey(((ElfPet)customEntity).owner)) {
                        ElfPet[] elfPetArray = CustomEnchantHandler.santaHatPlayers.get(((ElfPet)customEntity).owner);
                        int n = elfPetArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ElfPet elfPet = elfPetArray[n2];
                            if (elfPet != null && elfPet.getEntity() != null && !elfPet.getEntity().isDead() && (elfPet.target == null || elfPet.target.isDead())) {
                                elfPet.target = entityTargetLivingEntityEvent.getTarget();
                            }
                            ++n2;
                        }
                    }
                }
            }
            return;
        }
    }
}

