/*
 * Decompiled with CFR 0.152.
 */
package deadlydisasters.utils;

import com.mojang.datafixers.util.Pair;
import deadlydisasters.Main;
import deadlydisasters.utils.DDSong;
import deadlydisasters.utils.RepeatingTask;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Queue;
import org.bukkit.Sound;
import org.bukkit.entity.Player;

public class SongMaker {
    private Queue<Player> players = new ArrayDeque<Player>();
    private boolean loop;
    private List<Pair<List<Pair<Sound, Float>>, Integer>> notes = new ArrayList<Pair<List<Pair<Sound, Float>>, Integer>>();
    private RepeatingTask task;
    private int note;
    private float volume = 1.0f;

    public SongMaker(DDSong dDSong) {
        this.notes = dDSong.notes;
    }

    public void playSong() {
        if (this.task == null) {
            final int[] nArray = new int[]{(Integer)this.notes.get(0).getSecond()};
            this.task = new RepeatingTask(Main.getInstance(), 0, 1){

                @Override
                public void run() {
                    int n = nArray[0];
                    nArray[0] = n - 1;
                    if (n <= 0) {
                        List list = (List)SongMaker.this.notes.get(SongMaker.this.note).getFirst();
                        for (Player player : SongMaker.this.players) {
                            for (Pair pair : list) {
                                player.playSound(player.getLocation(), (Sound)pair.getFirst(), SongMaker.this.volume, ((Float)pair.getSecond()).floatValue());
                            }
                        }
                        ++SongMaker.this.note;
                        if (SongMaker.this.note < SongMaker.this.notes.size()) {
                            nArray[0] = (Integer)SongMaker.this.notes.get(SongMaker.this.note).getSecond();
                            return;
                        }
                        this.cancel();
                        SongMaker.this.task = null;
                        if (SongMaker.this.loop) {
                            SongMaker.this.note = 0;
                            SongMaker.this.playSong();
                        }
                        return;
                    }
                }
            };
        }
    }

    public void stopSong() {
        if (this.task != null) {
            this.task.cancel();
        }
    }

    public void addPlayer(Player player) {
        this.players.add(player);
    }

    public void removePlayer(Player player) {
        this.players.remove(player);
    }

    public void addPlayers(Collection<Player> collection) {
        this.players.addAll(collection);
    }

    public void removeAll() {
        this.players.clear();
    }

    public boolean isLoop() {
        return this.loop;
    }

    public void setLoop(boolean bl) {
        this.loop = bl;
    }

    public List<Pair<List<Pair<Sound, Float>>, Integer>> getNotes() {
        return this.notes;
    }

    public void setNotes(List<Pair<List<Pair<Sound, Float>>, Integer>> list) {
        this.notes = list;
    }

    public int getNote() {
        return this.note;
    }

    public void setNote(int n) {
        this.note = n;
    }

    public float getVolume() {
        return this.volume;
    }

    public void setVolume(float f) {
        this.volume = f;
    }
}

