/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.file;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.AclEntry;
import java.nio.file.attribute.AclFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.IOExceptionList;
import org.apache.commons.io.file.AccumulatorPathVisitor;
import org.apache.commons.io.file.CleaningPathVisitor;
import org.apache.commons.io.file.CopyDirectoryVisitor;
import org.apache.commons.io.file.Counters;
import org.apache.commons.io.file.CountingPathVisitor;
import org.apache.commons.io.file.DeleteOption;
import org.apache.commons.io.file.DeletingPathVisitor;
import org.apache.commons.io.file.DirectoryStreamFilter;
import org.apache.commons.io.file.PathFilter;
import org.apache.commons.io.file.StandardDeleteOption;

public final class PathUtils {
    public static final CopyOption[] EMPTY_COPY_OPTIONS = new CopyOption[0];
    public static final DeleteOption[] EMPTY_DELETE_OPTION_ARRAY = new DeleteOption[0];
    public static final FileVisitOption[] EMPTY_FILE_VISIT_OPTION_ARRAY = new FileVisitOption[0];
    public static final LinkOption[] EMPTY_LINK_OPTION_ARRAY = new LinkOption[0];
    public static final LinkOption[] NOFOLLOW_LINK_OPTION_ARRAY = new LinkOption[]{LinkOption.NOFOLLOW_LINKS};
    public static final OpenOption[] EMPTY_OPEN_OPTION_ARRAY = new OpenOption[0];
    public static final Path[] EMPTY_PATH_ARRAY = new Path[0];

    private static AccumulatorPathVisitor accumulate(Path path, int n, FileVisitOption[] fileVisitOptionArray) {
        return PathUtils.visitFileTree(AccumulatorPathVisitor.withLongCounters(), path, PathUtils.toFileVisitOptionSet(fileVisitOptionArray), n);
    }

    public static Counters.PathCounters cleanDirectory(Path path) {
        return PathUtils.cleanDirectory(path, EMPTY_DELETE_OPTION_ARRAY);
    }

    public static Counters.PathCounters cleanDirectory(Path path, DeleteOption ... deleteOptionArray) {
        return PathUtils.visitFileTree(new CleaningPathVisitor(Counters.longPathCounters(), deleteOptionArray, new String[0]), path).getPathCounters();
    }

    public static Counters.PathCounters copyDirectory(Path path, Path path2, CopyOption ... copyOptionArray) {
        Path path3 = path.toAbsolutePath();
        return PathUtils.visitFileTree(new CopyDirectoryVisitor(Counters.longPathCounters(), path3, path2, copyOptionArray), path3).getPathCounters();
    }

    public static Path copyFile(URL uRL, Path path, CopyOption ... copyOptionArray) {
        try (InputStream inputStream = uRL.openStream();){
            Files.copy(inputStream, path, copyOptionArray);
            Path path2 = path;
            return path2;
        }
    }

    public static Path copyFileToDirectory(Path path, Path path2, CopyOption ... copyOptionArray) {
        return Files.copy(path, path2.resolve(path.getFileName()), copyOptionArray);
    }

    public static Path copyFileToDirectory(URL uRL, Path path, CopyOption ... copyOptionArray) {
        try (InputStream inputStream = uRL.openStream();){
            Files.copy(inputStream, path.resolve(uRL.getFile()), copyOptionArray);
            Path path2 = path;
            return path2;
        }
    }

    public static Counters.PathCounters countDirectory(Path path) {
        return PathUtils.visitFileTree(new CountingPathVisitor(Counters.longPathCounters()), path).getPathCounters();
    }

    public static Path createParentDirectories(Path path, FileAttribute<?> ... fileAttributeArray) {
        Path path2 = path.getParent();
        if (path2 == null) {
            return null;
        }
        return Files.createDirectories(path2, fileAttributeArray);
    }

    public static Path current() {
        return Paths.get("", new String[0]);
    }

    public static Counters.PathCounters delete(Path path) {
        return PathUtils.delete(path, EMPTY_DELETE_OPTION_ARRAY);
    }

    public static Counters.PathCounters delete(Path path, DeleteOption ... deleteOptionArray) {
        return Files.isDirectory(path, LinkOption.NOFOLLOW_LINKS) ? PathUtils.deleteDirectory(path, deleteOptionArray) : PathUtils.deleteFile(path, deleteOptionArray);
    }

    public static Counters.PathCounters delete(Path path, LinkOption[] linkOptionArray, DeleteOption ... deleteOptionArray) {
        return Files.isDirectory(path, linkOptionArray) ? PathUtils.deleteDirectory(path, linkOptionArray, deleteOptionArray) : PathUtils.deleteFile(path, linkOptionArray, deleteOptionArray);
    }

    public static Counters.PathCounters deleteDirectory(Path path) {
        return PathUtils.deleteDirectory(path, EMPTY_DELETE_OPTION_ARRAY);
    }

    public static Counters.PathCounters deleteDirectory(Path path, DeleteOption ... deleteOptionArray) {
        return PathUtils.visitFileTree(new DeletingPathVisitor(Counters.longPathCounters(), NOFOLLOW_LINK_OPTION_ARRAY, deleteOptionArray, new String[0]), path).getPathCounters();
    }

    public static Counters.PathCounters deleteDirectory(Path path, LinkOption[] linkOptionArray, DeleteOption ... deleteOptionArray) {
        return PathUtils.visitFileTree(new DeletingPathVisitor(Counters.longPathCounters(), linkOptionArray, deleteOptionArray, new String[0]), path).getPathCounters();
    }

    public static Counters.PathCounters deleteFile(Path path) {
        return PathUtils.deleteFile(path, EMPTY_DELETE_OPTION_ARRAY);
    }

    public static Counters.PathCounters deleteFile(Path path, DeleteOption ... deleteOptionArray) {
        return PathUtils.deleteFile(path, NOFOLLOW_LINK_OPTION_ARRAY, deleteOptionArray);
    }

    public static Counters.PathCounters deleteFile(Path path, LinkOption[] linkOptionArray, DeleteOption ... deleteOptionArray) {
        long l;
        if (Files.isDirectory(path, linkOptionArray)) {
            throw new NoSuchFileException(path.toString());
        }
        Counters.PathCounters pathCounters = Counters.longPathCounters();
        boolean bl = Files.exists(path, linkOptionArray);
        long l2 = l = bl && !Files.isSymbolicLink(path) ? Files.size(path) : 0L;
        if (PathUtils.overrideReadOnly(deleteOptionArray) && bl) {
            PathUtils.setReadOnly(path, false, linkOptionArray);
        }
        if (Files.deleteIfExists(path)) {
            pathCounters.getFileCounter().increment();
            pathCounters.getByteCounter().add(l);
        }
        return pathCounters;
    }

    public static boolean directoryAndFileContentEquals(Path path, Path path2) {
        return PathUtils.directoryAndFileContentEquals(path, path2, EMPTY_LINK_OPTION_ARRAY, EMPTY_OPEN_OPTION_ARRAY, EMPTY_FILE_VISIT_OPTION_ARRAY);
    }

    public static boolean directoryAndFileContentEquals(Path path, Path path2, LinkOption[] linkOptionArray, OpenOption[] openOptionArray, FileVisitOption[] fileVisitOptionArray) {
        if (path == null && path2 == null) {
            return true;
        }
        if (path == null || path2 == null) {
            return false;
        }
        if (Files.notExists(path, new LinkOption[0]) && Files.notExists(path2, new LinkOption[0])) {
            return true;
        }
        RelativeSortedPaths relativeSortedPaths = new RelativeSortedPaths(path, path2, Integer.MAX_VALUE, linkOptionArray, fileVisitOptionArray);
        if (!relativeSortedPaths.equals) {
            return false;
        }
        List<Path> list = relativeSortedPaths.relativeFileList1;
        List<Path> list2 = relativeSortedPaths.relativeFileList2;
        for (Path path3 : list) {
            int n = Collections.binarySearch(list2, path3);
            if (n <= -1) {
                throw new IllegalStateException("Unexpected mismatch.");
            }
            if (PathUtils.fileContentEquals(path.resolve(path3), path2.resolve(path3), linkOptionArray, openOptionArray)) continue;
            return false;
        }
        return true;
    }

    public static boolean directoryContentEquals(Path path, Path path2) {
        return PathUtils.directoryContentEquals(path, path2, Integer.MAX_VALUE, EMPTY_LINK_OPTION_ARRAY, EMPTY_FILE_VISIT_OPTION_ARRAY);
    }

    public static boolean directoryContentEquals(Path path, Path path2, int n, LinkOption[] linkOptionArray, FileVisitOption[] fileVisitOptionArray) {
        return new RelativeSortedPaths((Path)path, (Path)path2, (int)n, (LinkOption[])linkOptionArray, (FileVisitOption[])fileVisitOptionArray).equals;
    }

    public static boolean fileContentEquals(Path path, Path path2) {
        return PathUtils.fileContentEquals(path, path2, EMPTY_LINK_OPTION_ARRAY, EMPTY_OPEN_OPTION_ARRAY);
    }

    /*
     * Exception decompiling
     */
    public static boolean fileContentEquals(Path var0, Path var1_1, LinkOption[] var2_2, OpenOption[] var3_3) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Path[] filter(PathFilter pathFilter, Path ... pathArray) {
        Objects.requireNonNull(pathFilter, "filter");
        if (pathArray == null) {
            return EMPTY_PATH_ARRAY;
        }
        return PathUtils.filterPaths(pathFilter, Stream.of(pathArray), Collectors.toList()).toArray(EMPTY_PATH_ARRAY);
    }

    private static <R, A> R filterPaths(PathFilter pathFilter, Stream<Path> stream, Collector<? super Path, A, R> collector) {
        Objects.requireNonNull(pathFilter, "filter");
        Objects.requireNonNull(collector, "collector");
        if (stream == null) {
            return Stream.empty().collect(collector);
        }
        return stream.filter(path -> {
            try {
                return path != null && pathFilter.accept((Path)path, PathUtils.readBasicFileAttributes(path)) == FileVisitResult.CONTINUE;
            }
            catch (IOException iOException) {
                return false;
            }
        }).collect(collector);
    }

    public static List<AclEntry> getAclEntryList(Path path) {
        AclFileAttributeView aclFileAttributeView = Files.getFileAttributeView(path, AclFileAttributeView.class, new LinkOption[0]);
        return aclFileAttributeView == null ? null : aclFileAttributeView.getAcl();
    }

    public static boolean isDirectory(Path path, LinkOption ... linkOptionArray) {
        return path != null && Files.isDirectory(path, linkOptionArray);
    }

    public static boolean isEmpty(Path path) {
        return Files.isDirectory(path, new LinkOption[0]) ? PathUtils.isEmptyDirectory(path) : PathUtils.isEmptyFile(path);
    }

    public static boolean isEmptyDirectory(Path path) {
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path);){
            boolean bl = !directoryStream.iterator().hasNext();
            return bl;
        }
    }

    public static boolean isEmptyFile(Path path) {
        return Files.size(path) <= 0L;
    }

    public static boolean isNewer(Path path, long l, LinkOption ... linkOptionArray) {
        Objects.requireNonNull(path, "file");
        if (Files.notExists(path, new LinkOption[0])) {
            return false;
        }
        return Files.getLastModifiedTime(path, linkOptionArray).toMillis() > l;
    }

    public static boolean isRegularFile(Path path, LinkOption ... linkOptionArray) {
        return path != null && Files.isRegularFile(path, linkOptionArray);
    }

    public static DirectoryStream<Path> newDirectoryStream(Path path, PathFilter pathFilter) {
        return Files.newDirectoryStream(path, new DirectoryStreamFilter(pathFilter));
    }

    private static boolean overrideReadOnly(DeleteOption ... deleteOptionArray) {
        if (deleteOptionArray == null) {
            return false;
        }
        return Stream.of(deleteOptionArray).anyMatch(deleteOption -> deleteOption == StandardDeleteOption.OVERRIDE_READ_ONLY);
    }

    public static BasicFileAttributes readBasicFileAttributes(Path path) {
        return Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
    }

    public static BasicFileAttributes readBasicFileAttributesUnchecked(Path path) {
        try {
            return PathUtils.readBasicFileAttributes(path);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    static List<Path> relativize(Collection<Path> collection, Path path, boolean bl, Comparator<? super Path> comparator) {
        Stream<Path> stream = collection.stream().map(path::relativize);
        if (bl) {
            stream = comparator == null ? stream.sorted() : stream.sorted(comparator);
        }
        return stream.collect(Collectors.toList());
    }

    public static Path setReadOnly(Path path, boolean bl, LinkOption ... linkOptionArray) {
        PosixFileAttributeView posixFileAttributeView;
        ArrayList<IOException> arrayList = new ArrayList<IOException>(2);
        DosFileAttributeView dosFileAttributeView = Files.getFileAttributeView(path, DosFileAttributeView.class, linkOptionArray);
        if (dosFileAttributeView != null) {
            try {
                dosFileAttributeView.setReadOnly(bl);
                return path;
            }
            catch (IOException iOException) {
                arrayList.add(iOException);
            }
        }
        if ((posixFileAttributeView = Files.getFileAttributeView(path, PosixFileAttributeView.class, linkOptionArray)) != null) {
            PosixFileAttributes posixFileAttributes = posixFileAttributeView.readAttributes();
            Set<PosixFilePermission> set = posixFileAttributes.permissions();
            set.remove((Object)PosixFilePermission.OWNER_WRITE);
            set.remove((Object)PosixFilePermission.GROUP_WRITE);
            set.remove((Object)PosixFilePermission.OTHERS_WRITE);
            try {
                return Files.setPosixFilePermissions(path, set);
            }
            catch (IOException iOException) {
                arrayList.add(iOException);
            }
        }
        if (!arrayList.isEmpty()) {
            throw new IOExceptionList(path.toString(), arrayList);
        }
        throw new IOException(String.format("No DosFileAttributeView or PosixFileAttributeView for '%s' (linkOptions=%s)", path, Arrays.toString(linkOptionArray)));
    }

    static Set<FileVisitOption> toFileVisitOptionSet(FileVisitOption ... fileVisitOptionArray) {
        return fileVisitOptionArray == null ? EnumSet.noneOf(FileVisitOption.class) : Stream.of(fileVisitOptionArray).collect(Collectors.toSet());
    }

    public static <T extends FileVisitor<? super Path>> T visitFileTree(T t, Path path) {
        Files.walkFileTree(path, t);
        return t;
    }

    public static <T extends FileVisitor<? super Path>> T visitFileTree(T t, Path path, Set<FileVisitOption> set, int n) {
        Files.walkFileTree(path, set, n, t);
        return t;
    }

    public static <T extends FileVisitor<? super Path>> T visitFileTree(T t, String string, String ... stringArray) {
        return PathUtils.visitFileTree(t, Paths.get(string, stringArray));
    }

    public static <T extends FileVisitor<? super Path>> T visitFileTree(T t, URI uRI) {
        return PathUtils.visitFileTree(t, Paths.get(uRI));
    }

    public static Stream<Path> walk(Path path2, PathFilter pathFilter, int n, boolean bl, FileVisitOption ... fileVisitOptionArray) {
        return Files.walk(path2, n, fileVisitOptionArray).filter(path -> pathFilter.accept((Path)path, bl ? PathUtils.readBasicFileAttributesUnchecked(path) : null) == FileVisitResult.CONTINUE);
    }

    private PathUtils() {
    }

    private static class RelativeSortedPaths {
        final boolean equals;
        final List<Path> relativeFileList1;
        final List<Path> relativeFileList2;

        private RelativeSortedPaths(Path path, Path path2, int n, LinkOption[] linkOptionArray, FileVisitOption[] fileVisitOptionArray) {
            List<Path> list = null;
            List<Path> list2 = null;
            if (path == null && path2 == null) {
                this.equals = true;
            } else if (path == null ^ path2 == null) {
                this.equals = false;
            } else {
                boolean bl = Files.notExists(path, linkOptionArray);
                boolean bl2 = Files.notExists(path2, linkOptionArray);
                if (bl || bl2) {
                    this.equals = bl && bl2;
                } else {
                    AccumulatorPathVisitor accumulatorPathVisitor = PathUtils.accumulate(path, n, fileVisitOptionArray);
                    AccumulatorPathVisitor accumulatorPathVisitor2 = PathUtils.accumulate(path2, n, fileVisitOptionArray);
                    if (accumulatorPathVisitor.getDirList().size() != accumulatorPathVisitor2.getDirList().size() || accumulatorPathVisitor.getFileList().size() != accumulatorPathVisitor2.getFileList().size()) {
                        this.equals = false;
                    } else {
                        List<Path> list3;
                        List<Path> list4 = accumulatorPathVisitor.relativizeDirectories(path, true, null);
                        if (!list4.equals(list3 = accumulatorPathVisitor2.relativizeDirectories(path2, true, null))) {
                            this.equals = false;
                        } else {
                            list = accumulatorPathVisitor.relativizeFiles(path, true, null);
                            list2 = accumulatorPathVisitor2.relativizeFiles(path2, true, null);
                            this.equals = list.equals(list2);
                        }
                    }
                }
            }
            this.relativeFileList1 = list;
            this.relativeFileList2 = list2;
        }
    }
}

