/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.FilterCollectionWriter;

public class ProxyCollectionWriter
extends FilterCollectionWriter {
    public ProxyCollectionWriter(Collection<Writer> collection) {
        super(collection);
    }

    public ProxyCollectionWriter(Writer ... writerArray) {
        super(writerArray);
    }

    protected void afterWrite(int n) {
    }

    @Override
    public Writer append(char c) {
        try {
            this.beforeWrite(1);
            super.append(c);
            this.afterWrite(1);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
        }
        return this;
    }

    @Override
    public Writer append(CharSequence charSequence) {
        try {
            int n = IOUtils.length(charSequence);
            this.beforeWrite(n);
            super.append(charSequence);
            this.afterWrite(n);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
        }
        return this;
    }

    @Override
    public Writer append(CharSequence charSequence, int n, int n2) {
        try {
            this.beforeWrite(n2 - n);
            super.append(charSequence, n, n2);
            this.afterWrite(n2 - n);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
        }
        return this;
    }

    protected void beforeWrite(int n) {
    }

    @Override
    public void close() {
        try {
            super.close();
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
        }
    }

    @Override
    public void flush() {
        try {
            super.flush();
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
        }
    }

    protected void handleIOException(IOException iOException) {
        throw iOException;
    }

    @Override
    public void write(char[] cArray) {
        try {
            int n = IOUtils.length(cArray);
            this.beforeWrite(n);
            super.write(cArray);
            this.afterWrite(n);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
        }
    }

    @Override
    public void write(char[] cArray, int n, int n2) {
        try {
            this.beforeWrite(n2);
            super.write(cArray, n, n2);
            this.afterWrite(n2);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
        }
    }

    @Override
    public void write(int n) {
        try {
            this.beforeWrite(1);
            super.write(n);
            this.afterWrite(1);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
        }
    }

    @Override
    public void write(String string) {
        try {
            int n = IOUtils.length(string);
            this.beforeWrite(n);
            super.write(string);
            this.afterWrite(n);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
        }
    }

    @Override
    public void write(String string, int n, int n2) {
        try {
            this.beforeWrite(n2);
            super.write(string, n, n2);
            this.afterWrite(n2);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
        }
    }
}

