/*
 * Decompiled with CFR 0.152.
 */
package ia.sh.com.jayway.jsonpath.internal.filter;

import ia.sh.com.jayway.jsonpath.Predicate$PredicateContext;
import ia.sh.com.jayway.jsonpath.internal.filter.Evaluator;
import ia.sh.com.jayway.jsonpath.internal.filter.EvaluatorFactory;
import ia.sh.com.jayway.jsonpath.internal.filter.ExpressionNode;
import ia.sh.com.jayway.jsonpath.internal.filter.RelationalOperator;
import ia.sh.com.jayway.jsonpath.internal.filter.ValueNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelationalExpressionNode
extends ExpressionNode {
    private static final Logger logger = LoggerFactory.getLogger(RelationalExpressionNode.class);
    private final ValueNode left;
    private final RelationalOperator relationalOperator;
    private final ValueNode right;

    public RelationalExpressionNode(ValueNode valueNode, RelationalOperator relationalOperator, ValueNode valueNode2) {
        this.left = valueNode;
        this.relationalOperator = relationalOperator;
        this.right = valueNode2;
        logger.trace("ExpressionNode {}", (Object)this.toString());
    }

    public String toString() {
        if (this.relationalOperator == RelationalOperator.EXISTS) {
            return this.left.toString();
        }
        return this.left.toString() + " " + this.relationalOperator.toString() + " " + this.right.toString();
    }

    @Override
    public boolean apply(Predicate$PredicateContext predicate$PredicateContext) {
        Evaluator evaluator;
        ValueNode valueNode = this.left;
        ValueNode valueNode2 = this.right;
        if (this.left.isPathNode()) {
            valueNode = this.left.asPathNode().evaluate(predicate$PredicateContext);
        }
        if (this.right.isPathNode()) {
            valueNode2 = this.right.asPathNode().evaluate(predicate$PredicateContext);
        }
        if ((evaluator = EvaluatorFactory.createEvaluator(this.relationalOperator)) != null) {
            return evaluator.evaluate(valueNode, valueNode2, predicate$PredicateContext);
        }
        return false;
    }
}

