/*
 * Decompiled with CFR 0.152.
 */
package ia.sh.com.jayway.jsonpath.spi.json;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import ia.sh.com.jayway.jsonpath.JsonPathException;
import ia.sh.com.jayway.jsonpath.spi.json.AbstractJsonProvider;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class GsonJsonProvider
extends AbstractJsonProvider {
    private static final JsonParser PARSER = new JsonParser();
    private final Gson gson;

    public GsonJsonProvider() {
        this(new Gson());
    }

    public GsonJsonProvider(Gson gson) {
        this.gson = gson;
    }

    @Override
    public Object unwrap(Object object) {
        if (object == null) {
            return null;
        }
        if (!(object instanceof JsonElement)) {
            return object;
        }
        JsonElement jsonElement = (JsonElement)object;
        if (jsonElement.isJsonNull()) {
            return null;
        }
        if (jsonElement.isJsonPrimitive()) {
            JsonPrimitive jsonPrimitive = jsonElement.getAsJsonPrimitive();
            if (jsonPrimitive.isString()) {
                return jsonPrimitive.getAsString();
            }
            if (jsonPrimitive.isBoolean()) {
                return jsonPrimitive.getAsBoolean();
            }
            if (jsonPrimitive.isNumber()) {
                return GsonJsonProvider.unwrapNumber(jsonPrimitive.getAsNumber());
            }
        }
        return object;
    }

    private static boolean isPrimitiveNumber(Number number) {
        return number instanceof Integer || number instanceof Float || number instanceof Double || number instanceof Long || number instanceof BigDecimal || number instanceof BigInteger;
    }

    private static Number unwrapNumber(Number number) {
        double d2;
        BigDecimal bigDecimal;
        Number number2 = !GsonJsonProvider.isPrimitiveNumber(number) ? (Number)((bigDecimal = new BigDecimal(number.toString())).scale() <= 0 ? (Number)(bigDecimal.abs().compareTo(new BigDecimal(Integer.MAX_VALUE)) <= 0 ? (Number)bigDecimal.intValue() : (Number)(bigDecimal.abs().compareTo(new BigDecimal(Long.MAX_VALUE)) <= 0 ? Long.valueOf(bigDecimal.longValue()) : bigDecimal)) : (Number)(BigDecimal.valueOf(d2 = bigDecimal.doubleValue()).compareTo(bigDecimal) != 0 ? bigDecimal : Double.valueOf(d2))) : (Number)number;
        return number2;
    }

    @Override
    public Object parse(String string) {
        return PARSER.parse(string);
    }

    @Override
    public Object parse(InputStream inputStream, String string) {
        try {
            return PARSER.parse((Reader)new InputStreamReader(inputStream, string));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new JsonPathException(unsupportedEncodingException);
        }
    }

    @Override
    public String toJson(Object object) {
        return this.gson.toJson(object);
    }

    @Override
    public Object createArray() {
        return new JsonArray();
    }

    @Override
    public Object createMap() {
        return new JsonObject();
    }

    @Override
    public boolean isArray(Object object) {
        return object instanceof JsonArray || object instanceof List;
    }

    @Override
    public Object getArrayIndex(Object object, int n2) {
        return this.toJsonArray(object).get(n2);
    }

    @Override
    public void setArrayIndex(Object object, int n2, Object object2) {
        if (!this.isArray(object)) {
            throw new UnsupportedOperationException();
        }
        JsonArray jsonArray = this.toJsonArray(object);
        if (n2 == jsonArray.size()) {
            jsonArray.add(this.createJsonElement(object2));
        } else {
            jsonArray.set(n2, this.createJsonElement(object2));
        }
    }

    @Override
    public Object getMapValue(Object object, String string) {
        JsonObject jsonObject = this.toJsonObject(object);
        JsonElement jsonElement = jsonObject.get(string);
        if (!jsonObject.has(string)) {
            return UNDEFINED;
        }
        return this.unwrap(jsonElement);
    }

    @Override
    public void setProperty(Object object, Object object2, Object object3) {
        if (this.isMap(object)) {
            this.toJsonObject(object).add(object2.toString(), this.createJsonElement(object3));
        } else {
            JsonArray jsonArray;
            int n2 = object2 != null ? (object2 instanceof Integer ? (Integer)object2 : Integer.parseInt(object2.toString())) : jsonArray.size();
            if (n2 == (jsonArray = this.toJsonArray(object)).size()) {
                jsonArray.add(this.createJsonElement(object3));
            } else {
                jsonArray.set(n2, this.createJsonElement(object3));
            }
        }
    }

    @Override
    public void removeProperty(Object object, Object object2) {
        if (this.isMap(object)) {
            this.toJsonObject(object).remove(object2.toString());
        } else {
            JsonArray jsonArray = this.toJsonArray(object);
            int n2 = object2 instanceof Integer ? (Integer)object2 : Integer.parseInt(object2.toString());
            jsonArray.remove(n2);
        }
    }

    @Override
    public boolean isMap(Object object) {
        return object instanceof JsonObject;
    }

    @Override
    public Collection getPropertyKeys(Object object) {
        ArrayList arrayList = new ArrayList();
        for (Map.Entry entry : this.toJsonObject(object).entrySet()) {
            arrayList.add(entry.getKey());
        }
        return arrayList;
    }

    @Override
    public int length(Object object) {
        JsonElement jsonElement;
        if (this.isArray(object)) {
            return this.toJsonArray(object).size();
        }
        if (this.isMap(object)) {
            return this.toJsonObject(object).entrySet().size();
        }
        if (object instanceof JsonElement && (jsonElement = this.toJsonElement(object)).isJsonPrimitive()) {
            return jsonElement.toString().length();
        }
        throw new JsonPathException("length operation can not applied to " + (object != null ? object.getClass().getName() : "null"));
    }

    @Override
    public Iterable toIterable(Object object) {
        JsonArray jsonArray = this.toJsonArray(object);
        ArrayList<Object> arrayList = new ArrayList<Object>(jsonArray.size());
        for (Object e2 : jsonArray) {
            arrayList.add(this.unwrap(e2));
        }
        return arrayList;
    }

    private JsonElement createJsonElement(Object object) {
        return this.gson.toJsonTree(object);
    }

    private JsonArray toJsonArray(Object object) {
        return (JsonArray)object;
    }

    private JsonObject toJsonObject(Object object) {
        return (JsonObject)object;
    }

    private JsonElement toJsonElement(Object object) {
        return (JsonElement)object;
    }
}

