/*
 * Decompiled with CFR 0.152.
 */
package ia.sh.io.protostuff;

import ia.sh.io.protostuff.LinkedBuffer;
import ia.sh.io.protostuff.WriteSession$FlushHandler;
import ia.sh.io.protostuff.WriteSink;
import java.io.OutputStream;

public class WriteSession {
    public final LinkedBuffer head;
    protected LinkedBuffer tail;
    protected int size = 0;
    public final int nextBufferSize;
    public final OutputStream out;
    public final WriteSession$FlushHandler flushHandler;
    public final WriteSink sink;

    public WriteSession(LinkedBuffer linkedBuffer) {
        this(linkedBuffer, 512);
    }

    public WriteSession(LinkedBuffer linkedBuffer, int n2) {
        this.tail = linkedBuffer;
        this.head = linkedBuffer;
        this.nextBufferSize = n2;
        this.out = null;
        this.flushHandler = null;
        this.sink = WriteSink.BUFFERED;
    }

    public WriteSession(LinkedBuffer linkedBuffer, OutputStream outputStream, WriteSession$FlushHandler flushHandler, int n2) {
        this.tail = linkedBuffer;
        this.head = linkedBuffer;
        this.nextBufferSize = n2;
        this.out = outputStream;
        this.flushHandler = flushHandler;
        this.sink = WriteSink.STREAMED;
        assert (outputStream != null);
    }

    public WriteSession(LinkedBuffer linkedBuffer, OutputStream outputStream) {
        this(linkedBuffer, outputStream, null, 512);
    }

    public void reset() {
    }

    public WriteSession clear() {
        this.tail = this.head.clear();
        this.size = 0;
        return this;
    }

    public final int getSize() {
        return this.size;
    }

    public final byte[] toByteArray() {
        LinkedBuffer linkedBuffer = this.head;
        int n2 = 0;
        byte[] byArray = new byte[this.size];
        do {
            int n3;
            if ((n3 = linkedBuffer.offset - linkedBuffer.start) <= 0) continue;
            System.arraycopy(linkedBuffer.buffer, linkedBuffer.start, byArray, n2, n3);
            n2 += n3;
        } while ((linkedBuffer = linkedBuffer.next) != null);
        return byArray;
    }

    protected int flush(byte[] byArray, int n2, int n3) {
        if (this.flushHandler != null) {
            return this.flushHandler.flush(this, byArray, n2, n3);
        }
        this.out.write(byArray, n2, n3);
        return n2;
    }

    protected int flush(byte[] byArray, int n2, int n3, byte[] byArray2, int n4, int n5) {
        if (this.flushHandler != null) {
            return this.flushHandler.flush(this, byArray, n2, n3, byArray2, n4, n5);
        }
        this.out.write(byArray, n2, n3);
        this.out.write(byArray2, n4, n5);
        return n2;
    }

    protected int flush(LinkedBuffer linkedBuffer, byte[] byArray, int n2, int n3) {
        if (this.flushHandler != null) {
            return this.flushHandler.flush(this, linkedBuffer, byArray, n2, n3);
        }
        this.out.write(byArray, n2, n3);
        return linkedBuffer.start;
    }
}

