/*
 * Decompiled with CFR 0.152.
 */
package ia.sh.net.minidev.asm;

import ia.sh.net.minidev.asm.ex.ConvertException;

public class DefaultConverter {
    public static int convertToint(Object object) {
        if (object == null) {
            return 0;
        }
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        if (object instanceof String) {
            return Integer.parseInt((String)object);
        }
        throw new ConvertException("Primitive: Can not convert " + object.getClass().getName() + " to int");
    }

    public static Integer convertToInt(Object object) {
        if (object == null) {
            return null;
        }
        Class<?> clazz = object.getClass();
        if (clazz == Integer.class) {
            return (Integer)object;
        }
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        throw new ConvertException("Primitive: Can not convert " + object.getClass().getName() + " to Integer");
    }

    public static short convertToshort(Object object) {
        if (object == null) {
            return 0;
        }
        if (object instanceof Number) {
            return ((Number)object).shortValue();
        }
        if (object instanceof String) {
            return Short.parseShort((String)object);
        }
        throw new ConvertException("Primitive: Can not convert " + object.getClass().getName() + " to short");
    }

    public static Short convertToShort(Object object) {
        if (object == null) {
            return null;
        }
        Class<?> clazz = object.getClass();
        if (clazz == Short.class) {
            return (Short)object;
        }
        if (object instanceof Number) {
            return ((Number)object).shortValue();
        }
        throw new ConvertException("Primitive: Can not convert " + object.getClass().getName() + " to Short");
    }

    public static long convertTolong(Object object) {
        if (object == null) {
            return 0L;
        }
        if (object instanceof Number) {
            return ((Number)object).longValue();
        }
        if (object instanceof String) {
            return Long.parseLong((String)object);
        }
        throw new ConvertException("Primitive: Can not convert " + object.getClass().getName() + " to long");
    }

    public static Long convertToLong(Object object) {
        if (object == null) {
            return null;
        }
        Class<?> clazz = object.getClass();
        if (clazz == Long.class) {
            return (Long)object;
        }
        if (object instanceof Number) {
            return ((Number)object).longValue();
        }
        throw new ConvertException("Primitive: Can not convert value '" + object + "' As " + object.getClass().getName() + " to Long");
    }

    public static byte convertTobyte(Object object) {
        if (object == null) {
            return 0;
        }
        if (object instanceof Number) {
            return ((Number)object).byteValue();
        }
        if (object instanceof String) {
            return Byte.parseByte((String)object);
        }
        throw new ConvertException("Primitive: Can not convert " + object.getClass().getName() + " to byte");
    }

    public static Byte convertToByte(Object object) {
        if (object == null) {
            return null;
        }
        Class<?> clazz = object.getClass();
        if (clazz == Byte.class) {
            return (Byte)object;
        }
        if (object instanceof Number) {
            return ((Number)object).byteValue();
        }
        throw new ConvertException("Primitive: Can not convert " + object.getClass().getName() + " to Byte");
    }

    public static float convertTofloat(Object object) {
        if (object == null) {
            return 0.0f;
        }
        if (object instanceof Number) {
            return ((Number)object).floatValue();
        }
        if (object instanceof String) {
            return Float.parseFloat((String)object);
        }
        throw new ConvertException("Primitive: Can not convert " + object.getClass().getName() + " to float");
    }

    public static Float convertToFloat(Object object) {
        if (object == null) {
            return null;
        }
        Class<?> clazz = object.getClass();
        if (clazz == Float.class) {
            return (Float)object;
        }
        if (object instanceof Number) {
            return Float.valueOf(((Number)object).floatValue());
        }
        throw new ConvertException("Primitive: Can not convert " + object.getClass().getName() + " to Float");
    }

    public static double convertTodouble(Object object) {
        if (object == null) {
            return 0.0;
        }
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        if (object instanceof String) {
            return Double.parseDouble((String)object);
        }
        throw new ConvertException("Primitive: Can not convert " + object.getClass().getName() + " to float");
    }

    public static Double convertToDouble(Object object) {
        if (object == null) {
            return null;
        }
        Class<?> clazz = object.getClass();
        if (clazz == Double.class) {
            return (Double)object;
        }
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        throw new ConvertException("Primitive: Can not convert " + object.getClass().getName() + " to Float");
    }

    public static char convertTochar(Object object) {
        if (object == null) {
            return ' ';
        }
        if (object instanceof String) {
            if (((String)object).length() > 0) {
                return ((String)object).charAt(0);
            }
            return ' ';
        }
        throw new ConvertException("Primitive: Can not convert " + object.getClass().getName() + " to char");
    }

    public static Character convertToChar(Object object) {
        if (object == null) {
            return null;
        }
        Class<?> clazz = object.getClass();
        if (clazz == Character.class) {
            return (Character)object;
        }
        if (object instanceof String) {
            if (((String)object).length() > 0) {
                return Character.valueOf(((String)object).charAt(0));
            }
            return Character.valueOf(' ');
        }
        throw new ConvertException("Primitive: Can not convert " + object.getClass().getName() + " to Character");
    }

    public static boolean convertTobool(Object object) {
        if (object == null) {
            return false;
        }
        if (object.getClass() == Boolean.class) {
            return (Boolean)object;
        }
        if (object instanceof String) {
            return Boolean.parseBoolean((String)object);
        }
        if (object instanceof Number) {
            return !object.toString().equals("0");
        }
        throw new ConvertException("Primitive: Can not convert " + object.getClass().getName() + " to boolean");
    }

    public static Boolean convertToBool(Object object) {
        if (object == null) {
            return null;
        }
        Class<?> clazz = object.getClass();
        if (clazz == Boolean.class) {
            return (Boolean)object;
        }
        if (object instanceof String) {
            return Boolean.parseBoolean((String)object);
        }
        throw new ConvertException("Primitive: Can not convert " + object.getClass().getName() + " to Boolean");
    }
}

