/*
 * Decompiled with CFR 0.152.
 */
package me.casperge.realisticseasons.api;

import java.util.ArrayList;
import java.util.List;
import me.casperge.realisticseasons.RealisticSeasons;
import me.casperge.realisticseasons.api.SeasonBiome;
import me.casperge.realisticseasons.api.TemperatureEffect;
import me.casperge.realisticseasons.calendar.Date;
import me.casperge.realisticseasons.season.Season;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.entity.Player;

public class SeasonsAPI {
    private static SeasonsAPI api;
    private RealisticSeasons main;

    public SeasonsAPI(RealisticSeasons realisticSeasons) {
        api = this;
        this.main = realisticSeasons;
    }

    public Season getSeason(World world) {
        return this.main.getSeasonManager().getSeason(world);
    }

    public void setSeason(World world, Season season) {
        this.main.getSeasonManager().setSeason(world, season);
    }

    public static SeasonsAPI getInstance() {
        return api;
    }

    public void setDate(World world, Date date) {
        this.main.getTimeManager().setDate(world, date);
    }

    public int getAirTemperature(Location location) {
        return this.main.getTemperatureManager().getAirTemperature(location);
    }

    public Date getDate(World world) {
        return this.main.getTimeManager().getDate(world);
    }

    public String getDayOfWeek(World world) {
        if (!this.main.getSeasonManager().worldData.containsKey(world)) {
            return "DISABLED";
        }
        Date date = this.main.getTimeManager().getDate(world);
        if (date == null) {
            return "DISABLED";
        }
        return this.main.getTimeManager().getWeekDay(this.main.getTimeManager().getDate(world));
    }

    public String getCurrentMonthName(World world) {
        if (!this.main.getSeasonManager().worldData.containsKey(world)) {
            return "DISABLED";
        }
        Date date = this.main.getTimeManager().getDate(world);
        if (date == null) {
            return "DISABLED";
        }
        return this.main.getTimeManager().getCalendar().getMonth(this.main.getTimeManager().getDate(world).getMonth()).getName();
    }

    public int getTemperature(Player player) {
        return this.main.getTemperatureManager().getTemperature(player);
    }

    public int getMinutes(World world) {
        return this.main.getTimeManager().getMinutes(world);
    }

    public int getSeconds(World world) {
        return this.main.getTimeManager().getSeconds(world);
    }

    public int getHours(World world) {
        return this.main.getTimeManager().getHours(world);
    }

    public void applyTimedTemperatureEffect(Player player, int n, int n2) {
        this.main.getTemperatureManager().getTempData().applyCustomEffect(player, n, n2);
    }

    public TemperatureEffect applyPermanentTemperatureEffect(Player player, int n) {
        return this.main.getTemperatureManager().getTempData().applyPermanentEffect(player, n);
    }

    public List<String> getActiveEvents(World world) {
        return new ArrayList<String>(this.main.getEventManager().getActiveEvents(world));
    }

    public SeasonBiome getReplacementSeasonBiome(Biome biome, Season season) {
        String string = this.main.getNMSUtils().getBiomeName(biome);
        if (this.main.getSeasonBiomesForAPI().containsKey(string)) {
            return this.main.getSeasonBiomesForAPI().get(string);
        }
        return null;
    }

    public SeasonBiome getReplacementSeasonBiome(String string, Season season) {
        if (this.main.getSeasonBiomesForAPI().containsKey(string)) {
            return this.main.getSeasonBiomesForAPI().get(string);
        }
        return null;
    }

    public SeasonBiome getReplacementSeasonBiome(Location location, Season season) {
        String string = this.main.getNMSUtils().getBiomeName(location);
        if (this.main.getSeasonBiomesForAPI().containsKey(string)) {
            return this.main.getSeasonBiomesForAPI().get(string);
        }
        return null;
    }
}

