/*
 * Decompiled with CFR 0.152.
 */
package me.casperge.realisticseasons.blockscanner;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import me.casperge.realisticseasons.RealisticSeasons;
import me.casperge.realisticseasons.paperlib.PaperLib;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.ChunkSnapshot;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.data.type.Campfire;
import org.bukkit.block.data.type.Furnace;
import org.bukkit.plugin.Plugin;

public class ChunkSystem {
    private static final int[] UNEVEN = new int[]{1, 3, 5, 7, 9, 11, 13, 15, 17, 19, 21, 23, 25, 27, 29, 31, 33, 35, 37, 39, 41};
    private ChunkSnapshot[] sections;
    private String worldName;
    private int middleX;
    private int middleZ;
    private int range;
    public AtomicBoolean hasProcessed = new AtomicBoolean(false);
    private AtomicInteger count = new AtomicInteger(0);
    private AtomicInteger required = new AtomicInteger(0);
    private AtomicBoolean completedScan = new AtomicBoolean(false);
    private int minY;
    private int maxY;

    public ChunkSystem(Chunk chunk2, int n, int n2, int n3) {
        int n4 = UNEVEN[n] * UNEVEN[n];
        this.minY = n2;
        this.maxY = n3;
        this.range = n;
        this.sections = new ChunkSnapshot[n4];
        this.worldName = chunk2.getWorld().getName();
        this.middleX = chunk2.getX();
        this.middleZ = chunk2.getZ();
        World world = chunk2.getWorld();
        int n5 = 0;
        for (int i = 0; i < UNEVEN[n]; ++i) {
            for (int j = 0; j < UNEVEN[n]; ++j) {
                int n6 = this.middleX + i - n;
                int n7 = this.middleZ + j - n;
                if (n6 < 1875000 && n7 < 1875000 && n6 > -1875000 && n7 > -1875000) {
                    if (world.isChunkLoaded(n6, n7)) {
                        CompletableFuture<Chunk> completableFuture = PaperLib.getChunkAtAsync(world, this.middleX + i - n, this.middleZ + j - n);
                        final int n8 = n5;
                        this.required.getAndIncrement();
                        long l = System.currentTimeMillis();
                        completableFuture.thenAccept(chunk -> {
                            if (System.currentTimeMillis() - l < 2000L) {
                                Runnable runnable = new Runnable(){
                                    final /* synthetic */ Chunk val$c;
                                    {
                                        this.val$c = chunk;
                                    }

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    @Override
                                    public void run() {
                                        ChunkSnapshot[] chunkSnapshotArray = ChunkSystem.this.sections;
                                        synchronized (chunkSnapshotArray) {
                                            ((ChunkSystem)ChunkSystem.this).sections[n8] = this.val$c.getChunkSnapshot(false, false, false);
                                        }
                                        ChunkSystem.this.count.getAndIncrement();
                                        ChunkSystem.this.checkForCompletion();
                                    }
                                };
                                if (RealisticSeasons.getInstance().isPaper()) {
                                    Bukkit.getScheduler().runTaskAsynchronously((Plugin)RealisticSeasons.getInstance(), runnable);
                                } else {
                                    Bukkit.getScheduler().runTask((Plugin)RealisticSeasons.getInstance(), runnable);
                                }
                            }
                        });
                    } else {
                        this.sections[n5] = null;
                    }
                } else {
                    this.sections[n5] = null;
                }
                ++n5;
            }
        }
        this.completedScan.set(true);
        this.checkForCompletion();
    }

    public String getWorld() {
        return this.worldName;
    }

    private void checkForCompletion() {
        if (this.completedScan.get() && this.required.get() == this.count.get()) {
            this.hasProcessed.set(true);
        }
    }

    public Material getBlockType(int n, int n2, int n3) {
        Furnace furnace;
        Campfire campfire;
        Material material;
        int n4 = n & 0xF;
        int n5 = n3 & 0xF;
        if (n2 < this.minY || n2 > this.maxY) {
            return Material.AIR;
        }
        int n6 = n - n4 >> 4;
        int n7 = n3 - n5 >> 4;
        ChunkSnapshot chunkSnapshot = this.getSnapshotAtWorldLocation(n6, n7);
        if (chunkSnapshot == null) {
            return Material.AIR;
        }
        try {
            material = chunkSnapshot.getBlockType(n4, n2, n5);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return Material.AIR;
        }
        if (material.equals((Object)Material.CAMPFIRE) || material.equals((Object)Material.SOUL_CAMPFIRE) ? !(campfire = (Campfire)chunkSnapshot.getBlockData(n4, n2, n5)).isLit() : (material.equals((Object)Material.FURNACE) || material.equals((Object)Material.BLAST_FURNACE)) && !(furnace = (Furnace)chunkSnapshot.getBlockData(n4, n2, n5)).isLit()) {
            return Material.AIR;
        }
        return chunkSnapshot.getBlockType(n4, n2, n5);
    }

    private ChunkSnapshot getSnapshotAtWorldLocation(int n, int n2) {
        int n3 = n - this.middleX;
        int n4 = n2 - this.middleZ;
        int n5 = (n3 + this.range) * UNEVEN[this.range] + (n4 + this.range);
        if (n5 < 0 || n5 > this.sections.length - 1) {
            return null;
        }
        return this.sections[n5];
    }
}

