/*
 * Decompiled with CFR 0.152.
 */
package me.casperge.realisticseasons.calendar;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import me.casperge.realisticseasons.RealisticSeasons;
import me.casperge.realisticseasons.calendar.Calendar;
import me.casperge.realisticseasons.calendar.Date;
import me.casperge.realisticseasons.calendar.DayChangeEvent;
import me.casperge.realisticseasons.calendar.DayChangeHandler;
import me.casperge.realisticseasons.calendar.Month;
import me.casperge.realisticseasons.calendar.Time;
import me.casperge.realisticseasons.data.CalendarFileLoader;
import me.casperge.realisticseasons.season.Season;
import me.casperge.realisticseasons.season.SubSeason;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.event.Event;

public class TimeManager {
    private Calendar calendar;
    private RealisticSeasons main;
    private HashMap<World, Date> dates = new HashMap();
    private List<World> disabledWorlds = new ArrayList<World>();
    private boolean useSystemTime = true;

    public TimeManager(RealisticSeasons realisticSeasons) {
        this.main = realisticSeasons;
        this.load();
        new DayChangeHandler(realisticSeasons);
    }

    public ZonedDateTime getCurrentZonedDateTime() {
        if (this.useSystemTime) {
            LocalDateTime localDateTime = LocalDateTime.now();
            ZonedDateTime zonedDateTime = localDateTime.atZone(ZoneId.systemDefault());
            return zonedDateTime;
        }
        ZonedDateTime zonedDateTime = ZonedDateTime.now().withZoneSameInstant(ZoneId.of(this.main.getSettings().timezone));
        return zonedDateTime;
    }

    public void load() {
        this.calendar = new CalendarFileLoader(this.main).load();
        if (!this.main.getSettings().timezone.equalsIgnoreCase("system")) {
            this.useSystemTime = false;
        }
    }

    public void addToDatesRegister(HashMap<World, Date> hashMap) {
        for (World world : hashMap.keySet()) {
            this.dates.put(world, hashMap.get(world));
        }
    }

    public void nextDay(World world) {
        Date date = this.dates.get(world);
        Date date2 = this.calendar.getNextDate(date);
        DayChangeEvent dayChangeEvent = new DayChangeEvent(world, date, date2);
        Bukkit.getPluginManager().callEvent((Event)dayChangeEvent);
        this.dates.replace(world, date2);
    }

    public void setDate(World world, Date date) {
        if (!this.dates.containsKey(world)) {
            this.dates.put(world, date);
            return;
        }
        Date date2 = this.dates.get(world);
        DayChangeEvent dayChangeEvent = new DayChangeEvent(world, date2, date);
        Bukkit.getPluginManager().callEvent((Event)dayChangeEvent);
        this.dates.replace(world, date);
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    public HashMap<World, Date> getDates() {
        return this.dates;
    }

    public boolean hasTime(World world) {
        return !this.disabledWorlds.contains(world);
    }

    public void resumeTime(World world) {
        if (!this.hasTime(world)) {
            this.disabledWorlds.remove(world);
        }
    }

    public void pauseTime(World world) {
        if (this.hasTime(world)) {
            this.disabledWorlds.add(world);
        }
    }

    public List<World> getPausedWorlds() {
        return this.disabledWorlds;
    }

    public String getWeekDay(Date date) {
        if (this.main.getSettings().syncWorldTimeWithRealWorld) {
            int n = this.getCurrentZonedDateTime().getDayOfWeek().getValue() - 1;
            if (n == -1) {
                n = 6;
            }
            return this.calendar.getWeekDay(n);
        }
        return this.calendar.getWeekDay(date);
    }

    public int getWeekDayAsInt(Date date, boolean bl) {
        if (this.main.getSettings().syncWorldTimeWithRealWorld) {
            int n = this.getCurrentZonedDateTime().getDayOfWeek().getValue() - 1;
            if (n == -1) {
                n = 6;
            }
            if (bl && --n == -1) {
                n = 6;
            }
            return n;
        }
        return this.calendar.getWeekDayAsInt(date);
    }

    public Date getDate(World world) {
        if (this.main.getSettings().syncWorldTimeWithRealWorld) {
            return this.currentDateFromCalendar();
        }
        return this.dates.get(world);
    }

    public Date currentDateFromCalendar() {
        ZonedDateTime zonedDateTime = this.getCurrentZonedDateTime();
        return new Date(zonedDateTime.getDayOfMonth(), zonedDateTime.getMonthValue(), zonedDateTime.getYear());
    }

    public int getDaysUntilNextSeason(World world) {
        return this.main.getTimeManager().getCalendar().getDaysUntil(this.main.getTimeManager().getDate(world), this.main.getTimeManager().getCalendar().getSeasonStart(this.main.getSeasonManager().getSeason(world).getNextSeason()));
    }

    public int getTotalDays(Season season) {
        return this.main.getTimeManager().getCalendar().getDaysUntil(this.main.getTimeManager().getCalendar().getSeasonStart(season), this.main.getTimeManager().getCalendar().getSeasonStart(season.getNextSeason()));
    }

    public int getSeconds(World world) {
        if (this.main.getSettings().syncWorldTimeWithRealWorld) {
            return this.getCurrentZonedDateTime().getSecond();
        }
        if (!this.main.getSettings().affectTime || this.main.getSeasonManager().getSeason(world) == Season.DISABLED || this.main.getSeasonManager().getSeason(world) == Season.RESTORE) {
            return Time.getSeconds(world, 1.0, 1.0);
        }
        Month month = this.calendar.getMonth(this.getDate(world).getMonth());
        return Time.getSeconds(world, month.getDayLengthMultiplier(), month.getNightLengthMultiplier());
    }

    public int getHours(World world) {
        if (this.main.getSettings().syncWorldTimeWithRealWorld) {
            return this.getCurrentZonedDateTime().getHour();
        }
        if (!this.main.getSettings().affectTime || this.main.getSeasonManager().getSeason(world) == Season.DISABLED || this.main.getSeasonManager().getSeason(world) == Season.RESTORE) {
            return Time.getHours(world, 1.0, 1.0);
        }
        Month month = this.calendar.getMonth(this.getDate(world).getMonth());
        return Time.getHours(world, month.getDayLengthMultiplier(), month.getNightLengthMultiplier());
    }

    public int getMinutes(World world) {
        if (this.main.getSettings().syncWorldTimeWithRealWorld) {
            return this.getCurrentZonedDateTime().getMinute();
        }
        if (!this.main.getSettings().affectTime || this.main.getSeasonManager().getSeason(world) == Season.DISABLED || this.main.getSeasonManager().getSeason(world) == Season.RESTORE) {
            return Time.getMinutes(world, 1.0, 1.0);
        }
        Month month = this.calendar.getMonth(this.getDate(world).getMonth());
        return Time.getMinutes(world, month.getDayLengthMultiplier(), month.getNightLengthMultiplier());
    }

    public String getTimeAsString(World world) {
        String string = this.main.getSettings().timeFormat;
        String string2 = this.main.getTimeManager().getHours(world) <= 11 ? "AM" : "PM";
        String string3 = String.valueOf(this.main.getTimeManager().getSeconds(world));
        String string4 = String.valueOf(this.main.getTimeManager().getMinutes(world));
        if (string3.length() == 1) {
            string3 = "0" + string3;
        }
        if (string4.length() == 1) {
            string4 = "0" + string4;
        }
        string = string.replaceAll("\\$seconds\\$", string3);
        string = string.replaceAll("\\$minutes\\$", string4);
        if (this.main.getSettings().is12hourClock) {
            String string5 = String.valueOf((this.main.getTimeManager().getHours(world) + 11) % 12 + 1);
            if (string5.length() == 1) {
                string5 = "0" + string5;
            }
            string = string.replaceAll("\\$hours\\$", string5);
            if (this.main.getSettings().AmPm) {
                string = string + " " + string2;
            }
        } else {
            String string6 = String.valueOf(this.main.getTimeManager().getHours(world));
            if (string6.length() == 1) {
                string6 = "0" + string6;
            }
            string = string.replaceAll("\\$hours\\$", string6);
        }
        return string;
    }

    public SubSeason getCorrectSubSeason(World world) {
        Date date = this.getDate(world);
        if (date == null) {
            return SubSeason.MIDDLE;
        }
        Long l = world.getFullTime() % 24000L;
        double d2 = this.getSeasonProgressPercentage(date, l);
        if (d2 < 9.0) {
            return SubSeason.START;
        }
        if (d2 >= 9.0 && d2 < 18.0) {
            return SubSeason.EARLY;
        }
        if (d2 >= 18.0 && d2 < 84.0) {
            return SubSeason.MIDDLE;
        }
        if (d2 >= 84.0 && d2 < 92.0) {
            return SubSeason.LATE;
        }
        if (d2 >= 92.0) {
            return SubSeason.END;
        }
        return SubSeason.MIDDLE;
    }

    public double getSeasonProgressPercentage(Date date, Long l) {
        Season season = this.calendar.getSeason(date);
        int n = this.getTotalDays(season);
        int n2 = this.calendar.getDaysUntil(date, this.main.getTimeManager().getCalendar().getSeasonStart(season.getNextSeason()));
        int n3 = n - n2;
        Long l2 = (long)n * 24000L;
        Long l3 = (long)n3 * 24000L + l;
        return (double)l3.longValue() / (double)l2.longValue() * 100.0;
    }

    public Date getHalfwaySeason(Season season) {
        Date date = this.getCalendar().getSeasonStart(season);
        int n = this.getTotalDays(season);
        int n2 = n / 2;
        Date date2 = null;
        for (int i = 0; i < n2; ++i) {
            date2 = i == 0 ? this.getCalendar().getNextDate(date) : this.getCalendar().getNextDate(date2);
        }
        return date2;
    }
}

