/*
 * Decompiled with CFR 0.152.
 */
package me.casperge.realisticseasons.commands;

import me.casperge.realisticseasons.RealisticSeasons;
import me.casperge.realisticseasons.data.LanguageManager;
import me.casperge.realisticseasons.data.MessageType;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffectType;

public class ToggleTemperatureCommand
implements CommandExecutor {
    public RealisticSeasons main;

    public ToggleTemperatureCommand(RealisticSeasons realisticSeasons) {
        this.main = realisticSeasons;
    }

    public boolean onCommand(CommandSender commandSender, Command command, String string, String[] stringArray) {
        if (commandSender instanceof Player) {
            Player player = (Player)commandSender;
            if (stringArray.length < 1 || !player.hasPermission("realisticseasons.toggletemperature.others")) {
                if (player.hasPermission("realisticseasons.toggletemperature")) {
                    if (!this.main.getTemperatureManager().hasTemperature(player)) {
                        this.main.getTemperatureManager().enableTemperature(player);
                        player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)LanguageManager.messages.get((Object)MessageType.TOGGLETEMPERATURECOMMAND).replaceAll("\\$status\\$", LanguageManager.messages.get((Object)MessageType.ENABLED))));
                    } else {
                        this.main.getTemperatureManager().disableTemperature(player);
                        for (PotionEffectType potionEffectType : this.main.getTemperatureManager().getTempData().getTempSettings().getBoostPotionEffects()) {
                            if (!player.hasPotionEffect(potionEffectType)) continue;
                            player.removePotionEffect(potionEffectType);
                        }
                        player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)LanguageManager.messages.get((Object)MessageType.TOGGLETEMPERATURECOMMAND).replaceAll("\\$status\\$", LanguageManager.messages.get((Object)MessageType.DISABLED))));
                    }
                } else {
                    player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)LanguageManager.messages.get((Object)MessageType.NO_PERMISSION)));
                }
            } else {
                Player player2 = Bukkit.getPlayer((String)stringArray[0]);
                if (player2 == null) {
                    player.sendMessage(ChatColor.RED + "ERROR: Could not find that player");
                    return true;
                }
                if (!this.main.getTemperatureManager().hasTemperature(player2)) {
                    this.main.getTemperatureManager().enableTemperature(player2);
                    player.sendMessage(ChatColor.GREEN + "Enabled temperature for " + player2.getName());
                } else {
                    this.main.getTemperatureManager().disableTemperature(player2);
                    for (PotionEffectType potionEffectType : this.main.getTemperatureManager().getTempData().getTempSettings().getBoostPotionEffects()) {
                        if (!player2.hasPotionEffect(potionEffectType)) continue;
                        player2.removePotionEffect(potionEffectType);
                    }
                    player.sendMessage(ChatColor.GREEN + "Disabled temperature for " + player2.getName());
                }
            }
        } else if (commandSender instanceof ConsoleCommandSender) {
            if (stringArray.length < 1) {
                Bukkit.getLogger().info("Usage: /toggletemperature <player>");
            } else {
                Player player = Bukkit.getPlayer((String)stringArray[0]);
                if (player == null) {
                    Bukkit.getLogger().info("ERROR: player not found");
                } else if (!this.main.getTemperatureManager().hasTemperature(player)) {
                    this.main.getTemperatureManager().enableTemperature(player);
                    Bukkit.getLogger().info("Enabled temperature for " + player.getName());
                } else {
                    this.main.getTemperatureManager().disableTemperature(player);
                    Bukkit.getLogger().info("Disabled temperature for " + player.getName());
                    for (PotionEffectType potionEffectType : this.main.getTemperatureManager().getTempData().getTempSettings().getBoostPotionEffects()) {
                        if (!player.hasPotionEffect(potionEffectType)) continue;
                        player.removePotionEffect(potionEffectType);
                    }
                }
            }
        }
        return true;
    }
}

