/*
 * Decompiled with CFR 0.152.
 */
package me.casperge.realisticseasons.data.chunksaver;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import me.casperge.realisticseasons.RealisticSeasons;
import me.casperge.realisticseasons.season.SeasonChunk;
import org.apache.commons.io.FileUtils;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

public class AsyncDataSaver {
    private List<SeasonChunk> saveQueue = new ArrayList<SeasonChunk>();
    private List<SeasonChunk> deleteQueue = new ArrayList<SeasonChunk>();
    File dataFile;
    RealisticSeasons main;
    YamlConfiguration data;

    public AsyncDataSaver(RealisticSeasons realisticSeasons) {
        this.dataFile = new File(realisticSeasons.getDataFolder(), "chunkdata.yml");
        this.main = realisticSeasons;
        if (!this.dataFile.exists()) {
            try {
                InputStream inputStream = realisticSeasons.getResource("chunkdata.yml");
                FileUtils.copyInputStreamToFile(inputStream, this.dataFile);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        this.data = YamlConfiguration.loadConfiguration((File)this.dataFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tick() {
        List<SeasonChunk> list = this.saveQueue;
        synchronized (list) {
            if (!this.saveQueue.isEmpty()) {
                for (SeasonChunk seasonChunk : this.saveQueue) {
                    this.save(seasonChunk);
                }
                this.saveQueue.clear();
            }
        }
        list = this.deleteQueue;
        synchronized (list) {
            if (!this.deleteQueue.isEmpty()) {
                for (SeasonChunk seasonChunk : this.deleteQueue) {
                    this.delete(seasonChunk);
                }
                this.deleteQueue.clear();
            }
        }
        try {
            this.data.save(this.dataFile);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void save(SeasonChunk seasonChunk) {
        if (seasonChunk != null) {
            this.data.set("chunkdata." + seasonChunk.getWorldName() + "." + String.valueOf(seasonChunk.getX()) + "." + String.valueOf(seasonChunk.getZ()), (Object)"1");
        }
    }

    private void delete(SeasonChunk seasonChunk) {
        if (seasonChunk != null) {
            this.data.set("chunkdata." + seasonChunk.getWorldName() + "." + String.valueOf(seasonChunk.getX()) + "." + String.valueOf(seasonChunk.getZ()), null);
        }
    }

    public SeasonChunk getRandomChunk(String string) {
        ConfigurationSection configurationSection;
        SeasonChunk seasonChunk = null;
        ConfigurationSection configurationSection2 = this.data.getConfigurationSection("chunkdata." + string);
        if (configurationSection2 != null && configurationSection2.getKeys(false).size() != 0 && (configurationSection = this.data.getConfigurationSection("chunkdata." + string + "." + String.valueOf(configurationSection2.getKeys(false).toArray()[0]))) != null) {
            if (configurationSection.getKeys(false).size() != 0) {
                String[] stringArray;
                String string2 = configurationSection.getCurrentPath() + "." + String.valueOf(configurationSection.getKeys(false).toArray()[0]);
                if (this.data.isString(string2) && (stringArray = string2.split("\\.")).length == 4) {
                    String string3 = stringArray[2];
                    String string4 = stringArray[3];
                    Integer n = Integer.valueOf(string3);
                    Integer n2 = Integer.valueOf(string4);
                    if (n != null && n2 != null) {
                        seasonChunk = new SeasonChunk(string, n, n2, 0L);
                    }
                }
            } else {
                this.data.set(configurationSection.getCurrentPath(), null);
            }
        }
        return seasonChunk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveChunk(SeasonChunk seasonChunk) {
        List<SeasonChunk> list = this.saveQueue;
        synchronized (list) {
            this.saveQueue.add(seasonChunk);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteChunk(SeasonChunk seasonChunk) {
        List<SeasonChunk> list = this.deleteQueue;
        synchronized (list) {
            this.deleteQueue.add(seasonChunk);
        }
    }

    public Set<String> getWorlds() {
        Set set = null;
        ConfigurationSection configurationSection = this.data.getConfigurationSection("chunkdata");
        if (configurationSection != null) {
            set = this.data.getConfigurationSection("chunkdata").getKeys(false);
        }
        return set;
    }
}

