/*
 * Decompiled with CFR 0.152.
 */
package me.casperge.realisticseasons.event;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import me.casperge.realisticseasons.RealisticSeasons;
import me.casperge.realisticseasons.biome.BiomeUtils;
import me.casperge.realisticseasons.commands.ToggleSeasonsCommand;
import me.casperge.realisticseasons.season.Season;
import me.casperge.realisticseasons.season.SubSeason;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import world.ofunny.bpm.Floodgate.FloodgateAPI;

public class ChunkPacketEventProtocolLib {
    public ChunkPacketEventProtocolLib(final RealisticSeasons realisticSeasons) {
        ProtocolLibrary.getProtocolManager().addPacketListener((PacketListener)new PacketAdapter((Plugin)realisticSeasons, new PacketType[]{PacketType.Play.Server.MAP_CHUNK}){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void onPacketSending(PacketEvent packetEvent) {
                PacketContainer packetContainer = packetEvent.getPacket();
                Player player = packetEvent.getPlayer();
                if (packetEvent.getPacketType() != PacketType.Play.Server.MAP_CHUNK || !realisticSeasons.getSettings().affectBiomes) return;
                int n = (Integer)packetContainer.getIntegers().read(0);
                int n2 = (Integer)packetContainer.getIntegers().read(1);
                Season season = realisticSeasons.getSeasonManager().getSeason(player.getWorld());
                SubSeason subSeason = SubSeason.MIDDLE;
                if ((season == Season.FALL || season == Season.WINTER || season == Season.SPRING || season == Season.SUMMER) && (subSeason = realisticSeasons.getSeasonManager().getSubSeason(player.getWorld())) == null) {
                    realisticSeasons.getSeasonManager().runSubSeasonCheck();
                    subSeason = realisticSeasons.getSeasonManager().getSubSeason(player.getWorld());
                    if (subSeason == null) {
                        subSeason = SubSeason.MIDDLE;
                    }
                }
                if (!realisticSeasons.hasSeasons(n, n2, player.getWorld())) {
                    if (!realisticSeasons.hasWorldGuard()) return;
                    if (realisticSeasons.getWorldGuardAPI().getPermanentSeason(n, n2, player.getWorld()) == Season.DISABLED) return;
                    season = realisticSeasons.getWorldGuardAPI().getPermanentSeason(n, n2, player.getWorld());
                }
                if (ToggleSeasonsCommand.disabled.contains(player.getUniqueId())) {
                    return;
                }
                if (season == Season.WINTER) {
                    if (FloodgateAPI.get().isBedrockPlayer(player) || !realisticSeasons.supportsCustomBiomes(player)) {
                        int[] nArray = (int[])packetContainer.getIntegerArrays().read(0);
                        for (int i = 0; i < ((int[])packetContainer.getIntegerArrays().read(0)).length; ++i) {
                            nArray[i] = 11;
                        }
                        packetContainer.getIntegerArrays().write(0, (Object)nArray);
                        return;
                    }
                    packetContainer.getIntegerArrays().write(0, (Object)BiomeUtils.updateBiomes((int[])packetContainer.getIntegerArrays().read(0), Season.WINTER.intValue(), subSeason.getPhase(), n, n2));
                    return;
                }
                if (season == Season.FALL) {
                    if (FloodgateAPI.get().isBedrockPlayer(player) || !realisticSeasons.supportsCustomBiomes(player)) {
                        int[] nArray = (int[])packetContainer.getIntegerArrays().read(0);
                        for (int i = 0; i < ((int[])packetContainer.getIntegerArrays().read(0)).length; ++i) {
                            nArray[i] = 35;
                        }
                        packetContainer.getIntegerArrays().write(0, (Object)nArray);
                        return;
                    }
                    packetContainer.getIntegerArrays().write(0, (Object)BiomeUtils.updateBiomes((int[])packetContainer.getIntegerArrays().read(0), Season.FALL.intValue(), subSeason.getPhase(), n, n2));
                    return;
                }
                if (season == Season.SPRING) {
                    if (FloodgateAPI.get().isBedrockPlayer(player) || !realisticSeasons.supportsCustomBiomes(player)) {
                        return;
                    }
                    packetContainer.getIntegerArrays().write(0, (Object)BiomeUtils.updateBiomes((int[])packetContainer.getIntegerArrays().read(0), Season.SPRING.intValue(), subSeason.getPhase(), n, n2));
                    return;
                }
                if (season != Season.SUMMER) return;
                if (FloodgateAPI.get().isBedrockPlayer(player) || !realisticSeasons.supportsCustomBiomes(player)) {
                    return;
                }
                packetContainer.getIntegerArrays().write(0, (Object)BiomeUtils.updateBiomes((int[])packetContainer.getIntegerArrays().read(0), Season.SUMMER.intValue(), subSeason.getPhase(), n, n2));
            }
        });
    }
}

