/*
 * Decompiled with CFR 0.152.
 */
package me.casperge.realisticseasons.event;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import me.casperge.realisticseasons.RealisticSeasons;
import me.casperge.realisticseasons.api.CustomBiomeFileLoader;
import me.casperge.realisticseasons.api.CustomWorldGenerator;
import me.casperge.realisticseasons.season.Season;
import me.casperge.realisticseasons.utils.JavaUtils;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Illager;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.EntityBlockFormEvent;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDamageByBlockEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class EntityEvents
implements Listener {
    private RealisticSeasons main;
    private Random r = new Random();
    private EntityType[] animals = new EntityType[]{EntityType.CHICKEN, EntityType.COW, EntityType.PIG, EntityType.SHEEP};
    private HashMap<EntityType, Material[]> tamingMaterials = new HashMap();
    private List<UUID> alreadyMessagedForCustomGenerator = new ArrayList<UUID>();
    private final String[] countriesWithFahrenheit = new String[]{"US", "LR", "BZ", "BS", "FM", "AG", "KY", "BM", "MH", "KN", "TC", "VG", "PW", "MS"};

    public EntityEvents(RealisticSeasons realisticSeasons) {
        realisticSeasons.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)realisticSeasons);
        this.main = realisticSeasons;
        this.tamingMaterials.put(EntityType.SHEEP, new Material[]{Material.WHEAT});
        this.tamingMaterials.put(EntityType.COW, new Material[]{Material.WHEAT});
        this.tamingMaterials.put(EntityType.MUSHROOM_COW, new Material[]{Material.WHEAT});
        this.tamingMaterials.put(EntityType.PIG, new Material[]{Material.CARROT, Material.POTATO, Material.BEETROOT});
        this.tamingMaterials.put(EntityType.CHICKEN, new Material[]{Material.WHEAT_SEEDS, Material.PUMPKIN_SEEDS, Material.MELON_SEEDS, Material.BEETROOT_SEEDS});
        this.tamingMaterials.put(EntityType.OCELOT, new Material[]{Material.SALMON, Material.COD});
        this.tamingMaterials.put(EntityType.RABBIT, new Material[]{Material.DANDELION, Material.CARROT, Material.GOLDEN_CARROT});
        this.tamingMaterials.put(EntityType.PANDA, new Material[]{Material.BAMBOO});
        this.tamingMaterials.put(EntityType.FOX, new Material[]{Material.SWEET_BERRIES});
        this.tamingMaterials.put(EntityType.BEE, new Material[]{Material.DANDELION, Material.POPPY, Material.BLUE_ORCHID, Material.ALLIUM, Material.AZURE_BLUET, Material.RED_TULIP, Material.ORANGE_TULIP, Material.WHITE_TULIP, Material.PINK_TULIP, Material.OXEYE_DAISY, Material.CORNFLOWER, Material.LILY_OF_THE_VALLEY, Material.WITHER_ROSE, Material.SUNFLOWER, Material.LILAC, Material.ROSE_BUSH, Material.PEONY});
    }

    @EventHandler
    public void onDrink(PlayerItemConsumeEvent playerItemConsumeEvent) {
        if (playerItemConsumeEvent.getItem().getType() == Material.POTION) {
            this.main.getTemperatureManager().getTempData().drinked(playerItemConsumeEvent.getPlayer());
        }
    }

    @EventHandler
    public void onHeal(EntityRegainHealthEvent entityRegainHealthEvent) {
        if (entityRegainHealthEvent.getEntity() instanceof Player && !this.main.getTemperatureManager().canHeal((Player)entityRegainHealthEvent.getEntity())) {
            entityRegainHealthEvent.setCancelled(true);
        }
    }

    @EventHandler
    public void onLogin(final PlayerLoginEvent playerLoginEvent) {
        if (!this.main.getTemperatureManager().getTempData().isEnabled()) {
            return;
        }
        if (!this.main.getTemperatureManager().hasPlayedBefore(playerLoginEvent.getPlayer().getUniqueId())) {
            this.main.getTemperatureManager().loggedIn(playerLoginEvent.getPlayer().getUniqueId());
            Bukkit.getScheduler().runTask((Plugin)this.main, new Runnable(){

                @Override
                public void run() {
                    final boolean bl = EntityEvents.this.main.getTemperatureManager().getTempData().getTempSettings().isConvertToFahrenheit();
                    if (EntityEvents.this.main.getTemperatureManager().getTempData().isEnabled() && EntityEvents.this.main.getTemperatureManager().getTempData().getTempSettings().isIpBasedTemperature()) {
                        Bukkit.getScheduler().runTaskAsynchronously((Plugin)EntityEvents.this.main, new Runnable(){

                            @Override
                            public void run() {
                                String string = JavaUtils.getGeoLocationCountryCode(playerLoginEvent.getAddress().getHostAddress());
                                if (string == null) {
                                    return;
                                }
                                boolean bl2 = false;
                                for (String string2 : EntityEvents.this.countriesWithFahrenheit) {
                                    if (!string2.equals(string)) continue;
                                    bl2 = true;
                                    break;
                                }
                                if (bl2 && !bl || !bl2 && bl) {
                                    Bukkit.getScheduler().runTask((Plugin)EntityEvents.this.main, new Runnable(){

                                        @Override
                                        public void run() {
                                            EntityEvents.this.main.getTemperatureManager().toggleFahrenheit(playerLoginEvent.getPlayer().getUniqueId());
                                        }
                                    });
                                }
                            }
                        });
                    }
                }
            });
        }
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent playerJoinEvent) {
        if (playerJoinEvent.getPlayer().hasPermission("realisticseasons.admin") && !this.alreadyMessagedForCustomGenerator.contains(playerJoinEvent.getPlayer().getUniqueId())) {
            this.alreadyMessagedForCustomGenerator.add(playerJoinEvent.getPlayer().getUniqueId());
            List<CustomWorldGenerator> list = CustomBiomeFileLoader.getActiveGenerators();
            List<CustomWorldGenerator> list2 = CustomBiomeFileLoader.getAlreadyInstalledGenerators();
            ArrayList<CustomWorldGenerator> arrayList = new ArrayList<CustomWorldGenerator>();
            for (CustomWorldGenerator customWorldGenerator : list) {
                if (list2.contains((Object)customWorldGenerator)) continue;
                arrayList.add(customWorldGenerator);
            }
            if (!arrayList.isEmpty()) {
                playerJoinEvent.getPlayer().sendMessage(ChatColor.DARK_GREEN + "[RealisticSeasons]" + ChatColor.GREEN + " Supported world generator detected. Install the required config files by running: ");
                for (CustomWorldGenerator customWorldGenerator : arrayList) {
                    playerJoinEvent.getPlayer().sendMessage(ChatColor.AQUA + "/rs install " + customWorldGenerator.toString());
                }
            }
            if (this.main.isFreshInstall && this.main.getSeasonManager().worldData.isEmpty()) {
                this.main.isFreshInstall = false;
                playerJoinEvent.getPlayer().sendMessage(ChatColor.DARK_GREEN + "[RealisticSeasons]" + ChatColor.GREEN + " thank you for installing RealisticSeasons. Get started by running" + ChatColor.DARK_GREEN + " /rs set <season>");
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onMobSpawn(CreatureSpawnEvent creatureSpawnEvent) {
        Season season;
        if (creatureSpawnEvent.getSpawnReason() == CreatureSpawnEvent.SpawnReason.NATURAL && creatureSpawnEvent.getLocation().getWorld().getEnvironment() != World.Environment.NETHER && creatureSpawnEvent.getLocation().getWorld().getEnvironment() != World.Environment.THE_END && (season = this.main.getSeasonManager().getSeason(creatureSpawnEvent.getLocation().getWorld())) != Season.DISABLED) {
            if (season == Season.FALL && creatureSpawnEvent.getEntity() instanceof Mob && this.main.getSettings().pumpkinsInFall && creatureSpawnEvent.getEntity() instanceof LivingEntity && Math.random() * 100.0 < (double)this.main.getSettings().pumpkinchance && !(creatureSpawnEvent.getEntity() instanceof Illager)) {
                LivingEntity livingEntity = creatureSpawnEvent.getEntity();
                livingEntity.getEquipment().setHelmet(new ItemStack(Material.CARVED_PUMPKIN, 1));
            }
            if (creatureSpawnEvent.getEntityType() == EntityType.ZOMBIE || creatureSpawnEvent.getEntityType() == EntityType.SKELETON || creatureSpawnEvent.getEntityType() == EntityType.CREEPER || creatureSpawnEvent.getEntityType() == EntityType.SPIDER) {
                if (season == Season.SUMMER && this.main.getSettings().spawnHusksInSummer) {
                    if (creatureSpawnEvent.getEntityType() == EntityType.ZOMBIE && this.r.nextInt(10) != 0) {
                        creatureSpawnEvent.setCancelled(true);
                        creatureSpawnEvent.getLocation().getWorld().spawnEntity(creatureSpawnEvent.getLocation(), EntityType.HUSK);
                    }
                } else if (season == Season.FALL) {
                    if (this.main.getSettings().spawnCaveSpidersInFall && creatureSpawnEvent.getEntityType() == EntityType.SPIDER && this.r.nextInt(3) == 1) {
                        creatureSpawnEvent.setCancelled(true);
                        creatureSpawnEvent.getLocation().getWorld().spawnEntity(creatureSpawnEvent.getLocation(), EntityType.CAVE_SPIDER);
                    } else if (this.main.getSettings().spawnExtraSpidersInFall && this.r.nextInt(2) == 0 && creatureSpawnEvent.getEntityType() == EntityType.SPIDER) {
                        creatureSpawnEvent.getLocation().getWorld().spawnEntity(creatureSpawnEvent.getLocation(), EntityType.SPIDER);
                    }
                    if (this.main.getSettings().spawnBatsInFall && this.r.nextInt(5) == 0) {
                        creatureSpawnEvent.getLocation().getWorld().spawnEntity(creatureSpawnEvent.getLocation().add(0.0, 1.0, 0.0), EntityType.BAT);
                    }
                    if (creatureSpawnEvent.getEntityType() == EntityType.SPIDER && this.main.getSettings().spawnExtraSpidersInFall && this.r.nextInt(3) == 0) {
                        creatureSpawnEvent.getLocation().getWorld().spawnEntity(creatureSpawnEvent.getLocation(), EntityType.SPIDER);
                    }
                } else if (season == Season.WINTER && this.main.getSettings().spawnStraysInWinter && creatureSpawnEvent.getEntityType() == EntityType.SKELETON && this.r.nextInt(10) != 0) {
                    creatureSpawnEvent.setCancelled(true);
                    creatureSpawnEvent.getLocation().getWorld().spawnEntity(creatureSpawnEvent.getLocation(), EntityType.STRAY);
                }
            }
        }
    }

    @EventHandler
    public void EntityDamage(EntityDamageEvent entityDamageEvent) {
        if (entityDamageEvent.getEntity().getType() == EntityType.SNOWMAN && entityDamageEvent.getCause() == EntityDamageEvent.DamageCause.DROWNING) {
            entityDamageEvent.setCancelled(true);
        }
    }

    @EventHandler
    public void snow(EntityBlockFormEvent entityBlockFormEvent) {
        if (entityBlockFormEvent.getEntity().getType() == EntityType.SNOWMAN) {
            if (entityBlockFormEvent.getEntity().getScoreboardTags().contains("seasonal")) {
                entityBlockFormEvent.setCancelled(true);
            } else if (this.main.getSettings().snowmanCantPlaceSnow) {
                entityBlockFormEvent.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onSnowball(ProjectileLaunchEvent projectileLaunchEvent) {
        if (projectileLaunchEvent.getEntityType() == EntityType.SNOWBALL) {
            if (projectileLaunchEvent.getEntity().getShooter() == null) {
                return;
            }
            if (!(projectileLaunchEvent.getEntity().getShooter() instanceof Entity)) {
                return;
            }
            Entity entity = (Entity)projectileLaunchEvent.getEntity().getShooter();
            if (entity.getType() == EntityType.SNOWMAN && entity.getScoreboardTags().contains("seasonal") && !this.main.getSettings().snowmanAttackMobs) {
                projectileLaunchEvent.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onTarget(EntityTargetEvent entityTargetEvent) {
        if (entityTargetEvent.getEntityType() == EntityType.SNOWMAN) {
            if (entityTargetEvent.getEntity().getScoreboardTags().contains("seasonal") && !this.main.getSettings().snowmanAttackMobs) {
                entityTargetEvent.setCancelled(true);
            }
        } else if ((entityTargetEvent.getEntityType() == EntityType.WOLF || entityTargetEvent.getEntityType() == EntityType.FOX) && entityTargetEvent.getEntity().getScoreboardTags().contains("seasonal")) {
            if (entityTargetEvent.getTarget() == null) {
                return;
            }
            if (entityTargetEvent.getEntityType() == EntityType.WOLF && entityTargetEvent.getTarget().getType() != EntityType.SHEEP) {
                return;
            }
            entityTargetEvent.setCancelled(true);
        }
    }

    @EventHandler
    public void onDamage(EntityDamageByBlockEvent entityDamageByBlockEvent) {
        if (entityDamageByBlockEvent.getDamager() == null) {
            return;
        }
        if (entityDamageByBlockEvent.getDamager().getType() == Material.SWEET_BERRY_BUSH && !(entityDamageByBlockEvent.getEntity() instanceof Player) && !this.main.getSettings().doBerryDamage) {
            entityDamageByBlockEvent.setCancelled(true);
        }
    }

    @EventHandler
    public void entityFeedEvent(PlayerInteractAtEntityEvent playerInteractAtEntityEvent) {
        boolean bl = false;
        for (EntityType entityType : this.animals) {
            if (entityType != playerInteractAtEntityEvent.getRightClicked().getType()) continue;
            bl = true;
        }
        if (bl && playerInteractAtEntityEvent.getRightClicked().getScoreboardTags().contains("seasonal") && playerInteractAtEntityEvent.getPlayer().getInventory().getItem(playerInteractAtEntityEvent.getHand()) != null) {
            Material material = playerInteractAtEntityEvent.getPlayer().getInventory().getItem(playerInteractAtEntityEvent.getHand()).getType();
            if (this.tamingMaterials.containsKey(playerInteractAtEntityEvent.getRightClicked().getType()) && this.containsMaterial(material, this.tamingMaterials.get(playerInteractAtEntityEvent.getRightClicked().getType()))) {
                playerInteractAtEntityEvent.getRightClicked().removeScoreboardTag("seasonal");
            }
        }
    }

    @EventHandler
    public void onDeath(PlayerDeathEvent playerDeathEvent) {
        if (this.main.getTemperatureManager().getTempData().isEnabled()) {
            this.main.getTemperatureManager().getTempData().removeIfDrinked(playerDeathEvent.getEntity());
        }
    }

    public boolean containsMaterial(Material material, Material[] materialArray) {
        boolean bl = false;
        for (Material material2 : materialArray) {
            if (material2 != material) continue;
            bl = true;
            break;
        }
        return bl;
    }
}

