/*
 * Decompiled with CFR 0.152.
 */
package me.casperge.realisticseasons.temperature;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import me.casperge.realisticseasons.RealisticSeasons;
import me.casperge.realisticseasons.Version;
import me.casperge.realisticseasons.runnables.TemperatureUpdater;
import me.casperge.realisticseasons.season.Season;
import me.casperge.realisticseasons.temperature.TempData;
import me.casperge.realisticseasons.temperature.TempUtils;
import me.casperge.realisticseasons.utils.ChunkUtils;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;

public class TemperatureManager {
    private TempData tempdata;
    private TempUtils temputils;
    private RealisticSeasons main;
    private boolean isEnabled;
    private HashMap<UUID, Integer> temperatures = new HashMap();
    private List<Player> noHealing = new ArrayList<Player>();
    private List<Player> freezing = new ArrayList<Player>();
    private List<UUID> fahrenheitEnabled = new ArrayList<UUID>();
    private List<UUID> temperatureDisabled = new ArrayList<UUID>();
    private List<UUID> hasCheckedTemperatureBefore = new ArrayList<UUID>();
    private List<UUID> rsBurn = new ArrayList<UUID>();
    private boolean is1_17;

    public TemperatureManager(final RealisticSeasons realisticSeasons) {
        this.main = realisticSeasons;
        this.tempdata = new TempData(realisticSeasons);
        this.is1_17 = Version.is_1_17_or_up();
        if (this.is1_17) {
            BukkitScheduler bukkitScheduler = realisticSeasons.getServer().getScheduler();
            bukkitScheduler.scheduleSyncRepeatingTask((Plugin)realisticSeasons, new Runnable(){

                @Override
                public void run() {
                    for (Player player : TemperatureManager.this.freezing) {
                        realisticSeasons.getNMSUtils().setFrozen(player, false);
                    }
                }
            }, 0L, 1L);
        }
    }

    public void loggedIn(UUID uUID) {
        this.hasCheckedTemperatureBefore.add(uUID);
    }

    public boolean hasPlayedBefore(UUID uUID) {
        return this.hasCheckedTemperatureBefore.contains(uUID);
    }

    public boolean hasRSBurn(UUID uUID) {
        return this.rsBurn.contains(uUID);
    }

    public void setRSBurn(UUID uUID, boolean bl) {
        if (bl) {
            if (!this.rsBurn.contains(uUID)) {
                this.rsBurn.add(uUID);
            }
        } else if (this.rsBurn.contains(uUID)) {
            this.rsBurn.remove(uUID);
        }
    }

    public int getAirTemperature(Location location) {
        if (!location.getWorld().isChunkLoaded(location.getBlockX() >> 4, location.getBlockZ() >> 4)) {
            return 5;
        }
        if (location.getWorld().getEnvironment() != World.Environment.NETHER && location.getWorld().getEnvironment() != World.Environment.THE_END) {
            int n = this.temputils.getCurrentWorldTemperature(location.getWorld());
            n = this.temputils.getBiomeModified(location, n);
            return this.temputils.getHeightModified(location, n);
        }
        if (location.getWorld().getEnvironment() == World.Environment.NETHER) {
            return this.tempdata.getTempSettings().getNetherTemperature();
        }
        if (location.getWorld().getEnvironment() == World.Environment.THE_END) {
            return this.tempdata.getTempSettings().getEndTemperature();
        }
        return 25;
    }

    public void load() {
        this.isEnabled = this.tempdata.load();
        this.temputils = new TempUtils(this.main, this.tempdata);
        if (!this.isEnabled) {
            return;
        }
        this.generateTempForLoadedWorlds();
        TemperatureUpdater temperatureUpdater = new TemperatureUpdater(this.main, this);
        temperatureUpdater.runTaskTimer((Plugin)this.main, this.tempdata.getTempSettings().getTemperatureUpdateInterval(), this.tempdata.getTempSettings().getTemperatureUpdateInterval());
        this.temputils.tickRate = this.tempdata.getTempSettings().getTemperatureUpdateInterval();
    }

    public TempData getTempData() {
        return this.tempdata;
    }

    public void disableTemperature(Player player) {
        if (!this.temperatureDisabled.contains(player.getUniqueId())) {
            this.temperatureDisabled.add(player.getUniqueId());
        }
    }

    public void enableTemperature(Player player) {
        if (this.temperatureDisabled.contains(player.getUniqueId())) {
            this.temperatureDisabled.remove(player.getUniqueId());
        }
    }

    public void disableTemperature(UUID uUID) {
        if (!this.temperatureDisabled.contains(uUID)) {
            this.temperatureDisabled.add(uUID);
        }
    }

    public void enableTemperature(UUID uUID) {
        if (this.temperatureDisabled.contains(uUID)) {
            this.temperatureDisabled.remove(uUID);
        }
    }

    public void toggleFahrenheit(Player player) {
        if (this.fahrenheitEnabled.contains(player.getUniqueId())) {
            this.fahrenheitEnabled.remove(player.getUniqueId());
        } else {
            this.fahrenheitEnabled.add(player.getUniqueId());
        }
    }

    public void toggleFahrenheit(UUID uUID) {
        if (this.fahrenheitEnabled.contains(uUID)) {
            this.fahrenheitEnabled.remove(uUID);
        } else {
            this.fahrenheitEnabled.add(uUID);
        }
    }

    public boolean hasFahrenheitEnabled(Player player) {
        return this.fahrenheitEnabled.contains(player.getUniqueId());
    }

    public List<UUID> getFahrenheitEnabled() {
        return this.fahrenheitEnabled;
    }

    public List<UUID> getKnownPlayers() {
        return this.hasCheckedTemperatureBefore;
    }

    public List<UUID> getTemperatureDisabled() {
        return this.temperatureDisabled;
    }

    public boolean hasTemperature(Player player) {
        if (!this.tempdata.isEnabled()) {
            return false;
        }
        return !this.temperatureDisabled.contains(player.getUniqueId());
    }

    public TempUtils getTempUtils() {
        return this.temputils;
    }

    public void generateTempForLoadedWorlds() {
        for (World world : this.main.getTemperatureManager().getTempData().getEnabledWorlds()) {
            if (world.getEnvironment() == World.Environment.NETHER || world.getEnvironment() == World.Environment.THE_END) continue;
            this.main.getTemperatureManager().getTempData().setBaseTemperature(world, this.temputils.generateNewBaseTemperature(world));
        }
    }

    public void loadWorld(World world) {
        this.main.getTemperatureManager().getTempData().setBaseTemperature(world, this.temputils.generateNewBaseTemperature(world));
        this.main.getTemperatureManager().getTempData().enableWorld(world);
    }

    public ChatColor getColorCode(int n) {
        ChatColor chatColor = ChatColor.GREEN;
        if (this.getTempData().getTempSettings().getColdHungerTemp() >= n) {
            chatColor = ChatColor.AQUA;
        }
        if (this.getTempData().getTempSettings().getColdSlownessTemp() >= n) {
            chatColor = ChatColor.BLUE;
        }
        if (this.getTempData().getTempSettings().getColdFreezingTemp() >= n) {
            chatColor = ChatColor.DARK_BLUE;
        }
        if (this.getTempData().getTempSettings().getWarmNoHealingTemp() <= n) {
            chatColor = ChatColor.GOLD;
        }
        if (this.getTempData().getTempSettings().getWarmSlownessTemp() <= n) {
            chatColor = ChatColor.RED;
        }
        if (this.getTempData().getTempSettings().getWarmFireTemp() <= n) {
            chatColor = ChatColor.DARK_RED;
        }
        if (this.getTempData().getTempSettings().getBoostMinTemp() <= n && this.getTempData().getTempSettings().getBoostMaxTemp() >= n && this.getTempData().getTempSettings().getBoostPotionEffects().size() > 0) {
            chatColor = ChatColor.LIGHT_PURPLE;
        }
        return chatColor;
    }

    public int calculateTemperature(Player player) {
        if (!ChunkUtils.isChunkLoaded(player.getLocation())) {
            return 10;
        }
        if (this.main.hasWorldGuard() && this.main.getWorldGuardAPI().getPermanentTemperature(player.getLocation().getChunk().getX(), player.getLocation().getChunk().getZ(), player.getWorld()) != null) {
            return this.main.getWorldGuardAPI().getPermanentTemperature(player.getLocation().getChunk().getX(), player.getLocation().getChunk().getZ(), player.getWorld());
        }
        if (!this.main.hasSeasons(player.getLocation().getChunk().getX(), player.getLocation().getChunk().getZ(), player.getWorld())) {
            return 25;
        }
        if (player.getWorld().getEnvironment() != World.Environment.NETHER && player.getWorld().getEnvironment() != World.Environment.THE_END) {
            int n = this.temputils.getCurrentWorldTemperature(player.getWorld());
            n = this.temputils.getBiomeModified(player.getLocation(), n);
            n = this.temputils.getHeightModified(player.getLocation(), n);
            n = this.temputils.getWaterModified(player, n, this.main.getSeasonManager().getSeason(player.getWorld()));
            n = this.temputils.getSprintingModified(player, n);
            n = this.temputils.getArmorModified(player, n);
            n = this.temputils.getFoodModified(player, n);
            n = this.tempdata.getCustomEffectsModified(player, n);
            n = this.tempdata.getPermanentEffectsModified(player, n);
            if (player.getLocation().getBlock().getType() == Material.LAVA && player.getFireTicks() > 1) {
                n += this.tempdata.getTempSettings().getLavaTemp();
            }
            return n;
        }
        if (player.getWorld().getEnvironment() == World.Environment.NETHER) {
            int n = this.tempdata.getTempSettings().getNetherTemperature();
            n = this.temputils.getSprintingModified(player, n);
            n = this.temputils.getArmorModified(player, n);
            n = this.temputils.getFoodModified(player, n);
            n = this.tempdata.getCustomEffectsModified(player, n);
            n = this.tempdata.getPermanentEffectsModified(player, n);
            return n;
        }
        if (player.getWorld().getEnvironment() == World.Environment.THE_END) {
            int n = this.tempdata.getTempSettings().getEndTemperature();
            n = this.temputils.getWaterModified(player, n, Season.WINTER);
            n = this.temputils.getSprintingModified(player, n);
            n = this.temputils.getArmorModified(player, n);
            n = this.temputils.getFoodModified(player, n);
            n = this.tempdata.getCustomEffectsModified(player, n);
            n = this.tempdata.getPermanentEffectsModified(player, n);
            return n;
        }
        return 25;
    }

    public void setHealing(Player player, boolean bl) {
        if (bl) {
            if (this.noHealing.contains(player)) {
                this.noHealing.remove(player);
            }
        } else if (!this.noHealing.contains(player)) {
            this.noHealing.add(player);
        }
    }

    public boolean canHeal(Player player) {
        return !this.noHealing.contains(player);
    }

    public void setFreezing(Player player, boolean bl, boolean bl2) {
        if (!bl) {
            if (this.freezing.contains(player)) {
                this.freezing.remove(player);
            }
        } else {
            this.main.getNMSUtils().setFrozen(player, bl2);
            if (!this.freezing.contains(player)) {
                this.freezing.add(player);
            }
        }
    }

    public boolean isFrozen(Player player) {
        return this.freezing.contains(player);
    }

    public int getTemperature(Player player) {
        if (this.temperatures.containsKey(player.getUniqueId())) {
            return this.temperatures.get(player.getUniqueId());
        }
        this.temperatures.put(player.getUniqueId(), this.calculateTemperature(player));
        return this.temperatures.get(player.getUniqueId());
    }

    public void updateTemperature(Player player) {
        this.temperatures.put(player.getUniqueId(), this.calculateTemperature(player));
    }
}

