/*
 * Decompiled with CFR 0.152.
 */
package me.casperge.realisticseasons.utils;

import me.casperge.realisticseasons.RealisticSeasons;
import me.casperge.realisticseasons.season.Season;
import me.casperge.realisticseasons.utils.ChunkUtils;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;

public class BlockUtils {
    RealisticSeasons main;

    public BlockUtils(RealisticSeasons realisticSeasons) {
        this.main = realisticSeasons;
    }

    public boolean isSnowable(Block block) {
        if (block.getType().isOccluding() && block.getType().isSolid() && block.getType() != Material.WATER && block.getType() != Material.LAVA && block.getType() != Material.FARMLAND && block.getType() != Material.ICE && !block.getType().toString().contains("STAIR") && !block.getType().toString().contains("SLAB") && !block.getType().toString().contains("FENCE") && block.getType() != Material.CRIMSON_NYLIUM && block.getType() != Material.WARPED_NYLIUM && block.getType() != Material.BARRIER || block.getType().toString().toLowerCase().contains("leave")) {
            if (this.main.hasTerra && this.main.getSettings().terraGenSnowDisabled && block.getType().toString().toLowerCase().contains("leave")) {
                return false;
            }
            Block block2 = block.getRelative(0, 1, 0);
            if (block2.getType() == Material.AIR && block2.getType() != Material.SNOW) {
                return true;
            }
        }
        return false;
    }

    public static boolean canLeafDrop(Block block) {
        return block.getType().isOccluding() && block.getType().isSolid() && block.getType() != Material.WATER && block.getType() != Material.LAVA && block.getType() != Material.FARMLAND && block.getType() != Material.ICE && !block.getType().toString().contains("STAIR") && !block.getType().toString().contains("SLAB") && !block.getType().toString().contains("FENCE") || block.getType().toString().toLowerCase().contains("leave") && block.getType() != Material.CRIMSON_NYLIUM && block.getType() != Material.WARPED_NYLIUM;
    }

    public boolean affectBlockInWinter(World world, int n, int n2, int n3) {
        Block block = world.getBlockAt(n, n2, n3);
        return this.affectBlockInWinter(block);
    }

    public boolean isSnowing(Location location) {
        RealisticSeasons realisticSeasons = RealisticSeasons.getInstance();
        if (location.getWorld().hasStorm() && realisticSeasons.getSeasonManager().getSeason(location.getWorld()) == Season.WINTER) {
            return realisticSeasons.getBlockUtils().affectBlockInWinter(location.getWorld(), location.getBlockX(), location.getBlockY(), location.getBlockZ());
        }
        return false;
    }

    public boolean affectBlockInWinter(Block block) {
        String string = this.main.getNMSUtils().getBiomeName(block.getLocation());
        if (ChunkUtils.checkBiome(ChunkUtils.BiomeType.AFFECTINWINTER, string)) {
            return false;
        }
        return !this.main.getSettings().keepNaturalSnow || !(block.getTemperature() < 0.15);
    }

    public boolean affectFlora(Block block) {
        String string = this.main.getNMSUtils().getBiomeName(block.getLocation());
        return !ChunkUtils.checkBiome(ChunkUtils.BiomeType.AFFECTFLORA, string);
    }

    public void placePuddleBlock(Block block) {
        this.main.getNMSUtils().setBlockInNMSChunk(block.getWorld(), block.getX(), block.getY(), block.getZ(), 40, (byte)0, false);
    }
}

