/*
 * Decompiled with CFR 0.152.
 */
package me.casperge.realisticseasons.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import me.casperge.realisticseasons.RealisticSeasons;
import me.casperge.realisticseasons.Version;
import me.casperge.realisticseasons.season.Season;
import me.casperge.realisticseasons.utils.JavaUtils;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;

public class ChunkUtils {
    RealisticSeasons main;
    public static List<Material> naturalplants = new ArrayList<Material>(Arrays.asList(Material.GRASS, Material.TALL_GRASS, Material.DANDELION, Material.POPPY, Material.BLUE_ORCHID, Material.ALLIUM, Material.AZURE_BLUET, Material.ORANGE_TULIP, Material.PINK_TULIP, Material.RED_TULIP, Material.WHITE_TULIP, Material.OXEYE_DAISY, Material.CORNFLOWER, Material.LILY_OF_THE_VALLEY, Material.RED_MUSHROOM, Material.BROWN_MUSHROOM, Material.SWEET_BERRY_BUSH));
    public static List<Material> flowers = new ArrayList<Material>(Arrays.asList(Material.DANDELION, Material.POPPY, Material.BLUE_ORCHID, Material.ALLIUM, Material.AZURE_BLUET, Material.ORANGE_TULIP, Material.PINK_TULIP, Material.RED_TULIP, Material.WHITE_TULIP, Material.OXEYE_DAISY, Material.CORNFLOWER, Material.LILY_OF_THE_VALLEY));
    private final List<Material> logPlaceAndBreak = new ArrayList<Material>(Arrays.asList(Material.DANDELION, Material.POPPY, Material.BLUE_ORCHID, Material.ALLIUM, Material.AZURE_BLUET, Material.ORANGE_TULIP, Material.PINK_TULIP, Material.RED_TULIP, Material.WHITE_TULIP, Material.OXEYE_DAISY, Material.CORNFLOWER, Material.LILY_OF_THE_VALLEY, Material.RED_MUSHROOM, Material.BROWN_MUSHROOM, Material.SWEET_BERRY_BUSH));
    private final List<Material> logs = Arrays.asList(Material.OAK_LOG, Material.SPRUCE_LOG, Material.BIRCH_LOG, Material.JUNGLE_LOG, Material.ACACIA_LOG, Material.SPRUCE_LOG);
    private int waterID;
    public static List<String> affectflora = new ArrayList<String>();
    public static List<String> affectinwinter = new ArrayList<String>();

    public ChunkUtils(RealisticSeasons realisticSeasons) {
        this.main = realisticSeasons;
        this.waterID = Version.getWaterID();
    }

    public static boolean isChunkLoaded(Location location) {
        int n = location.getBlockX() >> 4;
        int n2 = location.getBlockZ() >> 4;
        return location.getWorld().isChunkLoaded(n, n2);
    }

    public static Collection<Chunk> around(Chunk chunk, int n) {
        World world = chunk.getWorld();
        int n2 = n * 2 + 1;
        HashSet<Chunk> hashSet = new HashSet<Chunk>();
        int n3 = chunk.getX();
        int n4 = chunk.getZ();
        for (int i = -n; i <= n; ++i) {
            for (int j = -n; j <= n; ++j) {
                if (ChunkUtils.get2dDistance(n3, n4, n3 + i, n4 + j) > (double)n || n3 + i > 1875000 || n4 + j > 1875000 || n3 + i < -1875000 || n4 + j < -1875000 || !world.isChunkLoaded(n3 + i, n4 + j)) continue;
                hashSet.add(world.getChunkAt(n3 + i, n4 + j));
            }
        }
        return hashSet;
    }

    public static Collection<String> aroundString(int n, int n2, String string, int n3) {
        int n4 = n3 * 2 + 2;
        HashSet<String> hashSet = new HashSet<String>(n4 * n4);
        for (int i = -n3; i <= n3; ++i) {
            for (int j = -n3; j <= n3; ++j) {
                hashSet.add(String.valueOf(n + i) + "," + String.valueOf(n2 + j) + "," + string);
            }
        }
        return hashSet;
    }

    public static Chunk chunkFromString(String string) {
        String[] stringArray = string.split(",");
        int n = Integer.valueOf(stringArray[0]);
        int n2 = Integer.valueOf(stringArray[1]);
        World world = Bukkit.getWorld((String)stringArray[2]);
        if (n > 1875000 || n2 > 1875000 || n < -1875000 || n2 < -1875000) {
            return null;
        }
        return world.getChunkAt(n, n2);
    }

    public static boolean isChunkLoadedString(String string) {
        String[] stringArray = string.split(",");
        int n = Integer.valueOf(stringArray[0]);
        int n2 = Integer.valueOf(stringArray[1]);
        World world = Bukkit.getWorld((String)stringArray[2]);
        return world.isChunkLoaded(n, n2);
    }

    public HashMap<Material, Integer> getChunkPopulation(Chunk chunk) {
        HashMap<Material, Integer> hashMap = new HashMap<Material, Integer>();
        for (int i = 0; i <= 15; ++i) {
            for (int j = 0; j <= 15; ++j) {
                Block block = chunk.getWorld().getHighestBlockAt(chunk.getX() * 16 + i, chunk.getZ() * 16 + j).getRelative(0, 1, 0);
                if (naturalplants.contains(block.getType())) {
                    if (hashMap.containsKey(block.getType())) {
                        hashMap.put(block.getType(), hashMap.get(block.getType()) + 1);
                    } else {
                        hashMap.put(block.getType(), 1);
                    }
                }
                if (block.getRelative(0, -1, 0).getType() != Material.GRASS_BLOCK || block.getType() == Material.SNOW) continue;
                if (hashMap.containsKey(Material.GRASS_BLOCK)) {
                    hashMap.put(Material.GRASS_BLOCK, hashMap.get(Material.GRASS_BLOCK) + 1);
                    continue;
                }
                hashMap.put(Material.GRASS_BLOCK, 1);
            }
        }
        return hashMap;
    }

    public List<Block> getPlantBlocks(Chunk chunk) {
        ArrayList<Block> arrayList = new ArrayList<Block>();
        for (int i = 0; i <= 15; ++i) {
            for (int j = 0; j <= 15; ++j) {
                Block block = chunk.getWorld().getHighestBlockAt(chunk.getX() * 16 + i, chunk.getZ() * 16 + j).getRelative(0, 1, 0);
                if (!naturalplants.contains(block.getType()) || this.logPlaceAndBreak.contains(block.getType()) && this.main.getBlockStorage().isManualPlacedFlower(block.getLocation())) continue;
                arrayList.add(block);
            }
        }
        return arrayList;
    }

    public static List<Block> getGrassBlocks(Chunk chunk) {
        ArrayList<Block> arrayList = new ArrayList<Block>();
        for (int i = 0; i <= 15; ++i) {
            for (int j = 0; j <= 15; ++j) {
                Block block = chunk.getWorld().getHighestBlockAt(chunk.getX() * 16 + i, chunk.getZ() * 16 + j).getRelative(0, 1, 0);
                if (block.getType() != Material.GRASS && block.getType() != Material.TALL_GRASS) continue;
                arrayList.add(block);
            }
        }
        return arrayList;
    }

    public static List<Block> getGrowableBlocks(Chunk chunk) {
        ArrayList<Block> arrayList = new ArrayList<Block>();
        for (int i = 0; i <= 15; ++i) {
            for (int j = 0; j <= 15; ++j) {
                Block block = chunk.getWorld().getHighestBlockAt(chunk.getBlock(i, 60, j).getLocation());
                if (block.getType() != Material.GRASS_BLOCK || block.getRelative(BlockFace.UP).getType() != Material.AIR) continue;
                arrayList.add(block.getRelative(0, 1, 0));
            }
        }
        return arrayList;
    }

    public int[] getTotalPlantPopulation(Chunk chunk) {
        HashMap<Material, Integer> hashMap = this.getChunkPopulation(chunk);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        for (Map.Entry<Material, Integer> entry : hashMap.entrySet()) {
            if (entry.getKey() == Material.GRASS || entry.getKey() == Material.TALL_GRASS) {
                n += entry.getValue().intValue();
                continue;
            }
            if (flowers.contains(entry.getKey())) {
                n2 += entry.getValue().intValue();
                continue;
            }
            if (entry.getKey() == Material.GRASS_BLOCK) {
                n3 += entry.getValue().intValue();
                continue;
            }
            if (entry.getKey() == Material.SNOW || entry.getKey() == Material.ICE) {
                n4 += entry.getValue().intValue();
                continue;
            }
            if (entry.getKey() == Material.SWEET_BERRY_BUSH) {
                n5 += entry.getValue().intValue();
                continue;
            }
            if (entry.getKey() != Material.RED_MUSHROOM && entry.getKey() != Material.BROWN_MUSHROOM) continue;
            n6 += entry.getValue().intValue();
        }
        Object object = new int[]{n, n2, n3, n4, n5, n6};
        return object;
    }

    public boolean checkPopulation(Chunk chunk, float f, float f2, int n, int n2, Season season, boolean bl) {
        int[] nArray = this.getTotalPlantPopulation(chunk);
        if (nArray[3] != 0) {
            return false;
        }
        int n3 = Math.round((float)nArray[2] / f);
        int n4 = Math.round((float)nArray[2] * (f2 / 100.0f));
        int n5 = Math.round(nArray[2] / 6);
        if (nArray[1] - n2 > n4) {
            if (this.main.getSettings().flowerchanceinspring > 0.08f) {
                this.reducePopulation(chunk, n4, nArray[1], PlantType.FLOWER);
                bl = true;
            }
        } else if (nArray[1] + n2 < n4) {
            ChunkUtils.increasePopulation(chunk, n4, nArray[1], PlantType.FLOWER);
        }
        int n6 = Math.abs(chunk.getX()) % 10;
        int n7 = Math.abs(chunk.getZ()) % 10;
        if (n6 == 1 && n7 == 2 || n6 == 9 && n7 == 3 || n6 == 5 && n7 == 8 || n6 == 9 && n7 == 9 || n6 == 2 && n7 == 6) {
            if (season == Season.SUMMER) {
                if (nArray[4] < 1) {
                    if (n5 > this.main.getSettings().maxBerryBushes) {
                        n5 = this.main.getSettings().maxBerryBushes;
                    }
                    ChunkUtils.increasePopulation(chunk, n5, 0, PlantType.BERRY);
                }
            } else if (nArray[4] > 0) {
                this.reducePopulation(chunk, 0, nArray[4], PlantType.BERRY);
                bl = true;
            }
        } else if ((n6 == 2 && n7 == 1 || n6 == 3 && n7 == 9 || n6 == 8 && n7 == 5 || n6 == 9 && n7 == 7 || n6 == 6 && n7 == 2) && this.main.getSettings().spawnMushroomsInFall) {
            if (season == Season.FALL) {
                if (nArray[5] < 1) {
                    ChunkUtils.increasePopulation(chunk, n5, 0, PlantType.MUSHROOM);
                }
            } else if (nArray[5] > 0) {
                this.reducePopulation(chunk, 0, nArray[5], PlantType.MUSHROOM);
                bl = true;
            }
        }
        if (bl) {
            if (nArray[0] - n > n3) {
                this.reducePopulation(chunk, n3, nArray[0], PlantType.GRASS);
            } else if (nArray[0] + n < n3) {
                ChunkUtils.increasePopulation(chunk, n3, nArray[0], PlantType.GRASS);
            }
        }
        return true;
    }

    public void reducePopulation(Chunk chunk, int n, int n2, PlantType plantType) {
        block6: {
            Random random;
            block8: {
                block7: {
                    block5: {
                        random = new Random();
                        if (plantType != PlantType.GRASS) break block5;
                        List<Block> list = ChunkUtils.getGrassBlocks(chunk);
                        while (n2 > n) {
                            Block block = list.get(random.nextInt(list.size()));
                            list.remove(block);
                            if (block.getType() == Material.TALL_GRASS) {
                                block.setType(Material.AIR, false);
                                block.getRelative(0, 1, 0).setType(Material.AIR, false);
                                --n2;
                                continue;
                            }
                            block.setType(Material.AIR, false);
                            --n2;
                        }
                        break block6;
                    }
                    if (plantType != PlantType.FLOWER) break block7;
                    List<Block> list = this.getPlantBlocks(chunk);
                    while (n2 > n && list.size() > 0) {
                        Block block = list.get(random.nextInt(list.size()));
                        list.remove(block);
                        if (!flowers.contains(block.getType())) continue;
                        block.setType(Material.AIR, false);
                        --n2;
                    }
                    break block6;
                }
                if (plantType != PlantType.BERRY) break block8;
                List<Block> list = this.getPlantBlocks(chunk);
                while (n2 > n && list.size() > 0) {
                    Block block = list.get(random.nextInt(list.size()));
                    list.remove(block);
                    if (block.getType() != Material.SWEET_BERRY_BUSH) continue;
                    block.setType(Material.AIR, false);
                    --n2;
                }
                break block6;
            }
            if (plantType != PlantType.MUSHROOM) break block6;
            List<Block> list = this.getPlantBlocks(chunk);
            while (n2 > n && list.size() > 0) {
                Block block = list.get(random.nextInt(list.size()));
                list.remove(block);
                if (block.getType() != Material.RED_MUSHROOM && block.getType() != Material.BROWN_MUSHROOM) continue;
                block.setType(Material.AIR, false);
                --n2;
            }
        }
    }

    public static void increasePopulation(Chunk chunk, int n, int n2, PlantType plantType) {
        block7: {
            Random random;
            List<Block> list;
            block9: {
                block8: {
                    block6: {
                        list = ChunkUtils.getGrowableBlocks(chunk);
                        random = new Random();
                        if (plantType != PlantType.GRASS) break block6;
                        while (n2 < n && list.size() > 0) {
                            Block block = list.get(random.nextInt(list.size()));
                            list.remove(block);
                            block.setType(Material.GRASS, false);
                            ++n2;
                        }
                        break block7;
                    }
                    if (plantType != PlantType.FLOWER) break block8;
                    while (n2 < n && list.size() > 0) {
                        Block block = list.get(random.nextInt(list.size()));
                        list.remove(block);
                        block.setType(flowers.get(random.nextInt(flowers.size())), false);
                        ++n2;
                    }
                    break block7;
                }
                if (plantType != PlantType.BERRY) break block9;
                while (n2 < n && list.size() > 0) {
                    Block block = list.get(random.nextInt(list.size()));
                    list.remove(block);
                    if (!(ChunkUtils.get2dDistanceFromCenter(block, chunk) < 8.0)) continue;
                    block.setType(Material.SWEET_BERRY_BUSH, false);
                    ++n2;
                }
                break block7;
            }
            if (plantType != PlantType.MUSHROOM) break block7;
            while (n2 < n && list.size() > 0) {
                Block block = list.get(random.nextInt(list.size()));
                list.remove(block);
                if (!(ChunkUtils.get2dDistanceFromCenter(block, chunk) < 8.0)) continue;
                if (random.nextInt(2) == 0) {
                    block.setType(Material.BROWN_MUSHROOM, false);
                } else {
                    block.setType(Material.RED_MUSHROOM, false);
                }
                ++n2;
            }
        }
    }

    public static double get2dDistanceFromCenter(Block block, Chunk chunk) {
        Location location = new Location(chunk.getWorld(), (double)(chunk.getX() << 4), 64.0, (double)(chunk.getZ() << 4)).add(7.0, 0.0, 7.0);
        int n = Math.abs(location.getBlockX());
        int n2 = Math.abs(location.getBlockZ());
        int n3 = Math.abs(block.getX());
        int n4 = Math.abs(block.getZ());
        return Math.sqrt((n3 - n) * (n3 - n) + (n4 - n2) * (n4 - n2));
    }

    public static double get2dDistance(Block block, Block block2) {
        int n = Math.abs(block2.getX());
        int n2 = Math.abs(block2.getZ());
        int n3 = Math.abs(block.getX());
        int n4 = Math.abs(block.getZ());
        return Math.sqrt((n3 - n) * (n3 - n) + (n4 - n2) * (n4 - n2));
    }

    public static double get2dDistance(int n, int n2, int n3, int n4) {
        return Math.sqrt((n3 - n) * (n3 - n) + (n4 - n2) * (n4 - n2));
    }

    public boolean affectFlora(Chunk chunk) {
        String string = this.main.getNMSUtils().getBiomeName(chunk.getX() * 16, chunk.getWorld().getHighestBlockYAt(chunk.getX() * 16, chunk.getZ() * 16), chunk.getZ() * 16, chunk.getWorld());
        return !ChunkUtils.checkBiome(BiomeType.AFFECTFLORA, string);
    }

    public boolean dontAffectInWinter(int n, int n2, World world) {
        String string = this.main.getNMSUtils().getBiomeName(n * 16, world.getHighestBlockYAt(n * 16, n2 * 16), n2 * 16, world);
        return ChunkUtils.checkBiome(BiomeType.AFFECTINWINTER, string);
    }

    public boolean unfreezeChunk(Chunk chunk) {
        boolean bl = false;
        World world = chunk.getWorld();
        if (!this.main.hasBlockChanges(chunk.getX(), chunk.getZ(), chunk.getWorld())) {
            return false;
        }
        for (int i = 0; i <= 15; ++i) {
            block1: for (int j = 0; j <= 15; ++j) {
                int n;
                int n2;
                int n3 = i + chunk.getX() * 16;
                Block block = world.getHighestBlockAt(n3, n2 = j + chunk.getZ() * 16);
                if (block.getRelative(0, 1, 0).getType() == Material.SNOW && this.main.getSettings().snowRemoval) {
                    n = block.getY() + 1;
                    if (this.main.getBlockUtils().affectBlockInWinter(world, n3, n, n2)) {
                        this.main.getNMSUtils().setBlockInNMSChunk(world, n3, n, n2, 0, (byte)0, false);
                        if (!bl) {
                            bl = true;
                        }
                    }
                } else if (block.getType() == Material.ICE && this.main.getBlockUtils().affectBlockInWinter(world, n3, block.getY(), n2)) {
                    this.main.getNMSUtils().setBlockInNMSChunk(world, n3, block.getY(), n2, this.waterID, (byte)0, false);
                    if (!bl) {
                        bl = true;
                    }
                }
                if (!block.getType().toString().contains("LEAVE")) continue;
                n = -1;
                while (n + block.getLocation().getBlockY() > this.main.getNMSUtils().getMinHeight(block.getLocation().getWorld())) {
                    if (block.getRelative(0, n, 0).getType() == Material.SNOW) {
                        if (!this.main.getBlockUtils().affectBlockInWinter(world, n3, block.getLocation().getBlockY() + n, n2)) continue block1;
                        this.main.getNMSUtils().setBlockInNMSChunk(world, n3, block.getLocation().getBlockY() + n, n2, 0, (byte)0, false);
                        if (bl) continue block1;
                        bl = true;
                        continue block1;
                    }
                    if (!block.getRelative(0, n, 0).getType().toString().contains("LEAVE") && !this.logs.contains(block.getRelative(0, n, 0).getType()) && block.getRelative(0, n, 0).getType() != Material.AIR && block.getRelative(0, n, 0).getType() != Material.VINE) continue block1;
                    --n;
                }
            }
        }
        return bl;
    }

    public boolean unfreezeChunk(Chunk chunk, double d2) {
        boolean bl = false;
        World world = chunk.getWorld();
        if (!this.main.hasBlockChanges(chunk.getX(), chunk.getZ(), chunk.getWorld())) {
            return false;
        }
        for (int i = 0; i <= 15; ++i) {
            block1: for (int j = 0; j <= 15; ++j) {
                int n;
                int n2 = i + chunk.getX() * 16;
                int n3 = j + chunk.getZ() * 16;
                Block block = world.getHighestBlockAt(n2, n3);
                if (JavaUtils.getRandom().nextDouble() > d2) continue;
                if (block.getRelative(0, 1, 0).getType() == Material.SNOW && this.main.getSettings().snowRemoval) {
                    n = block.getY() + 1;
                    if (this.main.getBlockUtils().affectBlockInWinter(world, n2, n, n3)) {
                        this.main.getNMSUtils().setBlockInNMSChunk(world, n2, n, n3, 0, (byte)0, false);
                        if (!bl) {
                            bl = true;
                        }
                    }
                } else if (block.getType() == Material.ICE && this.main.getBlockUtils().affectBlockInWinter(world, n2, block.getY(), n3)) {
                    this.main.getNMSUtils().setBlockInNMSChunk(world, n2, block.getY(), n3, this.waterID, (byte)0, false);
                    if (!bl) {
                        bl = true;
                    }
                }
                if (!block.getType().toString().contains("LEAVE")) continue;
                n = -1;
                while (n + block.getLocation().getBlockY() > this.main.getNMSUtils().getMinHeight(block.getLocation().getWorld())) {
                    if (block.getRelative(0, n, 0).getType() == Material.SNOW) {
                        if (!this.main.getBlockUtils().affectBlockInWinter(world, n2, block.getLocation().getBlockY() + n, n3)) continue block1;
                        this.main.getNMSUtils().setBlockInNMSChunk(world, n2, block.getLocation().getBlockY() + n, n3, 0, (byte)0, false);
                        if (bl) continue block1;
                        bl = true;
                        continue block1;
                    }
                    if (!block.getRelative(0, n, 0).getType().toString().contains("LEAVE") && !this.logs.contains(block.getRelative(0, n, 0).getType()) && block.getRelative(0, n, 0).getType() != Material.AIR && block.getRelative(0, n, 0).getType() != Material.VINE) continue block1;
                    --n;
                }
            }
        }
        return bl;
    }

    public static Class<?> getCbClass(String string) {
        return Class.forName("org.bukkit.craftbukkit." + Bukkit.getServer().getClass().getPackage().getName().replace(".", ",").split(",")[3] + "." + string);
    }

    public static List<int[]> generateChunkPackets() {
        Random random = new Random();
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        int[] nArray = new int[1024];
        int[] nArray2 = new int[1024];
        int[] nArray3 = new int[1024];
        int[] nArray4 = new int[1024];
        int[] nArray5 = new int[1024];
        int n = 0;
        int n2 = 1;
        int n3 = 2;
        int n4 = 3;
        int n5 = 4;
        Arrays.fill(nArray, n);
        Arrays.fill(nArray2, n2);
        Arrays.fill(nArray3, n3);
        Arrays.fill(nArray4, n4);
        Arrays.fill(nArray5, n5);
        arrayList.add(nArray);
        arrayList.add(nArray2);
        arrayList.add(nArray3);
        arrayList.add(nArray4);
        arrayList.add(nArray5);
        for (int i = 65; i < 959; ++i) {
            int n6 = random.nextInt(20);
            if (n6 != 1) continue;
            int n7 = random.nextInt(5);
            int n8 = n7 == 0 ? n : (n7 == 1 ? n2 : (n7 == 2 ? n3 : (n7 == 3 ? n4 : n5)));
            int n9 = random.nextInt(arrayList.size());
            ChunkUtils.addToList((int[])arrayList.get(n9), i, n8);
        }
        return arrayList;
    }

    public static int[] addToList(int[] nArray, int n, int n2) {
        nArray[n] = n2;
        nArray[n - 1] = n2;
        nArray[n + 1] = n2;
        nArray[n + 4] = n2;
        nArray[n - 4] = n2;
        nArray[n - 16] = n2;
        nArray[n - 17] = n2;
        nArray[n - 15] = n2;
        nArray[n - 12] = n2;
        nArray[n - 20] = n2;
        nArray[n + 16] = n2;
        nArray[n + 15] = n2;
        nArray[n + 17] = n2;
        nArray[n + 21] = n2;
        nArray[n + 12] = n2;
        return nArray;
    }

    public static boolean checkBiome(BiomeType biomeType, String string) {
        for (String string2 : ChunkUtils.getBiomeList(biomeType)) {
            if (!string.toLowerCase().equals(string2.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public static List<String> getBiomeList(BiomeType biomeType) {
        switch (biomeType) {
            case AFFECTFLORA: {
                return affectflora;
            }
            case AFFECTINWINTER: {
                return affectinwinter;
            }
        }
        return null;
    }

    public void getId(Material material, Player player) {
        for (int i = 0; i < 10000; ++i) {
            this.main.getNMSUtils().setBlockInNMSChunk(player.getWorld(), player.getLocation().getBlockX(), player.getLocation().getBlockY(), player.getLocation().getBlockZ(), i, (byte)0, false);
            if (player.getLocation().getBlock().getType() != material) continue;
            player.sendMessage("Found: " + String.valueOf(i));
            break;
        }
    }

    public static enum PlantType {
        GRASS,
        FLOWER,
        BERRY,
        MUSHROOM;

    }

    public static enum BiomeType {
        AFFECTFLORA,
        AFFECTINWINTER;

    }

    public static enum FallChunkType {
        GROUNDONLY,
        ALL,
        NONE;

    }
}

