/*
 * Decompiled with CFR 0.152.
 */
package me.casperge.realisticseasons1_19_R3;

import com.mojang.serialization.Lifecycle;
import java.lang.reflect.Field;
import java.util.IdentityHashMap;
import java.util.Optional;
import me.casperge.enums.GrassType;
import me.casperge.interfaces.CustomBiome;
import net.minecraft.core.IRegistry;
import net.minecraft.core.RegistryMaterials;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeFog;
import net.minecraft.world.level.biome.BiomeSettingsGeneration;
import net.minecraft.world.level.biome.BiomeSettingsMobs;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.craftbukkit.v1_19_R3.CraftServer;

public class CustomBiome1_19_R3
implements CustomBiome {
    private BiomeBase.a newBiome = new BiomeBase.a();
    private BiomeFog.a newFog = new BiomeFog.a();
    private ResourceKey<BiomeBase> newKey;
    private DedicatedServer dedicatedserver;
    private boolean isRegistered = false;
    private String name;
    private String prename;
    private String originalname;
    private String fogColor;
    private String waterColor;
    private String waterFogColor;
    private String skyColor;
    private String foliageColor;
    private String grassColor;
    private Boolean isFrozen = false;
    private float depth;
    private float scale;
    private float temperature;
    private float downfall;
    private int biomeID = 0;
    private GrassType grassType = GrassType.NORMAL;
    private BiomeBase biome;
    private BiomeFog oldFog;
    private BiomeSettingsGeneration biomeSettingGen;

    public CustomBiome1_19_R3(String string, String string2, String string3) {
        ResourceKey resourceKey;
        Object object;
        this.name = string;
        this.prename = string2;
        this.originalname = string3;
        if (string3.equals("SNOWY_TUNDRA")) {
            string3 = "SNOWY_PLAINS";
        }
        if (string3.equals("MOUNTAINS")) {
            string3 = "WINDSWEPT_HILLS";
        }
        Server server = Bukkit.getServer();
        CraftServer craftServer = (CraftServer)server;
        this.dedicatedserver = craftServer.getServer();
        this.newKey = ResourceKey.a((ResourceKey)Registries.an, (MinecraftKey)new MinecraftKey(string2, string));
        if (string3.contains(":")) {
            object = string3.split(":");
            resourceKey = ResourceKey.a((ResourceKey)Registries.an, (MinecraftKey)new MinecraftKey(object[0].toLowerCase(), object[1].toLowerCase()));
        } else {
            resourceKey = ResourceKey.a((ResourceKey)Registries.an, (MinecraftKey)new MinecraftKey(string3.toLowerCase()));
        }
        this.biome = (BiomeBase)this.getBiomeRegistry().a(resourceKey);
        if (this.biome == null) {
            Bukkit.getLogger().severe("Biome: " + string3 + " could not be found. Aborting custom biome creation");
            return;
        }
        this.newBiome.a(true);
        this.newBiome.a(BiomeBase.TemperatureModifier.a);
        try {
            object = BiomeBase.class.getDeclaredField("l");
            ((Field)object).setAccessible(true);
            this.oldFog = (BiomeFog)((Field)object).get(this.biome);
            this.convertBiomeFog(this.oldFog);
            Field field = BiomeBase.class.getDeclaredField("j");
            field.setAccessible(true);
            this.biomeSettingGen = (BiomeSettingsGeneration)field.get(this.biome);
            this.newBiome.a(this.biomeSettingGen);
            Field field2 = BiomeBase.class.getDeclaredField("k");
            field2.setAccessible(true);
            BiomeSettingsMobs biomeSettingsMobs = (BiomeSettingsMobs)field2.get(this.biome);
            this.newBiome.a(biomeSettingsMobs);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException exception) {
            exception.printStackTrace();
        }
        this.depth = 0.2f;
        this.scale = 0.05f;
        this.newBiome.a(0.7f);
        this.temperature = 0.7f;
        this.newBiome.b(0.8f);
        this.downfall = 0.8f;
    }

    @Override
    public GrassType getGrassType() {
        return this.grassType;
    }

    @Override
    public void setFogColor(String string) {
        this.newFog.a(this.hexToDecimal(string));
        this.fogColor = string;
    }

    @Override
    public void setWaterColor(String string) {
        this.newFog.b(this.hexToDecimal(string));
        this.waterColor = string;
    }

    @Override
    public void setWaterFogColor(String string) {
        this.newFog.c(this.hexToDecimal(string));
        this.waterFogColor = string;
    }

    @Override
    public void setSkyColor(String string) {
        this.newFog.d(this.hexToDecimal(string));
        this.skyColor = string;
    }

    @Override
    public void setFoliageColor(String string) {
        this.newFog.e(this.hexToDecimal(string));
        this.foliageColor = string;
    }

    public int hexToDecimal(String string) {
        return Integer.parseInt(string, 16);
    }

    @Override
    public void setGrassColor(String string) {
        if (string.equals("CUSTOM")) {
            Optional<Integer> optional = this.getOptionalFieldInBiomea(this.oldFog, "g");
            if (!optional.isEmpty()) {
                this.newFog.f(optional.get().intValue());
                string = Integer.toHexString(optional.get());
            }
        } else {
            this.newFog.f(this.hexToDecimal(string));
        }
        this.newFog.a(BiomeFog.GrassColor.a);
        this.grassType = GrassType.NORMAL;
        this.grassColor = string;
    }

    @Override
    public void register() {
        try {
            if (this.isRegistered) {
                return;
            }
            this.newBiome.a(this.newFog.a());
            BiomeBase biomeBase = this.newBiome.a();
            RegistryMaterials registryMaterials = (RegistryMaterials)this.getBiomeRegistry();
            try {
                Field field = RegistryMaterials.class.getDeclaredField("m");
                field.setAccessible(true);
                field.set(registryMaterials, new IdentityHashMap());
                registryMaterials.f((Object)biomeBase);
                registryMaterials.a(this.newKey, (Object)biomeBase, Lifecycle.stable());
                field.set(registryMaterials, null);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException exception) {
                exception.printStackTrace();
            }
            this.isRegistered = true;
            this.biomeID = this.getBiomeRegistry().a((Object)biomeBase);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void setFrozen(Boolean bl) {
        if (bl.booleanValue()) {
            this.newBiome.a(true).a(0.0f).b(0.5f);
            this.isFrozen = true;
        } else {
            this.newBiome.a(BiomeBase.TemperatureModifier.a);
            this.isFrozen = false;
        }
    }

    private void convertBiomeFog(BiomeFog biomeFog) {
        this.fogColor = Integer.toHexString(this.getFieldInBiomea(biomeFog, "b"));
        this.waterColor = Integer.toHexString(this.getFieldInBiomea(biomeFog, "c"));
        this.waterFogColor = Integer.toHexString(this.getFieldInBiomea(biomeFog, "d"));
        this.skyColor = Integer.toHexString(this.getFieldInBiomea(biomeFog, "e"));
        Optional<Integer> optional = this.getOptionalFieldInBiomea(biomeFog, "f");
        if (optional.isPresent()) {
            this.foliageColor = Integer.toHexString(optional.get());
            this.newFog.e(optional.get().intValue());
        }
        this.newFog.a(this.getFieldInBiomea(biomeFog, "b"));
        this.newFog.b(this.getFieldInBiomea(biomeFog, "c"));
        this.newFog.c(this.getFieldInBiomea(biomeFog, "d"));
        this.newFog.d(this.getFieldInBiomea(biomeFog, "e"));
        if (this.originalname.equalsIgnoreCase("SWAMP")) {
            this.newFog.a(BiomeFog.GrassColor.c);
            this.grassType = GrassType.SWAMP;
        } else if (this.originalname.equalsIgnoreCase("DARK_FOREST")) {
            this.newFog.a(BiomeFog.GrassColor.b);
            this.grassType = GrassType.DARK_FOREST;
        } else {
            this.newFog.a(BiomeFog.GrassColor.a);
            this.grassType = GrassType.NORMAL;
        }
    }

    private int getFieldInBiomea(BiomeFog biomeFog, String string) {
        try {
            Field field = biomeFog.getClass().getDeclaredField(string);
            field.setAccessible(true);
            return (Integer)field.get(biomeFog);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException exception) {
            exception.printStackTrace();
            return 6;
        }
    }

    private Optional<Integer> getOptionalFieldInBiomea(BiomeFog biomeFog, String string) {
        try {
            Field field = biomeFog.getClass().getDeclaredField(string);
            field.setAccessible(true);
            return (Optional)field.get(biomeFog);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException exception) {
            exception.printStackTrace();
            return Optional.of(22222);
        }
    }

    @Override
    public void setDepth(Float f) {
        this.depth = f.floatValue();
    }

    @Override
    public void setScale(Float f) {
        this.scale = f.floatValue();
    }

    @Override
    public void setTemperature(Float f) {
        this.newBiome.a(f.floatValue());
        this.temperature = f.floatValue();
    }

    @Override
    public void setDownfall(Float f) {
        this.newBiome.b(f.floatValue());
        this.downfall = f.floatValue();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPreName() {
        return this.prename;
    }

    @Override
    public String getFullName() {
        return this.prename + ":" + this.name;
    }

    @Override
    public boolean isRegistered() {
        return this.isRegistered;
    }

    @Override
    public String getFogColor() {
        return this.fogColor;
    }

    @Override
    public String getWaterColor() {
        return this.waterColor;
    }

    @Override
    public String getWaterFogColor() {
        return this.waterFogColor;
    }

    @Override
    public String getSkyColor() {
        return this.skyColor;
    }

    @Override
    public String getFoliageColor() {
        if (this.foliageColor == null) {
            return "";
        }
        return this.foliageColor;
    }

    @Override
    public String getGrassColor() {
        return this.grassColor;
    }

    @Override
    public boolean isFrozen() {
        return this.isFrozen;
    }

    @Override
    public float getDepth() {
        return this.depth;
    }

    @Override
    public float getScale() {
        return this.scale;
    }

    @Override
    public float getTemperature() {
        return this.temperature;
    }

    @Override
    public float getDownfall() {
        return this.downfall;
    }

    @Override
    public int getBiomeID() {
        if (this.isRegistered) {
            return this.biomeID;
        }
        Bukkit.getLogger().severe("[RealisticSeasons] Can't get BiomeID of an unregistered biome!");
        return 0;
    }

    private IRegistry<BiomeBase> getBiomeRegistry() {
        return this.dedicatedserver.aX().d(Registries.an);
    }
}

