/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.CharArrayWriter;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.Selector;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.LineIterator;
import org.apache.commons.io.StandardLineSeparator;
import org.apache.commons.io.function.IOConsumer;
import org.apache.commons.io.output.AppendableWriter;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.commons.io.output.StringBuilderWriter;
import org.apache.commons.io.output.ThresholdingOutputStream;
import org.apache.commons.io.output.UnsynchronizedByteArrayOutputStream;

public class IOUtils {
    public static final int CR = 13;
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    public static final char DIR_SEPARATOR = File.separatorChar;
    public static final char DIR_SEPARATOR_UNIX = '/';
    public static final char DIR_SEPARATOR_WINDOWS = '\\';
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final int EOF = -1;
    public static final int LF = 10;
    @Deprecated
    public static final String LINE_SEPARATOR = System.lineSeparator();
    public static final String LINE_SEPARATOR_UNIX = StandardLineSeparator.LF.getString();
    public static final String LINE_SEPARATOR_WINDOWS = StandardLineSeparator.CRLF.getString();
    private static final ThreadLocal<byte[]> SKIP_BYTE_BUFFER = ThreadLocal.withInitial(IOUtils::byteArray);
    private static final ThreadLocal<char[]> SKIP_CHAR_BUFFER = ThreadLocal.withInitial(IOUtils::charArray);

    public static BufferedInputStream buffer(InputStream inputStream) {
        Objects.requireNonNull(inputStream, "inputStream");
        return inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream);
    }

    public static BufferedInputStream buffer(InputStream inputStream, int n) {
        Objects.requireNonNull(inputStream, "inputStream");
        return inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream, n);
    }

    public static BufferedOutputStream buffer(OutputStream outputStream) {
        Objects.requireNonNull(outputStream, "outputStream");
        return outputStream instanceof BufferedOutputStream ? (BufferedOutputStream)outputStream : new BufferedOutputStream(outputStream);
    }

    public static BufferedOutputStream buffer(OutputStream outputStream, int n) {
        Objects.requireNonNull(outputStream, "outputStream");
        return outputStream instanceof BufferedOutputStream ? (BufferedOutputStream)outputStream : new BufferedOutputStream(outputStream, n);
    }

    public static BufferedReader buffer(Reader reader) {
        return reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
    }

    public static BufferedReader buffer(Reader reader, int n) {
        return reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n);
    }

    public static BufferedWriter buffer(Writer writer) {
        return writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer);
    }

    public static BufferedWriter buffer(Writer writer, int n) {
        return writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer, n);
    }

    public static byte[] byteArray() {
        return IOUtils.byteArray(8192);
    }

    public static byte[] byteArray(int n) {
        return new byte[n];
    }

    private static char[] charArray() {
        return IOUtils.charArray(8192);
    }

    private static char[] charArray(int n) {
        return new char[n];
    }

    public static void close(Closeable closeable) {
        if (closeable != null) {
            closeable.close();
        }
    }

    public static void close(Closeable ... closeableArray) {
        if (closeableArray != null) {
            for (Closeable closeable : closeableArray) {
                IOUtils.close(closeable);
            }
        }
    }

    public static void close(Closeable closeable, IOConsumer<IOException> iOConsumer) {
        block3: {
            if (closeable != null) {
                try {
                    closeable.close();
                }
                catch (IOException iOException) {
                    if (iOConsumer == null) break block3;
                    iOConsumer.accept(iOException);
                }
            }
        }
    }

    public static void close(URLConnection uRLConnection) {
        if (uRLConnection instanceof HttpURLConnection) {
            ((HttpURLConnection)uRLConnection).disconnect();
        }
    }

    public static void closeQuietly(Closeable closeable) {
        IOUtils.closeQuietly(closeable, (Consumer<IOException>)null);
    }

    public static void closeQuietly(Closeable ... closeableArray) {
        if (closeableArray == null) {
            return;
        }
        for (Closeable closeable : closeableArray) {
            IOUtils.closeQuietly(closeable);
        }
    }

    public static void closeQuietly(Closeable closeable, Consumer<IOException> consumer) {
        block3: {
            if (closeable != null) {
                try {
                    closeable.close();
                }
                catch (IOException iOException) {
                    if (consumer == null) break block3;
                    consumer.accept(iOException);
                }
            }
        }
    }

    public static void closeQuietly(InputStream inputStream) {
        IOUtils.closeQuietly((Closeable)inputStream);
    }

    public static void closeQuietly(OutputStream outputStream) {
        IOUtils.closeQuietly((Closeable)outputStream);
    }

    public static void closeQuietly(Reader reader) {
        IOUtils.closeQuietly((Closeable)reader);
    }

    public static void closeQuietly(Selector selector) {
        IOUtils.closeQuietly((Closeable)selector);
    }

    public static void closeQuietly(ServerSocket serverSocket) {
        IOUtils.closeQuietly((Closeable)serverSocket);
    }

    public static void closeQuietly(Socket socket) {
        IOUtils.closeQuietly((Closeable)socket);
    }

    public static void closeQuietly(Writer writer) {
        IOUtils.closeQuietly((Closeable)writer);
    }

    public static long consume(InputStream inputStream) {
        return IOUtils.copyLarge(inputStream, NullOutputStream.NULL_OUTPUT_STREAM, IOUtils.getByteArray());
    }

    public static boolean contentEquals(InputStream inputStream, InputStream inputStream2) {
        if (inputStream == inputStream2) {
            return true;
        }
        if (inputStream == null || inputStream2 == null) {
            return false;
        }
        byte[] byArray = IOUtils.getByteArray();
        byte[] byArray2 = IOUtils.byteArray();
        block0: while (true) {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            while (true) {
                if (n3 >= 8192) continue block0;
                if (n == n3) {
                    int n4;
                    while ((n4 = inputStream.read(byArray, n, 8192 - n)) == 0) {
                    }
                    if (n4 == -1) {
                        return n2 == n3 && inputStream2.read() == -1;
                    }
                    n += n4;
                }
                if (n2 == n3) {
                    int n5;
                    while ((n5 = inputStream2.read(byArray2, n2, 8192 - n2)) == 0) {
                    }
                    if (n5 == -1) {
                        return n == n3 && inputStream.read() == -1;
                    }
                    n2 += n5;
                }
                if (byArray[n3] != byArray2[n3]) {
                    return false;
                }
                ++n3;
            }
            break;
        }
    }

    public static boolean contentEquals(Reader reader, Reader reader2) {
        if (reader == reader2) {
            return true;
        }
        if (reader == null || reader2 == null) {
            return false;
        }
        char[] cArray = IOUtils.getCharArray();
        char[] cArray2 = IOUtils.charArray();
        block0: while (true) {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            while (true) {
                if (n3 >= 8192) continue block0;
                if (n == n3) {
                    int n4;
                    while ((n4 = reader.read(cArray, n, 8192 - n)) == 0) {
                    }
                    if (n4 == -1) {
                        return n2 == n3 && reader2.read() == -1;
                    }
                    n += n4;
                }
                if (n2 == n3) {
                    int n5;
                    while ((n5 = reader2.read(cArray2, n2, 8192 - n2)) == 0) {
                    }
                    if (n5 == -1) {
                        return n == n3 && reader.read() == -1;
                    }
                    n2 += n5;
                }
                if (cArray[n3] != cArray2[n3]) {
                    return false;
                }
                ++n3;
            }
            break;
        }
    }

    public static boolean contentEqualsIgnoreEOL(Reader reader, Reader reader2) {
        if (reader == reader2) {
            return true;
        }
        if (reader == null ^ reader2 == null) {
            return false;
        }
        BufferedReader bufferedReader = IOUtils.toBufferedReader(reader);
        BufferedReader bufferedReader2 = IOUtils.toBufferedReader(reader2);
        String string = bufferedReader.readLine();
        String string2 = bufferedReader2.readLine();
        while (string != null && string.equals(string2)) {
            string = bufferedReader.readLine();
            string2 = bufferedReader2.readLine();
        }
        return Objects.equals(string, string2);
    }

    public static int copy(InputStream inputStream, OutputStream outputStream) {
        long l = IOUtils.copyLarge(inputStream, outputStream);
        if (l > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)l;
    }

    public static long copy(InputStream inputStream, OutputStream outputStream, int n) {
        return IOUtils.copyLarge(inputStream, outputStream, IOUtils.byteArray(n));
    }

    @Deprecated
    public static void copy(InputStream inputStream, Writer writer) {
        IOUtils.copy(inputStream, writer, Charset.defaultCharset());
    }

    public static void copy(InputStream inputStream, Writer writer, Charset charset) {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, Charsets.toCharset(charset));
        IOUtils.copy((Reader)inputStreamReader, writer);
    }

    public static void copy(InputStream inputStream, Writer writer, String string) {
        IOUtils.copy(inputStream, writer, Charsets.toCharset(string));
    }

    public static long copy(Reader reader, Appendable appendable) {
        return IOUtils.copy(reader, appendable, CharBuffer.allocate(8192));
    }

    public static long copy(Reader reader, Appendable appendable, CharBuffer charBuffer) {
        int n;
        long l = 0L;
        while (-1 != (n = reader.read(charBuffer))) {
            charBuffer.flip();
            appendable.append(charBuffer, 0, n);
            l += (long)n;
        }
        return l;
    }

    @Deprecated
    public static void copy(Reader reader, OutputStream outputStream) {
        IOUtils.copy(reader, outputStream, Charset.defaultCharset());
    }

    public static void copy(Reader reader, OutputStream outputStream, Charset charset) {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, Charsets.toCharset(charset));
        IOUtils.copy(reader, (Writer)outputStreamWriter);
        outputStreamWriter.flush();
    }

    public static void copy(Reader reader, OutputStream outputStream, String string) {
        IOUtils.copy(reader, outputStream, Charsets.toCharset(string));
    }

    public static int copy(Reader reader, Writer writer) {
        long l = IOUtils.copyLarge(reader, writer);
        if (l > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)l;
    }

    public static long copy(URL uRL, File file) {
        try (OutputStream outputStream = Files.newOutputStream(Objects.requireNonNull(file, "file").toPath(), new OpenOption[0]);){
            long l = IOUtils.copy(uRL, outputStream);
            return l;
        }
    }

    public static long copy(URL uRL, OutputStream outputStream) {
        try (InputStream inputStream = Objects.requireNonNull(uRL, "url").openStream();){
            long l = IOUtils.copyLarge(inputStream, outputStream);
            return l;
        }
    }

    public static long copyLarge(InputStream inputStream, OutputStream outputStream) {
        return IOUtils.copy(inputStream, outputStream, 8192);
    }

    public static long copyLarge(InputStream inputStream, OutputStream outputStream, byte[] byArray) {
        int n;
        Objects.requireNonNull(inputStream, "inputStream");
        Objects.requireNonNull(outputStream, "outputStream");
        long l = 0L;
        while (-1 != (n = inputStream.read(byArray))) {
            outputStream.write(byArray, 0, n);
            l += (long)n;
        }
        return l;
    }

    public static long copyLarge(InputStream inputStream, OutputStream outputStream, long l, long l2) {
        return IOUtils.copyLarge(inputStream, outputStream, l, l2, IOUtils.getByteArray());
    }

    public static long copyLarge(InputStream inputStream, OutputStream outputStream, long l, long l2, byte[] byArray) {
        int n;
        int n2;
        if (l > 0L) {
            IOUtils.skipFully(inputStream, l);
        }
        if (l2 == 0L) {
            return 0L;
        }
        int n3 = n2 = byArray.length;
        if (l2 > 0L && l2 < (long)n2) {
            n3 = (int)l2;
        }
        long l3 = 0L;
        while (n3 > 0 && -1 != (n = inputStream.read(byArray, 0, n3))) {
            outputStream.write(byArray, 0, n);
            l3 += (long)n;
            if (l2 <= 0L) continue;
            n3 = (int)Math.min(l2 - l3, (long)n2);
        }
        return l3;
    }

    public static long copyLarge(Reader reader, Writer writer) {
        return IOUtils.copyLarge(reader, writer, IOUtils.getCharArray());
    }

    public static long copyLarge(Reader reader, Writer writer, char[] cArray) {
        int n;
        long l = 0L;
        while (-1 != (n = reader.read(cArray))) {
            writer.write(cArray, 0, n);
            l += (long)n;
        }
        return l;
    }

    public static long copyLarge(Reader reader, Writer writer, long l, long l2) {
        return IOUtils.copyLarge(reader, writer, l, l2, IOUtils.getCharArray());
    }

    public static long copyLarge(Reader reader, Writer writer, long l, long l2, char[] cArray) {
        int n;
        if (l > 0L) {
            IOUtils.skipFully(reader, l);
        }
        if (l2 == 0L) {
            return 0L;
        }
        int n2 = cArray.length;
        if (l2 > 0L && l2 < (long)cArray.length) {
            n2 = (int)l2;
        }
        long l3 = 0L;
        while (n2 > 0 && -1 != (n = reader.read(cArray, 0, n2))) {
            writer.write(cArray, 0, n);
            l3 += (long)n;
            if (l2 <= 0L) continue;
            n2 = (int)Math.min(l2 - l3, (long)cArray.length);
        }
        return l3;
    }

    static byte[] getByteArray() {
        return SKIP_BYTE_BUFFER.get();
    }

    static char[] getCharArray() {
        return SKIP_CHAR_BUFFER.get();
    }

    public static int length(byte[] byArray) {
        return byArray == null ? 0 : byArray.length;
    }

    public static int length(char[] cArray) {
        return cArray == null ? 0 : cArray.length;
    }

    public static int length(CharSequence charSequence) {
        return charSequence == null ? 0 : charSequence.length();
    }

    public static int length(Object[] objectArray) {
        return objectArray == null ? 0 : objectArray.length;
    }

    public static LineIterator lineIterator(InputStream inputStream, Charset charset) {
        return new LineIterator(new InputStreamReader(inputStream, Charsets.toCharset(charset)));
    }

    public static LineIterator lineIterator(InputStream inputStream, String string) {
        return IOUtils.lineIterator(inputStream, Charsets.toCharset(string));
    }

    public static LineIterator lineIterator(Reader reader) {
        return new LineIterator(reader);
    }

    public static int read(InputStream inputStream, byte[] byArray) {
        return IOUtils.read(inputStream, byArray, 0, byArray.length);
    }

    public static int read(InputStream inputStream, byte[] byArray, int n, int n2) {
        int n3;
        int n4;
        int n5;
        if (n2 < 0) {
            throw new IllegalArgumentException("Length must not be negative: " + n2);
        }
        for (n4 = n2; n4 > 0 && -1 != (n5 = inputStream.read(byArray, n + (n3 = n2 - n4), n4)); n4 -= n5) {
        }
        return n2 - n4;
    }

    public static int read(ReadableByteChannel readableByteChannel, ByteBuffer byteBuffer) {
        int n;
        int n2 = byteBuffer.remaining();
        while (byteBuffer.remaining() > 0 && -1 != (n = readableByteChannel.read(byteBuffer))) {
        }
        return n2 - byteBuffer.remaining();
    }

    public static int read(Reader reader, char[] cArray) {
        return IOUtils.read(reader, cArray, 0, cArray.length);
    }

    public static int read(Reader reader, char[] cArray, int n, int n2) {
        int n3;
        int n4;
        int n5;
        if (n2 < 0) {
            throw new IllegalArgumentException("Length must not be negative: " + n2);
        }
        for (n4 = n2; n4 > 0 && -1 != (n5 = reader.read(cArray, n + (n3 = n2 - n4), n4)); n4 -= n5) {
        }
        return n2 - n4;
    }

    public static void readFully(InputStream inputStream, byte[] byArray) {
        IOUtils.readFully(inputStream, byArray, 0, byArray.length);
    }

    public static void readFully(InputStream inputStream, byte[] byArray, int n, int n2) {
        int n3 = IOUtils.read(inputStream, byArray, n, n2);
        if (n3 != n2) {
            throw new EOFException("Length to read: " + n2 + " actual: " + n3);
        }
    }

    public static byte[] readFully(InputStream inputStream, int n) {
        byte[] byArray = IOUtils.byteArray(n);
        IOUtils.readFully(inputStream, byArray, 0, byArray.length);
        return byArray;
    }

    public static void readFully(ReadableByteChannel readableByteChannel, ByteBuffer byteBuffer) {
        int n = byteBuffer.remaining();
        int n2 = IOUtils.read(readableByteChannel, byteBuffer);
        if (n2 != n) {
            throw new EOFException("Length to read: " + n + " actual: " + n2);
        }
    }

    public static void readFully(Reader reader, char[] cArray) {
        IOUtils.readFully(reader, cArray, 0, cArray.length);
    }

    public static void readFully(Reader reader, char[] cArray, int n, int n2) {
        int n3 = IOUtils.read(reader, cArray, n, n2);
        if (n3 != n2) {
            throw new EOFException("Length to read: " + n2 + " actual: " + n3);
        }
    }

    @Deprecated
    public static List<String> readLines(InputStream inputStream) {
        return IOUtils.readLines(inputStream, Charset.defaultCharset());
    }

    public static List<String> readLines(InputStream inputStream, Charset charset) {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, Charsets.toCharset(charset));
        return IOUtils.readLines(inputStreamReader);
    }

    public static List<String> readLines(InputStream inputStream, String string) {
        return IOUtils.readLines(inputStream, Charsets.toCharset(string));
    }

    public static List<String> readLines(Reader reader) {
        String string;
        BufferedReader bufferedReader = IOUtils.toBufferedReader(reader);
        ArrayList<String> arrayList = new ArrayList<String>();
        while ((string = bufferedReader.readLine()) != null) {
            arrayList.add(string);
        }
        return arrayList;
    }

    public static byte[] resourceToByteArray(String string) {
        return IOUtils.resourceToByteArray(string, null);
    }

    public static byte[] resourceToByteArray(String string, ClassLoader classLoader) {
        return IOUtils.toByteArray(IOUtils.resourceToURL(string, classLoader));
    }

    public static String resourceToString(String string, Charset charset) {
        return IOUtils.resourceToString(string, charset, null);
    }

    public static String resourceToString(String string, Charset charset, ClassLoader classLoader) {
        return IOUtils.toString(IOUtils.resourceToURL(string, classLoader), charset);
    }

    public static URL resourceToURL(String string) {
        return IOUtils.resourceToURL(string, null);
    }

    public static URL resourceToURL(String string, ClassLoader classLoader) {
        URL uRL;
        URL uRL2 = uRL = classLoader == null ? IOUtils.class.getResource(string) : classLoader.getResource(string);
        if (uRL == null) {
            throw new IOException("Resource not found: " + string);
        }
        return uRL;
    }

    public static long skip(InputStream inputStream, long l) {
        byte[] byArray;
        long l2;
        long l3;
        if (l < 0L) {
            throw new IllegalArgumentException("Skip count must be non-negative, actual: " + l);
        }
        for (l2 = l; l2 > 0L && (l3 = (long)inputStream.read(byArray = IOUtils.getByteArray(), 0, (int)Math.min(l2, (long)byArray.length))) >= 0L; l2 -= l3) {
        }
        return l - l2;
    }

    public static long skip(ReadableByteChannel readableByteChannel, long l) {
        long l2;
        int n;
        if (l < 0L) {
            throw new IllegalArgumentException("Skip count must be non-negative, actual: " + l);
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate((int)Math.min(l, 8192L));
        for (l2 = l; l2 > 0L; l2 -= (long)n) {
            byteBuffer.position(0);
            byteBuffer.limit((int)Math.min(l2, 8192L));
            n = readableByteChannel.read(byteBuffer);
            if (n == -1) break;
        }
        return l - l2;
    }

    public static long skip(Reader reader, long l) {
        char[] cArray;
        long l2;
        long l3;
        if (l < 0L) {
            throw new IllegalArgumentException("Skip count must be non-negative, actual: " + l);
        }
        for (l2 = l; l2 > 0L && (l3 = (long)reader.read(cArray = IOUtils.getCharArray(), 0, (int)Math.min(l2, (long)cArray.length))) >= 0L; l2 -= l3) {
        }
        return l - l2;
    }

    public static void skipFully(InputStream inputStream, long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("Bytes to skip must not be negative: " + l);
        }
        long l2 = IOUtils.skip(inputStream, l);
        if (l2 != l) {
            throw new EOFException("Bytes to skip: " + l + " actual: " + l2);
        }
    }

    public static void skipFully(ReadableByteChannel readableByteChannel, long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("Bytes to skip must not be negative: " + l);
        }
        long l2 = IOUtils.skip(readableByteChannel, l);
        if (l2 != l) {
            throw new EOFException("Bytes to skip: " + l + " actual: " + l2);
        }
    }

    public static void skipFully(Reader reader, long l) {
        long l2 = IOUtils.skip(reader, l);
        if (l2 != l) {
            throw new EOFException("Chars to skip: " + l + " actual: " + l2);
        }
    }

    public static InputStream toBufferedInputStream(InputStream inputStream) {
        return ByteArrayOutputStream.toBufferedInputStream(inputStream);
    }

    public static InputStream toBufferedInputStream(InputStream inputStream, int n) {
        return ByteArrayOutputStream.toBufferedInputStream(inputStream, n);
    }

    public static BufferedReader toBufferedReader(Reader reader) {
        return reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
    }

    public static BufferedReader toBufferedReader(Reader reader, int n) {
        return reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n);
    }

    public static byte[] toByteArray(InputStream inputStream) {
        try (UnsynchronizedByteArrayOutputStream unsynchronizedByteArrayOutputStream = new UnsynchronizedByteArrayOutputStream();){
            ThresholdingOutputStream thresholdingOutputStream2 = new ThresholdingOutputStream(Integer.MAX_VALUE, thresholdingOutputStream -> {
                throw new IllegalArgumentException(String.format("Cannot read more than %,d into a byte array", Integer.MAX_VALUE));
            }, thresholdingOutputStream -> unsynchronizedByteArrayOutputStream);
            try {
                IOUtils.copy(inputStream, (OutputStream)thresholdingOutputStream2);
                byte[] byArray = unsynchronizedByteArrayOutputStream.toByteArray();
                thresholdingOutputStream2.close();
                return byArray;
            }
            catch (Throwable throwable) {
                try {
                    thresholdingOutputStream2.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    public static byte[] toByteArray(InputStream inputStream, int n) {
        int n2;
        int n3;
        if (n < 0) {
            throw new IllegalArgumentException("Size must be equal or greater than zero: " + n);
        }
        if (n == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        byte[] byArray = IOUtils.byteArray(n);
        for (n2 = 0; n2 < n && (n3 = inputStream.read(byArray, n2, n - n2)) != -1; n2 += n3) {
        }
        if (n2 != n) {
            throw new IOException("Unexpected read size, current: " + n2 + ", expected: " + n);
        }
        return byArray;
    }

    public static byte[] toByteArray(InputStream inputStream, long l) {
        if (l > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Size cannot be greater than Integer max value: " + l);
        }
        return IOUtils.toByteArray(inputStream, (int)l);
    }

    @Deprecated
    public static byte[] toByteArray(Reader reader) {
        return IOUtils.toByteArray(reader, Charset.defaultCharset());
    }

    public static byte[] toByteArray(Reader reader, Charset charset) {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            IOUtils.copy(reader, (OutputStream)byteArrayOutputStream, charset);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
    }

    public static byte[] toByteArray(Reader reader, String string) {
        return IOUtils.toByteArray(reader, Charsets.toCharset(string));
    }

    @Deprecated
    public static byte[] toByteArray(String string) {
        return string.getBytes(Charset.defaultCharset());
    }

    public static byte[] toByteArray(URI uRI) {
        return IOUtils.toByteArray(uRI.toURL());
    }

    public static byte[] toByteArray(URL uRL) {
        URLConnection uRLConnection = uRL.openConnection();
        try {
            byte[] byArray = IOUtils.toByteArray(uRLConnection);
            return byArray;
        }
        finally {
            IOUtils.close(uRLConnection);
        }
    }

    public static byte[] toByteArray(URLConnection uRLConnection) {
        try (InputStream inputStream = uRLConnection.getInputStream();){
            byte[] byArray = IOUtils.toByteArray(inputStream);
            return byArray;
        }
    }

    @Deprecated
    public static char[] toCharArray(InputStream inputStream) {
        return IOUtils.toCharArray(inputStream, Charset.defaultCharset());
    }

    public static char[] toCharArray(InputStream inputStream, Charset charset) {
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        IOUtils.copy(inputStream, (Writer)charArrayWriter, charset);
        return charArrayWriter.toCharArray();
    }

    public static char[] toCharArray(InputStream inputStream, String string) {
        return IOUtils.toCharArray(inputStream, Charsets.toCharset(string));
    }

    public static char[] toCharArray(Reader reader) {
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        IOUtils.copy(reader, (Writer)charArrayWriter);
        return charArrayWriter.toCharArray();
    }

    @Deprecated
    public static InputStream toInputStream(CharSequence charSequence) {
        return IOUtils.toInputStream(charSequence, Charset.defaultCharset());
    }

    public static InputStream toInputStream(CharSequence charSequence, Charset charset) {
        return IOUtils.toInputStream(charSequence.toString(), charset);
    }

    public static InputStream toInputStream(CharSequence charSequence, String string) {
        return IOUtils.toInputStream(charSequence, Charsets.toCharset(string));
    }

    @Deprecated
    public static InputStream toInputStream(String string) {
        return IOUtils.toInputStream(string, Charset.defaultCharset());
    }

    public static InputStream toInputStream(String string, Charset charset) {
        return new ByteArrayInputStream(string.getBytes(Charsets.toCharset(charset)));
    }

    public static InputStream toInputStream(String string, String string2) {
        byte[] byArray = string.getBytes(Charsets.toCharset(string2));
        return new ByteArrayInputStream(byArray);
    }

    @Deprecated
    public static String toString(byte[] byArray) {
        return new String(byArray, Charset.defaultCharset());
    }

    public static String toString(byte[] byArray, String string) {
        return new String(byArray, Charsets.toCharset(string));
    }

    @Deprecated
    public static String toString(InputStream inputStream) {
        return IOUtils.toString(inputStream, Charset.defaultCharset());
    }

    public static String toString(InputStream inputStream, Charset charset) {
        try (StringBuilderWriter stringBuilderWriter = new StringBuilderWriter();){
            IOUtils.copy(inputStream, (Writer)stringBuilderWriter, charset);
            String string = stringBuilderWriter.toString();
            return string;
        }
    }

    public static String toString(InputStream inputStream, String string) {
        return IOUtils.toString(inputStream, Charsets.toCharset(string));
    }

    public static String toString(Reader reader) {
        try (StringBuilderWriter stringBuilderWriter = new StringBuilderWriter();){
            IOUtils.copy(reader, (Writer)stringBuilderWriter);
            String string = stringBuilderWriter.toString();
            return string;
        }
    }

    @Deprecated
    public static String toString(URI uRI) {
        return IOUtils.toString(uRI, Charset.defaultCharset());
    }

    public static String toString(URI uRI, Charset charset) {
        return IOUtils.toString(uRI.toURL(), Charsets.toCharset(charset));
    }

    public static String toString(URI uRI, String string) {
        return IOUtils.toString(uRI, Charsets.toCharset(string));
    }

    @Deprecated
    public static String toString(URL uRL) {
        return IOUtils.toString(uRL, Charset.defaultCharset());
    }

    public static String toString(URL uRL, Charset charset) {
        try (InputStream inputStream = uRL.openStream();){
            String string = IOUtils.toString(inputStream, charset);
            return string;
        }
    }

    public static String toString(URL uRL, String string) {
        return IOUtils.toString(uRL, Charsets.toCharset(string));
    }

    public static void write(byte[] byArray, OutputStream outputStream) {
        if (byArray != null) {
            outputStream.write(byArray);
        }
    }

    @Deprecated
    public static void write(byte[] byArray, Writer writer) {
        IOUtils.write(byArray, writer, Charset.defaultCharset());
    }

    public static void write(byte[] byArray, Writer writer, Charset charset) {
        if (byArray != null) {
            writer.write(new String(byArray, Charsets.toCharset(charset)));
        }
    }

    public static void write(byte[] byArray, Writer writer, String string) {
        IOUtils.write(byArray, writer, Charsets.toCharset(string));
    }

    @Deprecated
    public static void write(char[] cArray, OutputStream outputStream) {
        IOUtils.write(cArray, outputStream, Charset.defaultCharset());
    }

    public static void write(char[] cArray, OutputStream outputStream, Charset charset) {
        if (cArray != null) {
            outputStream.write(new String(cArray).getBytes(Charsets.toCharset(charset)));
        }
    }

    public static void write(char[] cArray, OutputStream outputStream, String string) {
        IOUtils.write(cArray, outputStream, Charsets.toCharset(string));
    }

    public static void write(char[] cArray, Writer writer) {
        if (cArray != null) {
            writer.write(cArray);
        }
    }

    @Deprecated
    public static void write(CharSequence charSequence, OutputStream outputStream) {
        IOUtils.write(charSequence, outputStream, Charset.defaultCharset());
    }

    public static void write(CharSequence charSequence, OutputStream outputStream, Charset charset) {
        if (charSequence != null) {
            IOUtils.write(charSequence.toString(), outputStream, charset);
        }
    }

    public static void write(CharSequence charSequence, OutputStream outputStream, String string) {
        IOUtils.write(charSequence, outputStream, Charsets.toCharset(string));
    }

    public static void write(CharSequence charSequence, Writer writer) {
        if (charSequence != null) {
            IOUtils.write(charSequence.toString(), writer);
        }
    }

    @Deprecated
    public static void write(String string, OutputStream outputStream) {
        IOUtils.write(string, outputStream, Charset.defaultCharset());
    }

    public static void write(String string, OutputStream outputStream, Charset charset) {
        if (string != null) {
            outputStream.write(string.getBytes(Charsets.toCharset(charset)));
        }
    }

    public static void write(String string, OutputStream outputStream, String string2) {
        IOUtils.write(string, outputStream, Charsets.toCharset(string2));
    }

    public static void write(String string, Writer writer) {
        if (string != null) {
            writer.write(string);
        }
    }

    @Deprecated
    public static void write(StringBuffer stringBuffer, OutputStream outputStream) {
        IOUtils.write(stringBuffer, outputStream, (String)null);
    }

    @Deprecated
    public static void write(StringBuffer stringBuffer, OutputStream outputStream, String string) {
        if (stringBuffer != null) {
            outputStream.write(stringBuffer.toString().getBytes(Charsets.toCharset(string)));
        }
    }

    @Deprecated
    public static void write(StringBuffer stringBuffer, Writer writer) {
        if (stringBuffer != null) {
            writer.write(stringBuffer.toString());
        }
    }

    public static void writeChunked(byte[] byArray, OutputStream outputStream) {
        if (byArray != null) {
            int n = byArray.length;
            int n2 = 0;
            while (n > 0) {
                int n3 = Math.min(n, 8192);
                outputStream.write(byArray, n2, n3);
                n -= n3;
                n2 += n3;
            }
        }
    }

    public static void writeChunked(char[] cArray, Writer writer) {
        if (cArray != null) {
            int n = cArray.length;
            int n2 = 0;
            while (n > 0) {
                int n3 = Math.min(n, 8192);
                writer.write(cArray, n2, n3);
                n -= n3;
                n2 += n3;
            }
        }
    }

    @Deprecated
    public static void writeLines(Collection<?> collection, String string, OutputStream outputStream) {
        IOUtils.writeLines(collection, string, outputStream, Charset.defaultCharset());
    }

    public static void writeLines(Collection<?> collection, String string, OutputStream outputStream, Charset charset) {
        if (collection == null) {
            return;
        }
        if (string == null) {
            string = System.lineSeparator();
        }
        Charset charset2 = Charsets.toCharset(charset);
        for (Object obj : collection) {
            if (obj != null) {
                outputStream.write(obj.toString().getBytes(charset2));
            }
            outputStream.write(string.getBytes(charset2));
        }
    }

    public static void writeLines(Collection<?> collection, String string, OutputStream outputStream, String string2) {
        IOUtils.writeLines(collection, string, outputStream, Charsets.toCharset(string2));
    }

    public static void writeLines(Collection<?> collection, String string, Writer writer) {
        if (collection == null) {
            return;
        }
        if (string == null) {
            string = System.lineSeparator();
        }
        for (Object obj : collection) {
            if (obj != null) {
                writer.write(obj.toString());
            }
            writer.write(string);
        }
    }

    public static Writer writer(Appendable appendable) {
        Objects.requireNonNull(appendable, "appendable");
        if (appendable instanceof Writer) {
            return (Writer)appendable;
        }
        if (appendable instanceof StringBuilder) {
            return new StringBuilderWriter((StringBuilder)appendable);
        }
        return new AppendableWriter<Appendable>(appendable);
    }
}

