/*
 * Decompiled with CFR 0.152.
 */
package com.xericker.mysteryboxes.commands;

import com.xericker.mysteryboxes.Main;
import com.xericker.mysteryboxes.commands.CommandInterface;
import com.xericker.mysteryboxes.commands.executors.ExecuteAlerts;
import com.xericker.mysteryboxes.commands.executors.ExecuteCommands;
import com.xericker.mysteryboxes.commands.executors.ExecuteDev;
import com.xericker.mysteryboxes.commands.executors.ExecuteReload;
import com.xericker.mysteryboxes.commands.executors.ExecuteRoot;
import com.xericker.mysteryboxes.commands.executors.ExecuteStats;
import com.xericker.mysteryboxes.commands.executors.ExecuteTest;
import com.xericker.mysteryboxes.commands.executors.boxes.ExecuteBoxInfo;
import com.xericker.mysteryboxes.commands.executors.boxes.ExecuteBoxList;
import com.xericker.mysteryboxes.commands.executors.boxes.ExecuteBoxUpdater;
import com.xericker.mysteryboxes.commands.executors.boxes.ExecuteBoxUpdaterAll;
import com.xericker.mysteryboxes.commands.executors.boxes.ExecuteGiftUpdater;
import com.xericker.mysteryboxes.commands.executors.boxes.ExecuteRBoxUpdater;
import com.xericker.mysteryboxes.commands.executors.boxes.ExecuteRBoxUpdaterAll;
import com.xericker.mysteryboxes.commands.executors.dust.ExecuteDustUpdater;
import com.xericker.mysteryboxes.commands.executors.dust.ExecuteDustUpdaterAll;
import com.xericker.mysteryboxes.commands.executors.loots.ExecuteLootList;
import com.xericker.mysteryboxes.commands.executors.menus.ExecuteMenu;
import com.xericker.mysteryboxes.commands.executors.menus.ExecuteTriggerScan;
import com.xericker.mysteryboxes.commands.executors.songs.ExecuteSongList;
import com.xericker.mysteryboxes.commands.executors.songs.ExecuteSongPack;
import com.xericker.mysteryboxes.commands.executors.songs.ExecuteSongUpdater;
import com.xericker.mysteryboxes.commands.executors.themes.ExecuteThemeList;
import com.xericker.mysteryboxes.commands.executors.themes.ExecuteThemeUpdater;
import com.xericker.mysteryboxes.config.files.LanguageValue;
import com.xericker.mysteryboxes.config.handlers.ConfigParser;
import java.util.Arrays;
import java.util.Optional;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public enum Command {
    SETBOXES(ExecuteBoxUpdater.class, new String[]{"[player]", "[box ID]", "[amount]"}, "Set boxes for a player"),
    ADDBOXES(ExecuteBoxUpdater.class, new String[]{"[player]", "[box ID]", "[amount]"}, "Add boxes to a player"),
    REMOVEBOXES(ExecuteBoxUpdater.class, new String[]{"[player]", "[box ID]", "[amount]"}, "Remove boxes from a player"),
    SETBOXESALL(ExecuteBoxUpdaterAll.class, new String[]{"[box ID]", "[amount]"}, "Set boxes for all players"),
    ADDBOXESALL(ExecuteBoxUpdaterAll.class, new String[]{"[box ID]", "[amount]"}, "Add boxes to all players"),
    REMOVEBOXESALL(ExecuteBoxUpdaterAll.class, new String[]{"[box ID]", "[amount]"}, "Remove boxes from all players"),
    ADDRANDOMBOXES(ExecuteRBoxUpdater.class, new String[]{"[player]", "[amount]/[range]"}, "Add random boxes to a player"),
    ADDRANDOMBOXESALL(ExecuteRBoxUpdaterAll.class, new String[]{"[amount]/[range]"}, "Add random boxes to all players"),
    LISTBOXES(ExecuteBoxList.class, new String[]{"boxes"}, "List all available boxes"),
    BOXINFO(ExecuteBoxInfo.class, new String[]{"box"}, new String[]{"[box ID]"}, "See info about a box"),
    LISTLOOTS(ExecuteLootList.class, new String[]{"loots"}, null, "List all available loots"),
    SETGIFTS(ExecuteGiftUpdater.class, new String[]{"[player]", "[box ID]", "[amount]"}, "Set gifts for a player"),
    ADDGIFTS(ExecuteGiftUpdater.class, new String[]{"[player]", "[box ID]", "[amount]"}, "Add gifts to a player"),
    REMOVEGIFTS(ExecuteGiftUpdater.class, new String[]{"[player]", "[box ID]", "[amount]"}, "Remove gifts from a player"),
    LISTSONGS(ExecuteSongList.class, new String[]{"songs"}, "List all available songs"),
    UNLOCKSONG(ExecuteSongUpdater.class, new String[]{"unlocksongs"}, new String[]{"[player]", "[song ID]/all"}, "Unlock a song for a player"),
    LOCKSONG(ExecuteSongUpdater.class, new String[]{"locksongs"}, new String[]{"[player]", "[song ID]/all"}, "Lock a song for a player"),
    GENSONGPACK(ExecuteSongPack.class, new String[]{"gensongs", "genpack"}, "Generate a song pack"),
    SCANSONGPACK(ExecuteSongPack.class, new String[]{"scanpack"}, "Validate files before generating a song pack"),
    LISTTHEMES(ExecuteThemeList.class, new String[]{"themes"}, "List all available themes"),
    UNLOCKTHEME(ExecuteThemeUpdater.class, new String[]{"unlockthemes"}, new String[]{"[player]", "[theme ID]/all"}, "Unlock a theme for a player"),
    LOCKTHEME(ExecuteThemeUpdater.class, new String[]{"lockthemes"}, new String[]{"[player]", "[theme ID]/all"}, "Lock a theme for a player"),
    SETDUST(ExecuteDustUpdater.class, new String[]{"[player]", "[amount]"}, "Set dust for a player"),
    ADDDUST(ExecuteDustUpdater.class, new String[]{"[player]", "[amount]"}, "Add dust to a player"),
    REMOVEDUST(ExecuteDustUpdater.class, new String[]{"[player]", "[amount]"}, "Remove dust from a player"),
    SETDUSTALL(ExecuteDustUpdaterAll.class, new String[]{"[amount]"}, "Set dust for all players"),
    ADDDUSTALL(ExecuteDustUpdaterAll.class, new String[]{"[amount]"}, "Add dust to all players"),
    REMOVEDUSTALL(ExecuteDustUpdaterAll.class, new String[]{"[amount]"}, "Remove dust from all players"),
    COMMANDS(ExecuteCommands.class, new String[]{"listcommands", "command", "list"}, new String[]{"[page]"}, "List all available commands"),
    ALERTS(ExecuteAlerts.class, new String[]{"alert"}, "Open the Alerts Visibility menu"),
    STATS(ExecuteStats.class, new String[]{"stat"}, new String[]{"[player]"}, "View stats of yourself or other players"),
    MENU(ExecuteMenu.class, new String[]{"menus"}, new String[]{"[menu ID]"}, "Open a specific menu"),
    SCANTRIGGERS(ExecuteTriggerScan.class, new String[]{"scantrigger"}, "Scan triggers of all menus"),
    RELOAD(ExecuteReload.class),
    DEV(ExecuteDev.class, true),
    TEST(ExecuteTest.class, true),
    ROOT(ExecuteRoot.class, true);

    private final Class<? extends CommandInterface> executor;
    private final boolean hidden;
    private final String[] aliases;
    private final String[] arguments;
    private String description = "Description not available";

    private Command(Class<? extends CommandInterface> clazz) {
        this(clazz, false, null, null, null);
    }

    private Command(Class<? extends CommandInterface> clazz, boolean bl) {
        this(clazz, bl, null, null, null);
    }

    private Command(Class<? extends CommandInterface> clazz, String[] stringArray) {
        this(clazz, false, stringArray, null, null);
    }

    private Command(Class<? extends CommandInterface> clazz, String[] stringArray, String string2) {
        this(clazz, false, stringArray, null, string2);
    }

    private Command(Class<? extends CommandInterface> clazz, String[] stringArray, String[] stringArray2) {
        this(clazz, false, stringArray, stringArray2, null);
    }

    private Command(Class<? extends CommandInterface> clazz, String[] stringArray, String[] stringArray2, String string2) {
        this(clazz, false, stringArray, stringArray2, string2);
    }

    private Command(Class<? extends CommandInterface> clazz, boolean bl, String[] stringArray, String[] stringArray2, String string2) {
        this.executor = clazz;
        this.hidden = bl;
        this.aliases = stringArray;
        this.arguments = stringArray2;
        if (string2 != null) {
            this.description = string2;
        }
    }

    public String getName() {
        return this.name().toLowerCase();
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public String[] getAliases() {
        return this.aliases;
    }

    public String[] getArguments() {
        return this.arguments;
    }

    public String getPermission() {
        return Main.getPlugin().getName().toLowerCase() + ".command." + this.name().toLowerCase();
    }

    public String getDescription() {
        return this.description;
    }

    public static Optional<Command> parseCommand(String string) {
        return Arrays.stream(Command.values()).filter(command -> command.getName().equalsIgnoreCase(string) || command.getAliases() != null && Arrays.stream(command.getAliases()).anyMatch(string2 -> string2.equalsIgnoreCase(string))).findFirst();
    }

    public void execute(CommandSender commandSender, String[] stringArray) {
        try {
            if (!this.hasPermission(commandSender, this, true)) {
                return;
            }
            CommandInterface commandInterface = this.executor.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            commandInterface.execute(commandSender, this, stringArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean hasPermission(Object object, Command command, boolean bl) {
        if (!(object instanceof Player)) {
            return true;
        }
        Player player = (Player)object;
        String string = "mysteryboxes.command.*";
        if (player.hasPermission(string)) {
            return true;
        }
        String string2 = command.getPermission();
        if (player.hasPermission(string2)) {
            return true;
        }
        if (bl) {
            for (String string3 : ConfigParser.getStringList(LanguageValue.GENERAL_NO_PERMISSION)) {
                player.sendMessage(string3);
            }
        }
        return false;
    }
}

