/*
 * Decompiled with CFR 0.152.
 */
package com.xericker.mysteryboxes.compiled.utils.nmsmappings;

import com.xericker.mysteryboxes.compiled.utils.MinecraftVersion;
import com.xericker.mysteryboxes.compiled.utils.nmsmappings.Forge1710Mappings;
import com.xericker.mysteryboxes.compiled.utils.nmsmappings.PackageWrapper;
import java.util.logging.Level;

public enum ClassWrapper {
    CRAFT_ITEMSTACK(PackageWrapper.CRAFTBUKKIT, "inventory.CraftItemStack", null, null),
    CRAFT_METAITEM(PackageWrapper.CRAFTBUKKIT, "inventory.CraftMetaItem", null, null),
    CRAFT_ENTITY(PackageWrapper.CRAFTBUKKIT, "entity.CraftEntity", null, null),
    CRAFT_WORLD(PackageWrapper.CRAFTBUKKIT, "CraftWorld", null, null),
    CRAFT_PERSISTENTDATACONTAINER(PackageWrapper.CRAFTBUKKIT, "persistence.CraftPersistentDataContainer", MinecraftVersion.MC1_14_R1, null),
    NMS_NBTBASE(PackageWrapper.NMS, "NBTBase", null, null, "net.minecraft.nbt", "net.minecraft.nbt.Tag"),
    NMS_NBTTAGSTRING(PackageWrapper.NMS, "NBTTagString", null, null, "net.minecraft.nbt", "net.minecraft.nbt.StringTag"),
    NMS_NBTTAGINT(PackageWrapper.NMS, "NBTTagInt", null, null, "net.minecraft.nbt", "net.minecraft.nbt.IntTag"),
    NMS_NBTTAGINTARRAY(PackageWrapper.NMS, "NBTTagIntArray", null, null, "net.minecraft.nbt", "net.minecraft.nbt.IntArrayTag"),
    NMS_NBTTAGFLOAT(PackageWrapper.NMS, "NBTTagFloat", null, null, "net.minecraft.nbt", "net.minecraft.nbt.FloatTag"),
    NMS_NBTTAGDOUBLE(PackageWrapper.NMS, "NBTTagDouble", null, null, "net.minecraft.nbt", "net.minecraft.nbt.DoubleTag"),
    NMS_NBTTAGLONG(PackageWrapper.NMS, "NBTTagLong", null, null, "net.minecraft.nbt", "net.minecraft.nbt.LongTag"),
    NMS_ITEMSTACK(PackageWrapper.NMS, "ItemStack", null, null, "net.minecraft.world.item", "net.minecraft.world.item.ItemStack"),
    NMS_NBTTAGCOMPOUND(PackageWrapper.NMS, "NBTTagCompound", null, null, "net.minecraft.nbt", "net.minecraft.nbt.CompoundTag"),
    NMS_NBTTAGLIST(PackageWrapper.NMS, "NBTTagList", null, null, "net.minecraft.nbt", "net.minecraft.nbt.ListTag"),
    NMS_NBTCOMPRESSEDSTREAMTOOLS(PackageWrapper.NMS, "NBTCompressedStreamTools", null, null, "net.minecraft.nbt", "net.minecraft.nbt.NbtIo"),
    NMS_MOJANGSONPARSER(PackageWrapper.NMS, "MojangsonParser", null, null, "net.minecraft.nbt", "net.minecraft.nbt.TagParser"),
    NMS_TILEENTITY(PackageWrapper.NMS, "TileEntity", null, null, "net.minecraft.world.level.block.entity", "net.minecraft.world.level.block.entity.BlockEntity"),
    NMS_BLOCKPOSITION(PackageWrapper.NMS, "BlockPosition", MinecraftVersion.MC1_8_R3, null, "net.minecraft.core", "net.minecraft.core.BlockPos"),
    NMS_WORLDSERVER(PackageWrapper.NMS, "WorldServer", null, null, "net.minecraft.server.level", "net.minecraft.server.level.ServerLevel"),
    NMS_MINECRAFTSERVER(PackageWrapper.NMS, "MinecraftServer", null, null, "net.minecraft.server", "net.minecraft.server.MinecraftServer"),
    NMS_WORLD(PackageWrapper.NMS, "World", null, null, "net.minecraft.world.level", "net.minecraft.world.level.Level"),
    NMS_ENTITY(PackageWrapper.NMS, "Entity", null, null, "net.minecraft.world.entity", "net.minecraft.world.entity.Entity"),
    NMS_ENTITYTYPES(PackageWrapper.NMS, "EntityTypes", null, null, "net.minecraft.world.entity", "net.minecraft.world.entity.EntityType"),
    NMS_REGISTRYSIMPLE(PackageWrapper.NMS, "RegistrySimple", MinecraftVersion.MC1_11_R1, MinecraftVersion.MC1_12_R1),
    NMS_REGISTRYMATERIALS(PackageWrapper.NMS, "RegistryMaterials", null, null, "net.minecraft.core", "net.minecraft.core.MappedRegistry"),
    NMS_IREGISTRY(PackageWrapper.NMS, "IRegistry", null, null, "net.minecraft.core", "net.minecraft.core.Registry"),
    NMS_MINECRAFTKEY(PackageWrapper.NMS, "MinecraftKey", MinecraftVersion.MC1_8_R3, null, "net.minecraft.resources", "net.minecraft.resources.ResourceKey"),
    NMS_GAMEPROFILESERIALIZER(PackageWrapper.NMS, "GameProfileSerializer", null, null, "net.minecraft.nbt", "net.minecraft.nbt.NbtUtils"),
    NMS_IBLOCKDATA(PackageWrapper.NMS, "IBlockData", MinecraftVersion.MC1_8_R3, null, "net.minecraft.world.level.block.state", "net.minecraft.world.level.block.state.BlockState"),
    GAMEPROFILE(PackageWrapper.NONE, "com.mojang.authlib.GameProfile", MinecraftVersion.MC1_8_R3, null);

    private Class<?> clazz;
    private boolean enabled = false;
    private final String mojangName;

    private ClassWrapper(PackageWrapper packageWrapper, String string2, MinecraftVersion minecraftVersion, MinecraftVersion minecraftVersion2) {
        this(packageWrapper, string2, minecraftVersion, minecraftVersion2, null, null);
    }

    private ClassWrapper(PackageWrapper packageWrapper, String string2, MinecraftVersion minecraftVersion, MinecraftVersion minecraftVersion2, String string3, String string4) {
        this.mojangName = string4;
        if (minecraftVersion != null && MinecraftVersion.getVersion().getVersionId() < minecraftVersion.getVersionId()) {
            return;
        }
        if (minecraftVersion2 != null && MinecraftVersion.getVersion().getVersionId() > minecraftVersion2.getVersionId()) {
            return;
        }
        this.enabled = true;
        try {
            if (MinecraftVersion.isAtLeastVersion(MinecraftVersion.MC1_18_R1) && string4 != null) {
                try {
                    this.clazz = Class.forName(string4);
                    return;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            if (MinecraftVersion.isAtLeastVersion(MinecraftVersion.MC1_17_R1) && string3 != null) {
                this.clazz = Class.forName(string3 + "." + string2);
            } else if (packageWrapper == PackageWrapper.NONE) {
                this.clazz = Class.forName(string2);
            } else if (MinecraftVersion.isForgePresent() && MinecraftVersion.getVersion() == MinecraftVersion.MC1_7_R4 && Forge1710Mappings.getClassMappings().get(this.name()) != null) {
                string2 = Forge1710Mappings.getClassMappings().get(this.name());
                this.clazz = Class.forName(string2);
            } else {
                String string5 = MinecraftVersion.getVersion().getPackageName();
                this.clazz = Class.forName(packageWrapper.getUri() + "." + string5 + "." + string2);
            }
        }
        catch (Throwable throwable) {
            MinecraftVersion.getLogger().log(Level.WARNING, "[NBTAPI] Error while trying to resolve the class '" + string2 + "'!", throwable);
        }
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getMojangName() {
        return this.mojangName;
    }
}

