/*
 * Decompiled with CFR 0.152.
 */
package com.xericker.mysteryboxes.core.events.opening;

import com.google.common.collect.Lists;
import com.xericker.mysteryboxes.Main;
import com.xericker.mysteryboxes.config.files.LanguageValue;
import com.xericker.mysteryboxes.config.handlers.ConfigParser;
import com.xericker.mysteryboxes.core.events.opening.OpenEventData;
import com.xericker.mysteryboxes.core.events.opening.loots.LootAcquired;
import com.xericker.mysteryboxes.core.events.opening.loots.LootHandler;
import com.xericker.mysteryboxes.core.events.opening.themes.ThemeHandler;
import com.xericker.mysteryboxes.core.events.opening.utils.BoxEntity;
import com.xericker.mysteryboxes.core.events.opening.utils.OpenEffects;
import com.xericker.mysteryboxes.core.songpack.SongPackRequest;
import com.xericker.mysteryboxes.core.songpack.SongPlayer;
import com.xericker.mysteryboxes.core.vaults.VaultAction;
import com.xericker.mysteryboxes.handlers.data.loots.Loot;
import com.xericker.mysteryboxes.handlers.data.loots.LootReveal;
import com.xericker.mysteryboxes.handlers.placeholders.GeneralPlaceholders;
import com.xericker.mysteryboxes.playerdata.player.PlayerData;
import com.xericker.mysteryboxes.playerdata.player.PlayerDataManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerResourcePackStatusEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import utils.PlayerUtils;
import utils.WorldUtils;

public class OpenEvent {
    private Player player;
    private OpenEventData openEventData;
    private int eventStep;
    private int finishStep;
    private int revealDelay;
    private boolean startReveal;
    private boolean tickRevealDelay;
    private boolean eventCancelled;
    private boolean eventFinished;
    private List<Loot> loots;
    private List<ArmorStand> holograms;
    private ArmorStand bigBoxEntity;
    private Map<ArmorStand, Loot> boxes;
    private SongPlayer songPlayer;
    private ThemeHandler themeExecutor;

    public OpenEvent(Player player, OpenEventData openEventData) {
        this.player = player;
        this.openEventData = openEventData;
    }

    public void openBox() {
        boolean bl;
        if (this.openEventData == null) {
            return;
        }
        PlayerData playerData = PlayerDataManager.getData(this.player);
        final Location location = this.getEventLocation();
        playerData.setVaultAction(VaultAction.OPENING);
        if (this.openEventData.vault != null) {
            this.openEventData.vault.setVaultAction(VaultAction.OPENING);
        }
        if (this.openEventData.forceTheme != null) {
            this.openEventData.startEventStep += 40;
            this.openEventData.chargeEventStep += 40;
            this.openEventData.revealEventStep += 40;
        }
        this.loots = LootHandler.getLoots(this.player, this.openEventData.box, this.openEventData.boxesToOpen);
        this.boxes = new HashMap<ArmorStand, Loot>();
        this.holograms = new ArrayList<ArmorStand>();
        this.themeExecutor = new ThemeHandler(this);
        this.themeExecutor.playTheme();
        SongPackRequest songPackRequest = playerData.getSongPackRequest();
        boolean bl2 = songPackRequest != null && songPackRequest.getStatus() == PlayerResourcePackStatusEvent.Status.SUCCESSFULLY_LOADED;
        boolean bl3 = bl = bl2 && (playerData.getChosenSongId() != null || this.openEventData.forceSongData != null);
        if (bl) {
            this.songPlayer = new SongPlayer(this);
        }
        new BukkitRunnable(){

            public void run() {
                boolean bl;
                Object object;
                ++OpenEvent.this.eventStep;
                if (OpenEvent.this.tickRevealDelay && OpenEvent.this.revealDelay > 0) {
                    --OpenEvent.this.revealDelay;
                    return;
                }
                if (OpenEvent.this.eventFinished && OpenEvent.this.revealDelay == 0) {
                    ++OpenEvent.this.finishStep;
                }
                if (OpenEvent.this.shouldContinue()) {
                    OpenEvent.this.themeExecutor.stopTheme();
                    OpenEvent.this.themeExecutor.stopSong();
                    OpenEvent.this.removeLeftovers();
                    this.cancel();
                    return;
                }
                if (OpenEvent.this.eventStep < OpenEvent.this.openEventData.startEventStep) {
                    return;
                }
                if (OpenEvent.this.eventStep == OpenEvent.this.openEventData.startEventStep) {
                    OpenEvent.this.bigBoxEntity = (ArmorStand)location.getWorld().spawn(location.clone().subtract(0.0, 2.0, 0.0), ArmorStand.class);
                    object = OpenEvent.this.loots.get(Main.getRandom().nextInt(OpenEvent.this.loots.size()));
                    OpenEvent.this.boxes.put(OpenEvent.this.bigBoxEntity, (Loot)object);
                    BoxEntity.BEFORE_REVEAL.updateBox(OpenEvent.this.bigBoxEntity, OpenEvent.this.openEventData.box, OpenEvent.this.boxes.get(OpenEvent.this.bigBoxEntity));
                    BoxEntity.updateEntity(OpenEvent.this.bigBoxEntity);
                    OpenEvent.this.themeExecutor.playAnimation(OpenEvent.this.bigBoxEntity);
                    if (OpenEvent.this.songPlayer == null) {
                        OpenEvent.this.themeExecutor.playSong();
                    } else {
                        OpenEvent.this.songPlayer.playSong();
                    }
                    for (Player player : PlayerUtils.getNearbyPlayers(OpenEvent.this.getEventLocation(), 15.0)) {
                        WorldUtils.sendChestAction(player, OpenEvent.this.getEventLocation(), 1);
                    }
                }
                if (OpenEvent.this.eventStep == OpenEvent.this.openEventData.chargeEventStep + 5) {
                    OpenEvent.this.themeExecutor.stopSong();
                    OpenEffects.playCharge(OpenEvent.this.bigBoxEntity);
                    if (OpenEvent.this.openEventData.boxesToOpen > 1) {
                        OpenEvent.this.themeExecutor.getAnimation().spawnBoxes();
                    }
                    if (OpenEvent.this.openEventData.vault != null) {
                        for (Player player : PlayerUtils.getNearbyPlayers(OpenEvent.this.getEventLocation(), 15.0)) {
                            WorldUtils.sendChestAction(player, OpenEvent.this.getEventLocation(), 0);
                        }
                    }
                }
                if (OpenEvent.this.openEventData.boxesToOpen == 1 && OpenEvent.this.eventStep == OpenEvent.this.openEventData.revealEventStep) {
                    OpenEvent.this.revealSingle();
                }
                if (OpenEvent.this.openEventData.boxesToOpen > 1 && OpenEvent.this.eventStep >= OpenEvent.this.openEventData.revealEventStep && OpenEvent.this.startReveal) {
                    OpenEvent.this.revealMultiple();
                    OpenEvent.this.startReveal = false;
                }
                object = BoxEntity.getFixedEyeLoc(OpenEvent.this.bigBoxEntity);
                if (OpenEvent.this.eventStep <= OpenEvent.this.openEventData.chargeEventStep) {
                    object.getWorld().playSound((Location)object, Sound.BLOCK_NOTE_BLOCK_BELL, 1.0f, 2.0f);
                    for (String string : OpenEvent.this.openEventData.box.getAnimationSettings().spiralParticles) {
                        WorldUtils.spawnParticle((Location)object, string);
                    }
                }
                if (OpenEvent.this.eventStep == OpenEvent.this.openEventData.chargeEventStep + 40 + 10) {
                    object.getWorld().playSound((Location)object, Sound.ENTITY_GENERIC_EXPLODE, 1.0f, 1.0f);
                    object.getWorld().playSound((Location)object, Sound.BLOCK_ENDER_CHEST_OPEN, 1.0f, 0.0f);
                    for (String string : OpenEvent.this.openEventData.box.getAnimationSettings().explosionParticles) {
                        WorldUtils.spawnParticle((Location)object, string);
                    }
                    if (OpenEvent.this.openEventData.boxesToOpen > 1) {
                        OpenEvent.this.bigBoxEntity.remove();
                    }
                }
                boolean bl2 = OpenEvent.this.openEventData.boxesToOpen == 1 ? OpenEvent.this.eventStep > OpenEvent.this.openEventData.chargeEventStep + 40 + 10 : (bl = OpenEvent.this.themeExecutor.getAnimation() != null && OpenEvent.this.themeExecutor.getAnimation().isIdleParticles());
                if (bl) {
                    for (ArmorStand armorStand : OpenEvent.this.boxes.keySet()) {
                        if (OpenEvent.this.openEventData.boxesToOpen > 1 && armorStand == OpenEvent.this.bigBoxEntity || armorStand.isDead()) continue;
                        Location location2 = BoxEntity.getFixedEyeLoc(armorStand);
                        for (String string : OpenEvent.this.openEventData.box.getAnimationSettings().idleParticles) {
                            WorldUtils.spawnParticle(location2, string);
                        }
                    }
                }
            }
        }.runTaskTimer((Plugin)Main.getPlugin(), 0L, (long)this.openEventData.mainTaskPeriod);
    }

    private void revealSingle() {
        this.tickRevealDelay = true;
        Loot loot = this.boxes.get(this.bigBoxEntity);
        LootReveal lootReveal = new LootAcquired(loot).getLootReveal(this.player);
        LootAcquired lootAcquired = new LootAcquired(loot, lootReveal);
        List<String> list = ConfigParser.getStringList(lootReveal == LootReveal.DISCOVERED ? LanguageValue.BOX_HOLOGRAM_DISCOVERED : LanguageValue.BOX_HOLOGRAM_DUPLICATED);
        Location location = this.bigBoxEntity.getLocation().clone().add(0.0, 1.0, 0.0);
        this.createHologram(location, loot, lootReveal, Lists.reverse(list));
        BoxEntity.AFTER_REVEAL.updateBox(this.bigBoxEntity, this.openEventData.box, loot);
        LootHandler.lootMessages(this.player, this.openEventData.box, Collections.singletonList(lootAcquired));
        LootHandler.claimLoot(this.player, this, this.openEventData.box, lootAcquired, this.bigBoxEntity);
        this.eventFinished = true;
    }

    private void revealMultiple() {
        this.tickRevealDelay = true;
        new BukkitRunnable(){
            int boxEntityIndex = 0;
            List<LootAcquired> lootsAcquired = new ArrayList<LootAcquired>();
            List<ArmorStand> smallBoxEntities;
            {
                this.smallBoxEntities = OpenEvent.this.boxes.keySet().stream().filter(armorStand -> armorStand != OpenEvent.this.bigBoxEntity).toList();
            }

            public void run() {
                if (OpenEvent.this.isEventCancelled()) {
                    this.cancel();
                    return;
                }
                if (OpenEvent.this.revealDelay > 0) {
                    return;
                }
                ArmorStand armorStand = this.smallBoxEntities.get(this.boxEntityIndex);
                Loot loot = OpenEvent.this.boxes.get(armorStand);
                LootReveal lootReveal = new LootAcquired(loot).getLootReveal(OpenEvent.this.player);
                LootAcquired lootAcquired = new LootAcquired(loot, lootReveal);
                List<String> list = ConfigParser.getStringList(lootReveal == LootReveal.DISCOVERED ? LanguageValue.BOX_HOLOGRAM_DISCOVERED : LanguageValue.BOX_HOLOGRAM_DUPLICATED);
                Location location = armorStand.getLocation().clone().add(0.0, 1.0, 0.0);
                OpenEvent.this.createHologram(location, loot, lootReveal, Lists.reverse(list));
                BoxEntity.AFTER_REVEAL.updateBox(armorStand, OpenEvent.this.openEventData.box, loot);
                LootHandler.claimLoot(OpenEvent.this.player, OpenEvent.this, OpenEvent.this.openEventData.box, lootAcquired, armorStand);
                this.lootsAcquired.add(lootAcquired);
                ++this.boxEntityIndex;
                if (this.boxEntityIndex == OpenEvent.this.openEventData.boxesToOpen) {
                    LootHandler.lootMessages(OpenEvent.this.player, OpenEvent.this.openEventData.box, this.lootsAcquired);
                    OpenEvent.this.eventFinished = true;
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)Main.getPlugin(), 0L, (long)this.openEventData.revealTaskPeriod);
    }

    private void createHologram(Location location, Loot loot, LootReveal lootReveal, List<String> list) {
        double d = 0.0;
        long l = LootHandler.calculateDustToGive(this.player, loot, lootReveal);
        for (String string : list) {
            ArmorStand armorStand = (ArmorStand)location.getWorld().spawn(location.clone().add(0.0, d, 0.0), ArmorStand.class);
            d += 0.25;
            armorStand.setSmall(true);
            this.holograms.add(armorStand);
            string = GeneralPlaceholders.translate((Object)this.player, this.openEventData.box, loot, string);
            string = string.replace("{DUST_TO_GIVE}", String.valueOf(l));
            BoxEntity.updateEntity(armorStand, string);
        }
    }

    public boolean shouldContinue() {
        return this.eventFinished && this.finishStep == this.openEventData.finishEventStep || !this.player.isOnline();
    }

    public void removeLeftovers() {
        this.cancelEvent();
        for (ArmorStand armorStand : this.boxes.keySet()) {
            armorStand.remove();
        }
        for (ArmorStand armorStand : this.holograms) {
            armorStand.remove();
        }
        PlayerData playerData = PlayerDataManager.getData(this.player);
        playerData.setVaultAction(null);
        if (this.openEventData.vault != null) {
            this.openEventData.vault.setVaultAction(null);
        }
        this.themeExecutor.stopTheme();
        if (this.songPlayer != null) {
            this.songPlayer.stopSong();
        }
        this.bigBoxEntity.remove();
    }

    public Location getEventLocation() {
        Location location = this.openEventData.vault != null && this.openEventData.vault.getVaultLoc() != null ? this.openEventData.vault.getVaultLoc().add(0.5, 0.75, 0.5) : this.player.getLocation().add(0.5, 0.0, 0.5);
        location.setYaw(this.player.getLocation().getYaw() - 180.0f);
        return location;
    }

    public Player getPlayer() {
        return this.player;
    }

    public OpenEventData getOpenData() {
        return this.openEventData;
    }

    public ArmorStand getBigBoxEntity() {
        return this.bigBoxEntity;
    }

    public Map<ArmorStand, Loot> getBoxes() {
        return this.boxes;
    }

    public List<Loot> getLoots() {
        return this.loots;
    }

    public void setRevealDelay(int n) {
        this.revealDelay = n;
    }

    public void setStartReveal(boolean bl) {
        this.startReveal = bl;
    }

    public boolean isEventCancelled() {
        return this.eventCancelled;
    }

    public void cancelEvent() {
        this.eventCancelled = true;
    }
}

